/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.refactoring.convertToClass.JSItemToClassConvertor;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSToClassConversionConstructorFunction {
    @NotNull
    private final JSFunction myFunction;
    @NotNull
    private final String myFunctionName;
    private final Map<String, JSAssignmentExpression> myInnerProperties;
    private final Map<JSReferenceExpression, JSAssignmentExpression> myParameterAssignments;

    public JSToClassConversionConstructorFunction(@NotNull JSFunction function, @Nullable String name) {
        if (function == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(0);
        }
        this.myInnerProperties = new HashMap<String, JSAssignmentExpression>();
        this.myFunction = function;
        this.myFunctionName = name == null ? StringUtil.notNullize((String)function.getName()) : name;
        this.myParameterAssignments = new HashMap<JSReferenceExpression, JSAssignmentExpression>();
        JSBlockStatement constructorBlock = (JSBlockStatement)PsiTreeUtil.getChildOfType((PsiElement)function, JSBlockStatement.class);
        if (constructorBlock != null) {
            Collection assignments = PsiTreeUtil.findChildrenOfType((PsiElement)constructorBlock, JSAssignmentExpression.class);
            for (JSAssignmentExpression expression : assignments) {
                PsiElement element;
                if (expression.getDefinitionExpression() == null || !this.isThisMember((PsiElement)expression.getDefinitionExpression())) continue;
                this.myInnerProperties.put(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)expression.getDefinitionExpression(), (boolean)false), expression);
                JSExpression initializer = expression.getDefinitionExpression().getInitializer();
                if (!(initializer instanceof JSReferenceExpression) || (element = ((JSReferenceExpression)initializer).resolve()) == null || !element.isValid() || !(element instanceof JSParameter) || !(element.getParent() instanceof JSParameterList) || !this.myFunction.equals((Object)element.getParent().getParent())) continue;
                this.myParameterAssignments.put((JSReferenceExpression)initializer, expression);
            }
        }
    }

    public @Unmodifiable Collection<JSAssignmentExpression> getOnlyPropertyDefinitions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> !(assignment.getDefinitionExpression().getInitializer() instanceof JSFunction));
    }

    public @Unmodifiable Collection<JSAssignmentExpression> getOnlyFunctions() {
        return ContainerUtil.filter(this.myInnerProperties.values(), assignment -> assignment.getDefinitionExpression().getInitializer() instanceof JSFunction);
    }

    @Nullable
    public JSAssignmentExpression getInnerProperty(@NotNull String key) {
        if (key == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(1);
        }
        return this.myInnerProperties.get(key);
    }

    public boolean isEmpty() {
        return this.myInnerProperties.isEmpty();
    }

    @NotNull
    public String getFunctionName() {
        String string = this.myFunctionName;
        if (string == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public JSFunction getFunction() {
        JSFunction jSFunction = this.myFunction;
        if (jSFunction == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(3);
        }
        return jSFunction;
    }

    private boolean isThisMember(PsiElement element) {
        if (!(element instanceof JSElementBase)) {
            return false;
        }
        JSElementBase base = (JSElementBase)element;
        return base.getNamespace() != null && (this.myFunctionName.equals(base.getNamespace().getName()) || "constructor".equals(this.myFunctionName) && this.myFunction.getParent() instanceof ES6Class && Objects.equals(((ES6Class)this.myFunction.getParent()).getName(), base.getNamespace().getName()));
    }

    public void replaceUsedParameters() {
        JSParameterListElement[] parameters;
        for (JSParameterListElement parameter : parameters = this.myFunction.getParameters()) {
            if (parameter.getName() == null) continue;
            Ref existingRebindTarget = new Ref();
            JSRefactoringUtil.rebindIfThereAreUsages((PsiElement)parameter, (PsiElement)this.myFunction, references -> {
                for (Object reference : references) {
                    JSAssignmentExpression expression;
                    if (!(reference instanceof PsiElement) || (expression = this.myParameterAssignments.get(reference)) == null) continue;
                    existingRebindTarget.set((Object)expression.getDefinitionExpression());
                    break;
                }
                boolean toReplace = false;
                block1: for (PsiReference reference : references) {
                    for (JSAssignmentExpression assignmentExpression : this.getOnlyFunctions()) {
                        JSExpression initializer;
                        JSExpression jSExpression = initializer = assignmentExpression.getDefinitionExpression() == null ? null : assignmentExpression.getDefinitionExpression().getInitializer();
                        if (initializer != null && reference instanceof PsiElement && PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)((PsiElement)reference), (boolean)false)) {
                            toReplace = true;
                            continue block1;
                        }
                        if (!toReplace) continue;
                        continue block1;
                    }
                }
                if (!toReplace) {
                    return null;
                }
                String innerName = JSCodeStyleSettings.getSettings((PsiElement)this.myFunction).FIELD_PREFIX + parameter.getName();
                return !existingRebindTarget.isNull() ? (PsiElement)existingRebindTarget.get() : JSItemToClassConvertor.addPropertyAssignment((PsiElement)this.myFunction, innerName, parameter.getName());
            }, reference -> existingRebindTarget.isNull() || !reference.equals((Object)((JSDefinitionExpression)existingRebindTarget.get()).getInitializer()));
        }
    }

    public void removeInnerProperty(@NotNull String name) {
        if (name == null) {
            JSToClassConversionConstructorFunction.$$$reportNull$$$0(4);
        }
        this.myInnerProperties.remove(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionConstructorFunction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInnerProperty";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeInnerProperty";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

