/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.javascript.JSModuleBaseReference;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportCall;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.evaluable.JSCustomElementType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001b\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/lang/javascript/validation/JSValidationUtils;", "", "<init>", "()V", "hasImportReferences", "", "element", "Lcom/intellij/psi/PsiElement;", "isSymbolNotAccessible", "resolveResults", "", "Lcom/intellij/psi/ResolveResult;", "([Lcom/intellij/psi/ResolveResult;)Z", "isAcceptableQualifier", "node", "Lcom/intellij/lang/javascript/psi/JSReferenceExpression;", "reportIncompleteAsArgumentTypesMismatch", "([Lcom/intellij/psi/ResolveResult;)Lcom/intellij/psi/PsiElement;", "intellij.javascript.codeinsight"})
@SourceDebugExtension(value={"SMAP\nJSValidationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSValidationUtils.kt\ncom/intellij/lang/javascript/validation/JSValidationUtils\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,81:1\n13225#2,2:82\n18#3:84\n*S KotlinDebug\n*F\n+ 1 JSValidationUtils.kt\ncom/intellij/lang/javascript/validation/JSValidationUtils\n*L\n44#1:82,2\n76#1:84\n*E\n"})
public final class JSValidationUtils {
    @NotNull
    public static final JSValidationUtils INSTANCE = new JSValidationUtils();

    private JSValidationUtils() {
    }

    @JvmStatic
    public static final boolean hasImportReferences(@NotNull PsiElement element) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element instanceof JSLiteralExpression) {
                PsiElement parent = element.getContext();
                if (parent instanceof JSArgumentList) {
                    PsiElement callCandidate = ((JSArgumentList)parent).getContext();
                    if (callCandidate instanceof JSCallExpression && (((JSCallExpression)callCandidate).isRequireCall() || ((JSCallExpression)callCandidate).isDefineCall() || ((JSCallExpression)callCandidate).isImportPhaseCall())) {
                        return true;
                    }
                } else {
                    if (parent instanceof ES6ImportCall) {
                        return true;
                    }
                    if (parent instanceof TypeScriptModule) {
                        return ((TypeScriptModule)parent).getIdentifyingElement() == element;
                    }
                }
            }
            PsiReference[] psiReferenceArray = element.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            Object[] $this$any$iv = psiReferenceArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiReference el = (PsiReference)element$iv;
                boolean bl2 = false;
                if (!(el instanceof JSModuleBaseReference)) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl || element instanceof ES6ImportExportDeclaration && ((ES6ImportExportDeclaration)element).getFromClause() == null || element instanceof ES6FromClause;
    }

    @JvmStatic
    public static final boolean isSymbolNotAccessible(@NotNull ResolveResult[] resolveResults) {
        Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
        if (resolveResults.length == 0) {
            return false;
        }
        ResolveResult result2 = resolveResults[0];
        if (!(result2 instanceof JSResolveResult)) {
            return false;
        }
        JSResolveResult.ProblemKind resolveProblemKey = ((JSResolveResult)result2).getResolveProblemKind();
        return resolveProblemKey == JSResolveResult.ProblemKind.JS_PRIVATE_MEMBER_IS_NOT_ACCESSIBLE || resolveProblemKey == JSResolveResult.ProblemKind.JS_PROTECTED_MEMBER_IS_NOT_ACCESSIBLE;
    }

    @JvmStatic
    public static final boolean isAcceptableQualifier(@NotNull JSReferenceExpression node) {
        JSExpression nextQualifier;
        JSExpression qualifier;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        JSExpression jSExpression = node.getQualifier();
        if (jSExpression == null) {
            return false;
        }
        JSExpression topQualifier = qualifier = jSExpression;
        while (topQualifier instanceof JSReferenceExpression && (nextQualifier = ((JSReferenceExpression)topQualifier).getQualifier()) != null) {
            topQualifier = nextQualifier;
        }
        JSType jsType = JSResolveUtil.getExpressionJSType((JSExpression)topQualifier);
        return jsType instanceof JSCustomElementType && PluginManagerCore.isDisabled((PluginId)PluginManagerCore.ULTIMATE_PLUGIN_ID);
    }

    @JvmStatic
    @Nullable
    public static final PsiElement reportIncompleteAsArgumentTypesMismatch(@NotNull ResolveResult[] resolveResults) {
        ResolveResult resolveResult;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
                resolveResult = (ResolveResult)ArraysKt.singleOrNull((Object[])resolveResults);
                if (resolveResult == null) break block4;
                ResolveResult $this$asSafely$iv = resolveResult;
                boolean $i$f$asSafely = false;
                ResolveResult resolveResult2 = $this$asSafely$iv;
                if (!(resolveResult2 instanceof JSResolveResult)) {
                    resolveResult2 = null;
                }
                if ((resolveResult = (JSResolveResult)resolveResult2) != null) break block5;
            }
            return null;
        }
        ResolveResult jSResolveResult = resolveResult;
        return jSResolveResult.getResolveProblemKind() == JSResolveResult.ProblemKind.ARGUMENT_TYPES_MISMATCH ? resolveResults[0].getElement() : null;
    }
}

