/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSWithStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypedJSReferenceChecker
extends JSReferenceChecker {
    public TypedJSReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            TypedJSReferenceChecker.$$$reportNull$$$0(0);
        }
        super(reporter);
    }

    @Override
    @Nullable
    public ProblemHighlightType getUnresolvedReferenceHighlightType(@NotNull JSReferenceExpression node) {
        JSExpression qualifier;
        if (node == null) {
            TypedJSReferenceChecker.$$$reportNull$$$0(1);
        }
        if ((qualifier = node.getQualifier()) == null) {
            JSExpression expression;
            List withStatements = JSPsiImplUtils.getWithStatementContexts((JSReferenceExpression)node);
            if (!withStatements.isEmpty() && (expression = ((JSWithStatement)withStatements.getFirst()).getExpression()) != null && expression != node && PsiTreeUtil.findCommonParent((PsiElement)node, (PsiElement)expression) != expression) {
                return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
            }
            return ProblemHighlightType.ERROR;
        }
        return ProblemHighlightType.LIKE_UNKNOWN_SYMBOL;
    }

    @Override
    protected boolean suggestCreateVarFromUsage(JSReferenceExpression node) {
        JSClass clazz;
        JSExpression qualifier = node.getQualifier();
        JSClass targetClass = null;
        if (qualifier == null) {
            targetClass = JSResolveUtil.getClassOfContext((PsiElement)node);
        } else if (qualifier instanceof JSReferenceExpression && DialectDetector.isActionScript((PsiElement)node) && (clazz = ActionScriptResolveUtil.findClassOfQualifier((JSExpression)qualifier, (PsiFile)node.getContainingFile())) != null) {
            targetClass = clazz;
        }
        if (targetClass != null) {
            return !targetClass.isInterface();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/validation/TypedJSReferenceChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getUnresolvedReferenceHighlightType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

