/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeArgumentsOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptSingleType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeArgumentsListOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptValidateGenericTypesInspection
extends JSInspection {
    public boolean isCoveredByTypeScriptServiceHighlighting() {
        return true;
    }

    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            TypeScriptValidateGenericTypesInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            TypeScriptValidateGenericTypesInspection.$$$reportNull$$$0(1);
        }
        final TypeScriptAnnotatorCheckerProvider provider = TypeScriptAnnotatorCheckerProvider.getCheckerProvider((PsiElement)holder.getFile());
        return new JSElementVisitor(this){

            private boolean isAcceptable(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                return holder.isOnTheFly() || !provider.skipErrors(element);
            }

            @Contract(pure=true)
            @NotNull
            private ProblemHighlightType getProblemHighlightType(@Nullable PsiElement element) {
                ProblemHighlightType problemHighlightType = provider.skipErrors(element) ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                if (problemHighlightType == null) {
                    1.$$$reportNull$$$0(1);
                }
                return problemHighlightType;
            }

            public void visitTypeScriptClass(@NotNull TypeScriptClass typeScriptClass) {
                if (typeScriptClass == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!this.isAcceptable((PsiElement)typeScriptClass)) {
                    return;
                }
                TypeScriptTypeParameterList parameterList = typeScriptClass.getTypeParameterList();
                if (parameterList == null) {
                    return;
                }
                if (parameterList.getTypeParameters().length == 0) {
                    holder.registerProblem((PsiElement)parameterList, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.not.empty.parameter", (Object[])new Object[0]), new LocalQuickFix[0]);
                }
            }

            public void visitReferenceListMember(@NotNull JSReferenceListMember member) {
                if (member == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!this.isAcceptable((PsiElement)member)) {
                    return;
                }
                JSExpression referenceExpression = member.getExpression();
                if (!(referenceExpression instanceof JSReferenceExpression)) {
                    return;
                }
                String name = StringUtil.notNullize((String)member.getReferenceText());
                this.processTypeOwner((TypeScriptTypeArgumentsListOwner)member, (JSReferenceExpression)referenceExpression, name);
            }

            public void visitTypeScriptSingleType(@NotNull TypeScriptSingleType singleType) {
                if (singleType == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (!this.isAcceptable((PsiElement)singleType)) {
                    return;
                }
                JSReferenceExpression referenceExpression = singleType.getReferenceExpression();
                if (referenceExpression == null) {
                    return;
                }
                String name = StringUtil.notNullize((String)singleType.getQualifiedTypeName());
                this.processTypeOwner((TypeScriptTypeArgumentsListOwner)singleType, referenceExpression, name);
            }

            private void processTypeOwner(@NotNull TypeScriptTypeArgumentsListOwner typeArgumentsListOwner, @NotNull JSReferenceExpression referenceExpression, @NotNull String name) {
                Object[] results;
                ResolveResult resolveResult;
                if (typeArgumentsListOwner == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (referenceExpression == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (!DialectDetector.isTypeScript((PsiElement)typeArgumentsListOwner)) {
                    return;
                }
                if (!(typeArgumentsListOwner instanceof JSTypeArgumentsOwner)) {
                    return;
                }
                ProblemHighlightType problemHighlightType = this.getProblemHighlightType((PsiElement)typeArgumentsListOwner);
                TypeScriptTypeArgumentList arguments = typeArgumentsListOwner.getTypeArgumentList();
                JSTypeDeclaration[] declarationParameters = ((JSTypeArgumentsOwner)typeArgumentsListOwner).getTypeArguments();
                int declarationParametersLength = declarationParameters.length;
                if (declarationParametersLength == 0 && arguments != null) {
                    holder.registerProblem((PsiElement)arguments, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.not.empty.argument", (Object[])new Object[0]), problemHighlightType, new LocalQuickFix[0]);
                }
                if ((resolveResult = (ResolveResult)ArrayUtil.getFirstElement((Object[])(results = referenceExpression.multiResolve(false)))) == null) {
                    return;
                }
                PsiElement element = resolveResult.getElement();
                if ((element instanceof TypeScriptEnum || element instanceof TypeScriptTypeParameter) && arguments != null) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), problemHighlightType, new LocalQuickFix[]{JSFixFactory.getInstance().removeGenericArgumentFix((JSElement)arguments)});
                }
                if (!(element instanceof TypeScriptTypeParameterListOwner)) {
                    return;
                }
                TypeScriptTypeParameterList expectedList = ((TypeScriptTypeParameterListOwner)element).getTypeParameterList();
                if (arguments != null && (expectedList == null || expectedList.getTypeParameters().length == 0)) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.generics.should.not.be", (Object[])new Object[]{name}), problemHighlightType, new LocalQuickFix[]{JSFixFactory.getInstance().removeGenericArgumentFix((JSElement)arguments)});
                    return;
                }
                if (expectedList == null) {
                    return;
                }
                TypeScriptTypeParameter[] expectedListTypeParameters = expectedList.getTypeParameters();
                int expectedParametersLength = expectedListTypeParameters.length;
                int expectedNonDefaultParametersLength = this.getNonDefaultParametersAmount(expectedList);
                if (declarationParametersLength >= expectedNonDefaultParametersLength && declarationParametersLength <= expectedParametersLength) {
                    return;
                }
                if (declarationParametersLength > expectedParametersLength) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number.between", (Object[])new Object[]{name, expectedNonDefaultParametersLength, expectedParametersLength}), problemHighlightType, new LocalQuickFix[0]);
                    return;
                }
                if (expectedParametersLength != expectedNonDefaultParametersLength) {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number.between", (Object[])new Object[]{name, expectedNonDefaultParametersLength, expectedParametersLength}), problemHighlightType, new LocalQuickFix[]{JSFixFactory.getInstance().addGenericArgumentFix(typeArgumentsListOwner)});
                } else {
                    holder.registerProblem((PsiElement)typeArgumentsListOwner, JavaScriptBundle.message((String)"typescript.validate.generic.types.inspection.error.argument.number", (Object[])new Object[]{name, expectedParametersLength}), problemHighlightType, new LocalQuickFix[]{JSFixFactory.getInstance().addGenericArgumentFix(typeArgumentsListOwner)});
                }
            }

            private int getNonDefaultParametersAmount(@NotNull TypeScriptTypeParameterList expectedList) {
                if (expectedList == null) {
                    1.$$$reportNull$$$0(8);
                }
                return (int)Arrays.stream(expectedList.getTypeParameters()).filter(parameter -> parameter.getDefault() == null).count();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeScriptClass";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "member";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "singleType";
                        break;
                    }
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "typeArgumentsListOwner";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "referenceExpression";
                        break;
                    }
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedList";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getProblemHighlightType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "isAcceptable";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeScriptClass";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "visitReferenceListMember";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "visitTypeScriptSingleType";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "processTypeOwner";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "getNonDefaultParametersAmount";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/lang/typescript/inspections/TypeScriptValidateGenericTypesInspection";
        objectArray[2] = "createVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

