/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.control;

import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.EquivalenceChecker;
import org.jetbrains.annotations.NotNull;

public final class ConditionalExpressionWithIdenticalBranchesJSInspection
extends JavaScriptInspection
implements CleanupLocalInspectionTool {
    private final InspectionJSFix fix = new CollapseConditional();

    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        String string = JavaScriptBundle.message((String)"conditional.expression.with.identical.branches.error.string", (Object[])new Object[0]);
        if (string == null) {
            ConditionalExpressionWithIdenticalBranchesJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionWithIdenticalBranchesVisitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection", "buildErrorString"));
    }

    private static class CollapseConditional
    extends InspectionJSFix {
        private CollapseConditional() {
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaScriptBundle.message((String)"collapse.conditional.expression.fix", (Object[])new Object[0]);
            if (string == null) {
                CollapseConditional.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression expression = (JSConditionalExpression)descriptor.getPsiElement();
            JSExpression thenExpression = (JSExpression)expression.getThenBranch();
            assert (thenExpression != null);
            String bodyText = thenExpression.getText();
            CollapseConditional.replaceExpression((JSExpression)expression, (String)bodyText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection$CollapseConditional", "getFamilyName"));
        }
    }

    private static class ConditionalExpressionWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionWithIdenticalBranchesVisitor() {
        }

        public void visitJSConditionalExpression(@NotNull JSConditionalExpression expression) {
            if (expression == null) {
                ConditionalExpressionWithIdenticalBranchesVisitor.$$$reportNull$$$0(0);
            }
            super.visitJSConditionalExpression(expression);
            JSExpression thenExpression = (JSExpression)expression.getThenBranch();
            JSExpression elseExpression = (JSExpression)expression.getElseBranch();
            if (EquivalenceChecker.expressionsAreEquivalent(thenExpression, elseExpression)) {
                this.registerError((PsiElement)expression);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/sixrr/inspectjs/control/ConditionalExpressionWithIdenticalBranchesJSInspection$ConditionalExpressionWithIdenticalBranchesVisitor", "visitJSConditionalExpression"));
        }
    }
}

