/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.functionmetrics;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.functionmetrics.FunctionMetricsInspection;
import org.jetbrains.annotations.NotNull;

public final class ParametersPerFunctionJSInspection
extends FunctionMetricsInspection {
    @Override
    protected int getDefaultLimit() {
        return 5;
    }

    @Override
    protected String getConfigurationLabel() {
        return JavaScriptBundle.message((String)"function.parameter.limit", (Object[])new Object[0]);
    }

    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSFunction function = (JSFunction)((PsiElement)args[0]).getParent();
        assert (function != null);
        JSParameter[] parameters = function.getParameterVariables();
        int numParameters = parameters.length;
        if (ParametersPerFunctionJSInspection.functionHasIdentifier((JSFunction)function)) {
            String string = JavaScriptBundle.message((String)"function.has.too.many.parameters.error.string", (Object[])new Object[]{numParameters});
            if (string == null) {
                ParametersPerFunctionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = JavaScriptBundle.message((String)"anonymous.function.has.too.many.parameters.error.string", (Object[])new Object[]{numParameters});
        if (string == null) {
            ParametersPerFunctionJSInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSFunctionDeclaration(@NotNull JSFunction function) {
            JSParameterListElement[] parameters;
            int numParameters;
            if (function == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if ((numParameters = (parameters = function.getParameters()).length) <= ParametersPerFunctionJSInspection.this.getLimit()) {
                return;
            }
            this.registerFunctionError(function);
        }

        public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            this.visitJSFunctionDeclaration((JSFunction)node);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/sixrr/inspectjs/functionmetrics/ParametersPerFunctionJSInspection$Visitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitJSFunctionExpression";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

