/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.naming;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnumField;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.psi.PsiElement;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.naming.ConventionInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class LocalVariableNamingConventionJSInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 32;

    protected InspectionJSFix buildFix(PsiElement location) {
        return JSFixFactory.getInstance().renameFix();
    }

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @InspectionMessage
    @NotNull
    public String buildErrorString(Object ... args) {
        JSVariable variable = (JSVariable)((PsiElement)args[0]).getParent();
        assert (variable != null);
        String variableName = variable.getName();
        if (variableName.length() < this.getMinLength()) {
            String string = JavaScriptBundle.message((String)"variable.name.is.too.short.error.string", (Object[])new Object[0]);
            if (string == null) {
                LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (variableName.length() > this.getMaxLength()) {
            String string = JavaScriptBundle.message((String)"variable.name.is.too.long.error.string", (Object[])new Object[0]);
            if (string == null) {
                LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = JavaScriptBundle.message((String)"variable.name.doesnt.match.regex.error.string", (Object[])new Object[]{this.getRegex()});
        if (string == null) {
            LocalVariableNamingConventionJSInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NonNls
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 32;
    }

    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/naming/LocalVariableNamingConventionJSInspection", "buildErrorString"));
    }

    private class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitJSVarStatement(@NotNull JSVarStatement jsVarStatement) {
            JSVariable[] variables;
            if (jsVarStatement == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSVarStatement(jsVarStatement);
            if (jsVarStatement.getParent() instanceof JSFile) {
                return;
            }
            for (JSVariable variable : variables = jsVarStatement.getVariables()) {
                String name;
                JSAttributeList attributeList;
                if (variable instanceof TypeScriptEnumField || (attributeList = variable.getAttributeList()) != null && attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && variable.isConst() || (name = variable.getName()) == null || LocalVariableNamingConventionJSInspection.this.isValid(name)) continue;
                this.registerVariableError(variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsVarStatement", "com/sixrr/inspectjs/naming/LocalVariableNamingConventionJSInspection$Visitor", "visitJSVarStatement"));
        }
    }
}

