/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events.scheme;

import com.intellij.internal.statistic.eventLog.events.scheme.EventDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.FieldDescriptor;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\tH\u0007J$\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\f\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002J$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0005H\u0002J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00112\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u0005H\u0002J:\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u000e\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0011H\u0002J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u001c\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u001a\u0010$\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#2\b\u0010 \u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010'\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010(\u001a\u00020\u001e2\u0006\u0010)\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/scheme/EventSchemeValidator;", "", "<init>", "()V", "SYMBOLS_TO_REPLACE_FIELD_NAME", "", "validateEventScheme", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "", "eventsScheme", "validateGroupScheme", "group", "validatedGroupNames", "", "validateEvents", "schema", "", "Lcom/intellij/internal/statistic/eventLog/events/scheme/EventDescriptor;", "groupId", "validateFields", "fields", "Lcom/intellij/internal/statistic/eventLog/events/scheme/FieldDescriptor;", "eventId", "validateRules", "fieldName", "rules", "unwrapRule", "rule", "containsSystemSymbols", "", "value", "toReplace", "isAscii", "c", "", "isSymbolToReplace", "isWhiteSpaceToReplace", "isAsciiControl", "isProhibitedSymbol", "containsChar", "str", "intellij.platform.statistics"})
public final class EventSchemeValidator {
    @NotNull
    public static final EventSchemeValidator INSTANCE = new EventSchemeValidator();
    @NotNull
    private static final String SYMBOLS_TO_REPLACE_FIELD_NAME = ":;, ";

    private EventSchemeValidator() {
    }

    @JvmStatic
    @NotNull
    public static final Map<GroupDescriptor, List<String>> validateEventScheme(@NotNull List<GroupDescriptor> eventsScheme) {
        Intrinsics.checkNotNullParameter(eventsScheme, (String)"eventsScheme");
        HashSet groupNames = new HashSet();
        Map errors = new LinkedHashMap();
        for (GroupDescriptor group : CollectionsKt.toSet((Iterable)eventsScheme)) {
            List<String> groupErrors = INSTANCE.validateGroupScheme(group, groupNames);
            if (!(!((Collection)groupErrors).isEmpty())) continue;
            errors.put(group, groupErrors);
        }
        return errors;
    }

    private final List<String> validateGroupScheme(GroupDescriptor group, Set<String> validatedGroupNames) {
        ArrayList<Object> errors = new ArrayList<Object>();
        String groupId = group.getId();
        if (StringsKt.isBlank((CharSequence)groupId)) {
            errors.add("Group id is null or empty");
        }
        if (!validatedGroupNames.add(groupId)) {
            errors.add("Duplicate group `" + groupId + "`");
        }
        if (group.getVersion() <= 0) {
            errors.add("Group version should not be null and should be > 0 (groupId=" + groupId + ")");
        }
        errors.addAll((Collection)this.validateEvents(group.getSchema(), groupId));
        return errors;
    }

    private final List<String> validateEvents(Set<EventDescriptor> schema, String groupId) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        if (schema.isEmpty()) {
            errors.add((CallSite)((Object)("Group should contain at least one event (groupId=" + groupId + ")")));
            return errors;
        }
        HashSet<String> eventsNames = new HashSet<String>();
        for (EventDescriptor event : schema) {
            String eventId = event.getEvent();
            if (StringsKt.isBlank((CharSequence)eventId)) {
                errors.add((CallSite)((Object)("Event id is null or empty (groupId=" + groupId + ")")));
            } else if (!eventsNames.add(eventId)) {
                errors.add((CallSite)((Object)("Duplicate event (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            if (this.containsSystemSymbols(eventId, null)) {
                errors.add((CallSite)((Object)("Only printable ASCII symbols except '\" are allowed in event name (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            errors.addAll((Collection)this.validateFields(event.getFields(), groupId, eventId));
        }
        return errors;
    }

    private final List<String> validateFields(Set<FieldDescriptor> fields, String groupId, String eventId) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        for (FieldDescriptor field : fields) {
            String fieldName = field.getPath();
            if (StringsKt.isBlank((CharSequence)fieldName)) {
                errors.add((CallSite)((Object)("Field path is empty (groupId=" + groupId + ", eventId=" + eventId + ")")));
            }
            if (this.containsSystemSymbols(fieldName, SYMBOLS_TO_REPLACE_FIELD_NAME)) {
                errors.add((CallSite)((Object)("Only printable ASCII symbols except whitespaces and .:;,'\" are allowed in field name (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            errors.addAll((Collection)this.validateRules(groupId, eventId, fieldName, field.getValue()));
        }
        return errors;
    }

    private final List<String> validateRules(String groupId, String eventId, String fieldName, Set<String> rules) {
        ArrayList<CallSite> errors = new ArrayList<CallSite>();
        if (rules == null) {
            errors.add((CallSite)((Object)("Validation rules are not specified (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            return errors;
        }
        for (String validationRule : rules) {
            String rule;
            if (StringsKt.isBlank((CharSequence)validationRule)) {
                errors.add((CallSite)((Object)("Validation rule is null or empty (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            if (Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.*}") || Intrinsics.areEqual((Object)validationRule, (Object)"{regexp:.+}")) {
                errors.add((CallSite)((Object)("Regexp should be more strict to prevent accidentally reporting sensitive data (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
            }
            if (!StringsKt.startsWith$default((String)(rule = this.unwrapRule(validationRule)), (String)"enum:", (boolean)false, (int)2, null) || !this.containsSystemSymbols(validationRule, null)) continue;
            errors.add((CallSite)((Object)("Only printable ASCII symbols except '\" are allowed in validation rule (groupId=" + groupId + ", eventId=" + eventId + ", field=" + fieldName + ")")));
        }
        return errors;
    }

    private final String unwrapRule(String rule) {
        String string;
        String trimmedRule = ((Object)StringsKt.trim((CharSequence)rule)).toString();
        if (StringsKt.startsWith$default((String)trimmedRule, (String)"{", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)trimmedRule, (String)"}", (boolean)false, (int)2, null)) {
            String string2 = trimmedRule.substring(1, trimmedRule.length() - 1);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        } else {
            string = rule;
        }
        return string;
    }

    private final boolean containsSystemSymbols(String value, String toReplace) {
        if (value == null) {
            return false;
        }
        String string = value;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char element = string.charAt(i);
            if (!this.isAscii(element)) {
                return true;
            }
            if (this.isWhiteSpaceToReplace(element)) {
                return true;
            }
            if (this.isSymbolToReplace(element, toReplace)) {
                return true;
            }
            if (!this.isProhibitedSymbol(element)) continue;
            return true;
        }
        return false;
    }

    private final boolean isAscii(char c) {
        return c <= '\u007f';
    }

    private final boolean isSymbolToReplace(char c, String toReplace) {
        return toReplace != null && this.containsChar(toReplace, c) ? true : this.isAsciiControl(c);
    }

    private final boolean isWhiteSpaceToReplace(char c) {
        return c == '\n' || c == '\r' || c == '\t';
    }

    private final boolean isAsciiControl(char c) {
        return c < ' ' || c == '\u007f';
    }

    private final boolean isProhibitedSymbol(char c) {
        return c == '\'' || c == '\"';
    }

    private final boolean containsChar(String str, char c) {
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char element = str.charAt(i);
            if (element != c) continue;
            return true;
        }
        return false;
    }
}

