/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.remote.NodeJSRemoteInterpreterManager;
import com.jetbrains.nodejs.remote.NodeJSRemoteSdkAdditionalData;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePathMappingsFetcher {
    private static final Logger LOG = Logger.getInstance(NodePathMappingsFetcher.class);
    private final ExecutorService myExecutorService;
    private final Map<NodeJSRemoteSdkAdditionalData, Future<PathMappingSettings>> myLastCalculatedFetchMap;
    private final Map<NodeJSRemoteSdkAdditionalData, Future<PathMappingSettings>> myLastScheduledFetchMap;
    private final Project myProject;

    public NodePathMappingsFetcher(@NotNull Project project) {
        if (project == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(0);
        }
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Node Remote Path Mappings", (int)1);
        this.myLastCalculatedFetchMap = new ConcurrentHashMap<NodeJSRemoteSdkAdditionalData, Future<PathMappingSettings>>();
        this.myLastScheduledFetchMap = new ConcurrentHashMap<NodeJSRemoteSdkAdditionalData, Future<PathMappingSettings>>();
        this.myProject = project;
    }

    @NotNull
    public static NodePathMappingsFetcher getInstance(@NotNull Project project) {
        if (project == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(1);
        }
        NodePathMappingsFetcher nodePathMappingsFetcher = (NodePathMappingsFetcher)project.getService(NodePathMappingsFetcher.class);
        if (nodePathMappingsFetcher == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(2);
        }
        return nodePathMappingsFetcher;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public PathMappingSettings calcPathMappingsOrGetLastResult(@NotNull NodeJSRemoteSdkAdditionalData data, long timeout, @NotNull TimeUnit timeUnit) throws com.intellij.execution.ExecutionException {
        void unit;
        PathMappingSettings result;
        if (data == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(3);
        }
        if (timeUnit == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(4);
        }
        if ((result = this.doCalcPathMappingsOrGetLastResult(data, timeout, (TimeUnit)unit)) == null) {
            LOG.info("No path mappings available yet");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    private PathMappingSettings doCalcPathMappingsOrGetLastResult(@NotNull NodeJSRemoteSdkAdditionalData data, long timeout, @NotNull TimeUnit timeUnit) throws com.intellij.execution.ExecutionException {
        if (data == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(5);
        }
        if (timeUnit == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(6);
        }
        Future<PathMappingSettings> future = this.schedulePathMappingsFetch(data);
        try {
            void unit;
            return future.get(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted");
            return null;
        }
        catch (ExecutionException e) {
            return NodePathMappingsFetcher.rethrow(e);
        }
        catch (TimeoutException ignored) {
            LOG.info("Timed out fetching path mappings, checking the last result...");
            future = this.myLastCalculatedFetchMap.get((Object)data);
            if (future != null) {
                try {
                    return future.get();
                }
                catch (InterruptedException e) {
                    LOG.info("Interrupted last result");
                    return null;
                }
                catch (ExecutionException e) {
                    return NodePathMappingsFetcher.rethrow(e);
                }
            }
            LOG.info("Last result is unavailable");
            return null;
        }
    }

    @NotNull
    private Future<PathMappingSettings> schedulePathMappingsFetch(@NotNull NodeJSRemoteSdkAdditionalData data) {
        if (data == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(7);
        }
        AtomicReference<FutureTask<PathMappingSettings>> futureReference = new AtomicReference<FutureTask<PathMappingSettings>>();
        FutureTask<PathMappingSettings> future = new FutureTask<PathMappingSettings>(() -> {
            Future thisFuture = Objects.requireNonNull((Future)futureReference.get());
            if (thisFuture != this.myLastScheduledFetchMap.get((Object)data)) {
                return null;
            }
            try {
                NodeJSRemoteInterpreterManager manager = NodeJSRemoteInterpreterManager.getInstance();
                PathMappingSettings pathMappingSettings = manager.setupMappings(this.myProject, data);
                return pathMappingSettings;
            }
            finally {
                this.myLastCalculatedFetchMap.put(data, thisFuture);
            }
        });
        futureReference.set(future);
        this.myLastScheduledFetchMap.put(data, future);
        this.myExecutorService.execute(future);
        FutureTask<PathMappingSettings> futureTask = future;
        if (futureTask == null) {
            NodePathMappingsFetcher.$$$reportNull$$$0(8);
        }
        return futureTask;
    }

    private static PathMappingSettings rethrow(ExecutionException e) throws com.intellij.execution.ExecutionException {
        com.intellij.execution.ExecutionException ije = (com.intellij.execution.ExecutionException)((Object)ObjectUtils.tryCast((Object)e.getCause(), com.intellij.execution.ExecutionException.class));
        if (ije != null) {
            throw ije;
        }
        throw new com.intellij.execution.ExecutionException(NodeJSBundle.message((String)"node.remote.cannot_failed_path_mappings.error.message", (Object[])new Object[0]), (Throwable)e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/remote/NodePathMappingsFetcher";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/remote/NodePathMappingsFetcher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "schedulePathMappingsFetch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 8: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "calcPathMappingsOrGetLastResult";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doCalcPathMappingsOrGetLastResult";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "schedulePathMappingsFetch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8 -> new IllegalStateException(string);
        };
    }
}

