/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.packages.NodePackageLinkResolver;
import com.intellij.model.Pointer;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.model.VueDirective;
import org.jetbrains.vuejs.model.VueEntitiesContainer;
import org.jetbrains.vuejs.model.VueFilter;
import org.jetbrains.vuejs.model.VueLibrary;
import org.jetbrains.vuejs.model.VueMixin;
import org.jetbrains.vuejs.model.VueModelVisitor;
import org.jetbrains.vuejs.model.VueNamedComponent;
import org.jetbrains.vuejs.model.source.VueComponentsCalculation;
import org.jetbrains.vuejs.model.typed.VueTypedEntitiesProvider;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010.\u001a\u00020 2\u0006\u0010/\u001a\u00020 H\u0002J\u0014\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0082\u0004J\n\u00104\u001a\u000205H\u0096\u0080\u0004J\n\u00106\u001a\u00020\u0006H\u0096\u0080\u0004J\u0010\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001108H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00160\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001a0\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0013R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020(0\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0018R,\u0010*\u001a\u001a\u0012\u0004\u0012\u00020$\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020(0\u00150+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006:"}, d2={"Lorg/jetbrains/vuejs/model/source/VueLibraryImpl;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lorg/jetbrains/vuejs/model/VueLibrary;", "project", "Lcom/intellij/openapi/project/Project;", "moduleName", "", "moduleVersion", "packageJsonFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getModuleName", "()Ljava/lang/String;", "getModuleVersion", "parents", "", "Lorg/jetbrains/vuejs/model/VueEntitiesContainer;", "getParents", "()Ljava/util/List;", "directives", "", "Lorg/jetbrains/vuejs/model/VueDirective;", "getDirectives", "()Ljava/util/Map;", "filters", "Lorg/jetbrains/vuejs/model/VueFilter;", "getFilters", "mixins", "Lorg/jetbrains/vuejs/model/VueMixin;", "getMixins", "source", "Lcom/intellij/psi/PsiDirectory;", "getSource", "()Lcom/intellij/psi/PsiDirectory;", "defaultProximity", "Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "getDefaultProximity", "()Lorg/jetbrains/vuejs/model/VueModelVisitor$Proximity;", "components", "Lorg/jetbrains/vuejs/model/VueNamedComponent;", "getComponents", "componentsWithProximity", "Lkotlin/Pair;", "getComponentsWithProximity", "()Lkotlin/Pair;", "findIndexedDirectory", "psiDirectory", "equals", "", "other", "", "hashCode", "", "toString", "createPointer", "Lcom/intellij/model/Pointer;", "Companion", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueLibraryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueLibraryImpl.kt\norg/jetbrains/vuejs/model/source/VueLibraryImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,132:1\n1#2:133\n37#3,2:134\n*S KotlinDebug\n*F\n+ 1 VueLibraryImpl.kt\norg/jetbrains/vuejs/model/source/VueLibraryImpl\n*L\n93#1:134,2\n*E\n"})
public final class VueLibraryImpl
extends UserDataHolderBase
implements VueLibrary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final String moduleName;
    @Nullable
    private final String moduleVersion;
    @NotNull
    private final VirtualFile packageJsonFile;
    @NotNull
    private final List<VueEntitiesContainer> parents;
    @NotNull
    private final Map<String, VueDirective> directives;
    @NotNull
    private final Map<String, VueFilter> filters;
    @NotNull
    private final List<VueMixin> mixins;
    @NotNull
    private static final String[] PACKAGES_WITH_GLOBAL_COMPONENTS;

    public VueLibraryImpl(@NotNull Project project, @Nullable String moduleName, @Nullable String moduleVersion, @NotNull VirtualFile packageJsonFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageJsonFile, (String)"packageJsonFile");
        this.project = project;
        this.moduleName = moduleName;
        this.moduleVersion = moduleVersion;
        this.packageJsonFile = packageJsonFile;
        this.parents = CollectionsKt.emptyList();
        this.directives = MapsKt.emptyMap();
        this.filters = MapsKt.emptyMap();
        this.mixins = CollectionsKt.emptyList();
    }

    @Override
    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    @Nullable
    public String getModuleVersion() {
        return this.moduleVersion;
    }

    @Override
    @NotNull
    public List<VueEntitiesContainer> getParents() {
        return this.parents;
    }

    @Override
    @NotNull
    public Map<String, VueDirective> getDirectives() {
        return this.directives;
    }

    @Override
    @NotNull
    public Map<String, VueFilter> getFilters() {
        return this.filters;
    }

    @Override
    @NotNull
    public List<VueMixin> getMixins() {
        return this.mixins;
    }

    @Nullable
    public PsiDirectory getSource() {
        PsiFile psiFile = PsiManager.getInstance((Project)this.project).findFile(this.packageJsonFile);
        return psiFile != null ? psiFile.getParent() : null;
    }

    @Override
    @NotNull
    public VueModelVisitor.Proximity getDefaultProximity() {
        return (VueModelVisitor.Proximity)((Object)this.getComponentsWithProximity().getFirst());
    }

    @Override
    @NotNull
    public Map<String, VueNamedComponent> getComponents() {
        return (Map)this.getComponentsWithProximity().getSecond();
    }

    private final Pair<VueModelVisitor.Proximity, Map<String, VueNamedComponent>> getComponentsWithProximity() {
        Object object = CachedValuesManager.getManager((Project)this.project).getCachedValue((UserDataHolder)this, () -> VueLibraryImpl._get_componentsWithProximity_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Pair)object;
    }

    private final PsiDirectory findIndexedDirectory(PsiDirectory psiDirectory) {
        VirtualFile virtualFile = psiDirectory.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile target = NodePackageLinkResolver.INSTANCE.resolve(virtualFile);
        PsiDirectory psiDirectory2 = psiDirectory.getManager().findDirectory(target);
        if (psiDirectory2 == null) {
            psiDirectory2 = psiDirectory;
        }
        return psiDirectory2;
    }

    public boolean equals(@Nullable Object other) {
        VueLibraryImpl vueLibraryImpl = other instanceof VueLibraryImpl ? (VueLibraryImpl)other : null;
        return Intrinsics.areEqual((Object)(vueLibraryImpl != null ? vueLibraryImpl.packageJsonFile : null), (Object)this.packageJsonFile) && Intrinsics.areEqual((Object)((VueLibraryImpl)other).project, (Object)this.project);
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = 31 * result + this.packageJsonFile.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return "VueLibraryImpl(" + this.getModuleName() + ")";
    }

    @Override
    @NotNull
    public Pointer<? extends VueEntitiesContainer> createPointer() {
        Project project = this.project;
        String moduleName = this.getModuleName();
        String moduleVersion = this.getModuleVersion();
        String string = this.packageJsonFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        LightFilePointer packageJsonFilePtr = new LightFilePointer(string);
        return () -> VueLibraryImpl.createPointer$lambda$0(packageJsonFilePtr, project, moduleName, moduleVersion);
    }

    private static final Pair _get_componentsWithProximity_$lambda$0$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Pair((Object)VueUtilKt.fromAsset$default(((VueNamedComponent)it.getFirst()).getName(), false, 2, null), it.getFirst());
    }

    private static final String _get_componentsWithProximity_$lambda$0$3(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (String)it.getFirst();
    }

    private static final CachedValueProvider.Result _get_componentsWithProximity_$lambda$0(VueLibraryImpl this$0) {
        Object[] objectArray = new Object[3];
        Intrinsics.checkNotNullExpressionValue((Object)NodeModulesDirectoryManager.getInstance((Project)this$0.project).getNodeModulesDirChangeTracker(), (String)"getNodeModulesDirChangeTracker(...)");
        objectArray[1] = this$0.packageJsonFile;
        objectArray[2] = DumbService.Companion.getInstance(this$0.project).getModificationTracker();
        List dependencies = CollectionsKt.mutableListOf((Object[])objectArray);
        PsiDirectory psiDirectory = this$0.getSource();
        Pair components = null;
        if (psiDirectory == null) {
            components = new Pair((Object)VueModelVisitor.Proximity.GLOBAL, (Object)MapsKt.emptyMap());
            Key key = PsiModificationTracker.MODIFICATION_COUNT;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODIFICATION_COUNT");
            dependencies.add(key);
        } else {
            Pair pair;
            Map map;
            Map map2;
            VirtualFile virtualFile = psiDirectory.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
            VirtualFile directoryFile = virtualFile;
            GlobalSearchScope globalSearchScope = GlobalSearchScopesCore.directoryScope((Project)psiDirectory.getProject(), (VirtualFile)directoryFile, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"directoryScope(...)");
            GlobalSearchScope scope = globalSearchScope;
            boolean globalize = ArraysKt.contains((Object[])PACKAGES_WITH_GLOBAL_COMPONENTS, (Object)psiDirectory.getName());
            if (directoryFile.is(VFileProperty.SYMLINK)) {
                FileIndexFacade fileIndexFacade = FileIndexFacade.getInstance((Project)this$0.project);
                VirtualFile virtualFile2 = directoryFile.getCanonicalFile();
                if (virtualFile2 == null) {
                    virtualFile2 = directoryFile;
                }
                if (fileIndexFacade.isInContent(virtualFile2)) {
                    Key key = PsiModificationTracker.MODIFICATION_COUNT;
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"MODIFICATION_COUNT");
                    dependencies.add(key);
                }
            }
            PsiDirectory indexedPsiDirectory = this$0.findIndexedDirectory(psiDirectory);
            Map it = map2 = VueTypedEntitiesProvider.INSTANCE.calculateDtsComponents(indexedPsiDirectory);
            boolean bl = false;
            Map map3 = map = !it.isEmpty() ? map2 : null;
            if (map != null) {
                it = map;
                boolean bl2 = false;
                pair = new Pair((Object)VueModelVisitor.Proximity.OUT_OF_SCOPE, it);
            } else {
                it = MapsKt.toMap((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)VueComponentsCalculation.Companion.calculateScopeComponents(scope, globalize).getList()), VueLibraryImpl::_get_componentsWithProximity_$lambda$0$2), VueLibraryImpl::_get_componentsWithProximity_$lambda$0$3));
                boolean bl3 = false;
                pair = new Pair((Object)VueModelVisitor.Proximity.GLOBAL, (Object)it);
            }
            components = pair;
        }
        Collection $this$toTypedArray$iv = dependencies;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray2 = thisCollection$iv.toArray(new Object[0]);
        return new CachedValueProvider.Result((Object)components, Arrays.copyOf(objectArray2, objectArray2.length));
    }

    private static final VueLibraryImpl createPointer$lambda$0(LightFilePointer $packageJsonFilePtr, Project $project, String $moduleName, String $moduleVersion) {
        VueLibraryImpl vueLibraryImpl;
        VirtualFile virtualFile = $packageJsonFilePtr.getFile();
        if (virtualFile != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            vueLibraryImpl = new VueLibraryImpl($project, $moduleName, $moduleVersion, it);
        } else {
            vueLibraryImpl = null;
        }
        return vueLibraryImpl;
    }

    static {
        String[] stringArray = new String[]{"vuetify", "bootstrap-vue", "shards-vue"};
        PACKAGES_WITH_GLOBAL_COMPONENTS = stringArray;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/model/source/VueLibraryImpl$Companion;", "", "<init>", "()V", "PACKAGES_WITH_GLOBAL_COMPONENTS", "", "", "[Ljava/lang/String;", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

