/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/codeinsight/completion/EditorConfigAppendInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "suffix", "", "shouldMoveCaret", "", "shouldAutopopup", "<init>", "(Ljava/lang/String;ZZ)V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "intellij.editorconfig.backend"})
public final class EditorConfigAppendInsertionHandler
implements InsertHandler<LookupElement> {
    @NotNull
    private final String suffix;
    private final boolean shouldMoveCaret;
    private final boolean shouldAutopopup;

    public EditorConfigAppendInsertionHandler(@NotNull String suffix, boolean shouldMoveCaret, boolean shouldAutopopup) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        this.suffix = suffix;
        this.shouldMoveCaret = shouldMoveCaret;
        this.shouldAutopopup = shouldAutopopup;
    }

    public /* synthetic */ EditorConfigAppendInsertionHandler(String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(string, bl, bl2);
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caretModel2 = caretModel;
        int caretOffset = caretModel2.getOffset();
        document2.insertString(caretOffset, (CharSequence)this.suffix);
        if (this.shouldMoveCaret) {
            caretModel2.moveToOffset(caretOffset + this.suffix.length());
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
        editor2.getSelectionModel().removeSelection();
        if (this.shouldAutopopup) {
            Project project = editor2.getProject();
            Intrinsics.checkNotNull((Object)project);
            AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor2);
        }
    }
}

