/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.reference;

import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.reference.ActionReference;
import com.intellij.jpa.jpb.model.reference.TemplateHelper;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.re.reference.EntityAttrCommentHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\r2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/re/reference/UncommentAsIsHandler;", "Lcom/intellij/re/reference/EntityAttrCommentHandler;", "<init>", "()V", "getTextRangeFromJpabComment", "Lcom/intellij/openapi/util/TextRange;", "commentText", "", "actionPerformed", "", "psiComment", "Lcom/intellij/psi/PsiComment;", "entityClass", "Lcom/intellij/psi/PsiClass;", "addAccessMethods", "addedField", "Lcom/intellij/psi/PsiMember;", "entity", "Lcom/intellij/jpa/jpb/model/model/EntityPsi;", "addMethodsToClass", "dtoClass", "newMethods", "", "", "intellij.javaee.reverseEngineering"})
@SourceDebugExtension(value={"SMAP\nReverseEngineeringCommentReferenceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReverseEngineeringCommentReferenceProvider.kt\ncom/intellij/re/reference/UncommentAsIsHandler\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,296:1\n106#2:297\n78#2,22:298\n*S KotlinDebug\n*F\n+ 1 ReverseEngineeringCommentReferenceProvider.kt\ncom/intellij/re/reference/UncommentAsIsHandler\n*L\n278#1:297\n278#1:298,22\n*E\n"})
public final class UncommentAsIsHandler
extends EntityAttrCommentHandler {
    @Override
    @Nullable
    public TextRange getTextRangeFromJpabComment(@NotNull CharSequence commentText) {
        Intrinsics.checkNotNullParameter((Object)commentText, (String)"commentText");
        String regexText = "(" + JpaModelBundle.message((String)"uncomment.as.is", (Object[])new Object[0]) + ") \\| ";
        return ActionReference.Companion.getTextRangeFromComment(commentText, regexText);
    }

    @Override
    public void actionPerformed(@NotNull PsiComment psiComment, @NotNull PsiClass entityClass) {
        Intrinsics.checkNotNullParameter((Object)psiComment, (String)"psiComment");
        Intrinsics.checkNotNullParameter((Object)entityClass, (String)"entityClass");
        Project project = entityClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiMember createdField = this.getCommentedField(entityClass, psiComment);
        EntityPsi entityPsi = EntityPsi.getInstance((PsiClass)entityClass);
        Intrinsics.checkNotNullExpressionValue((Object)entityPsi, (String)"getInstance(...)");
        EntityPsi entity = entityPsi;
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> UncommentAsIsHandler.actionPerformed$lambda$0(project2, createdField, entityClass, psiComment, this, entity));
    }

    private final void addAccessMethods(PsiMember addedField, EntityPsi entity) {
        Object[] objectArray;
        String string;
        String type;
        PsiClass psiClass = entity.getPsiClass();
        Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiClass(...)");
        PsiClass entityClass = psiClass;
        if (!Intrinsics.areEqual((Object)entityClass.getLanguage(), (Object)JavaLanguage.INSTANCE)) {
            return;
        }
        List newMethods = new ArrayList();
        String name = addedField.getName();
        PsiType psiType = AttributeUtil.getMemberType((PsiMember)addedField);
        String string2 = type = psiType != null ? psiType.getCanonicalText() : null;
        if (name == null || type == null) {
            return;
        }
        String string3 = StringUtil.capitalize((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"capitalize(...)");
        String upped = string3;
        if (!entity.isLombokGetter()) {
            string = "public %3$s get%1$s() { return %2$s; }";
            objectArray = new Object[]{upped, name, type};
            String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
            newMethods.add(string4);
        }
        if (!entity.isImmutable() && !entity.isLombokSetter()) {
            string = "public void set%1$s(%3$s %2$s) { this.%2$s = %2$s; }";
            objectArray = new Object[]{upped, name, type};
            String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            newMethods.add(string5);
        }
        if (!((Collection)newMethods).isEmpty()) {
            this.addMethodsToClass(entityClass, newMethods);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addMethodsToClass(PsiClass dtoClass, List<String> newMethods) {
        Project project = dtoClass.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Iterator<String> iterator = newMethods.iterator();
        while (iterator.hasNext()) {
            PsiElement insertedMethod;
            PsiMethod createdMethod;
            void $this$trim$iv;
            String newMethod;
            String string = newMethod = iterator.next();
            PsiElementFactory psiElementFactory = PsiElementFactory.getInstance((Project)project2);
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory.createMethodFromText(((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), dtoClass.getContext()), (String)"createMethodFromText(...)");
            Intrinsics.checkNotNullExpressionValue((Object)dtoClass.add((PsiElement)createdMethod), (String)"add(...)");
            JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(insertedMethod);
        }
    }

    private static final void actionPerformed$lambda$0(Project $project, PsiMember $createdField, PsiClass $entityClass, PsiComment $psiComment, UncommentAsIsHandler this$0, EntityPsi $entity) {
        PsiElement psiElement = JavaCodeStyleManager.getInstance((Project)$project).shortenClassReferences((PsiElement)$createdField);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiMember");
        PsiMember processedField = (PsiMember)psiElement;
        TemplateHelper templateHelper = (TemplateHelper)TemplateHelper.Companion.getInstance((PsiElement)$entityClass);
        PsiMember addedField = templateHelper != null ? templateHelper.addFieldToClass($entityClass, processedField) : null;
        $psiComment.delete();
        if (addedField != null) {
            this$0.addAccessMethods(addedField, $entity);
        }
    }
}

