/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.buildView.frontend;

import com.intellij.build.BuildContent;
import com.intellij.build.BuildContentId;
import com.intellij.build.BuildId;
import com.intellij.build.BuildViewEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.observable.util.DisposerUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.platform.buildView.BuildViewApi;
import com.intellij.platform.buildView.frontend.FrontendBuildViewManagerKt;
import com.intellij.platform.buildView.frontend.FrontendMultipleBuildsView;
import com.intellij.platform.project.ProjectIdKt;
import fleet.rpc.client.DurableKt;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\u0012\u0012\b\u0012\u00060\nj\u0002`\u000b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u001d\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/buildView/frontend/FrontendBuildViewManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "activeMap", "", "", "Lcom/intellij/build/BuildCategoryId;", "Lcom/intellij/platform/buildView/frontend/FrontendMultipleBuildsView;", "getActiveMap", "()Ljava/util/Map;", "contentMap", "Lcom/intellij/build/BuildContentId;", "getContentMap", "buildMap", "Lcom/intellij/build/BuildId;", "getBuildMap", "listenToBackend", "", "getOrCreateView", "content", "Lcom/intellij/build/BuildContent;", "intellij.platform.buildView.frontend"})
final class FrontendBuildViewManager {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Map<Integer, FrontendMultipleBuildsView> activeMap;
    @NotNull
    private final Map<BuildContentId, FrontendMultipleBuildsView> contentMap;
    @NotNull
    private final Map<BuildId, FrontendMultipleBuildsView> buildMap;

    public FrontendBuildViewManager(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.activeMap = new LinkedHashMap();
        this.contentMap = new LinkedHashMap();
        this.buildMap = new LinkedHashMap();
    }

    @NotNull
    public final Map<Integer, FrontendMultipleBuildsView> getActiveMap() {
        return this.activeMap;
    }

    @NotNull
    public final Map<BuildContentId, FrontendMultipleBuildsView> getContentMap() {
        return this.contentMap;
    }

    @NotNull
    public final Map<BuildId, FrontendMultipleBuildsView> getBuildMap() {
        return this.buildMap;
    }

    public final void listenToBackend() {
        CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
        ModalityState modalityState = ModalityState.any();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
        BuildersKt.launch$default((CoroutineScope)this.scope, (CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ FrontendBuildViewManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = DurableKt.durable$default((boolean)false, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ FrontendBuildViewManager this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.label = 1;
                                        v0 = BuildViewApi.Companion.getInstance((Continuation)this);
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl13
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl13:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = ((BuildViewApi)v0).getBuildViewEventsFlow(ProjectIdKt.projectId((Project)FrontendBuildViewManager.access$getProject$p(this.this$0)), (Continuation)this);
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl21
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl21:
                                        // 2 sources

                                        this.label = 3;
                                        v2 = ((Flow)v1).collect(new FlowCollector(this.this$0){
                                            final /* synthetic */ FrontendBuildViewManager this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            public final Object emit(BuildViewEvent event, Continuation<? super Unit> $completion) {
                                                FrontendMultipleBuildsView view;
                                                Logger $this$debug_u24default$iv = FrontendBuildViewManagerKt.access$getLOG$p();
                                                Throwable t$iv = null;
                                                boolean $i$f$debug = false;
                                                if ($this$debug_u24default$iv.isDebugEnabled()) {
                                                    Logger logger = $this$debug_u24default$iv;
                                                    boolean bl = false;
                                                    logger.debug("Event: " + event, t$iv);
                                                }
                                                BuildId buildId = event.getBuildId();
                                                BuildViewEvent buildViewEvent = event;
                                                if (buildViewEvent instanceof BuildViewEvent.BuildStarted) {
                                                    FrontendMultipleBuildsView frontendMultipleBuildsView = FrontendBuildViewManager.access$getOrCreateView(this.this$0, ((BuildViewEvent.BuildStarted)event).getContent());
                                                    FrontendBuildViewManager frontendBuildViewManager = this.this$0;
                                                    FrontendMultipleBuildsView it = frontendMultipleBuildsView;
                                                    boolean bl = false;
                                                    frontendBuildViewManager.getBuildMap().put(buildId, it);
                                                    v0 = frontendMultipleBuildsView;
                                                } else {
                                                    v0 = view = buildViewEvent instanceof BuildViewEvent.BuildRemoved ? this.this$0.getBuildMap().remove(buildId) : this.this$0.getBuildMap().get(buildId);
                                                }
                                                if (view == null) {
                                                    FrontendBuildViewManagerKt.access$getLOG$p().error("Build content not found for " + event);
                                                } else {
                                                    view.handleEvent(event);
                                                }
                                                return Unit.INSTANCE;
                                            }
                                        }, (Continuation)this);
                                        if (v2 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl29
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl29:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this), (int)1, null);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final FrontendMultipleBuildsView getOrCreateView(BuildContent content2) {
        FrontendMultipleBuildsView frontendMultipleBuildsView = this.contentMap.computeIfAbsent(content2.getId(), arg_0 -> FrontendBuildViewManager.getOrCreateView$lambda$1(arg_0 -> FrontendBuildViewManager.getOrCreateView$lambda$0(content2, this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)frontendMultipleBuildsView, (String)"computeIfAbsent(...)");
        return frontendMultipleBuildsView;
    }

    private static final Unit getOrCreateView$lambda$0$0(FrontendBuildViewManager this$0, int $categoryId, FrontendMultipleBuildsView $newView, BuildContent $content) {
        this$0.activeMap.remove($categoryId, $newView);
        this$0.contentMap.remove($content.getId());
        return Unit.INSTANCE;
    }

    private static final FrontendMultipleBuildsView getOrCreateView$lambda$0(BuildContent $content, FrontendBuildViewManager this$0, BuildContentId it) {
        FrontendMultipleBuildsView newView;
        block0: {
            FrontendMultipleBuildsView oldView;
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            int categoryId = $content.getCategoryId();
            newView = new FrontendMultipleBuildsView(this$0.project, $content, this$0.scope);
            DisposerUtilKt.whenDisposed((Disposable)newView, () -> FrontendBuildViewManager.getOrCreateView$lambda$0$0(this$0, categoryId, newView, $content));
            FrontendMultipleBuildsView frontendMultipleBuildsView = oldView = this$0.activeMap.put(categoryId, newView);
            if (frontendMultipleBuildsView == null) break block0;
            frontendMultipleBuildsView.lockContent();
        }
        return newView;
    }

    private static final FrontendMultipleBuildsView getOrCreateView$lambda$1(Function1 $tmp0, Object p0) {
        return (FrontendMultipleBuildsView)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(FrontendBuildViewManager $this) {
        return $this.project;
    }

    public static final /* synthetic */ FrontendMultipleBuildsView access$getOrCreateView(FrontendBuildViewManager $this, BuildContent content2) {
        return $this.getOrCreateView(content2);
    }
}

