/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.cache;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.PathUtil;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionCacheCommonsKt;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionFileNotFoundException;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionLocalFileManager;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionLocalFileManagerKt;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionName;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionReference;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionVersion;
import com.intellij.vcs.github.ultimate.features.cache.GitHubRetriableInternalException;
import com.intellij.vcs.github.ultimate.features.cache.providers.LocalFilesProvider;
import com.intellij.vcs.github.ultimate.features.cache.state.GitHubActionsCache;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0013J \u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0080@\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bH\u0082@\u00a2\u0006\u0002\u0010\u001fJ \u0010 \u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0019H\u0082@\u00a2\u0006\u0004\b!\u0010\u001bJ\u0017\u0010\"\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b#\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/vcs/github/ultimate/features/cache/GitHubActionLocalFileManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "stateService", "Lcom/intellij/vcs/github/ultimate/features/cache/state/GitHubActionsCache;", "getStateService", "()Lcom/intellij/vcs/github/ultimate/features/cache/state/GitHubActionsCache;", "filesCacheDir", "Ljava/nio/file/Path;", "tryGetLocalFile", "", "actionReference", "Lcom/intellij/vcs/github/ultimate/features/cache/GitHubActionReference;", "tryGetLocalFile-JISXR48", "(Ljava/lang/String;)Ljava/lang/String;", "deleteFileFromCache", "", "deleteFileFromCache-m7BU8Ik", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearCache", "saveFileAndGetUrl", "remoteFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "saveFileAndGetUrl-kxUNVeE$intellij_vcs_github_ultimate_features", "(Ljava/lang/String;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "saveFile", "virtualFile", "filePath", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/nio/file/Path;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "deleteActionFile", "deleteActionFile-kxUNVeE", "createLocalFileName", "createLocalFileName-JISXR48", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nGitHubActionLocalFileManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionLocalFileManager.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionLocalFileManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n30#2,2:134\n30#2,2:136\n1#3:138\n*S KotlinDebug\n*F\n+ 1 GitHubActionLocalFileManager.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionLocalFileManager\n*L\n45#1:134,2\n51#1:136,2\n*E\n"})
public final class GitHubActionLocalFileManager {
    @NotNull
    private final Project project;
    @NotNull
    private final Path filesCacheDir;

    public GitHubActionLocalFileManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Path path = Paths.get(PathManager.getSystemPath(), new String[0]).resolve("github-actions").resolve("cache");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.filesCacheDir = path;
    }

    private final GitHubActionsCache getStateService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitHubActionsCache> serviceClass$iv = GitHubActionsCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GitHubActionsCache)object;
    }

    @Nullable
    public final String tryGetLocalFile-JISXR48(@NotNull String actionReference) throws CancellationException, GithubStatusCodeException {
        Intrinsics.checkNotNullParameter((Object)actionReference, (String)"actionReference");
        if (GitHubActionCacheCommonsKt.isLocalAction-JISXR48(actionReference)) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<LocalFilesProvider> serviceClass$iv = LocalFilesProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            LocalFilesProvider localFilesProvider = (LocalFilesProvider)object;
            VirtualFile resultVFile = localFilesProvider.resolveLocalFile-JISXR48(actionReference);
            return resultVFile.getUrl();
        }
        Path filePath = this.filesCacheDir.resolve(this.createLocalFileName-JISXR48(actionReference));
        Intrinsics.checkNotNull((Object)filePath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(filePath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return VfsUtil.pathToUrl((String)PathsKt.getInvariantSeparatorsPathString((Path)filePath));
    }

    @Nullable
    public final Object deleteFileFromCache-m7BU8Ik(@NotNull String actionReference, @NotNull Continuation<? super Unit> $completion) {
        String string;
        try {
            string = this.getStateService().getActionFileUrl-JISXR48(actionReference);
        }
        catch (GitHubActionFileNotFoundException gitHubActionFileNotFoundException) {
            return Unit.INSTANCE;
        }
        String fileUrl = string;
        if (fileUrl == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
        if (virtualFile == null) {
            return Unit.INSTANCE;
        }
        VirtualFile virtualFile2 = virtualFile;
        Object object = this.deleteActionFile-kxUNVeE(actionReference, virtualFile2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void clearCache() {
        NioFiles.deleteRecursively((Path)this.filesCacheDir);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object saveFileAndGetUrl-kxUNVeE$intellij_vcs_github_ultimate_features(@NotNull String actionReference, @NotNull VirtualFile remoteFile, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof saveFileAndGetUrl.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ GitHubActionLocalFileManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveFileAndGetUrl-kxUNVeE$intellij_vcs_github_ultimate_features(null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                filePath = this.filesCacheDir.resolve(this.createLocalFileName-JISXR48(actionReference));
                Intrinsics.checkNotNull((Object)filePath);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)actionReference);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)remoteFile);
                $continuation.L$2 = filePath;
                $continuation.label = 1;
                v0 = this.saveFile(remoteFile, filePath, (Continuation<? super Unit>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                filePath = (Path)$continuation.L$2;
                remoteFile = (VirtualFile)$continuation.L$1;
                actionReference = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                v1 = VfsUtil.pathToUrl((String)filePath.toAbsolutePath().toString());
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"pathToUrl(...)");
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object saveFile(VirtualFile virtualFile, Path filePath, Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(virtualFile, filePath, null){
            int label;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Path $filePath;
            {
                this.$virtualFile = $virtualFile;
                this.$filePath = $filePath;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        GitHubActionLocalFileManagerKt.access$getLOG$p().debug("Saving file " + this.$virtualFile + " to " + this.$filePath);
                        try {
                            Closeable closeable = this.$virtualFile.getInputStream();
                            Path path = this.$filePath;
                            Throwable throwable = null;
                            try {
                                long l;
                                InputStream inputStream = (InputStream)closeable;
                                boolean bl = false;
                                PathsKt.createParentDirectories((Path)path, (FileAttribute[])new FileAttribute[0]);
                                FileAttribute[] fileAttributeArray = new FileAttribute[]{};
                                Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(path, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
                                Object object = path;
                                Object object2 = new OpenOption[]{StandardOpenOption.WRITE};
                                OutputStream outputStream = Files.newOutputStream((Path)object, Arrays.copyOf(object2, ((OpenOption[])object2).length));
                                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                                object = outputStream;
                                object2 = null;
                                try {
                                    OutputStream outputStream2 = (OutputStream)object;
                                    boolean bl2 = false;
                                    Intrinsics.checkNotNull((Object)inputStream);
                                    l = ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)outputStream2, (int)0, (int)2, null);
                                }
                                catch (Throwable throwable2) {
                                    object2 = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                                }
                                long l2 = l;
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                        }
                        catch (IOException e) {
                            GitHubActionLocalFileManagerKt.access$getLOG$p().warn("Failed to save file " + this.$filePath, (Throwable)e);
                            throw new GitHubRetriableInternalException("fetchAndSaveActionFile(): Failed to write content to file stream", e);
                        }
                        GitHubActionLocalFileManagerKt.access$getLOG$p().debug("Finished saving " + this.$virtualFile + " to local filesystem cache " + this.$filePath);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object deleteActionFile-kxUNVeE(String actionReference, VirtualFile virtualFile, Continuation<? super Unit> $completion) {
        if (GitHubActionCacheCommonsKt.isLocalAction-JISXR48(actionReference)) {
            return CoroutinesKt.readAction(() -> GitHubActionLocalFileManager.deleteActionFile_kxUNVeE$lambda$0(virtualFile, actionReference, this), $completion);
        }
        return CoroutinesKt.edtWriteAction(() -> GitHubActionLocalFileManager.deleteActionFile_kxUNVeE$lambda$1(virtualFile, actionReference, this), $completion);
    }

    private final String createLocalFileName-JISXR48(String actionReference) {
        Pair<GitHubActionName, GitHubActionVersion> pair = GitHubActionReference.split-impl(actionReference);
        String actionName = ((GitHubActionName)pair.component1()).unbox-impl();
        String version = ((GitHubActionVersion)pair.component2()).unbox-impl();
        if (GitHubActionCacheCommonsKt.isFileReference-8eTOyyI(actionName)) {
            String string = PathUtil.getParentPath((String)actionName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getParentPath(...)");
            String path = string;
            String string2 = PathUtil.getFileName((String)actionName);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
            String fileName = string2;
            String string3 = PathUtil.makeFileName((String)(path + File.separator + version + File.separator + fileName), null);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"makeFileName(...)");
            return string3;
        }
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String string4 = PathUtil.makeFileName((String)(StringsKt.replace$default((String)actionReference, (String)"@", (String)string, (boolean)false, (int)4, null) + File.separator + "action"), (String)"yml");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"makeFileName(...)");
        return string4;
    }

    private static final Unit deleteActionFile_kxUNVeE$lambda$0(VirtualFile $virtualFile, String $actionReference, GitHubActionLocalFileManager this$0) {
        Unit unit;
        VirtualFile virtualFile;
        GitHubActionLocalFileManagerKt.access$getLOG$p().debug("Invalidating file " + $virtualFile.getUrl() + " for action " + $actionReference);
        VirtualFile it = virtualFile = $virtualFile;
        boolean bl = false;
        Object object = it.isValid() ? virtualFile : null;
        if (object != null && (object = VirtualFileUtil.findPsiFile((VirtualFile)object, (Project)this$0.project)) != null) {
            object.clearCaches();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final Unit deleteActionFile_kxUNVeE$lambda$1(VirtualFile $virtualFile, String $actionReference, GitHubActionLocalFileManager this$0) {
        Unit unit;
        VirtualFile virtualFile;
        GitHubActionLocalFileManagerKt.access$getLOG$p().debug("Deleting file " + $virtualFile.getUrl() + " for action " + $actionReference + " from filesystem cache");
        VirtualFile it = virtualFile = $virtualFile;
        boolean bl = false;
        Object object = it.isValid() ? virtualFile : null;
        if (object != null) {
            object.delete((Object)this$0);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public static final /* synthetic */ Object access$saveFile(GitHubActionLocalFileManager $this, VirtualFile virtualFile, Path filePath, Continuation $completion) {
        return $this.saveFile(virtualFile, filePath, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$deleteActionFile-kxUNVeE(GitHubActionLocalFileManager $this, String actionReference, VirtualFile virtualFile, Continuation $completion) {
        return $this.deleteActionFile-kxUNVeE(actionReference, virtualFile, (Continuation<? super Unit>)$completion);
    }
}

