/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.cache;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionCacheLoader;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionMetadataResolverKt;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionReference;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionsCatalogHelpersKt;
import com.intellij.vcs.github.ultimate.features.cache.GitHubRetriableInternalException;
import com.intellij.vcs.github.ultimate.features.cache.metadata.GitHubActionMetadata;
import com.intellij.vcs.github.ultimate.features.cache.metadata.GitHubActionMetadataFactory;
import com.intellij.vcs.github.ultimate.features.cache.state.GitHubActionsCache;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0007J\u0012\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/github/ultimate/features/cache/GitHubActionMetadataResolver;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "stateService", "Lcom/intellij/vcs/github/ultimate/features/cache/state/GitHubActionsCache;", "getStateService", "()Lcom/intellij/vcs/github/ultimate/features/cache/state/GitHubActionsCache;", "metadataFactory", "Lcom/intellij/vcs/github/ultimate/features/cache/metadata/GitHubActionMetadataFactory;", "getMetadataFactory", "()Lcom/intellij/vcs/github/ultimate/features/cache/metadata/GitHubActionMetadataFactory;", "cachedValuesManager", "Lcom/intellij/psi/util/CachedValuesManager;", "kotlin.jvm.PlatformType", "getCachedValuesManager", "()Lcom/intellij/psi/util/CachedValuesManager;", "resolve", "Lcom/intellij/vcs/github/ultimate/features/cache/metadata/GitHubActionMetadata;", "referenceString", "", "calculateAndCacheMetadata", "actionFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nGitHubActionMetadataResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionMetadataResolver.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionMetadataResolver\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n30#2,2:87\n1#3:89\n*S KotlinDebug\n*F\n+ 1 GitHubActionMetadataResolver.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionMetadataResolver\n*L\n33#1:87,2\n*E\n"})
public final class GitHubActionMetadataResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;

    public GitHubActionMetadataResolver(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
    }

    private final GitHubActionsCache getStateService() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitHubActionsCache> serviceClass$iv = GitHubActionsCache.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (GitHubActionsCache)object;
    }

    private final GitHubActionMetadataFactory getMetadataFactory() {
        return new GitHubActionMetadataFactory(this.project);
    }

    private final CachedValuesManager getCachedValuesManager() {
        return CachedValuesManager.getManager((Project)this.project);
    }

    @RequiresReadLock
    @Nullable
    public final GitHubActionMetadata resolve(@Nullable String referenceString) throws IllegalArgumentException, GithubStatusCodeException {
        CharSequence charSequence = referenceString;
        if (charSequence == null || charSequence.length() == 0) {
            throw new IllegalArgumentException("Reference String can not be empty");
        }
        String actionReference = GitHubActionReference.constructor-impl(GitHubActionsCatalogHelpersKt.normalizeReferenceString(referenceString));
        String actionFileUrl = this.getStateService().getActionFileUrl-JISXR48(actionReference);
        if (actionFileUrl == null) {
            BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, actionReference, null){
                int label;
                final /* synthetic */ GitHubActionMetadataResolver this$0;
                final /* synthetic */ String $actionReference;
                {
                    this.this$0 = $receiver;
                    this.$actionReference = $actionReference;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            ComponentManager $this$service$iv = (ComponentManager)GitHubActionMetadataResolver.access$getProject$p(this.this$0);
                            boolean $i$f$service = false;
                            Class<GitHubActionCacheLoader> serviceClass$iv = GitHubActionCacheLoader.class;
                            Object object2 = $this$service$iv.getService(serviceClass$iv);
                            if (object2 == null) {
                                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                            }
                            this.label = 1;
                            Object object3 = ((GitHubActionCacheLoader)object2).reloadActionData-m7BU8Ik(this.$actionReference, (Continuation<? super GitHubActionMetadata>)((Continuation)this));
                            if (object3 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            Object object3;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                object3 = $result;
                                return Unit.INSTANCE;
                            }
                            catch (CancellationException e) {
                                throw e;
                            }
                            catch (Exception e) {
                                GitHubActionMetadataResolverKt.access$getLOG$p().warnWithDebug("Failed to reload action data for " + this.$actionReference, (Throwable)e);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            return null;
        }
        VirtualFile actionFile = VirtualFileManager.getInstance().findFileByUrl(actionFileUrl);
        VirtualFile virtualFile = actionFile;
        GitHubActionMetadataResolverKt.access$getLOG$p().debug("Calculating metadata for " + actionReference + ". File: " + (virtualFile != null ? virtualFile.getUrl() : null));
        return this.calculateAndCacheMetadata(actionFile);
    }

    @RequiresReadLock
    @NotNull
    public final GitHubActionMetadata calculateAndCacheMetadata(@Nullable VirtualFile actionFile) throws GithubStatusCodeException {
        Object object;
        block5: {
            block4: {
                PsiFile psiFile;
                if (actionFile == null || !actionFile.isValid()) {
                    throw new GitHubRetriableInternalException("calculateAndCacheMetadata(): Failed to validate actionFile", new IllegalArgumentException(""));
                }
                object = VirtualFileUtil.findPsiFile((VirtualFile)actionFile, (Project)this.project);
                if (object == null) break block4;
                PsiFile it = psiFile = object;
                boolean bl = false;
                object = it.isValid() ? psiFile : null;
                if (object != null) break block5;
            }
            throw new GitHubRetriableInternalException("calculateAndCacheMetadata(): Failed to find psi file", new IllegalArgumentException(""));
        }
        PsiFile psiFile = object;
        GitHubActionMetadata meta = (GitHubActionMetadata)this.getCachedValuesManager().getCachedValue((UserDataHolder)psiFile, () -> GitHubActionMetadataResolver.calculateAndCacheMetadata$lambda$1(this, psiFile));
        Intrinsics.checkNotNull((Object)meta);
        return meta;
    }

    private static final CachedValueProvider.Result calculateAndCacheMetadata$lambda$1(GitHubActionMetadataResolver this$0, PsiFile $psiFile) {
        GitHubActionMetadata metadata = this$0.getMetadataFactory().createMetadata($psiFile);
        Object[] objectArray = new Object[]{$psiFile};
        return CachedValueProvider.Result.create((Object)metadata, (Object[])objectArray);
    }

    public static final /* synthetic */ Project access$getProject$p(GitHubActionMetadataResolver $this) {
        return $this.project;
    }
}

