/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.cache;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionName;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionReference;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionVersion;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionsCatalog;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.extensions.GithubYamlFileDetectionKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u0006H\u0081@\u00a2\u0006\u0002\u0010\u0007\u001a\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "normalizeReferenceString", "", "referenceString", "refreshOpenFiles", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getOpenGitHubFiles", "", "Lcom/intellij/psi/PsiFile;", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nGitHubActionsCatalogHelpers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubActionsCatalogHelpers.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionsCatalogHelpersKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,40:1\n13#2:41\n*S KotlinDebug\n*F\n+ 1 GitHubActionsCatalogHelpers.kt\ncom/intellij/vcs/github/ultimate/features/cache/GitHubActionsCatalogHelpersKt\n*L\n14#1:41\n*E\n"})
public final class GitHubActionsCatalogHelpersKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final String normalizeReferenceString(@NotNull String referenceString) {
        Intrinsics.checkNotNullParameter((Object)referenceString, (String)"referenceString");
        Pair<GitHubActionName, GitHubActionVersion> pair = GitHubActionReference.split-impl(GitHubActionReference.constructor-impl(referenceString));
        String actionName = ((GitHubActionName)pair.component1()).unbox-impl();
        String version = ((GitHubActionVersion)pair.component2()).unbox-impl();
        return actionName + "@" + version;
    }

    @RequiresReadLock
    @Nullable
    public static final Object refreshOpenFiles(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutinesKt.readAction(GitHubActionsCatalogHelpersKt::refreshOpenFiles$lambda$0, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @RequiresReadLock
    private static final Set<PsiFile> getOpenGitHubFiles() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        return SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])projectArray), GitHubActionsCatalogHelpersKt::getOpenGitHubFiles$lambda$0));
    }

    private static final Unit refreshOpenFiles$lambda$0() {
        Set<PsiFile> openGitHubFiles = GitHubActionsCatalogHelpersKt.getOpenGitHubFiles();
        LOG.debug("refreshOpenFiles(): call DaemonCodeAnalyzer.restart() for opened files: " + openGitHubFiles);
        for (PsiFile file : openGitHubFiles) {
            DaemonCodeAnalyzer.getInstance((Project)file.getProject()).restart(file, (Object)"metadata was fetched");
        }
        return Unit.INSTANCE;
    }

    private static final boolean getOpenGitHubFiles$lambda$0$0(VirtualFile virtualFile) {
        Intrinsics.checkNotNull((Object)virtualFile);
        return GithubYamlFileDetectionKt.isGithubActionsFile((VirtualFile)virtualFile);
    }

    private static final PsiFile getOpenGitHubFiles$lambda$0$1(Project $project, VirtualFile openFile) {
        return PsiManager.getInstance((Project)$project).findFile(openFile);
    }

    private static final Sequence getOpenGitHubFiles$lambda$0(Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getOpenFiles(...)");
        return SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])virtualFileArray), GitHubActionsCatalogHelpersKt::getOpenGitHubFiles$lambda$0$0), arg_0 -> GitHubActionsCatalogHelpersKt.getOpenGitHubFiles$lambda$0$1(project, arg_0));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitHubActionsCatalog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

