/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.cache.listeners;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.vcs.github.ultimate.features.cache.GitHubActionsCatalog;
import com.intellij.vcs.github.ultimate.features.cache.state.GitHubActionsCache;
import com.intellij.vcs.github.ultimate.features.context.handler.GitHubActionContext;
import com.intellij.vcs.github.ultimate.features.ide.PluginSettingsUtilKt;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\u0018\u0010\t\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\n\u001a\u00020\u00052\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\r2\b\u0010\u0012\u001a\u0004\u0018\u00010\rH\u0002J\u0017\u0010\u0013\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00142\u0006\u0010\u000f\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002J(\u0010\u0019\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u001a2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001e\u001a\u00020\rH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/vcs/github/ultimate/features/cache/listeners/LocalActionsFileChangeListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "<init>", "()V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "reloadLocalActionEntries", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFilesAffectedByDeleteAction", "event", "getFilesAffectedByCreateAction", "filterFileName", "file", "filterNewChildName", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/vfs/newvfs/events/VFileCopyEvent;", "handlePropertyChangeEvent", "Lcom/intellij/openapi/vfs/newvfs/events/VFilePropertyChangeEvent;", "refreshCacheOnGithubFolderAdded", "groupFilesByProject", "", "Lcom/intellij/openapi/project/Project;", "fileList", "collectActionChildren", "dir", "ActionFileCollector", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nLocalActionsFileChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalActionsFileChangeListener.kt\ncom/intellij/vcs/github/ultimate/features/cache/listeners/LocalActionsFileChangeListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 7 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 8 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,126:1\n1391#2:127\n1480#2,5:128\n1391#2:133\n1480#2,5:134\n1915#2:142\n1916#2:146\n812#2,12:148\n1642#2,10:160\n1915#2:170\n1916#2:172\n1652#2:173\n777#2:174\n873#2,2:175\n1915#2:177\n1916#2:183\n777#2:188\n873#2,2:189\n221#3:139\n222#3:147\n30#4,2:140\n30#4,2:181\n57#5:143\n35#5,2:144\n57#5:178\n35#5,2:179\n1#6:171\n9810#7,2:184\n9961#7,2:186\n9964#7:191\n13225#7,2:199\n507#8,7:192\n*S KotlinDebug\n*F\n+ 1 LocalActionsFileChangeListener.kt\ncom/intellij/vcs/github/ultimate/features/cache/listeners/LocalActionsFileChangeListener\n*L\n30#1:127\n30#1:128,5\n36#1:133\n36#1:134,5\n44#1:142\n44#1:146\n90#1:148,12\n91#1:160,10\n91#1:170\n91#1:172\n91#1:173\n92#1:174\n92#1:175,2\n94#1:177\n94#1:183\n102#1:188\n102#1:189,2\n42#1:139\n42#1:147\n43#1:140,2\n96#1:181,2\n45#1:143\n45#1:144,2\n95#1:178\n95#1:179,2\n91#1:171\n101#1:184,2\n101#1:186,2\n101#1:191\n107#1:199,2\n103#1:192,7\n*E\n"})
public final class LocalActionsFileChangeListener
implements BulkFileListener {
    /*
     * WARNING - void declaration
     */
    public void before(@NotNull List<? extends VFileEvent> events) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!PluginSettingsUtilKt.githubActionsSupportEnabled()) {
            return;
        }
        Iterable $this$flatMap$iv = events;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VFileEvent it = (VFileEvent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getFilesAffectedByDeleteAction(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        this.reloadLocalActionEntries(files);
    }

    /*
     * WARNING - void declaration
     */
    public void after(@NotNull List<? extends VFileEvent> events) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (!PluginSettingsUtilKt.githubActionsSupportEnabled()) {
            return;
        }
        Iterable $this$flatMap$iv = events;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            VFileEvent it = (VFileEvent)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getFilesAffectedByCreateAction(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        this.reloadLocalActionEntries(files);
        this.refreshCacheOnGithubFolderAdded(events);
    }

    private final void reloadLocalActionEntries(List<? extends VirtualFile> files) {
        Map<Project, List<VirtualFile>> $this$forEach$iv = this.groupFilesByProject(files);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Project, List<VirtualFile>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Project, List<VirtualFile>> element$iv;
            Map.Entry<Project, List<VirtualFile>> entry = element$iv = iterator.next();
            boolean bl = false;
            Project project = entry.getKey();
            List<VirtualFile> files2 = entry.getValue();
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitHubActionsCatalog> serviceClass$iv = GitHubActionsCatalog.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            GitHubActionsCatalog catalog = (GitHubActionsCatalog)object;
            Iterable $this$forEach$iv2 = files2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VirtualFile f = (VirtualFile)element$iv2;
                boolean bl2 = false;
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.debug("Files " + f.getPath() + " in project " + project.getName() + " caused action cache reload");
                catalog.reloadLocalActionEntry$intellij_vcs_github_ultimate_features(f);
            }
        }
    }

    private final List<VirtualFile> getFilesAffectedByDeleteAction(VFileEvent event) {
        List<VirtualFile> list;
        VFileEvent vFileEvent = event;
        if (vFileEvent instanceof VFileDeleteEvent) {
            if (((VFileDeleteEvent)event).getFile().isDirectory()) {
                VirtualFile virtualFile = ((VFileDeleteEvent)event).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                list = this.collectActionChildren(virtualFile);
            } else {
                list = CollectionsKt.listOfNotNull((Object)this.filterFileName(((VFileDeleteEvent)event).getFile()));
            }
        } else if (vFileEvent instanceof VFileMoveEvent) {
            if (((VFileMoveEvent)event).getFile().isDirectory()) {
                VirtualFile virtualFile = ((VFileMoveEvent)event).getOldParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
                list = this.collectActionChildren(virtualFile);
            } else {
                list = CollectionsKt.listOfNotNull((Object)this.filterFileName(((VFileMoveEvent)event).getFile()));
            }
        } else {
            list = vFileEvent instanceof VFilePropertyChangeEvent ? this.handlePropertyChangeEvent((VFilePropertyChangeEvent)event) : CollectionsKt.emptyList();
        }
        return list;
    }

    private final List<VirtualFile> getFilesAffectedByCreateAction(VFileEvent event) {
        List<Object> list;
        VFileEvent vFileEvent = event;
        if (vFileEvent instanceof VFileCreateEvent) {
            VirtualFile virtualFile = ((VFileCreateEvent)event).getFile();
            boolean bl = virtualFile != null ? virtualFile.isDirectory() : false;
            list = !bl ? CollectionsKt.listOfNotNull((Object)this.filterFileName(((VFileCreateEvent)event).getFile())) : CollectionsKt.emptyList();
        } else if (vFileEvent instanceof VFileCopyEvent) {
            list = CollectionsKt.listOfNotNull((Object)this.filterNewChildName((VFileCopyEvent)event));
        } else if (vFileEvent instanceof VFileMoveEvent) {
            if (((VFileMoveEvent)event).getFile().isDirectory()) {
                VirtualFile virtualFile = ((VFileMoveEvent)event).getNewParent();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNewParent(...)");
                list = this.collectActionChildren(virtualFile);
            } else {
                list = CollectionsKt.listOfNotNull((Object)this.filterFileName(((VFileMoveEvent)event).getFile()));
            }
        } else {
            list = vFileEvent instanceof VFilePropertyChangeEvent ? this.handlePropertyChangeEvent((VFilePropertyChangeEvent)event) : CollectionsKt.emptyList();
        }
        return list;
    }

    private final VirtualFile filterFileName(VirtualFile file) {
        VirtualFile virtualFile = file;
        return CollectionsKt.contains((Iterable)GitHubActionContext.ContextUtils.getFileNames(), (Object)(virtualFile != null ? virtualFile.getName() : null)) ? file : null;
    }

    private final VirtualFile filterNewChildName(VFileCopyEvent event) {
        return GitHubActionContext.ContextUtils.getFileNames().contains(event.getNewChildName()) ? event.getFile() : null;
    }

    private final List<VirtualFile> handlePropertyChangeEvent(VFilePropertyChangeEvent event) {
        List list;
        if (!Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name")) {
            return new ArrayList();
        }
        if (event.getFile().isDirectory()) {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            list = this.collectActionChildren(virtualFile);
        } else {
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            list = VirtualFileUtil.isFile((VirtualFile)virtualFile) && (CollectionsKt.contains((Iterable)GitHubActionContext.ContextUtils.getFileNames(), (Object)event.getOldValue()) || CollectionsKt.contains((Iterable)GitHubActionContext.ContextUtils.getFileNames(), (Object)event.getNewValue())) ? CollectionsKt.listOfNotNull((Object)event.getFile()) : (List)new ArrayList();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshCacheOnGithubFolderAdded(List<? extends VFileEvent> events) {
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = events;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof VFileCreateEvent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterIsInstanceTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VFileCreateEvent it = (VFileCreateEvent)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(it.isDirectory() && Intrinsics.areEqual((Object)it.getName(), (Object)".github"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List githubActionsFolders = (List)destination$iv$iv;
        Iterable $this$forEach$iv = this.groupFilesByProject(githubActionsFolders).keySet();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Project project = (Project)element$iv;
            boolean bl = false;
            boolean $i$f$fileLogger = false;
            boolean $i$f$currentClassLogger = false;
            Class<?> clazz$iv$iv = MethodHandles.lookup().lookupClass();
            Logger logger = Logger.getInstance(clazz$iv$iv);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("GitHub Actions folder is added, refreshing catalog");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitHubActionsCache> serviceClass$iv = GitHubActionsCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((GitHubActionsCache)object).refreshCache();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Project, List<VirtualFile>> groupFilesByProject(List<? extends VirtualFile> fileList) {
        void $this$associateWithTo$iv$iv;
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$associateWith$iv = projectArray;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)$this$associateWith$iv.length), (int)16));
        Object[] objectArray = $this$associateWith$iv;
        Map map2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (void element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$filterTo$iv$iv;
            Project project = (Project)element$iv$iv;
            void var23_26 = element$iv$iv;
            Map map3 = map2;
            boolean bl = false;
            Iterable $this$filter$iv = fileList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                void project2;
                VirtualFile file = (VirtualFile)element$iv$iv2;
                boolean bl2 = false;
                if (!ProjectFileIndex.getInstance((Project)project2).isInContent(file)) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List list = (List)destination$iv$iv2;
            map3.put(var23_26, list);
        }
        Map $this$filterValues$iv = map2;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        for (Map.Entry entry : $this$filterValues$iv.entrySet()) {
            List p0 = (List)entry.getValue();
            boolean bl = false;
            boolean bl2 = !((Collection)p0).isEmpty();
            if (!bl2) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        return result$iv;
    }

    private final List<VirtualFile> collectActionChildren(VirtualFile dir) {
        boolean isContentDir;
        block2: {
            boolean bl;
            Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
            Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
            Object[] $this$any$iv = projectArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Project project = (Project)element$iv;
                boolean bl2 = false;
                if (!ProjectFileIndex.getInstance((Project)project).isInContent(dir)) continue;
                bl = true;
                break block2;
            }
            bl = isContentDir = false;
        }
        if (!isContentDir) {
            return CollectionsKt.emptyList();
        }
        List files = new ArrayList();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)dir, (VirtualFileVisitor)new ActionFileCollector(files));
        return files;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/vcs/github/ultimate/features/cache/listeners/LocalActionsFileChangeListener$ActionFileCollector;", "Lcom/intellij/openapi/vfs/VirtualFileVisitor;", "Ljava/lang/Void;", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Ljava/util/List;)V", "getFiles", "()Ljava/util/List;", "visitFile", "", "file", "intellij.vcs.github.ultimate.features"})
    private static final class ActionFileCollector
    extends VirtualFileVisitor<Void> {
        @NotNull
        private final List<VirtualFile> files;

        public ActionFileCollector(@NotNull List<VirtualFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS};
            super(optionArray);
            this.files = files;
        }

        @NotNull
        public final List<VirtualFile> getFiles() {
            return this.files;
        }

        public boolean visitFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!file.isDirectory() && GitHubActionContext.ContextUtils.getFileNames().contains(file.getName())) {
                this.files.add(file);
            }
            return true;
        }
    }
}

