/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssBlockManipulator;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.impl.CssBlockImpl;
import com.intellij.psi.css.impl.CssBlockImplManipulatorKt;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtilCore;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006H\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0006H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/psi/css/impl/CssBlockImplManipulator;", "Lcom/intellij/psi/css/CssBlockManipulator;", "Lcom/intellij/psi/css/impl/CssBlockImpl;", "<init>", "()V", "addDeclaration", "Lcom/intellij/psi/css/CssDeclaration;", "block", "name", "", "value", "anchor", "removeDeclaration", "", "declaration", "intellij.css.backend"})
public final class CssBlockImplManipulator
implements CssBlockManipulator<CssBlockImpl> {
    @Nullable
    public CssDeclaration addDeclaration(@NotNull CssBlockImpl block, @NotNull String name, @NotNull String value, @Nullable CssDeclaration anchor) {
        ASTNode astNode;
        PsiElement _anchor;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CssBlockImpl $this$addDeclaration_u24lambda_u240 = block;
        boolean bl2 = false;
        PsiElement anchor2 = (PsiElement)anchor;
        boolean bl3 = bl = anchor2 == null || anchor2.getParent() == $this$addDeclaration_u24lambda_u240;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Project project = $this$addDeclaration_u24lambda_u240.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        CssElementFactory factory = CssElementFactory.getInstance((Project)project2);
        CssDeclaration cssDeclaration = factory.createProperty(name, value, CssPsiUtilCore.getStylesheetLanguage((PsiElement)((PsiElement)$this$addDeclaration_u24lambda_u240)));
        Intrinsics.checkNotNullExpressionValue((Object)cssDeclaration, (String)"createProperty(...)");
        CssDeclaration cssDeclaration2 = cssDeclaration;
        PsiElement semicolon = cssDeclaration2.getNextSibling();
        if (semicolon != null && semicolon.getNode().getElementType() != CssElementTypes.CSS_SEMICOLON) {
            semicolon = null;
        }
        if (anchor2 != null) {
            anchor2 = (PsiElement)CssUtilCore.appendStatementWithSemicolonIfNeeded((Project)project2, (PsiElement)anchor2);
        }
        PsiElement psiElement = anchor2;
        Object nextSibling = psiElement != null ? PsiTreeUtil.nextVisibleLeaf((PsiElement)psiElement) : null;
        PsiElement psiElement2 = nextSibling;
        if (psiElement2 == null) {
            psiElement2 = CssBlockImplManipulatorKt.access$getFirstVisibleChild($this$addDeclaration_u24lambda_u240);
        }
        PsiElement psiElement3 = _anchor = psiElement2;
        Object object = astNode = psiElement3 != null ? psiElement3.getNode() : null;
        if (astNode != null) {
            IElementType iElementType = astNode.getElementType();
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
            IElementType type = iElementType;
            if (type != CssElementTypes.CSS_SEMICOLON && anchor2 != null) {
                _anchor = anchor2;
            }
        }
        if (anchor2 != null && _anchor != null) {
            nextSibling = PsiTreeUtil.nextLeaf((PsiElement)_anchor);
            boolean containsNewLine = false;
            while (nextSibling != null && !containsNewLine) {
                boolean isComment = nextSibling instanceof PsiComment;
                boolean isWhiteSpace = nextSibling instanceof PsiWhiteSpace;
                if (!isComment && !isWhiteSpace) break;
                containsNewLine = StringUtil.containsChar((String)nextSibling.getText(), (char)'\n');
                if (containsNewLine && !isComment) continue;
                _anchor = nextSibling;
                nextSibling = PsiTreeUtil.nextLeaf((PsiElement)nextSibling);
            }
        }
        return (CssDeclaration)(semicolon != null ? $this$addDeclaration_u24lambda_u240.addRangeAfter((PsiElement)cssDeclaration2, semicolon, _anchor) : $this$addDeclaration_u24lambda_u240.addAfter((PsiElement)cssDeclaration2, _anchor));
    }

    public void removeDeclaration(@NotNull CssBlockImpl block, @NotNull CssDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        CssBlockImpl $this$removeDeclaration_u24lambda_u240 = block;
        boolean bl = false;
        PsiElement nextSibling = declaration.getNextSibling();
        if (nextSibling != null) {
            ASTNode astNode1;
            PsiElement nextNextSibling;
            ASTNode astNode = nextSibling.getNode();
            if (!(astNode == null || astNode.getElementType() != CssElementTypes.CSS_WHITE_SPACE && astNode.getElementType() != CssElementTypes.CSS_SEMICOLON || (nextNextSibling = nextSibling.getNextSibling()) == null || (astNode1 = nextNextSibling.getNode()) == null || CssElementTypes.CSS_SEMICOLON != astNode1.getElementType() && CssElementTypes.CSS_WHITE_SPACE != astNode1.getElementType())) {
                nextSibling = nextNextSibling;
            }
            if ((astNode = nextSibling.getNode()) != null && (astNode.getElementType() == CssElementTypes.CSS_SEMICOLON || astNode.getElementType() == CssElementTypes.CSS_WHITE_SPACE)) {
                $this$removeDeclaration_u24lambda_u240.deleteChildRange((PsiElement)declaration, nextSibling);
            } else {
                $this$removeDeclaration_u24lambda_u240.deleteChildRange((PsiElement)declaration, (PsiElement)declaration);
            }
        }
    }
}

