/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jvm.analysis.refactoring;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.jvm.analysis.refactoring.CallChainReplacementInfo;
import com.intellij.jvm.analysis.refactoring.CallReplacementInfo;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FileModifier.SafeTypeForPreview
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B%\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000e\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0014\u0010\u0010\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/jvm/analysis/refactoring/CallChainReplacementInfo;", "", "qualifiedReference", "", "callReplacementInfos", "", "Lcom/intellij/jvm/analysis/refactoring/CallReplacementInfo;", "<init>", "(Ljava/lang/String;[Lcom/intellij/jvm/analysis/refactoring/CallReplacementInfo;)V", "getQualifiedReference", "()Ljava/lang/String;", "getCallReplacementInfos", "()[Lcom/intellij/jvm/analysis/refactoring/CallReplacementInfo;", "[Lcom/intellij/jvm/analysis/refactoring/CallReplacementInfo;", "qualifierPresentation", "getQualifierPresentation", "callPresentation", "getCallPresentation", "presentation", "getPresentation", "intellij.jvm.analysis.refactoring"})
public final class CallChainReplacementInfo {
    @Nullable
    private final String qualifiedReference;
    @NotNull
    private final CallReplacementInfo[] callReplacementInfos;

    public CallChainReplacementInfo(@Nullable String qualifiedReference, CallReplacementInfo ... callReplacementInfos) {
        Intrinsics.checkNotNullParameter((Object)callReplacementInfos, (String)"callReplacementInfos");
        this.qualifiedReference = qualifiedReference;
        this.callReplacementInfos = callReplacementInfos;
    }

    @Nullable
    public final String getQualifiedReference() {
        return this.qualifiedReference;
    }

    @NotNull
    public final CallReplacementInfo[] getCallReplacementInfos() {
        return this.callReplacementInfos;
    }

    private final String getQualifierPresentation() {
        return this.qualifiedReference != null ? this.qualifiedReference + (!(this.callReplacementInfos.length == 0) ? "." : "") : "";
    }

    private final String getCallPresentation() {
        return !(this.callReplacementInfos.length == 0) ? ArraysKt.joinToString$default((Object[])this.callReplacementInfos, (CharSequence)"().", null, (CharSequence)"()", (int)0, null, (Function1)((Function1)callPresentation.1.INSTANCE), (int)26, null) : "";
    }

    @NotNull
    public final String getPresentation() {
        return this.getQualifierPresentation() + this.getCallPresentation();
    }
}

