/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ReadableExternalAnnotationsManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ModCommandAwareExternalAnnotationsManager
extends ReadableExternalAnnotationsManager {
    public ModCommandAwareExternalAnnotationsManager(PsiManager psiManager) {
        super(psiManager);
    }

    public static ModCommandAwareExternalAnnotationsManager getInstance(@NotNull Project project) {
        if (project == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(0);
        }
        return (ModCommandAwareExternalAnnotationsManager)ExternalAnnotationsManager.getInstance((Project)project);
    }

    @Nullable
    protected List<XmlFile> findExternalAnnotationsXmlFiles(@NotNull PsiModifierListOwner listOwner) {
        List psiFiles;
        if (listOwner == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(1);
        }
        if ((psiFiles = this.findExternalAnnotationsFiles(listOwner)) == null) {
            return null;
        }
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        for (PsiFile psiFile : psiFiles) {
            if (!(psiFile instanceof XmlFile)) continue;
            xmlFiles.add((XmlFile)psiFile);
        }
        return xmlFiles;
    }

    @NotNull
    private ModCommand processExistingExternalAnnotationsModCommand(@NotNull List<PsiModifierListOwner> listOwners, @NotNull List<String> annotationFQNs, @NotNull Processor<? super XmlTag> annotationTagProcessor) {
        if (listOwners == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(2);
        }
        if (annotationFQNs == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(3);
        }
        if (annotationTagProcessor == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(4);
        }
        if (listOwners.isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(5);
            }
            return modCommand;
        }
        List origTags = StreamEx.of(listOwners).mapToEntry(this::findExternalAnnotationsXmlFiles).removeValues(f -> f == null || f.isEmpty()).flatMapKeyValue((owner, fileList) -> StreamEx.of((Collection)fileList).cross((Collection)annotationFQNs).flatMapKeyValue((file, annotationFQN) -> ModCommandAwareExternalAnnotationsManager.getTagsToProcess(file, owner, annotationFQN).stream())).toList();
        if (origTags.isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(6);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)((XmlTag)origTags.get(0)), (tg, updater) -> {
            List tags = ContainerUtil.map((Collection)origTags, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0));
            Set files = StreamEx.of((Collection)tags).map(t -> (XmlFile)t.getContainingFile()).toSet();
            for (XmlTag tag : tags) {
                if (!tag.isValid()) continue;
                annotationTagProcessor.process((Object)tag);
            }
            if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
                for (XmlFile file : files) {
                    ModCommandAwareExternalAnnotationsManager.sortItems(file);
                }
            }
        });
        if (modCommand == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(7);
        }
        return modCommand;
    }

    @NotNull
    public ModCommand annotateExternallyModCommand(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, PsiNameValuePair @Nullable [] value) {
        if (listOwner == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(8);
        }
        if (annotationFQName == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(9);
        }
        ModCommand modCommand = this.annotateExternallyModCommand(listOwner, annotationFQName, value, List.of());
        if (modCommand == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(10);
        }
        return modCommand;
    }

    @NotNull
    public ModCommand annotateExternallyModCommand(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQName, PsiNameValuePair @Nullable [] value, @NotNull @NotNull List<@NotNull String> annotationsToRemove) {
        if (listOwner == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(11);
        }
        if (annotationFQName == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(12);
        }
        if (annotationsToRemove == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(13);
        }
        throw new UnsupportedOperationException("annotateExternallyModCommand is not implemented in " + ((Object)((Object)this)).getClass().getName());
    }

    @NotNull
    protected static List<XmlTag> getTagsToProcess(@NotNull XmlFile file, @NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN) {
        XmlDocument document;
        if (file == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(14);
        }
        if (listOwner == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(15);
        }
        if (annotationFQN == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(16);
        }
        if ((document = file.getDocument()) == null) {
            List<XmlTag> list = List.of();
            if (list == null) {
                ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(17);
            }
            return list;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            List<XmlTag> list = List.of();
            if (list == null) {
                ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(18);
            }
            return list;
        }
        String externalName = ModCommandAwareExternalAnnotationsManager.getExternalName((PsiModifierListOwner)listOwner);
        ArrayList<XmlTag> tagsToProcess = new ArrayList<XmlTag>();
        for (XmlTag tag : rootTag.getSubTags()) {
            String className;
            String nameValue = tag.getAttributeValue("name");
            String string = className = nameValue == null ? null : StringUtil.unescapeXmlEntities((String)nameValue);
            if (!Comparing.strEqual((String)className, (String)externalName)) continue;
            for (XmlTag annotationTag : tag.getSubTags()) {
                if (!Comparing.strEqual((String)annotationTag.getAttributeValue("name"), (String)annotationFQN)) continue;
                tagsToProcess.add(annotationTag);
            }
        }
        ArrayList<XmlTag> arrayList = tagsToProcess;
        if (arrayList == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public ModCommand deannotateModCommand(List<PsiModifierListOwner> listOwner, @NotNull List<String> annotationFQNs) {
        if (annotationFQNs == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(20);
        }
        return this.processExistingExternalAnnotationsModCommand(listOwner, annotationFQNs, (Processor<? super XmlTag>)((Processor)annotationTag -> {
            XmlTag xmlTag;
            PsiElement parent = annotationTag.getParent();
            annotationTag.delete();
            if (parent instanceof XmlTag && (xmlTag = (XmlTag)parent).getSubTags().length == 0) {
                parent.delete();
            }
            return true;
        }));
    }

    @NotNull
    public ModCommand editExternalAnnotationModCommand(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, PsiNameValuePair @Nullable [] value) {
        if (listOwner == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(21);
        }
        if (annotationFQN == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(22);
        }
        return this.processExistingExternalAnnotationsModCommand(List.of(listOwner), List.of(annotationFQN), (Processor<? super XmlTag>)((Processor)annotationTag -> {
            annotationTag.replace((PsiElement)XmlElementFactory.getInstance((Project)this.myPsiManager.getProject()).createTagFromText((CharSequence)ModCommandAwareExternalAnnotationsManager.createAnnotationTag(annotationFQN, value)));
            return true;
        }));
    }

    protected static void sortItems(@NotNull XmlFile xmlFile) {
        XmlDocument document;
        if (xmlFile == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(23);
        }
        if ((document = xmlFile.getDocument()) == null) {
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        ArrayList<XmlTag> itemTags = new ArrayList<XmlTag>();
        for (XmlTag item : rootTag.getSubTags()) {
            if (item.getAttributeValue("name") != null) {
                itemTags.add(item);
                continue;
            }
            item.delete();
        }
        ArrayList sorted = new ArrayList(itemTags);
        sorted.sort((item1, item2) -> {
            String externalName1 = item1.getAttributeValue("name");
            String externalName2 = item2.getAttributeValue("name");
            assert (externalName1 != null && externalName2 != null);
            return externalName1.compareTo(externalName2);
        });
        if (!sorted.equals(itemTags)) {
            for (XmlTag item : sorted) {
                rootTag.addAfter((PsiElement)item, null);
                item.delete();
            }
        }
    }

    @VisibleForTesting
    @NonNls
    @NotNull
    public static String createAnnotationTag(@NotNull String annotationFQName, PsiNameValuePair @Nullable [] values) {
        String text;
        if (annotationFQName == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(24);
        }
        if (values != null && values.length != 0) {
            text = "<annotation name='" + annotationFQName + "'>\n";
            text = (String)text + StringUtil.join((Object[])values, pair -> "<val" + (String)(pair.getName() != null ? " name=\"" + pair.getName() + "\"" : "") + " val=\"" + StringUtil.escapeXmlEntities((String)pair.getValue().getText()) + "\"/>", (String)"    \n");
            text = (String)text + "</annotation>";
        } else {
            text = "<annotation name='" + annotationFQName + "'/>\n";
        }
        String string = text;
        if (string == null) {
            ModCommandAwareExternalAnnotationsManager.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 10, 17, 18, 19, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwners";
                break;
            }
            case 3: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQNs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationTagProcessor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/ModCommandAwareExternalAnnotationsManager";
                break;
            }
            case 9: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/ModCommandAwareExternalAnnotationsManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "processExistingExternalAnnotationsModCommand";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "annotateExternallyModCommand";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagsToProcess";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotationTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findExternalAnnotationsXmlFiles";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processExistingExternalAnnotationsModCommand";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 17: 
            case 18: 
            case 19: 
            case 25: {
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "annotateExternallyModCommand";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getTagsToProcess";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "deannotateModCommand";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "editExternalAnnotationModCommand";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "sortItems";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotationTag";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 10, 17, 18, 19, 25 -> new IllegalStateException(string);
        };
    }
}

