/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.StringContentIndentUtil;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiLiteralUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.paint.LinePainter2D;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaTextBlockIndentPass
extends TextEditorHighlightingPass {
    private static final StringContentIndentRenderer RENDERER = new StringContentIndentRenderer();
    private final Editor myEditor;
    private final PsiJavaFile myFile;
    private List<StringContentIndent> myIndents;

    @Contract(pure=true)
    JavaTextBlockIndentPass(@NotNull Project project, @NotNull Editor editor, @NotNull PsiJavaFile file) {
        if (project == null) {
            JavaTextBlockIndentPass.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            JavaTextBlockIndentPass.$$$reportNull$$$0(1);
        }
        if (file == null) {
            JavaTextBlockIndentPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument());
        this.myIndents = Collections.emptyList();
        this.myEditor = editor;
        this.myFile = file;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        if (progress == null) {
            JavaTextBlockIndentPass.$$$reportNull$$$0(3);
        }
        if (!this.myEditor.getSettings().isIndentGuidesShown() || !PsiUtil.isAvailable((JavaFeature)JavaFeature.TEXT_BLOCKS, (PsiElement)this.myFile)) {
            return;
        }
        Document document = this.myEditor.getDocument();
        IndentCollector collector = new IndentCollector(document);
        this.myFile.accept((PsiElementVisitor)collector);
        this.myIndents = collector.getIndents();
    }

    public void doApplyInformationToEditor() {
        if (!StringContentIndentUtil.isDocumentUpdated(this.myEditor)) {
            return;
        }
        MarkupModel model = this.myEditor.getMarkupModel();
        Map<TextRange, RangeHighlighter> oldHighlighters = StringContentIndentUtil.getIndentHighlighters(this.myEditor);
        ArrayList<RangeHighlighter> newHighlighters = new ArrayList<RangeHighlighter>();
        for (StringContentIndent indent : this.myIndents) {
            TextRange newRange = new TextRange(indent.startOffset, indent.endOffset);
            int newIndent = indent.column;
            if (newIndent <= 0) continue;
            RangeHighlighter oldHighlighter = oldHighlighters.get(newRange);
            if (oldHighlighter != null && StringContentIndentUtil.getIndent(oldHighlighter) == newIndent) {
                newHighlighters.add(oldHighlighter);
                oldHighlighters.remove(newRange);
                continue;
            }
            RangeHighlighter newHighlighter = model.addRangeHighlighter(null, indent.startOffset, indent.endOffset, 0, HighlighterTargetArea.EXACT_RANGE);
            newHighlighter.setCustomRenderer((CustomHighlighterRenderer)RENDERER);
            StringContentIndentUtil.setIndent(newHighlighter, newIndent);
            newHighlighters.add(newHighlighter);
        }
        oldHighlighters.values().forEach(RangeMarker::dispose);
        StringContentIndentUtil.addIndentHighlighters(this.myEditor, newHighlighters);
        StringContentIndentUtil.updateTimestamp(this.myEditor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaTextBlockIndentPass";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doCollectInformation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class IndentCollector
    extends JavaRecursiveElementWalkingVisitor {
        private final Document myDocument;
        private final List<StringContentIndent> myIndents;

        private IndentCollector(@NotNull Document document) {
            if (document == null) {
                IndentCollector.$$$reportNull$$$0(0);
            }
            this.myIndents = new ArrayList<StringContentIndent>();
            this.myDocument = document;
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            TextBlockModel model;
            if (expression == null) {
                IndentCollector.$$$reportNull$$$0(1);
            }
            if ((model = TextBlockModel.create(expression)) == null) {
                return;
            }
            TextRange contentRange = this.getContentRange(model.myRange);
            if (contentRange == null) {
                return;
            }
            this.myIndents.add(new StringContentIndent(model.myBaseIndent, contentRange.getStartOffset(), contentRange.getEndOffset()));
        }

        @Nullable
        private TextRange getContentRange(@NotNull TextRange blockRange) {
            if (blockRange == null) {
                IndentCollector.$$$reportNull$$$0(2);
            }
            int nStartLine = this.myDocument.getLineNumber(blockRange.getStartOffset()) + 1;
            int nEndLine = this.myDocument.getLineNumber(blockRange.getEndOffset());
            TextRange lastLineRange = new TextRange(this.myDocument.getLineStartOffset(nEndLine), this.myDocument.getLineEndOffset(nEndLine));
            String lastLine = this.myDocument.getText(lastLineRange);
            if (StringUtil.skipWhitespaceForward((CharSequence)(lastLine = lastLine.substring(0, lastLine.indexOf("\"\"\""))), (int)0) == lastLine.length()) {
                --nEndLine;
            }
            if (nEndLine < nStartLine) {
                return null;
            }
            return new TextRange(this.myDocument.getLineStartOffset(nStartLine), this.myDocument.getLineStartOffset(nEndLine));
        }

        @Contract(pure=true)
        private List<StringContentIndent> getIndents() {
            return this.myIndents;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "blockRange";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaTextBlockIndentPass$IndentCollector";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getContentRange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static final class TextBlockModel {
            private final int myBaseIndent;
            private final TextRange myRange;

            @Contract(pure=true)
            private TextBlockModel(int baseIndent, @NotNull TextRange range) {
                if (range == null) {
                    TextBlockModel.$$$reportNull$$$0(0);
                }
                this.myBaseIndent = baseIndent;
                this.myRange = range;
            }

            @Nullable
            private static TextBlockModel create(@Nullable PsiLiteralExpression expression) {
                if (expression == null || !expression.isTextBlock()) {
                    return null;
                }
                int baseIndent = TextBlockModel.getIndent(expression);
                if (baseIndent == -1) {
                    return null;
                }
                TextRange range = expression.getTextRange();
                if (range == null) {
                    return null;
                }
                return new TextBlockModel(baseIndent, range);
            }

            private static int getIndent(@NotNull PsiLiteralExpression literal) {
                String[] lines;
                if (literal == null) {
                    TextBlockModel.$$$reportNull$$$0(1);
                }
                if ((lines = PsiLiteralUtil.getTextBlockLines((PsiLiteralExpression)literal)) == null) {
                    return -1;
                }
                int indent = PsiLiteralUtil.getTextBlockIndent((String[])lines);
                if (indent <= 0) {
                    return indent;
                }
                IndentType indentType = TextBlockModel.findIndentType(lines, indent);
                if (indentType == null) {
                    return -1;
                }
                if (indentType == IndentType.TABS) {
                    indent *= CodeStyle.getSettings((Project)literal.getProject()).getTabSize((FileType)JavaFileType.INSTANCE);
                }
                return indent;
            }

            @Nullable
            private static IndentType findIndentType(String @NotNull [] lines, int indent) {
                if (lines == null) {
                    TextBlockModel.$$$reportNull$$$0(2);
                }
                IndentType indentType = null;
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i];
                    if (!TextBlockModel.isContentPart(lines, i, line)) continue;
                    for (int j = 0; j < indent; ++j) {
                        char c = line.charAt(j);
                        IndentType currentType = IndentType.of(c);
                        if (currentType == null) {
                            return null;
                        }
                        if (indentType == null) {
                            indentType = currentType;
                            continue;
                        }
                        if (indentType == currentType) continue;
                        return null;
                    }
                }
                return indentType;
            }

            private static boolean isContentPart(String @NotNull [] lines, int i, String line) {
                if (lines == null) {
                    TextBlockModel.$$$reportNull$$$0(3);
                }
                return !line.isEmpty() && (i == lines.length - 1 || !line.chars().allMatch(Character::isWhitespace));
            }

            public String toString() {
                return "TextBlockModel{myBaseIndent=" + this.myBaseIndent + ", myRange=" + String.valueOf(this.myRange) + "}";
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literal";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "lines";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/JavaTextBlockIndentPass$IndentCollector$TextBlockModel";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "<init>";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getIndent";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "findIndentType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isContentPart";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }

            private static enum IndentType {
                SPACES,
                TABS;


                @Contract(pure=true)
                @Nullable
                private static IndentType of(char c) {
                    if (c == ' ') {
                        return SPACES;
                    }
                    if (c == '\t') {
                        return TABS;
                    }
                    return null;
                }
            }
        }
    }

    private record StringContentIndent(int column, int startOffset, int endOffset) {
    }

    private static class StringContentIndentRenderer
    implements CustomHighlighterRenderer {
        private StringContentIndentRenderer() {
        }

        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            int endLine;
            int indent;
            if (editor == null) {
                StringContentIndentRenderer.$$$reportNull$$$0(0);
            }
            if (highlighter == null) {
                StringContentIndentRenderer.$$$reportNull$$$0(1);
            }
            if (g == null) {
                StringContentIndentRenderer.$$$reportNull$$$0(2);
            }
            if ((indent = StringContentIndentUtil.getIndent(highlighter)) <= 0) {
                return;
            }
            int startOffset = highlighter.getStartOffset();
            int endOffset = highlighter.getEndOffset();
            int startLine = editor.offsetToVisualLine(startOffset, false);
            if (startLine == (endLine = editor.offsetToVisualLine(endOffset, false)) && editor.getFoldingModel().isOffsetCollapsed(startOffset)) {
                return;
            }
            Point start = editor.visualPositionToXY(new VisualPosition(startLine, indent - 1));
            Point end = editor.visualPositionToXY(new VisualPosition(endLine, indent - 1));
            EditorColorsScheme scheme = editor.getColorsScheme();
            g.setColor(scheme.getColor(EditorColors.STRING_CONTENT_INDENT_GUIDE_COLOR));
            g.setFont(scheme.getFont(EditorFontType.PLAIN));
            FontMetrics fontMetrics = g.getFontMetrics();
            int ascent = fontMetrics.getAscent();
            int descent = fontMetrics.getDescent();
            float baseline = editor.getAscent();
            float startY = (float)start.y + baseline - (float)ascent;
            float endY = (float)end.y + baseline + (float)descent;
            Point right = editor.visualPositionToXY(new VisualPosition(startLine, indent));
            float x = (float)(start.x + right.x) / 2.0f;
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)x, (double)startY, (double)x, (double)endY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
            }
            objectArray[1] = "com/intellij/codeInsight/daemon/impl/JavaTextBlockIndentPass$StringContentIndentRenderer";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

