/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddTypeCastFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceExpressionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceWithQualifierFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapWithAdapterMethodCallFix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.MethodCallUtils;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import one.util.streamex.MoreCollectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AdaptExpressionTypeFixUtil {
    private AdaptExpressionTypeFixUtil() {
    }

    private static void registerPatchParametersFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression call, @NotNull PsiMethod method, @NotNull PsiType expectedTypeByParent, @NotNull PsiType actualType) {
        PsiClassType psiClassType;
        JavaResolveResult result;
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(0);
        }
        if (call == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(1);
        }
        if (method == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(2);
        }
        if (expectedTypeByParent == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(3);
        }
        if (actualType == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(4);
        }
        if (!((result = call.resolveMethodGenerics()) instanceof MethodCandidateInfo)) {
            return;
        }
        MethodCandidateInfo candidateInfo = (MethodCandidateInfo)result;
        PsiType methodType = method.getReturnType();
        Substitution.TypeParameterSubstitution substitution = (Substitution.TypeParameterSubstitution)ObjectUtils.tryCast((Object)AdaptExpressionTypeFixUtil.findDesiredSubstitution(expectedTypeByParent, actualType, methodType, 0), Substitution.TypeParameterSubstitution.class);
        if (substitution == null) {
            return;
        }
        PsiTypeParameter typeParameter = substitution.myTypeParameter;
        PsiType expectedTypeValue = substitution.myDesiredType;
        Object[] parameters = method.getParameterList().getParameters();
        Set<PsiTypeParameter> set = Set.of(typeParameter);
        if (!PsiTreeUtil.isAncestor((PsiElement)method, (PsiElement)typeParameter, (boolean)true)) {
            AdaptExpressionTypeFixUtil.registerPatchQualifierFixes(info, call, method, typeParameter, expectedTypeValue, (PsiParameter[])parameters, set);
            return;
        }
        PsiParameter parameter = ((Optional)StreamEx.of((Object[])parameters).collect(MoreCollectors.onlyOne(p -> PsiTypesUtil.mentionsTypeParameters((PsiType)p.getType(), (Set)set)))).orElse(null);
        PsiSubstitutor substitutor = candidateInfo.getSubstitutor(false);
        PsiSubstitutor desiredSubstitutor = substitutor.put(typeParameter, expectedTypeValue);
        if (parameter == null) {
            parameter = AdaptExpressionTypeFixUtil.findWrongParameter(call, method, desiredSubstitutor, typeParameter);
        }
        if (parameter == null) {
            return;
        }
        PsiExpression arg = PsiUtil.skipParenthesizedExprDown((PsiExpression)MethodCallUtils.getArgumentForParameter((PsiCall)call, parameter));
        if (arg == null) {
            return;
        }
        PsiType parameterType = parameter.getType();
        if (parameterType instanceof PsiEllipsisType) {
            PsiEllipsisType ellipsisType = (PsiEllipsisType)parameterType;
            if (MethodCallUtils.isVarArgCall((PsiCall)call)) {
                if (call.getArgumentList().getExpressionCount() != parameters.length) {
                    return;
                }
                parameterType = ellipsisType.getComponentType();
            }
        }
        if (parameterType instanceof PsiClassType && (psiClassType = (PsiClassType)parameterType).rawType().equalsToText("java.lang.Class") && typeParameter == AdaptExpressionTypeFixUtil.getSoleTypeParameter(parameterType) && expectedTypeValue instanceof PsiClassType) {
            PsiClassType classType = (PsiClassType)expectedTypeValue;
            if (JavaGenericsUtil.isReifiableType((PsiType)expectedTypeValue)) {
                info.accept((CommonIntentionAction)new ReplaceExpressionAction(arg, classType.rawType().getCanonicalText() + ".class", classType.rawType().getPresentableText() + ".class"));
            }
        }
        PsiType expectedArgType = desiredSubstitutor.substitute(parameterType);
        if (arg instanceof PsiLambdaExpression && parameterType instanceof PsiClassType) {
            AdaptExpressionTypeFixUtil.registerLambdaReturnFixes(info, (PsiLambdaExpression)arg, (PsiClassType)parameterType, expectedArgType, typeParameter);
            return;
        }
        PsiType actualArgType = PsiPolyExpressionUtil.isPolyExpression((PsiExpression)arg) ? substitutor.put(typeParameter, substitution.myActualType).substitute(parameterType) : arg.getType();
        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, false, arg, expectedArgType, actualArgType);
    }

    @Nullable
    private static PsiParameter findWrongParameter(@NotNull PsiMethodCallExpression call, @NotNull PsiMethod method, @NotNull PsiSubstitutor substitutor, @NotNull PsiTypeParameter typeParameter) {
        if (call == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(5);
        }
        if (method == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(6);
        }
        if (substitutor == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(7);
        }
        if (typeParameter == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(8);
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        PsiExpression[] expressions = call.getArgumentList().getExpressions();
        if (expressions.length != parameters.length) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)call.getProject());
        ArrayList<PsiParameter> candidates = new ArrayList<PsiParameter>();
        for (int i = 0; i < parameters.length; ++i) {
            MethodCandidateInfo info;
            PsiType type = parameters[i].getType();
            if (!PsiTypesUtil.mentionsTypeParameters((PsiType)type, Set.of(typeParameter))) continue;
            PsiType substituted = substitutor.substitute(type);
            PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(x)null", (PsiElement)call);
            PsiTypeElement typeElement = factory.createTypeElement(substituted);
            try {
                Objects.requireNonNull(cast.getCastType()).replace((PsiElement)typeElement);
            }
            catch (IncorrectOperationException ignored) {
                continue;
            }
            PsiMethodCallExpression copy = (PsiMethodCallExpression)LambdaUtil.copyTopLevelCall((PsiCall)call);
            copy.getArgumentList().getExpressions()[i].replace((PsiElement)cast);
            JavaResolveResult resolveResult = copy.resolveMethodGenerics();
            if (!(resolveResult instanceof MethodCandidateInfo) || (info = (MethodCandidateInfo)resolveResult).getElement() != method || info.getInferenceErrorMessage() != null) continue;
            candidates.add(parameters[i]);
        }
        return (PsiParameter)ContainerUtil.getOnlyItem(candidates);
    }

    private static void registerPatchQualifierFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiMethodCallExpression call, @NotNull PsiMethod method, @NotNull PsiTypeParameter typeParameter, @NotNull PsiType expectedTypeValue, @NotNull @NotNull PsiParameter @NotNull [] parameters, @NotNull Set<PsiTypeParameter> set) {
        PsiMethodCallExpression qualifierCall;
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(9);
        }
        if (call == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(10);
        }
        if (method == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(11);
        }
        if (typeParameter == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(12);
        }
        if (expectedTypeValue == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(13);
        }
        if (set == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(14);
        }
        if (parameters == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(15);
        }
        if ((qualifierCall = MethodCallUtils.getQualifierMethodCall(call)) == null) {
            return;
        }
        JavaResolveResult qualifierResolve = qualifierCall.resolveMethodGenerics();
        PsiMethod qualifierMethod = (PsiMethod)ObjectUtils.tryCast((Object)qualifierResolve.getElement(), PsiMethod.class);
        if (qualifierMethod == null) {
            return;
        }
        PsiClassType qualifierType = (PsiClassType)ObjectUtils.tryCast((Object)qualifierMethod.getReturnType(), PsiClassType.class);
        if (qualifierType == null) {
            return;
        }
        if (ContainerUtil.exists((Object[])parameters, p -> PsiTypesUtil.mentionsTypeParameters((PsiType)p.getType(), (Set)set))) {
            return;
        }
        PsiClassType.ClassResolveResult classResolveResult = qualifierType.resolveGenerics();
        PsiClass qualifierClass = classResolveResult.getElement();
        if (qualifierClass == null) {
            return;
        }
        PsiClassType expectedQualifierType = JavaPsiFacade.getElementFactory((Project)method.getProject()).createType(qualifierClass, classResolveResult.getSubstitutor().put(typeParameter, expectedTypeValue));
        PsiType actualType = qualifierCall.getType();
        if (actualType != null && !expectedQualifierType.equals(actualType)) {
            AdaptExpressionTypeFixUtil.registerPatchParametersFixes(info, qualifierCall, qualifierMethod, (PsiType)expectedQualifierType, actualType);
        }
    }

    private static void registerLambdaReturnFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiLambdaExpression arg, @NotNull PsiClassType parameterType, @Nullable PsiType expectedArgType, @NotNull PsiTypeParameter typeParameter) {
        PsiTypeParameter[] fnParams;
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(16);
        }
        if (arg == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(17);
        }
        if (parameterType == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(18);
        }
        if (typeParameter == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(19);
        }
        if (!(expectedArgType instanceof PsiClassType)) {
            return;
        }
        PsiExpression lambdaBody = LambdaUtil.extractSingleExpressionFromBody((PsiElement)arg.getBody());
        if (lambdaBody == null) {
            return;
        }
        PsiClass fnInterface = parameterType.resolve();
        if (fnInterface == null) {
            return;
        }
        Object[] fnArgs = parameterType.getParameters();
        if (fnArgs.length != (fnParams = fnInterface.getTypeParameters()).length) {
            return;
        }
        PsiType fnTypeArgumentToChange = ((Optional)StreamEx.of((Object[])fnArgs).collect(MoreCollectors.onlyOne(c -> PsiTypesUtil.mentionsTypeParameters((PsiType)c, Set.of(typeParameter))))).orElse(null);
        if (fnTypeArgumentToChange == null) {
            return;
        }
        int index = ArrayUtil.indexOf((Object[])fnArgs, (Object)fnTypeArgumentToChange);
        if (index == -1) {
            return;
        }
        PsiTypeParameter fnParam = fnParams[index];
        PsiMethod sam = LambdaUtil.getFunctionalInterfaceMethod((PsiClass)fnInterface);
        if (sam == null) {
            return;
        }
        Set<PsiTypeParameter> fnParamSet = Set.of(fnParam);
        PsiType returnType = sam.getReturnType();
        if (!PsiTypesUtil.mentionsTypeParameters((PsiType)returnType, fnParamSet) || ContainerUtil.exists((Object[])sam.getParameterList().getParameters(), p -> PsiTypesUtil.mentionsTypeParameters((PsiType)p.getType(), (Set)fnParamSet))) {
            return;
        }
        PsiType expectedFnReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)expectedArgType);
        if (expectedFnReturnType == null) {
            return;
        }
        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, false, lambdaBody, expectedFnReturnType);
    }

    static void registerExpectedTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiExpression expression, @Nullable PsiType expectedType) {
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(20);
        }
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(21);
        }
        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, true, expression, expectedType);
    }

    private static void registerExpectedTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, boolean wholeRange, @NotNull PsiExpression expression, @Nullable PsiType expectedType) {
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(22);
        }
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(23);
        }
        PsiType actualType = PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expression) ? ((PsiExpression)expression.copy()).getType() : expression.getType();
        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, wholeRange, expression, expectedType, actualType);
    }

    static void registerExpectedTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, @NotNull PsiExpression expression, @Nullable PsiType expectedType, @Nullable PsiType actualType) {
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(24);
        }
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(25);
        }
        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes(info, true, expression, expectedType, actualType);
    }

    private static void registerExpectedTypeFixes(@NotNull Consumer<? super CommonIntentionAction> info, boolean wholeRange, @NotNull PsiExpression expression, @Nullable PsiType expectedType, @Nullable PsiType actualType) {
        String role;
        if (info == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(26);
        }
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(27);
        }
        if (actualType == null || expectedType == null) {
            return;
        }
        HighlightFixUtil.registerChangeVariableTypeFixes(info, expression, expectedType);
        if (!(expression.getParent() instanceof PsiConditionalExpression) || !PsiTypes.voidType().equals((Object)expectedType)) {
            info.accept((CommonIntentionAction)HighlightFixUtil.createChangeReturnTypeFix(expression, expectedType));
        }
        boolean mentionsTypeArgument = AdaptExpressionTypeFixUtil.mentionsTypeArgument(expression, actualType);
        expectedType = GenericsUtil.getVariableTypeByExpressionType((PsiType)expectedType);
        String string = role = wholeRange ? null : AdaptExpressionTypeFixUtil.getRole(expression);
        if (!mentionsTypeArgument) {
            info.accept((CommonIntentionAction)new WrapWithAdapterMethodCallFix(expectedType, expression, role));
            info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createWrapWithOptionalFix(expectedType, expression));
            info.accept((CommonIntentionAction)new WrapExpressionFix(expectedType, expression, role));
            PsiType castToType = AdaptExpressionTypeFixUtil.suggestCastTo(expression, expectedType, actualType);
            if (castToType != null) {
                info.accept((CommonIntentionAction)new AddTypeCastFix(castToType, expression, role));
            }
        }
        if (expectedType instanceof PsiArrayType) {
            PsiArrayType arrayType = (PsiArrayType)expectedType;
            PsiType erasedValueType = TypeConversionUtil.erasure((PsiType)actualType);
            if (erasedValueType != null && !PsiTypes.nullType().equals(erasedValueType) && TypeConversionUtil.isAssignable((PsiType)arrayType.getComponentType(), (PsiType)erasedValueType)) {
                info.accept((CommonIntentionAction)QuickFixFactory.getInstance().createSurroundWithArrayFix(null, expression));
            }
        }
        HighlightFixUtil.registerCollectionToArrayFixAction(info, actualType, expectedType, expression);
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod argMethod;
            PsiType type;
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
            if (qualifier != null && (type = qualifier.getType()) != null && expectedType.isAssignableFrom(type)) {
                info.accept((CommonIntentionAction)new ReplaceWithQualifierFix(call, role));
            }
            if ((argMethod = call.resolveMethod()) != null) {
                AdaptExpressionTypeFixUtil.registerPatchParametersFixes(info, call, argMethod, expectedType, actualType);
            }
        }
    }

    private static boolean mentionsTypeArgument(PsiExpression expression, PsiType type) {
        if (!(expression instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        return PsiTypesUtil.mentionsTypeParameters((PsiType)type, Set.of(method.getTypeParameters()));
    }

    @Nls
    private static String getRole(@NotNull PsiExpression expression) {
        PsiElement parent;
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(28);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression.getParent())) instanceof PsiExpressionList) {
            long index;
            PsiExpressionList list = (PsiExpressionList)parent;
            int count = list.getExpressionCount();
            if (count > 1 && (index = StreamEx.of((Object[])list.getExpressions()).map(PsiUtil::skipParenthesizedExprDown).indexOf((Object)expression).orElse(-1L)) != -1L) {
                return QuickFixBundle.message("fix.expression.role.nth.argument", index + 1L);
            }
            return QuickFixBundle.message("fix.expression.role.argument", new Object[0]);
        }
        if (parent instanceof PsiLambdaExpression) {
            return QuickFixBundle.message("fix.expression.role.lambda.return", new Object[0]);
        }
        return null;
    }

    @NotNull
    private static Substitution findDesiredSubstitution(@Nullable PsiType expected, @Nullable PsiType actual, @Nullable PsiType methodType, int level) {
        PsiClassType expectedClassType;
        PsiClass methodClass;
        block34: {
            block33: {
                if (expected == null || actual == null || methodType == null) {
                    Substitution substitution = Substitution.BOTTOM;
                    if (substitution == null) {
                        AdaptExpressionTypeFixUtil.$$$reportNull$$$0(29);
                    }
                    return substitution;
                }
                if (expected instanceof PsiArrayType) {
                    PsiArrayType expectedArrayType = (PsiArrayType)expected;
                    if (actual instanceof PsiArrayType) {
                        PsiArrayType actualArrayType = (PsiArrayType)actual;
                        if (methodType instanceof PsiArrayType) {
                            PsiArrayType methodArrayType = (PsiArrayType)methodType;
                            return AdaptExpressionTypeFixUtil.findDesiredSubstitution(expectedArrayType.getComponentType(), actualArrayType.getComponentType(), methodArrayType.getComponentType(), level);
                        }
                    }
                }
                if (expected.equals(actual)) {
                    Substitution substitution = Substitution.TOP;
                    if (substitution == null) {
                        AdaptExpressionTypeFixUtil.$$$reportNull$$$0(30);
                    }
                    return substitution;
                }
                if (!(methodType instanceof PsiClassType)) {
                    Substitution substitution = Substitution.BOTTOM;
                    if (substitution == null) {
                        AdaptExpressionTypeFixUtil.$$$reportNull$$$0(31);
                    }
                    return substitution;
                }
                PsiClassType classType = (PsiClassType)methodType;
                methodClass = classType.resolve();
                if (methodClass == null) {
                    Substitution substitution = Substitution.BOTTOM;
                    if (substitution == null) {
                        AdaptExpressionTypeFixUtil.$$$reportNull$$$0(32);
                    }
                    return substitution;
                }
                if (methodClass instanceof PsiTypeParameter) {
                    PsiTypeParameter parameter = (PsiTypeParameter)methodClass;
                    if (!(expected instanceof PsiPrimitiveType)) {
                        for (PsiClassType superType : methodClass.getSuperTypes()) {
                            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(parameter, expected);
                            if (substitutor.substitute((PsiType)superType).isAssignableFrom(expected)) continue;
                            Substitution substitution = Substitution.BOTTOM;
                            if (substitution == null) {
                                AdaptExpressionTypeFixUtil.$$$reportNull$$$0(33);
                            }
                            return substitution;
                        }
                        return new Substitution.TypeParameterSubstitution(parameter, actual, expected);
                    }
                    Substitution substitution = Substitution.BOTTOM;
                    if (substitution == null) {
                        AdaptExpressionTypeFixUtil.$$$reportNull$$$0(34);
                    }
                    return substitution;
                }
                if (!(expected instanceof PsiClassType)) break block33;
                expectedClassType = (PsiClassType)expected;
                if (actual instanceof PsiClassType) break block34;
            }
            Substitution substitution = Substitution.BOTTOM;
            if (substitution == null) {
                AdaptExpressionTypeFixUtil.$$$reportNull$$$0(35);
            }
            return substitution;
        }
        PsiClassType actualClassType = (PsiClassType)actual;
        PsiClass expectedClass = expectedClassType.resolve();
        PsiClass actualClass = actualClassType.resolve();
        if (expectedClass == null || actualClass == null || !actualClass.isEquivalentTo((PsiElement)methodClass)) {
            Substitution substitution = Substitution.BOTTOM;
            if (substitution == null) {
                AdaptExpressionTypeFixUtil.$$$reportNull$$$0(36);
            }
            return substitution;
        }
        if (!expectedClass.isEquivalentTo((PsiElement)actualClass)) {
            if (level > 0) {
                Substitution substitution = Substitution.BOTTOM;
                if (substitution == null) {
                    AdaptExpressionTypeFixUtil.$$$reportNull$$$0(37);
                }
                return substitution;
            }
            methodType = AdaptExpressionTypeFixUtil.trySubstitute(methodType, expectedClass);
            actual = AdaptExpressionTypeFixUtil.trySubstitute(actual, expectedClass);
            if (methodType == null || actual == null) {
                Substitution substitution = Substitution.BOTTOM;
                if (substitution == null) {
                    AdaptExpressionTypeFixUtil.$$$reportNull$$$0(38);
                }
                return substitution;
            }
        }
        PsiType[] methodTypeParameters = ((PsiClassType)methodType).getParameters();
        PsiType[] expectedTypeParameters = expectedClassType.getParameters();
        PsiType[] actualTypeParameters = ((PsiClassType)actual).getParameters();
        if (methodTypeParameters.length != expectedTypeParameters.length || methodTypeParameters.length != actualTypeParameters.length) {
            Substitution substitution = Substitution.BOTTOM;
            if (substitution == null) {
                AdaptExpressionTypeFixUtil.$$$reportNull$$$0(39);
            }
            return substitution;
        }
        Substitution existing = Substitution.TOP;
        for (int i = 0; i < methodTypeParameters.length; ++i) {
            Substitution substitution = AdaptExpressionTypeFixUtil.findDesiredSubstitution(expectedTypeParameters[i], actualTypeParameters[i], methodTypeParameters[i], level + 1);
            if (existing == Substitution.TOP) {
                existing = substitution;
                continue;
            }
            if (substitution == Substitution.TOP || existing.equals(substitution)) continue;
            Substitution substitution2 = Substitution.BOTTOM;
            if (substitution2 == null) {
                AdaptExpressionTypeFixUtil.$$$reportNull$$$0(40);
            }
            return substitution2;
        }
        Substitution substitution = existing;
        if (substitution == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(41);
        }
        return substitution;
    }

    @Nullable
    private static PsiType trySubstitute(@NotNull PsiType type, @NotNull PsiClass superClass) {
        if (type == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(42);
        }
        if (superClass == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(43);
        }
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClassType.ClassResolveResult result = classType.resolveGenerics();
        PsiClass psiClass = result.getElement();
        if (psiClass == null) {
            return null;
        }
        if (!psiClass.isInheritor(superClass, true)) {
            return null;
        }
        PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)psiClass, (PsiSubstitutor)result.getSubstitutor());
        return JavaPsiFacade.getElementFactory((Project)superClass.getProject()).createType(superClass, substitutor);
    }

    @Nullable
    private static PsiTypeParameter getSoleTypeParameter(@Nullable PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiType[] parameters = classType.getParameters();
        if (parameters.length != 1) {
            return null;
        }
        PsiType parameter = parameters[0];
        if (parameter instanceof PsiWildcardType) {
            PsiWildcardType wildcardType = (PsiWildcardType)parameter;
            parameter = wildcardType.getExtendsBound();
        }
        if (!(parameter instanceof PsiClassType)) {
            return null;
        }
        PsiClassType paramClassType = (PsiClassType)parameter;
        return (PsiTypeParameter)ObjectUtils.tryCast((Object)paramClassType.resolve(), PsiTypeParameter.class);
    }

    @Nullable
    static PsiType suggestCastTo(@NotNull PsiExpression expression, @Nullable PsiType expectedTypeByParent, @Nullable PsiType actualType) {
        PsiPrimitiveType unboxedType;
        boolean convertible;
        if (expression == null) {
            AdaptExpressionTypeFixUtil.$$$reportNull$$$0(44);
        }
        PsiExpression origExpression = expression;
        while (expression instanceof PsiTypeCastExpression || expression instanceof PsiParenthesizedExpression) {
            if (expression instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)expression;
                if ((expression = castExpression.getOperand()) == null) {
                    return null;
                }
                actualType = expression.getType();
            }
            if (!(expression instanceof PsiParenthesizedExpression)) continue;
            PsiParenthesizedExpression parenthesizedExpression = (PsiParenthesizedExpression)expression;
            expression = parenthesizedExpression.getExpression();
        }
        if (expression == null || expectedTypeByParent == null || actualType == null) {
            return null;
        }
        if (origExpression == expression && TypeConversionUtil.isAssignable((PsiType)expectedTypeByParent, (PsiType)actualType)) {
            return null;
        }
        boolean bl = convertible = expression instanceof PsiNewExpression ? expectedTypeByParent.isAssignableFrom(actualType) : TypeConversionUtil.areTypesConvertible((PsiType)actualType, (PsiType)expectedTypeByParent);
        if (convertible) {
            return expectedTypeByParent;
        }
        if (actualType instanceof PsiPrimitiveType && (unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)expectedTypeByParent)) != null && TypeConversionUtil.areTypesConvertible((PsiType)actualType, (PsiType)unboxedType)) {
            return unboxedType;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeByParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 8: 
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypeValue";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/AdaptExpressionTypeFixUtil";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/AdaptExpressionTypeFixUtil";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "findDesiredSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerPatchParametersFixes";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findWrongParameter";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerPatchQualifierFixes";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerLambdaReturnFixes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "registerExpectedTypeFixes";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getRole";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "trySubstitute";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "suggestCastTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41 -> new IllegalStateException(string);
        };
    }

    private static interface Substitution {
        public static final Substitution TOP = new Substitution(){

            public String toString() {
                return "TOP";
            }
        };
        public static final Substitution BOTTOM = new Substitution(){

            public String toString() {
                return "BOTTOM";
            }
        };

        public static class TypeParameterSubstitution
        implements Substitution {
            @NotNull
            final PsiTypeParameter myTypeParameter;
            @NotNull
            final PsiType myActualType;
            @NotNull
            final PsiType myDesiredType;

            public TypeParameterSubstitution(@NotNull PsiTypeParameter parameter, @NotNull PsiType actualType, @NotNull PsiType desiredType) {
                if (parameter == null) {
                    TypeParameterSubstitution.$$$reportNull$$$0(0);
                }
                if (actualType == null) {
                    TypeParameterSubstitution.$$$reportNull$$$0(1);
                }
                if (desiredType == null) {
                    TypeParameterSubstitution.$$$reportNull$$$0(2);
                }
                this.myTypeParameter = parameter;
                this.myActualType = actualType;
                this.myDesiredType = desiredType;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TypeParameterSubstitution that = (TypeParameterSubstitution)o;
                return this.myTypeParameter.equals((Object)that.myTypeParameter) && this.myDesiredType.equals(that.myDesiredType);
            }

            public int hashCode() {
                return Objects.hash(this.myTypeParameter, this.myDesiredType);
            }

            public String toString() {
                return this.myTypeParameter.getName() + "->" + this.myDesiredType.getCanonicalText();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parameter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actualType";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "desiredType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/codeInsight/daemon/impl/analysis/AdaptExpressionTypeFixUtil$Substitution$TypeParameterSubstitution";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }
}

