/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.ClassUtil;
import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.analysis.AbstractJavaErrorFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.AdaptExpressionTypeFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixTypoUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightFixUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddExportsOptionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddMissingDeconstructionComponentsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModulesOptionFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AddRequiresDirectiveFix;
import com.intellij.codeInsight.daemon.impl.quickfix.AdjustFunctionContextFix;
import com.intellij.codeInsight.daemon.impl.quickfix.DeleteRepeatedInterfaceFix;
import com.intellij.codeInsight.daemon.impl.quickfix.FlipIntersectionSidesFix;
import com.intellij.codeInsight.daemon.impl.quickfix.GoToSymbolFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MergeModuleStatementsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MissingStrProcessorFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveAnnotationOnStaticMemberQualifyingTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveAnnotationToPackageInfoFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveFileFix;
import com.intellij.codeInsight.daemon.impl.quickfix.MoveMembersIntoClassFix;
import com.intellij.codeInsight.daemon.impl.quickfix.NormalizeBracketsFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifySuperArgumentFix;
import com.intellij.codeInsight.daemon.impl.quickfix.QualifyWithThisFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceVarWithExplicitTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.ReplaceWithYieldFix;
import com.intellij.codeInsight.daemon.impl.quickfix.VariableArrayTypeFix;
import com.intellij.codeInsight.daemon.impl.quickfix.WrapExpressionFix;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.QuickFixFactory;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.PriorityIntentionActionWrapper;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.core.JavaPsiBundle;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.java.codeserver.core.JavaPreviewFeatureUtil;
import com.intellij.java.codeserver.core.JavaPsiModifierUtil;
import com.intellij.java.codeserver.core.JavaPsiSwitchUtil;
import com.intellij.java.codeserver.core.JpmsModuleAccessInfo;
import com.intellij.java.codeserver.highlighting.errors.JavaAmbiguousCallContext;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.java.codeserver.highlighting.errors.JavaIncompatibleTypeErrorContext;
import com.intellij.java.codeserver.highlighting.errors.JavaMismatchedCallContext;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCaseLabelElement;
import com.intellij.psi.PsiCaseLabelElementList;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiDeconstructionList;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiImplicitClass;
import com.intellij.psi.PsiImportModuleStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReference;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifier;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReceiverParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSwitchLabeledRuleStatement;
import com.intellij.psi.PsiTemplateExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.impl.light.LightRecordField;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.AccessModifier;
import com.intellij.psi.util.JavaPsiPatternUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.fixes.MakeDefaultLastCaseFix;
import com.siyeh.ig.psiutils.InstanceOfUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultJavaErrorFixProvider
extends AbstractJavaErrorFixProvider {
    private final QuickFixFactory myFactory = QuickFixFactory.getInstance();

    DefaultJavaErrorFixProvider() {
        this.multi(JavaErrorKinds.UNSUPPORTED_FEATURE, error -> HighlightFixUtil.getIncreaseLanguageLevelFixes(error.psi(), (JavaFeature)error.context()));
        this.multi(JavaErrorKinds.PREVIEW_API_USAGE, error -> HighlightFixUtil.getIncreaseLanguageLevelFixes(error.psi(), ((JavaPreviewFeatureUtil.PreviewFeatureUsage)error.context()).feature()));
        AbstractJavaErrorFixProvider.JavaFixProvider genericRemover = error -> this.myFactory.createDeleteFix(error.psi());
        for (JavaErrorKind kind : List.of(JavaErrorKinds.ANNOTATION_MEMBER_THROWS_NOT_ALLOWED, JavaErrorKinds.ANNOTATION_ATTRIBUTE_DUPLICATE, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_EXTENDS, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_IN_PERMIT_LIST, JavaErrorKinds.RECEIVER_STATIC_CONTEXT, JavaErrorKinds.RECEIVER_WRONG_POSITION, JavaErrorKinds.RECORD_HEADER_REGULAR_CLASS, JavaErrorKinds.INTERFACE_CLASS_INITIALIZER, JavaErrorKinds.INTERFACE_CONSTRUCTOR, JavaErrorKinds.CLASS_IMPLICIT_INITIALIZER, JavaErrorKinds.CLASS_IMPLICIT_PACKAGE, JavaErrorKinds.RECORD_EXTENDS, JavaErrorKinds.ENUM_EXTENDS, JavaErrorKinds.RECORD_PERMITS, JavaErrorKinds.ENUM_PERMITS, JavaErrorKinds.ANNOTATION_PERMITS, JavaErrorKinds.NEW_EXPRESSION_DIAMOND_NOT_ALLOWED, JavaErrorKinds.REFERENCE_TYPE_ARGUMENT_STATIC_CLASS, JavaErrorKinds.STATEMENT_CASE_OUTSIDE_SWITCH, JavaErrorKinds.NEW_EXPRESSION_DIAMOND_NOT_APPLICABLE, JavaErrorKinds.NEW_EXPRESSION_ANONYMOUS_IMPLEMENTS_INTERFACE_WITH_TYPE_ARGUMENTS, JavaErrorKinds.CALL_DIRECT_ABSTRACT_METHOD_ACCESS, JavaErrorKinds.RECORD_SPECIAL_METHOD_TYPE_PARAMETERS, JavaErrorKinds.RECORD_SPECIAL_METHOD_THROWS, JavaErrorKinds.ARRAY_TYPE_ARGUMENTS, JavaErrorKinds.ARRAY_EMPTY_DIAMOND, JavaErrorKinds.IMPORT_LIST_EXTRA_SEMICOLON, JavaErrorKinds.ENUM_CONSTANT_MODIFIER, JavaErrorKinds.METHOD_REFERENCE_PARAMETERIZED_QUALIFIER, JavaErrorKinds.CONSTRUCTOR_IN_IMPLICIT_CLASS, JavaErrorKinds.TYPE_ARGUMENT_IN_PERMITS_LIST, JavaErrorKinds.MODULE_NO_PACKAGE, JavaErrorKinds.MODULE_DUPLICATE_REQUIRES, JavaErrorKinds.MODULE_DUPLICATE_EXPORTS, JavaErrorKinds.MODULE_DUPLICATE_OPENS, JavaErrorKinds.MODULE_DUPLICATE_USES, JavaErrorKinds.MODULE_DUPLICATE_PROVIDES, JavaErrorKinds.MODULE_OPENS_IN_WEAK_MODULE)) {
            this.fix(kind, genericRemover);
        }
        this.createModifierFixes();
        this.createClassFixes();
        this.createConstructorFixes();
        this.createMethodFixes();
        this.createExpressionFixes();
        this.createVariableFixes();
        this.createPatternFixes();
        this.createStatementFixes();
        this.createExceptionFixes();
        this.createGenericFixes();
        this.createRecordFixes();
        this.createTypeFixes();
        this.createAccessFixes();
        this.createAnnotationFixes();
        this.createReceiverParameterFixes();
        this.createModuleFixes();
    }

    private void createModuleFixes() {
        this.fix(JavaErrorKinds.MODULE_FILE_WRONG_NAME, error -> this.myFactory.createRenameFileFix("module-info.java"));
        this.fix(JavaErrorKinds.MODULE_FILE_DUPLICATE, error -> error.context() != null ? new GoToSymbolFix((NavigatablePsiElement)error.context(), JavaErrorBundle.message("module.open.duplicate.text", new Object[0])) : null);
        AbstractJavaErrorFixProvider.JavaFixProvider mergeModuleFix = error -> MergeModuleStatementsFix.createFix(error.psi());
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_REQUIRES, mergeModuleFix);
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_PROVIDES, mergeModuleFix);
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_OPENS, mergeModuleFix);
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_USES, mergeModuleFix);
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_EXPORTS, mergeModuleFix);
        this.fix(JavaErrorKinds.MODULE_FILE_WRONG_LOCATION, error -> new MoveFileFix(((PsiJavaModule)error.psi()).getContainingFile().getVirtualFile(), (VirtualFile)error.context(), QuickFixBundle.message("move.file.to.source.root.text", new Object[0])));
        this.fix(JavaErrorKinds.MODULE_OPENS_IN_WEAK_MODULE, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "open"));
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_EXPORTS_TARGET, error -> this.myFactory.createDeleteFix(error.psi(), QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_OPENS_TARGET, error -> this.myFactory.createDeleteFix(error.psi(), QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
        this.fix(JavaErrorKinds.IMPORT_MODULE_NOT_ALLOWED, error -> this.myFactory.createReplaceOnDemandImport((PsiImportModuleStatement)error.psi(), QuickFixBundle.message("replace.import.module.fix.text", new Object[0])));
        this.fix(JavaErrorKinds.MODULE_DUPLICATE_IMPLEMENTATION, error -> this.myFactory.createDeleteFix(error.psi(), QuickFixBundle.message("delete.reference.fix.text", new Object[0])));
        this.multi(JavaErrorKinds.MODULE_NOT_ON_PATH, error -> {
            PsiJavaModuleReference ref = ((PsiJavaModuleReferenceElement)error.psi()).getReference();
            if (ref != null) {
                ArrayList registrar = new ArrayList();
                this.myFactory.registerOrderEntryFixes((PsiReference)ref, registrar);
                return registrar;
            }
            return List.of();
        });
        this.fix(JavaErrorKinds.MODULE_SERVICE_IMPLEMENTATION_TYPE, error -> {
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)error.project()).createType(((JavaErrorKinds.SuperclassSubclassContext)error.context()).superClass());
            return this.myFactory.createExtendsListFix(((JavaErrorKinds.SuperclassSubclassContext)error.context()).subClass(), type, true);
        });
        AbstractJavaErrorFixProvider.JavaFixProvider createClassInPackage = error -> {
            String packageName = ((PsiPackageAccessibilityStatement)error.psi()).getPackageName();
            Module module = ModuleUtilCore.findModuleForFile((PsiFile)((PsiPackageAccessibilityStatement)error.psi()).getContainingFile());
            return module == null ? null : this.myFactory.createCreateClassInPackageInModuleFix(module, packageName);
        };
        this.fix(JavaErrorKinds.MODULE_REFERENCE_PACKAGE_NOT_FOUND, createClassInPackage);
        this.fix(JavaErrorKinds.MODULE_REFERENCE_PACKAGE_EMPTY, createClassInPackage);
        AbstractJavaErrorFixProvider.JavaFixProvider fixExports = error -> {
            if (((JpmsModuleAccessInfo)error.context()).getTarget().getPackageName().isEmpty()) {
                return null;
            }
            Module jpsModule = ((JpmsModuleAccessInfo)error.context()).getCurrent().getJpsModule();
            PsiJavaModule targetModule = ((JpmsModuleAccessInfo)error.context()).getTarget().getModule();
            if (targetModule instanceof PsiCompiledElement && jpsModule != null) {
                return new AddExportsOptionFix(jpsModule, targetModule.getName(), ((JpmsModuleAccessInfo)error.context()).getTarget().getPackageName(), ((JpmsModuleAccessInfo)error.context()).getCurrent().getName());
            }
            if (!(targetModule instanceof PsiCompiledElement) && ((JpmsModuleAccessInfo)error.context()).getCurrent().getModule() != null) {
                return new AddExportsDirectiveFix(Objects.requireNonNull(targetModule), ((JpmsModuleAccessInfo)error.context()).getTarget().getPackageName(), ((JpmsModuleAccessInfo)error.context()).getCurrent().getName());
            }
            return null;
        };
        this.fix(JavaErrorKinds.MODULE_ACCESS_FROM_UNNAMED, fixExports);
        this.fix(JavaErrorKinds.MODULE_ACCESS_FROM_NAMED, fixExports);
        AbstractJavaErrorFixProvider.JavaFixProvider fixModuleOptions = error -> new AddModulesOptionFix(Objects.requireNonNull(((JpmsModuleAccessInfo)error.context()).getCurrent().getJpsModule()), Objects.requireNonNull(((JpmsModuleAccessInfo)error.context()).getTarget().getModule()).getName());
        this.fix(JavaErrorKinds.MODULE_ACCESS_PACKAGE_NOT_IN_GRAPH, fixModuleOptions);
        this.fix(JavaErrorKinds.MODULE_ACCESS_NOT_IN_GRAPH, fixModuleOptions);
        AbstractJavaErrorFixProvider.JavaFixProvider fixRequires = error -> new AddRequiresDirectiveFix(Objects.requireNonNull(((JpmsModuleAccessInfo)error.context()).getCurrent().getModule()), Objects.requireNonNull(((JpmsModuleAccessInfo)error.context()).getTarget().getModule()).getName());
        this.fix(JavaErrorKinds.MODULE_ACCESS_PACKAGE_DOES_NOT_READ, fixRequires);
        this.fix(JavaErrorKinds.MODULE_ACCESS_DOES_NOT_READ, fixRequires);
        this.fixes(JavaErrorKinds.MODULE_ACCESS_JPS_DEPENDENCY_PROBLEM, (error, sink) -> {
            PsiJavaModuleReferenceElement ref;
            PsiJavaModuleReference reference;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiJavaModuleReferenceElement && (reference = (ref = (PsiJavaModuleReferenceElement)patt0$temp).getReference()) != null) {
                ArrayList list = new ArrayList();
                this.myFactory.registerOrderEntryFixes((PsiReference)reference, list);
                list.forEach(sink);
            }
        });
    }

    private void createStatementFixes() {
        this.fix(JavaErrorKinds.RETURN_OUTSIDE_SWITCH_EXPRESSION, error -> ((PsiReturnStatement)error.psi()).getReturnValue() != null ? new ReplaceWithYieldFix((PsiReturnStatement)error.psi()) : null);
        this.fixes(JavaErrorKinds.RETURN_VALUE_MISSING, (error, sink) -> {
            PsiMethod method = (PsiMethod)error.context();
            sink.accept(this.myFactory.createMethodReturnFix(method, (PsiType)PsiTypes.voidType(), true));
            PsiType expectedType = HighlightFixUtil.determineReturnType(method);
            if (expectedType != null && !PsiTypes.voidType().equals((Object)expectedType)) {
                sink.accept(this.myFactory.createMethodReturnFix(method, expectedType, true, true));
            }
        });
        AbstractJavaErrorFixProvider.JavaFixesPusher fixReturnFromVoid = (error, sink) -> {
            PsiMethod method = (PsiMethod)error.context();
            if (method != null && method.getBody() != null) {
                PsiType expectedType;
                PsiType valueType = RefactoringChangeUtil.getTypeByExpression((PsiExpression)Objects.requireNonNull(((PsiReturnStatement)error.psi()).getReturnValue()));
                if (valueType != null) {
                    sink.accept(this.myFactory.createDeleteReturnFix(method, (PsiReturnStatement)error.psi()));
                    sink.accept(this.myFactory.createMethodReturnFix(method, valueType, true));
                }
                if ((expectedType = HighlightFixUtil.determineReturnType(method)) != null && !PsiTypes.voidType().equals((Object)expectedType) && !expectedType.equals(valueType)) {
                    sink.accept(this.myFactory.createMethodReturnFix(method, expectedType, true, true));
                }
            }
        };
        this.fixes(JavaErrorKinds.RETURN_FROM_CONSTRUCTOR, fixReturnFromVoid);
        this.fixes(JavaErrorKinds.RETURN_FROM_VOID_METHOD, fixReturnFromVoid);
        this.fix(JavaErrorKinds.RETURN_MISSING, error -> this.myFactory.createAddReturnFix((PsiParameterListOwner)error.context()));
        this.fix(JavaErrorKinds.RETURN_MISSING, error -> {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            Object patt0$temp = error.context();
            if (patt0$temp instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)patt0$temp;
                localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createMethodReturnFix(method, (PsiType)PsiTypes.voidType(), true);
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            return localQuickFixAndIntentionActionOnPsiElement;
        });
        this.fixes(JavaErrorKinds.STATEMENT_BAD_EXPRESSION, (error, sink) -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiExpressionStatement) {
                PsiLoopStatement loop;
                PsiExpressionStatement expressionStatement = (PsiExpressionStatement)patt0$temp;
                HighlightFixUtil.registerFixesForExpressionStatement(sink, (PsiElement)expressionStatement);
                PsiElement parent = expressionStatement.getParent();
                if (parent instanceof PsiCodeBlock || parent instanceof PsiIfStatement || parent instanceof PsiLoopStatement && (loop = (PsiLoopStatement)parent).getBody() == expressionStatement) {
                    sink.accept(PriorityIntentionActionWrapper.lowPriority((IntentionAction)this.myFactory.createDeleteSideEffectAwareFix(expressionStatement)));
                }
            }
        });
        this.fix(JavaErrorKinds.STATEMENT_BAD_EXPRESSION, error -> HighlightFixTypoUtil.createKeywordTypoFix((PsiStatement)error.psi()));
        this.fix(JavaErrorKinds.STATEMENT_UNREACHABLE, error -> this.myFactory.createDeleteFix(error.psi(), QuickFixBundle.message("delete.unreachable.statement.fix.text", new Object[0])));
        this.fix(JavaErrorKinds.STATEMENT_UNREACHABLE_LOOP_BODY, error -> this.myFactory.createSimplifyBooleanFix((PsiExpression)error.psi(), false));
        this.fix(JavaErrorKinds.FOREACH_NOT_APPLICABLE, error -> this.myFactory.createNotIterableForEachLoopFix((PsiExpression)error.psi()));
        this.fix(JavaErrorKinds.LABEL_WITHOUT_STATEMENT, error -> HighlightFixTypoUtil.createKeywordTypoFix((PsiLabeledStatement)error.psi()));
        this.fix(JavaErrorKinds.SWITCH_LABEL_EXPECTED, error -> {
            PsiSwitchLabeledRuleStatement previousRule = (PsiSwitchLabeledRuleStatement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)error.psi(), PsiSwitchLabeledRuleStatement.class);
            return previousRule == null ? null : this.myFactory.createWrapSwitchRuleStatementsIntoBlockFix(previousRule);
        });
        this.fixes(JavaErrorKinds.SWITCH_SELECTOR_TYPE_INVALID, (error, sink) -> {
            HighlightFixUtil.registerFixesOnInvalidSelector(sink, (PsiExpression)error.psi());
            JavaFeature feature = ((JavaPsiSwitchUtil.SelectorKind)error.context()).getFeature();
            if (feature != null) {
                HighlightFixUtil.getIncreaseLanguageLevelFixes(error.psi(), feature).forEach(sink);
            }
        });
        this.fix(JavaErrorKinds.SWITCH_LABEL_DUPLICATE, error -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiCaseLabelElement) {
                PsiCaseLabelElement caseLabel = (PsiCaseLabelElement)patt0$temp;
                return this.myFactory.createDeleteSwitchLabelFix(caseLabel);
            }
            if (error.context() == JavaPsiSwitchUtil.SwitchSpecialValue.DEFAULT_VALUE) {
                return this.myFactory.createDeleteDefaultFix(null, error.psi());
            }
            return null;
        });
        this.fix(JavaErrorKinds.SWITCH_EXPRESSION_NO_RESULT, error -> this.myFactory.createLiftThrowOutOfSwitchExpression((PsiSwitchExpression)error.psi()));
        this.fix(JavaErrorKinds.SYNTAX_ERROR, error -> {
            PsiElement patt0$temp = ((PsiErrorElement)error.psi()).getParent();
            if (!(patt0$temp instanceof PsiSwitchLabeledRuleStatement)) return null;
            PsiSwitchLabeledRuleStatement rule = (PsiSwitchLabeledRuleStatement)patt0$temp;
            if (!((PsiErrorElement)error.psi()).getErrorDescription().equals(JavaPsiBundle.message((String)"expected.switch.rule", (Object[])new Object[0]))) return null;
            IntentionAction intentionAction = this.myFactory.createWrapSwitchRuleStatementsIntoBlockFix(rule);
            return intentionAction;
        });
        this.fix(JavaErrorKinds.SYNTAX_ERROR, error -> HighlightFixTypoUtil.createKeywordTypoFix((PsiErrorElement)error.psi()));
    }

    private void createMethodFixes() {
        AbstractJavaErrorFixProvider.JavaFixProvider addBody = error -> this.myFactory.createAddMethodBodyFix((PsiMethod)error.psi());
        this.fix(JavaErrorKinds.METHOD_DEFAULT_SHOULD_HAVE_BODY, addBody);
        this.fix(JavaErrorKinds.METHOD_STATIC_IN_INTERFACE_SHOULD_HAVE_BODY, addBody);
        this.fix(JavaErrorKinds.METHOD_PRIVATE_IN_INTERFACE_SHOULD_HAVE_BODY, addBody);
        this.fix(JavaErrorKinds.METHOD_SHOULD_HAVE_BODY, addBody);
        this.fix(JavaErrorKinds.METHOD_SHOULD_HAVE_BODY_OR_ABSTRACT, addBody);
        this.fix(JavaErrorKinds.METHOD_DEFAULT_IN_CLASS, error -> this.removeModifierFix((PsiModifierListOwner)error.psi(), "default"));
        this.fix(JavaErrorKinds.METHOD_ABSTRACT_BODY, error -> this.removeModifierFix((PsiModifierListOwner)error.psi(), "abstract"));
        this.fix(JavaErrorKinds.METHOD_SHOULD_HAVE_BODY_OR_ABSTRACT, error -> this.maybeAddModifierFix((PsiModifierListOwner)error.psi(), "abstract"));
        AbstractJavaErrorFixProvider.JavaFixProvider deleteBody = error -> this.myFactory.createDeleteMethodBodyFix((PsiMethod)error.psi());
        this.fix(JavaErrorKinds.METHOD_ABSTRACT_BODY, deleteBody);
        this.fix(JavaErrorKinds.METHOD_INTERFACE_BODY, deleteBody);
        this.fix(JavaErrorKinds.METHOD_NATIVE_BODY, deleteBody);
        this.fix(JavaErrorKinds.METHOD_NO_PARAMETER_LIST, error -> this.myFactory.createAddParameterListFix((PsiMethod)error.psi()));
        this.fixes(JavaErrorKinds.METHOD_INTERFACE_BODY, (error, sink) -> {
            PsiMethod method = (PsiMethod)error.psi();
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.EXTENSION_METHODS, (PsiElement)method) && Stream.of(method.findDeepestSuperMethods()).map(PsiJvmMember::getContainingClass).filter(Objects::nonNull).map(PsiClass::getQualifiedName).noneMatch("java.lang.Object"::equals)) {
                sink.accept(PriorityIntentionActionWrapper.highPriority((IntentionAction)this.addModifierFix((PsiModifierListOwner)method, "default")));
                sink.accept(this.addModifierFix((PsiModifierListOwner)method, "static"));
            }
        });
        this.fix(JavaErrorKinds.METHOD_ABSTRACT_BODY, error -> this.myFactory.createPushDownMethodFix());
        this.fix(JavaErrorKinds.METHOD_NATIVE_BODY, error -> this.myFactory.createPushDownMethodFix());
        this.fix(JavaErrorKinds.METHOD_STATIC_OVERRIDES_INSTANCE, error -> this.removeModifierFix((PsiModifierListOwner)((JavaErrorKinds.OverrideClashContext)error.context()).method(), "static"));
        this.fix(JavaErrorKinds.METHOD_INSTANCE_OVERRIDES_STATIC, error -> this.maybeAddModifierFix((PsiModifierListOwner)((JavaErrorKinds.OverrideClashContext)error.context()).method(), "static"));
        this.fix(JavaErrorKinds.METHOD_STATIC_OVERRIDES_INSTANCE, error -> this.maybeAddModifierFix((PsiModifierListOwner)((JavaErrorKinds.OverrideClashContext)error.context()).superMethod(), "static"));
        this.fix(JavaErrorKinds.METHOD_INSTANCE_OVERRIDES_STATIC, error -> this.removeModifierFix((PsiModifierListOwner)((JavaErrorKinds.OverrideClashContext)error.context()).superMethod(), "static"));
        this.fix(JavaErrorKinds.METHOD_OVERRIDES_FINAL, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.METHOD_INHERITANCE_WEAKER_PRIVILEGES, error -> {
            IntentionAction intentionAction;
            if (error.psi() instanceof PsiMethod) {
                intentionAction = this.myFactory.createChangeModifierFix();
            } else {
                PsiElement patt0$temp = error.psi();
                if (patt0$temp instanceof PsiClass) {
                    PsiClass cls = (PsiClass)patt0$temp;
                    intentionAction = this.myFactory.createImplementMethodsFix(cls);
                } else {
                    intentionAction = null;
                }
            }
            return intentionAction;
        });
        this.multi(JavaErrorKinds.METHOD_INHERITANCE_CLASH_DOES_NOT_THROW, error -> List.of(this.myFactory.createMethodThrowsFix(((JavaErrorKinds.IncompatibleOverrideExceptionContext)error.context()).method(), ((JavaErrorKinds.IncompatibleOverrideExceptionContext)error.context()).exceptionType(), false, false), this.myFactory.createMethodThrowsFix(((JavaErrorKinds.IncompatibleOverrideExceptionContext)error.context()).superMethod(), ((JavaErrorKinds.IncompatibleOverrideExceptionContext)error.context()).exceptionType(), true, true)));
        this.fix(JavaErrorKinds.VARARG_NOT_LAST_PARAMETER, error -> this.myFactory.createMakeVarargParameterLastFix((PsiVariable)error.psi()));
        this.fixes(JavaErrorKinds.METHOD_INHERITANCE_CLASH_INCOMPATIBLE_RETURN_TYPES, (error, sink) -> {
            PsiType patt0$temp;
            JavaErrorKinds.IncompatibleOverrideReturnTypeContext context = (JavaErrorKinds.IncompatibleOverrideReturnTypeContext)error.context();
            PsiMethod method = context.method();
            if (method instanceof LightRecordMethod) {
                LightRecordMethod recordMethod = (LightRecordMethod)method;
                HighlightFixUtil.getChangeVariableTypeFixes((PsiVariable)recordMethod.getRecordComponent(), context.superMethodReturnType()).forEach(sink);
            } else {
                sink.accept(this.myFactory.createMethodReturnFix(method, context.superMethodReturnType(), false));
            }
            sink.accept(this.myFactory.createSuperMethodReturnFix(context.superMethod(), context.methodReturnType()));
            PsiClass returnClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)context.methodReturnType());
            if (returnClass != null && (patt0$temp = context.superMethodReturnType()) instanceof PsiClassType) {
                PsiClassType classType = (PsiClassType)patt0$temp;
                sink.accept(this.myFactory.createChangeParameterClassFix(returnClass, classType));
            }
        });
        this.fix(JavaErrorKinds.VARARG_CSTYLE_DECLARATION, error -> new NormalizeBracketsFix((PsiVariable)error.psi()));
        this.fix(JavaErrorKinds.METHOD_MISSING_RETURN_TYPE_NOT_CONSTRUCTOR, error -> {
            PsiMethod method = (PsiMethod)error.psi();
            PsiType expectedType = HighlightFixUtil.determineReturnType(method);
            return expectedType != null ? this.myFactory.createMethodReturnFix(method, expectedType, true, true) : null;
        });
        this.fixes(JavaErrorKinds.METHOD_MISSING_RETURN_TYPE, (error, sink) -> {
            String className = (String)error.context();
            PsiMethod method = (PsiMethod)error.psi();
            sink.accept(this.myFactory.createRenameElementFix((PsiNamedElement)method, className));
            PsiType expectedType = HighlightFixUtil.determineReturnType(method);
            if (expectedType != null) {
                sink.accept(this.myFactory.createMethodReturnFix(method, expectedType, true, true));
            }
        });
        this.fixes(JavaErrorKinds.METHOD_ABSTRACT_IN_NON_ABSTRACT_CLASS, (error, sink) -> {
            PsiMethod method = (PsiMethod)error.context();
            sink.accept(method.getBody() != null ? this.removeModifierFix((PsiModifierListOwner)method, "abstract") : this.myFactory.createAddMethodBodyFix(method));
            PsiClass aClass = method.getContainingClass();
            if (aClass != null && !aClass.isEnum() && !aClass.isRecord()) {
                sink.accept(this.addModifierFix((PsiModifierListOwner)aClass, "abstract"));
            }
        });
        this.fix(JavaErrorKinds.METHOD_GENERIC_CLASH, error -> ((JavaErrorKinds.OverrideClashContext)error.context()).method() instanceof SyntheticElement ? null : this.myFactory.createSameErasureButDifferentMethodsFix(((JavaErrorKinds.OverrideClashContext)error.context()).method(), ((JavaErrorKinds.OverrideClashContext)error.context()).superMethod()));
        this.fixes(JavaErrorKinds.METHOD_DUPLICATE, (error, sink) -> {
            List duplicates = ContainerUtil.filter((Collection)((JavaErrorKinds.DuplicateMethodsContext)error.context()).methods(), m -> !(m instanceof SyntheticElement));
            if (duplicates.size() > 1) {
                sink.accept(this.myFactory.createShowDuplicateElementsFix(duplicates));
            }
        });
    }

    private void createExceptionFixes() {
        this.fix(JavaErrorKinds.EXCEPTION_MUST_BE_DISJOINT, error -> this.myFactory.createDeleteMultiCatchFix((PsiTypeElement)error.psi()));
        this.fix(JavaErrorKinds.EXCEPTION_NEVER_THROWN_TRY_MULTI, error -> this.myFactory.createDeleteMultiCatchFix((PsiTypeElement)error.psi()));
        this.fixes(JavaErrorKinds.EXCEPTION_ALREADY_CAUGHT, (error, sink) -> {
            PsiParameter parameter = (PsiParameter)PsiTreeUtil.getParentOfType((PsiElement)error.psi(), PsiParameter.class, (boolean)false);
            if (parameter == null) {
                return;
            }
            boolean multiCatch = PsiUtil.getParameterTypeElements((PsiParameter)parameter).size() > 1;
            sink.accept(multiCatch ? this.myFactory.createDeleteMultiCatchFix((PsiTypeElement)error.psi()) : this.myFactory.createDeleteCatchFix(parameter));
            PsiCatchSection catchSection = (PsiCatchSection)Objects.requireNonNull(parameter.getDeclarationScope());
            PsiCatchSection upperCatchSection = (PsiCatchSection)error.context();
            sink.accept(this.myFactory.createMoveCatchUpFix(catchSection, upperCatchSection));
        });
        this.fix(JavaErrorKinds.EXCEPTION_NEVER_THROWN_TRY, error -> this.myFactory.createDeleteCatchFix((PsiParameter)error.psi()));
        this.fixes(JavaErrorKinds.EXCEPTION_UNHANDLED, (error, sink) -> {
            PsiElement element = error.psi();
            HighlightFixUtil.registerUnhandledExceptionFixes(element, sink);
            if (element instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)element;
                sink.accept(this.myFactory.createAddExceptionToThrowsFix((PsiElement)method, (Collection)error.context()));
                PsiClass aClass = method.getContainingClass();
                if (aClass != null) {
                    sink.accept(this.myFactory.createCreateConstructorMatchingSuperFix(aClass));
                }
            } else if (element instanceof PsiClass) {
                PsiClass cls = (PsiClass)element;
                sink.accept(this.myFactory.createCreateConstructorMatchingSuperFix(cls));
            }
        });
        this.fixes(JavaErrorKinds.EXCEPTION_UNHANDLED_CLOSE, (error, sink) -> HighlightFixUtil.registerUnhandledExceptionFixes(error.psi(), sink));
    }

    private void createConstructorFixes() {
        AbstractJavaErrorFixProvider.JavaFixesPusher constructorCallFixes = (error, sink) -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiClass) {
                PsiClass cls = (PsiClass)patt0$temp;
                sink.accept(this.myFactory.createCreateConstructorMatchingSuperFix(cls));
            } else {
                PsiElement patt1$temp = error.psi();
                if (patt1$temp instanceof PsiMethod) {
                    PsiMethod method = (PsiMethod)patt1$temp;
                    sink.accept(this.myFactory.createInsertSuperFix(method));
                    sink.accept(this.myFactory.createInsertThisFix(method));
                }
            }
        };
        this.fixes(JavaErrorKinds.CONSTRUCTOR_AMBIGUOUS_IMPLICIT_CALL, constructorCallFixes);
        this.fixes(JavaErrorKinds.CONSTRUCTOR_NO_DEFAULT, constructorCallFixes);
        this.fix(JavaErrorKinds.CONSTRUCTOR_AMBIGUOUS_IMPLICIT_CALL, error -> this.myFactory.createAddDefaultConstructorFix(Objects.requireNonNull(((JavaErrorKinds.AmbiguousImplicitConstructorCallContext)error.context()).psiClass().getSuperClass())));
        this.fix(JavaErrorKinds.CONSTRUCTOR_NO_DEFAULT, error -> this.myFactory.createAddDefaultConstructorFix((PsiClass)error.context()));
    }

    private void createModifierFixes() {
        this.fix(JavaErrorKinds.MODIFIER_NOT_ALLOWED, error -> {
            PsiClass aClass;
            String modifier = (String)error.context();
            PsiModifierList list = (PsiModifierList)((PsiKeyword)error.psi()).getParent();
            PsiElement parent = list.getParent();
            if (parent instanceof PsiClass && !(aClass = (PsiClass)parent).isInterface() && ("private".equals(modifier) || "protected".equals(modifier))) {
                return this.myFactory.createChangeModifierFix();
            }
            if (parent instanceof PsiModifierListOwner) {
                PsiModifierListOwner owner = (PsiModifierListOwner)parent;
                return this.removeModifierFix(owner, modifier);
            }
            return this.myFactory.createModifierListFix(list, modifier, false, false);
        });
        AbstractJavaErrorFixProvider.JavaFixProvider removeModifier = error -> {
            String modifier = ((PsiKeyword)error.psi()).getText();
            PsiModifierList list = (PsiModifierList)((PsiKeyword)error.psi()).getParent();
            return this.removeModifierFix((PsiModifierListOwner)list.getParent(), modifier);
        };
        this.fix(JavaErrorKinds.MODIFIER_NOT_ALLOWED_LOCAL_CLASS, removeModifier);
        this.fix(JavaErrorKinds.MODIFIER_REPEATED, removeModifier);
        this.fix(JavaErrorKinds.MODIFIER_INCOMPATIBLE, removeModifier);
        this.fix(JavaErrorKinds.MODIFIER_NOT_ALLOWED_NON_SEALED, removeModifier);
    }

    private void createPatternFixes() {
        this.fixes(JavaErrorKinds.PATTERN_DECONSTRUCTION_COUNT_MISMATCH, (error, sink) -> {
            if (((JavaErrorKinds.DeconstructionCountMismatchContext)error.context()).hasMismatch()) {
                return;
            }
            PsiRecordComponent[] recordComponents = ((JavaErrorKinds.DeconstructionCountMismatchContext)error.context()).recordComponents();
            PsiPattern[] patternComponents = ((JavaErrorKinds.DeconstructionCountMismatchContext)error.context()).patternComponents();
            PsiDeconstructionList list = (PsiDeconstructionList)error.psi();
            if (patternComponents.length < recordComponents.length) {
                Object[] missingRecordComponents = Arrays.copyOfRange(recordComponents, patternComponents.length, recordComponents.length);
                List missingPatterns = ContainerUtil.map((Object[])missingRecordComponents, component -> AddMissingDeconstructionComponentsFix.Pattern.create(component, (PsiElement)list));
                sink.accept(new AddMissingDeconstructionComponentsFix(list, missingPatterns));
            } else {
                PsiPattern[] elementsToDelete = Arrays.copyOfRange(patternComponents, recordComponents.length, patternComponents.length);
                int diff = patternComponents.length - recordComponents.length;
                String text = QuickFixBundle.message("remove.redundant.nested.patterns.fix.text", diff);
                sink.accept(QuickFixFactory.getInstance().createDeleteFix((PsiElement[])elementsToDelete, text));
            }
        });
        this.fix(JavaErrorKinds.UNSUPPORTED_FEATURE, error -> {
            if (error.context() == JavaFeature.PRIMITIVE_TYPES_IN_PATTERNS) {
                return HighlightFixUtil.createPrimitiveToBoxedPatternFix(error.psi());
            }
            return null;
        });
        this.fix(JavaErrorKinds.CAST_INCONVERTIBLE, error -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiInstanceOfExpression) {
                PsiInstanceOfExpression instanceOfExpression = (PsiInstanceOfExpression)patt0$temp;
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)((JavaIncompatibleTypeErrorContext)error.context()).rType())) {
                    return this.myFactory.createReplacePrimitiveWithBoxedTypeAction(((JavaIncompatibleTypeErrorContext)error.context()).lType(), Objects.requireNonNull(InstanceOfUtils.findCheckTypeElement(instanceOfExpression)));
                }
            }
            return null;
        });
        AbstractJavaErrorFixProvider.JavaFixProvider redundantInstanceOfFix = error -> {
            PsiPatternVariable variable = ((PsiTypeTestPattern)error.psi()).getPatternVariable();
            if (variable != null && !VariableAccessUtils.variableIsUsed((PsiVariable)variable, variable.getDeclarationScope())) {
                return new RedundantInstanceofFix(((PsiTypeTestPattern)error.psi()).getParent());
            }
            return null;
        };
        this.fix(JavaErrorKinds.PATTERN_INSTANCEOF_EQUALS, redundantInstanceOfFix);
        this.fix(JavaErrorKinds.PATTERN_INSTANCEOF_SUPERTYPE, redundantInstanceOfFix);
    }

    private void createVariableFixes() {
        this.fix(JavaErrorKinds.UNNAMED_VARIABLE_BRACKETS, error -> new NormalizeBracketsFix((PsiVariable)error.psi()));
        this.fix(JavaErrorKinds.UNNAMED_VARIABLE_WITHOUT_INITIALIZER, error -> this.myFactory.createAddVariableInitializerFix((PsiVariable)error.psi()));
        this.fixes(JavaErrorKinds.LVTI_NO_INITIALIZER, (error, sink) -> HighlightFixUtil.registerSpecifyVarTypeFix((PsiLocalVariable)error.psi(), sink));
        this.fixes(JavaErrorKinds.LVTI_NULL, (error, sink) -> HighlightFixUtil.registerSpecifyVarTypeFix((PsiLocalVariable)error.psi(), sink));
        AbstractJavaErrorFixProvider.JavaFixProvider innerClassAccessFix = error -> {
            PsiVariable variable = (PsiVariable)error.context();
            PsiElement scope = Objects.requireNonNull(ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)error.psi()));
            return this.myFactory.createVariableAccessFromInnerClassFix(variable, scope);
        };
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_FINAL, innerClassAccessFix);
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL, innerClassAccessFix);
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA, innerClassAccessFix);
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_GUARD, innerClassAccessFix);
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL, error -> this.myFactory.createMakeVariableEffectivelyFinalFix((PsiVariable)error.context()));
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_LAMBDA, error -> this.myFactory.createMakeVariableEffectivelyFinalFix((PsiVariable)error.context()));
        this.fix(JavaErrorKinds.VARIABLE_MUST_BE_EFFECTIVELY_FINAL_GUARD, error -> this.myFactory.createMakeVariableEffectivelyFinalFix((PsiVariable)error.context()));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED, error -> this.myFactory.createDeferFinalAssignmentFix((PsiVariable)error.context(), (PsiReferenceExpression)error.psi()));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_FIELD, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_CONSTRUCTOR, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_ASSIGNED_INITIALIZER, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.VARIABLE_ASSIGNED_IN_LOOP, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_DEFINED, error -> this.myFactory.createNavigateToAlreadyDeclaredVariableFix((PsiVariable)error.context()));
        this.fix(JavaErrorKinds.VARIABLE_ALREADY_DEFINED, error -> {
            IntentionAction intentionAction;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiLocalVariable) {
                PsiLocalVariable local = (PsiLocalVariable)patt0$temp;
                intentionAction = this.myFactory.createReuseVariableDeclarationFix(local);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        });
        this.fixes(JavaErrorKinds.FIELD_NOT_INITIALIZED, (error, sink) -> {
            PsiField field = (PsiField)error.psi();
            sink.accept(this.myFactory.createCreateConstructorParameterFromFieldFix(field));
            sink.accept(this.myFactory.createInitializeFinalFieldInConstructorFix(field));
            sink.accept(this.myFactory.createAddVariableInitializerFix((PsiVariable)field));
            PsiClass containingClass = field.getContainingClass();
            if (containingClass != null && !containingClass.isInterface()) {
                sink.accept(this.removeModifierFix((PsiModifierListOwner)field, "final"));
            }
        });
        this.fixes(JavaErrorKinds.VARIABLE_NOT_INITIALIZED, (error, sink) -> {
            PsiElement topBlock;
            PsiVariable variable = (PsiVariable)error.context();
            if (!(variable instanceof LightRecordField)) {
                sink.accept(this.myFactory.createAddVariableInitializerFix(variable));
            }
            if (variable instanceof PsiLocalVariable && (topBlock = PsiUtil.getVariableCodeBlock((PsiVariable)variable, null)) != null) {
                sink.accept(HighlightFixUtil.createInsertSwitchDefaultFix(variable, topBlock, error.psi()));
            }
            if (variable instanceof PsiField) {
                PsiField field = (PsiField)variable;
                sink.accept(this.removeModifierFix((PsiModifierListOwner)field, "final"));
            }
        });
    }

    private void createExpressionFixes() {
        this.fix(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_MALFORMED, error -> this.myFactory.createRemoveNewQualifierFix((PsiNewExpression)error.psi(), null));
        this.fix(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_STATIC_CLASS, error -> ((PsiClass)error.context()).isEnum() ? null : this.removeModifierFix((PsiModifierListOwner)error.context(), "static"));
        this.fix(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_STATIC_CLASS, error -> this.myFactory.createRemoveNewQualifierFix((PsiNewExpression)error.psi(), (PsiClass)error.context()));
        this.fix(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_ANONYMOUS_IMPLEMENTS_INTERFACE, error -> this.myFactory.createRemoveNewQualifierFix((PsiNewExpression)error.psi(), null));
        this.fix(JavaErrorKinds.NEW_EXPRESSION_QUALIFIED_QUALIFIED_CLASS_REFERENCE, error -> this.myFactory.createDeleteFix(error.psi(), QuickFixBundle.message("remove.qualifier.fix", new Object[0])));
        this.fix(JavaErrorKinds.NEW_EXPRESSION_DIAMOND_INFERENCE_FAILURE, error -> {
            if (error.context() == PsiDiamondType.DiamondInferenceResult.ANONYMOUS_INNER_RESULT && !PsiUtil.isLanguageLevel9OrHigher((PsiElement)error.psi())) {
                return this.myFactory.createIncreaseLanguageLevelFix(LanguageLevel.JDK_1_9);
            }
            return null;
        });
        this.fixes(JavaErrorKinds.NEW_EXPRESSION_UNRESOLVED_CONSTRUCTOR, (error, sink) -> {
            PsiConstructorCall constructorCall = (PsiConstructorCall)error.psi();
            PsiExpressionList list = constructorCall.getArgumentList();
            if (list != null) {
                JavaResolveResult[] results = ((JavaErrorKinds.UnresolvedConstructorContext)error.context()).results();
                WrapExpressionFix.registerWrapAction(results, list.getExpressions(), sink);
                HighlightFixUtil.registerFixesOnInvalidConstructorCall(sink, constructorCall, ((JavaErrorKinds.UnresolvedConstructorContext)error.context()).psiClass(), results);
            }
        });
        this.fix(JavaErrorKinds.TYPE_PARAMETER_ABSENT_CLASS, error -> this.myFactory.createChangeClassSignatureFromUsageFix((PsiClass)error.context(), (PsiReferenceParameterList)error.psi()));
        this.fix(JavaErrorKinds.TYPE_PARAMETER_COUNT_MISMATCH, error -> {
            IntentionAction intentionAction;
            Object patt0$temp = error.context();
            if (patt0$temp instanceof PsiClass) {
                PsiClass cls = (PsiClass)patt0$temp;
                intentionAction = this.myFactory.createChangeClassSignatureFromUsageFix(cls, (PsiReferenceParameterList)error.psi());
            } else {
                intentionAction = null;
            }
            return intentionAction;
        });
        AbstractJavaErrorFixProvider.JavaFixProvider addBoundFix = error -> {
            PsiType patt0$temp = ((JavaErrorKinds.TypeParameterBoundMismatchContext)error.context()).bound();
            if (patt0$temp instanceof PsiClassType) {
                PsiClassType bound = (PsiClassType)patt0$temp;
                PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)((JavaErrorKinds.TypeParameterBoundMismatchContext)error.context()).actualType());
                if (psiClass != null) {
                    return this.myFactory.createExtendsListFix(psiClass, bound, true);
                }
            }
            return null;
        };
        this.fix(JavaErrorKinds.TYPE_PARAMETER_TYPE_NOT_WITHIN_EXTEND_BOUND, addBoundFix);
        this.fix(JavaErrorKinds.TYPE_PARAMETER_TYPE_NOT_WITHIN_IMPLEMENT_BOUND, addBoundFix);
        this.fixes(JavaErrorKinds.TYPE_PARAMETER_ABSENT_CLASS, (error, sink) -> {
            PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)error.psi();
            PsiElement grandParent = referenceParameterList.getParent().getParent();
            if (!(grandParent instanceof PsiTypeElement)) {
                return;
            }
            PsiElement patt0$temp = PsiTreeUtil.skipParentsOfType((PsiElement)grandParent, (Class[])new Class[]{PsiTypeElement.class});
            if (!(patt0$temp instanceof PsiVariable)) {
                return;
            }
            PsiVariable variable = (PsiVariable)patt0$temp;
            if (((PsiClass)error.context()).getTypeParameters().length == 0) {
                sink.accept(PriorityIntentionActionWrapper.highPriority((IntentionAction)this.myFactory.createDeleteFix((PsiElement)referenceParameterList)));
            }
            HighlightFixUtil.registerVariableParameterizedTypeFixes(sink, variable, referenceParameterList);
        });
        this.fix(JavaErrorKinds.LITERAL_CHARACTER_TOO_LONG, error -> this.myFactory.createConvertToStringLiteralAction());
        this.fix(JavaErrorKinds.LITERAL_CHARACTER_EMPTY, error -> this.myFactory.createConvertToStringLiteralAction());
        this.fix(JavaErrorKinds.PATTERN_TYPE_PATTERN_EXPECTED, error -> {
            String patternVarName = new VariableNameGenerator(error.psi(), VariableKind.LOCAL_VARIABLE).byName("ignored").generate(true);
            return this.myFactory.createReplaceWithTypePatternFix((PsiReferenceExpression)error.psi(), (PsiClass)error.context(), patternVarName);
        });
        this.fix(JavaErrorKinds.ARRAY_INITIALIZER_NOT_ALLOWED, error -> this.myFactory.createAddNewArrayExpressionFix((PsiArrayInitializerExpression)error.psi()));
        this.fix(JavaErrorKinds.ARRAY_GENERIC, error -> {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiReferenceParameterList) {
                PsiReferenceParameterList list = (PsiReferenceParameterList)patt0$temp;
                localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createDeleteFix((PsiElement)list);
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            return localQuickFixAndIntentionActionOnPsiElement;
        });
        this.fix(JavaErrorKinds.ARRAY_TYPE_EXPECTED, error -> {
            IntentionAction intentionAction;
            PsiElement patt0$temp = ((PsiExpression)error.psi()).getParent();
            if (patt0$temp instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression accessExpression = (PsiArrayAccessExpression)patt0$temp;
                intentionAction = this.myFactory.createReplaceWithListAccessFix(accessExpression);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        });
        this.fix(JavaErrorKinds.ARRAY_ILLEGAL_INITIALIZER, error -> {
            PsiArrayInitializerExpression initializerExpression;
            PsiType sameType;
            PsiElement patt0$temp = ((PsiExpression)error.psi()).getParent();
            if (patt0$temp instanceof PsiArrayInitializerExpression && (sameType = JavaHighlightUtil.sameType((initializerExpression = (PsiArrayInitializerExpression)patt0$temp).getInitializers())) != null) {
                return VariableArrayTypeFix.createFix(initializerExpression, sameType);
            }
            return null;
        });
        this.fixes(JavaErrorKinds.CALL_EXPECTED, (error, sink) -> {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)error.psi();
            JavaResolveResult result = methodCall.getMethodExpression().advancedResolve(true);
            PsiElement resolved = result.getElement();
            if (resolved instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)resolved;
                sink.accept(this.myFactory.createInsertNewFix(methodCall, psiClass));
            } else {
                sink.accept(this.myFactory.createStaticImportMethodFix(methodCall));
                sink.accept(this.myFactory.createQualifyStaticMethodCallFix(methodCall));
                sink.accept(this.myFactory.addMethodQualifierFix(methodCall));
                this.myFactory.createCreateMethodFromUsageFixes(methodCall).forEach(sink);
                if (resolved instanceof PsiVariable) {
                    PsiMethod method;
                    PsiVariable variable = (PsiVariable)resolved;
                    if (PsiUtil.isAvailable((JavaFeature)JavaFeature.LAMBDA_EXPRESSIONS, (PsiElement)methodCall) && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)variable.getType())) != null) {
                        sink.accept(this.myFactory.createInsertMethodCallFix(methodCall, method));
                    }
                }
            }
        });
        this.fixes(JavaErrorKinds.CALL_UNRESOLVED_NAME, (error, sink) -> HighlightFixUtil.registerMethodCallIntentions(sink, (PsiMethodCallExpression)error.psi(), ((PsiMethodCallExpression)error.psi()).getArgumentList()));
        this.fix(JavaErrorKinds.CALL_QUALIFIER_PRIMITIVE, error -> this.myFactory.createRenameWrongRefFix(((PsiMethodCallExpression)error.psi()).getMethodExpression()));
        this.fixes(JavaErrorKinds.CALL_QUALIFIER_PRIMITIVE, (error, sink) -> HighlightFixUtil.registerMethodCallIntentions(sink, (PsiMethodCallExpression)error.psi(), ((PsiMethodCallExpression)error.psi()).getArgumentList()));
        this.fixes(JavaErrorKinds.CALL_AMBIGUOUS, (error, sink) -> HighlightFixUtil.registerAmbiguousCallFixes(sink, (PsiMethodCallExpression)error.psi(), ((JavaAmbiguousCallContext)error.context()).results()));
        this.fixes(JavaErrorKinds.CALL_AMBIGUOUS_NO_MATCH, (error, sink) -> HighlightFixUtil.registerAmbiguousCallFixes(sink, (PsiMethodCallExpression)error.psi(), (JavaResolveResult[])error.context()));
        this.fix(JavaErrorKinds.CALL_AMBIGUOUS_NO_MATCH, error -> HighlightFixTypoUtil.createKeywordTypoFix((PsiMethodCallExpression)error.psi()));
        this.fixes(JavaErrorKinds.REFERENCE_NON_STATIC_FROM_STATIC_CONTEXT, (error, sink) -> {
            HighlightFixUtil.registerStaticProblemQuickFixAction(sink, (PsiElement)error.context(), (PsiJavaCodeReferenceElement)error.psi());
            PsiElement patt0$temp = ((PsiJavaCodeReferenceElement)error.psi()).getParent();
            if (patt0$temp instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)patt0$temp;
                HighlightFixUtil.registerMethodCallIntentions(sink, methodCall, methodCall.getArgumentList());
            } else {
                PsiElement patt1$temp = error.psi();
                if (patt1$temp instanceof PsiReferenceExpression) {
                    PsiReferenceExpression expression = (PsiReferenceExpression)patt1$temp;
                    sink.accept(this.myFactory.createRenameWrongRefFix(expression));
                }
            }
        });
        this.fixes(JavaErrorKinds.CALL_UNRESOLVED, (error, sink) -> {
            PsiElement element;
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)error.psi();
            JavaResolveResult[] resolveResults = (JavaResolveResult[])error.context();
            if (resolveResults.length == 1 && (element = resolveResults[0].getElement()) != null && !resolveResults[0].isStaticsScopeCorrect()) {
                HighlightFixUtil.registerStaticProblemQuickFixAction(sink, element, (PsiJavaCodeReferenceElement)methodCall.getMethodExpression());
            }
            HighlightFixUtil.registerAmbiguousCallFixes(sink, methodCall, resolveResults);
        });
        this.fix(JavaErrorKinds.CALL_DIRECT_ABSTRACT_METHOD_ACCESS, error -> {
            PsiMethod method = (PsiMethod)error.context();
            int options = 4097;
            String name = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options, (int)0);
            String text = QuickFixBundle.message("remove.modifier.fix", name, VisibilityUtil.toPresentableText((String)"abstract"));
            return this.myFactory.createAddMethodBodyFix(method, text);
        });
        this.multi(JavaErrorKinds.CALL_CONSTRUCTOR_MUST_BE_FIRST_STATEMENT, error -> HighlightFixUtil.getIncreaseLanguageLevelFixes(error.psi(), JavaFeature.STATEMENTS_BEFORE_SUPER));
        this.fix(JavaErrorKinds.STRING_TEMPLATE_PROCESSOR_MISSING, error -> new MissingStrProcessorFix((PsiTemplateExpression)error.psi()));
        this.fixes(JavaErrorKinds.UNARY_OPERATOR_NOT_APPLICABLE, (error, sink) -> {
            PsiUnaryExpression unary = (PsiUnaryExpression)error.psi();
            if (unary instanceof PsiPrefixExpression) {
                PsiPrefixExpression prefixExpression = (PsiPrefixExpression)unary;
                if (unary.getOperationTokenType() == JavaTokenType.EXCL) {
                    sink.accept(this.myFactory.createNegationBroadScopeFix(prefixExpression));
                    PsiExpression operand = unary.getOperand();
                    if (operand != null) {
                        AdaptExpressionTypeFixUtil.registerExpectedTypeFixes((Consumer<? super CommonIntentionAction>)sink, operand, (PsiType)PsiTypes.booleanType(), operand.getType());
                        sink.accept(HighlightFixUtil.createChangeReturnTypeFix(operand, (PsiType)PsiTypes.booleanType()));
                    }
                }
            }
        });
        this.fixes(JavaErrorKinds.EXPRESSION_SUPER_UNQUALIFIED_DEFAULT_METHOD, (error, sink) -> QualifySuperArgumentFix.registerQuickFixAction((PsiSuperExpression)error.context(), sink));
        this.fix(JavaErrorKinds.REFERENCE_UNRESOLVED, error -> HighlightFixUtil.createUnresolvedReferenceFix((PsiJavaCodeReferenceElement)error.psi()));
        this.fix(JavaErrorKinds.REFERENCE_UNRESOLVED, error -> HighlightFixUtil.createVariableTypeFix((PsiJavaCodeReferenceElement)error.psi()));
        this.fix(JavaErrorKinds.REFERENCE_UNRESOLVED, error -> HighlightFixTypoUtil.createKeywordTypoFix((PsiJavaCodeReferenceElement)error.psi()));
        this.fix(JavaErrorKinds.REFERENCE_QUALIFIER_PRIMITIVE, error -> {
            IntentionAction intentionAction;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)patt0$temp;
                intentionAction = this.myFactory.createRenameWrongRefFix(ref);
            } else {
                intentionAction = null;
            }
            return intentionAction;
        });
        this.fix(JavaErrorKinds.CAST_INTERSECTION_NOT_INTERFACE, error -> {
            PsiTypeElement conjunct = (PsiTypeElement)error.psi();
            return new FlipIntersectionSidesFix(((PsiClassType)conjunct.getType()).getClassName(), conjunct, (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)conjunct, PsiTypeElement.class, (boolean)true));
        });
        this.fix(JavaErrorKinds.CAST_INTERSECTION_REPEATED_INTERFACE, error -> new DeleteRepeatedInterfaceFix((PsiTypeElement)error.psi()));
        this.fix(JavaErrorKinds.EXPRESSION_CLASS_PARAMETERIZED_TYPE, error -> {
            PsiReferenceParameterList parameterList;
            PsiTypeElement operand = (PsiTypeElement)error.psi();
            PsiJavaCodeReferenceElement referenceElement = operand.getInnermostComponentReferenceElement();
            if (referenceElement != null && (parameterList = referenceElement.getParameterList()) != null) {
                return this.myFactory.createDeleteFix((PsiElement)parameterList);
            }
            return null;
        });
        this.fix(JavaErrorKinds.METHOD_REFERENCE_RETURN_TYPE_ERROR, error -> AdjustFunctionContextFix.createFix((PsiExpression)error.psi()));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_UNRESOLVED_METHOD, error -> this.myFactory.createCreateMethodFromUsageFix((PsiMethodReferenceExpression)error.psi()));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_UNRESOLVED_CONSTRUCTOR, error -> this.myFactory.createCreateMethodFromUsageFix((PsiMethodReferenceExpression)error.psi()));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_INFERENCE_ERROR, error -> this.myFactory.createCreateMethodFromUsageFix((PsiMethodReferenceExpression)error.psi()));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_STATIC_METHOD_NON_STATIC_QUALIFIER, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "static"));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_STATIC_METHOD_RECEIVER, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "static"));
        this.fix(JavaErrorKinds.METHOD_REFERENCE_NON_STATIC_METHOD_IN_STATIC_CONTEXT, error -> this.addModifierFix((PsiModifierListOwner)error.context(), "static"));
        this.fix(JavaErrorKinds.ASSIGNMENT_TO_FINAL_VARIABLE, error -> {
            PsiVariable variable = (PsiVariable)error.context();
            PsiElement scope = ControlFlowUtil.getScopeEnforcingEffectiveFinality((PsiVariable)variable, (PsiElement)error.psi());
            return scope == null || variable instanceof PsiField ? this.removeModifierFix((PsiModifierListOwner)variable, "final") : this.myFactory.createVariableAccessFromInnerClassFix(variable, scope);
        });
        AbstractJavaErrorFixProvider.JavaFixProvider qualifyFix = error -> {
            PsiElement patt0$temp = error.psi();
            if (!(patt0$temp instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression ref = (PsiReferenceExpression)patt0$temp;
            PsiClass parentClass = PsiUtil.getContainingClass((PsiElement)ref);
            if (parentClass == null || !PsiUtil.isInnerClass((PsiClass)parentClass)) {
                return null;
            }
            String referenceName = ref.getReferenceName();
            PsiClass containingClass = Objects.requireNonNull(parentClass.getContainingClass());
            PsiField fieldInContainingClass = containingClass.findFieldByName(referenceName, true);
            return fieldInContainingClass != null && ref.getQualifierExpression() == null ? new QualifyWithThisFix(containingClass, ref) : null;
        };
        this.fix(JavaErrorKinds.REFERENCE_MEMBER_BEFORE_CONSTRUCTOR, qualifyFix);
        this.fix(JavaErrorKinds.CALL_MEMBER_BEFORE_CONSTRUCTOR, qualifyFix);
        this.fix(JavaErrorKinds.CLASS_OR_PACKAGE_EXPECTED, error -> this.myFactory.createRemoveQualifierFix(Objects.requireNonNull(((PsiReferenceExpression)error.psi()).getQualifierExpression()), (PsiReferenceExpression)error.psi(), (PsiClass)error.context()));
        this.fix(JavaErrorKinds.SWITCH_LABEL_QUALIFIED_ENUM, error -> this.myFactory.createDeleteFix(Objects.requireNonNull(((PsiReferenceExpression)error.psi()).getQualifier()), JavaErrorBundle.message("qualified.enum.constant.in.switch.remove.fix", new Object[0])));
        this.fix(JavaErrorKinds.SWITCH_DEFAULT_LABEL_CONTAINS_CASE, error -> this.myFactory.createReplaceCaseDefaultWithDefaultFix((PsiCaseLabelElementList)error.context()));
        AbstractJavaErrorFixProvider.JavaFixProvider splitCase = error -> this.myFactory.createSplitSwitchBranchWithSeveralCaseValuesAction();
        this.fix(JavaErrorKinds.SWITCH_MULTIPLE_LABELS_WITH_PATTERN_VARIABLES, splitCase);
        this.fix(JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS, splitCase);
        this.fix(JavaErrorKinds.SWITCH_LABEL_COMBINATION_CONSTANTS_AND_PATTERNS_UNNAMED, splitCase);
        this.fix(JavaErrorKinds.SWITCH_LABEL_MULTIPLE_PATTERNS, splitCase);
        this.fix(JavaErrorKinds.SWITCH_LABEL_MULTIPLE_PATTERNS_UNNAMED, splitCase);
        this.fix(JavaErrorKinds.SWITCH_DEFAULT_NULL_ORDER, error -> this.myFactory.createReverseCaseDefaultNullFixFix((PsiCaseLabelElementList)error.context()));
        this.fixes(JavaErrorKinds.SWITCH_DOMINANCE_VIOLATION, (error, sink) -> {
            PsiElement who = (PsiElement)error.context();
            PsiCaseLabelElement overWhom = (PsiCaseLabelElement)error.psi();
            if (who instanceof PsiKeyword && "default".equals(who.getText()) || JavaPsiSwitchUtil.isInCaseNullDefaultLabel((PsiElement)who)) {
                PsiSwitchLabelStatementBase labelStatementBase = (PsiSwitchLabelStatementBase)PsiTreeUtil.getParentOfType((PsiElement)who, PsiSwitchLabelStatementBase.class);
                if (labelStatementBase != null) {
                    sink.accept(new MakeDefaultLastCaseFix(labelStatementBase));
                }
            } else if (who instanceof PsiCaseLabelElement) {
                PsiCaseLabelElement whoElement = (PsiCaseLabelElement)who;
                if (!JavaPsiPatternUtil.dominates((PsiCaseLabelElement)overWhom, (PsiCaseLabelElement)whoElement) && overWhom.getParent() != whoElement.getParent()) {
                    sink.accept(this.myFactory.createMoveSwitchBranchUpFix(whoElement, overWhom));
                }
                sink.accept(this.myFactory.createDeleteSwitchLabelFix(overWhom));
            }
        });
        this.fix(JavaErrorKinds.SWITCH_UNCONDITIONAL_PATTERN_AND_DEFAULT, error -> {
            IntentionAction intentionAction;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiCaseLabelElement) {
                PsiCaseLabelElement elementCoversType = (PsiCaseLabelElement)patt0$temp;
                intentionAction = this.myFactory.createDeleteSwitchLabelFix(elementCoversType);
            } else {
                intentionAction = this.myFactory.createDeleteDefaultFix(null, error.psi());
            }
            return intentionAction;
        });
        this.fix(JavaErrorKinds.SWITCH_UNCONDITIONAL_PATTERN_AND_BOOLEAN, error -> this.myFactory.createDeleteSwitchLabelFix((PsiCaseLabelElement)error.psi()));
        this.fix(JavaErrorKinds.SWITCH_DEFAULT_AND_BOOLEAN, error -> this.myFactory.createDeleteDefaultFix(null, error.psi()));
        AbstractJavaErrorFixProvider.JavaFixesPusher switchFixes = (error, sink) -> {
            sink.accept(this.myFactory.createAddSwitchDefaultFix((PsiSwitchBlock)error.psi(), null));
            HighlightFixUtil.addCompletenessFixes(sink, (PsiSwitchBlock)error.psi());
        };
        this.fixes(JavaErrorKinds.SWITCH_EMPTY, switchFixes);
        this.fixes(JavaErrorKinds.SWITCH_INCOMPLETE, switchFixes);
    }

    private void createAccessFixes() {
        AbstractJavaErrorFixProvider.JavaFixesPusher accessFix = (error, sink) -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiJavaCodeReferenceElement) {
                PsiElement patt1$temp;
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)patt0$temp;
                if (((JavaResolveResult)error.context()).isStaticsScopeCorrect() && (patt1$temp = ((JavaResolveResult)error.context()).getElement()) instanceof PsiJvmMember) {
                    PsiJvmMember member = (PsiJvmMember)patt1$temp;
                    HighlightFixUtil.registerAccessQuickFixAction(sink, member, ref, null);
                    if (ref instanceof PsiReferenceExpression) {
                        PsiReferenceExpression expression = (PsiReferenceExpression)ref;
                        sink.accept(this.myFactory.createRenameWrongRefFix(expression));
                    }
                }
            }
        };
        this.fixes(JavaErrorKinds.ACCESS_PRIVATE, accessFix);
        this.fixes(JavaErrorKinds.ACCESS_PROTECTED, accessFix);
        this.fixes(JavaErrorKinds.ACCESS_PACKAGE_LOCAL, accessFix);
        this.fixes(JavaErrorKinds.ACCESS_GENERIC_PROBLEM, accessFix);
    }

    private void createTypeFixes() {
        this.fixes(JavaErrorKinds.TYPE_INCOMPATIBLE, (error, sink) -> HighlightFixUtil.registerIncompatibleTypeFixes(sink, error.psi(), ((JavaIncompatibleTypeErrorContext)error.context()).lType(), ((JavaIncompatibleTypeErrorContext)error.context()).rType()));
        this.fixes(JavaErrorKinds.SWITCH_EXPRESSION_INCOMPATIBLE_TYPE, (error, sink) -> HighlightFixUtil.registerIncompatibleTypeFixes(sink, (PsiElement)Objects.requireNonNull((PsiSwitchExpression)PsiTreeUtil.getParentOfType((PsiElement)error.psi(), PsiSwitchExpression.class)), ((JavaIncompatibleTypeErrorContext)error.context()).lType(), ((JavaIncompatibleTypeErrorContext)error.context()).rType()));
        this.fixes(JavaErrorKinds.CALL_TYPE_INFERENCE_ERROR, (error, sink) -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)patt0$temp;
                HighlightFixUtil.registerCallInferenceFixes(sink, callExpression);
            }
        });
        this.fixes(JavaErrorKinds.LAMBDA_INFERENCE_ERROR, (error, sink) -> {
            PsiExpressionList list;
            PsiElement patt1$temp;
            PsiElement patt0$temp = ((PsiLambdaExpression)error.psi()).getParent();
            if (patt0$temp instanceof PsiExpressionList && (patt1$temp = (list = (PsiExpressionList)patt0$temp).getParent()) instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression callExpression = (PsiMethodCallExpression)patt1$temp;
                MethodCandidateInfo resolveResult = (MethodCandidateInfo)error.context();
                PsiMethod method = resolveResult.getElement();
                HighlightFixUtil.registerMethodCallIntentions(sink, callExpression, callExpression.getArgumentList());
                if (!PsiTypesUtil.mentionsTypeParameters((PsiType)((PsiExpression)callExpression.copy()).getType(), Set.of(method.getTypeParameters()))) {
                    HighlightFixUtil.registerMethodReturnFixAction(sink, resolveResult, (PsiCall)callExpression);
                }
                HighlightFixUtil.registerTargetTypeFixesBasedOnApplicabilityInference(sink, callExpression, resolveResult, method);
                LambdaUtil.getReturnExpressions((PsiLambdaExpression)((PsiLambdaExpression)error.psi())).stream().map(PsiExpression::getType).distinct().map(type -> AdjustFunctionContextFix.createFix(type, (PsiFunctionalExpression)error.psi())).forEach(sink);
            }
        });
        this.fixes(JavaErrorKinds.LAMBDA_RETURN_TYPE_ERROR, (error, sink) -> {
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiExpression) {
                PsiExpression expr = (PsiExpression)patt0$temp;
                sink.accept(AdjustFunctionContextFix.createFix(expr));
                PsiLambdaExpression lambda = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiLambdaExpression.class);
                if (lambda != null) {
                    HighlightFixUtil.registerLambdaReturnTypeFixes(sink, lambda, expr);
                }
            }
        });
        this.fixes(JavaErrorKinds.CALL_WRONG_ARGUMENTS, (error, sink) -> {
            JavaMismatchedCallContext context = (JavaMismatchedCallContext)error.context();
            PsiExpressionList list = context.list();
            Project project = error.project();
            PsiResolveHelper resolveHelper = PsiResolveHelper.getInstance((Project)project);
            MethodCandidateInfo candidate = context.candidate();
            PsiElement parent = list.getParent();
            if (parent instanceof PsiAnonymousClass) {
                parent = parent.getParent();
            }
            if (parent instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
                PsiType expectedTypeByParent = InferenceSession.getTargetTypeByParent((PsiElement)methodCall);
                PsiType actualType = ((PsiExpression)methodCall.copy()).getType();
                if (expectedTypeByParent != null && actualType != null && !expectedTypeByParent.isAssignableFrom(actualType)) {
                    AdaptExpressionTypeFixUtil.registerExpectedTypeFixes((Consumer<? super CommonIntentionAction>)sink, (PsiExpression)methodCall, expectedTypeByParent, actualType);
                }
                HighlightFixUtil.registerQualifyMethodCallFix(sink, resolveHelper.getReferencedMethodCandidates((PsiCallExpression)methodCall, false), methodCall, list);
                HighlightFixUtil.registerMethodCallIntentions(sink, methodCall, list);
                HighlightFixUtil.registerMethodReturnFixAction(sink, candidate, (PsiCall)methodCall);
                HighlightFixUtil.registerTargetTypeFixesBasedOnApplicabilityInference(sink, methodCall, candidate, candidate.getElement());
                HighlightFixUtil.registerImplementsExtendsFix(sink, methodCall, candidate.getElement());
            }
            if (parent instanceof PsiConstructorCall) {
                PsiConstructorCall constructorCall = (PsiConstructorCall)parent;
                JavaResolveResult[] methodCandidates = JavaResolveResult.EMPTY_ARRAY;
                PsiClass aClass = Objects.requireNonNull(candidate.getElement().getContainingClass());
                if (constructorCall instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)constructorCall;
                    methodCandidates = resolveHelper.getReferencedMethodCandidates((PsiCallExpression)newExpression, true);
                } else if (constructorCall instanceof PsiEnumConstant) {
                    PsiEnumConstant enumConstant = (PsiEnumConstant)constructorCall;
                    PsiClassType type = JavaPsiFacade.getElementFactory((Project)project).createType(aClass);
                    methodCandidates = resolveHelper.multiResolveConstructor(type, list, (PsiElement)enumConstant);
                }
                HighlightFixUtil.registerFixesOnInvalidConstructorCall(sink, constructorCall, aClass, methodCandidates);
                HighlightFixUtil.registerMethodReturnFixAction(sink, candidate, (PsiCall)constructorCall);
            }
            for (PsiExpression expression : context.mismatchedExpressions()) {
                if (!(expression instanceof PsiNewExpression)) continue;
                PsiNewExpression newExpression = (PsiNewExpression)expression;
                PsiJavaCodeReferenceElement classReference = newExpression.getClassOrAnonymousClassReference();
                this.myFactory.createReplaceTypeWithWrongImportFixes(classReference).forEach(sink);
            }
        });
        this.fix(JavaErrorKinds.TYPE_ARGUMENT_PRIMITIVE, error -> {
            PsiType psiType;
            PsiTypeElement typeElement = (PsiTypeElement)error.psi();
            PsiType type = typeElement.getType();
            if (type instanceof PsiWildcardType) {
                PsiWildcardType wildcardType = (PsiWildcardType)type;
                psiType = Objects.requireNonNull(wildcardType.getBound());
            } else {
                psiType = type;
            }
            PsiPrimitiveType toConvert = (PsiPrimitiveType)psiType;
            PsiClassType boxedType = toConvert.getBoxedType((PsiElement)typeElement);
            if (boxedType != null) {
                return QuickFixFactory.getInstance().createReplacePrimitiveWithBoxedTypeAction(typeElement, toConvert.getPresentableText(), boxedType.getCanonicalText());
            }
            return null;
        });
    }

    private void createClassFixes() {
        this.fix(JavaErrorKinds.CLASS_INHERITS_UNRELATED_DEFAULTS, error -> this.myFactory.createImplementMethodsFix((PsiClass)error.psi()));
        this.fix(JavaErrorKinds.CLASS_INHERITS_ABSTRACT_AND_DEFAULT, error -> this.myFactory.createImplementMethodsFix((PsiClass)error.psi()));
        this.fixes(JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD, (error, sink) -> {
            PsiMethod anyMethodToImplement;
            PsiClass psiClass;
            PsiMember member = (PsiMember)error.psi();
            if (member instanceof PsiEnumConstant) {
                PsiEnumConstant enumConstant = (PsiEnumConstant)member;
                psiClass = Objects.requireNonNullElse(enumConstant.getInitializingClass(), member.getContainingClass());
            } else {
                psiClass = (PsiClass)member;
            }
            PsiClass aClass = psiClass;
            PsiClass containingClass = Objects.requireNonNull(((PsiMethod)error.context()).getContainingClass());
            PsiMethod psiMethod = anyMethodToImplement = member instanceof PsiEnumConstant ? ClassUtil.getAnyAbstractMethod((PsiClass)aClass) : ClassUtil.getAnyMethodToImplement((PsiClass)aClass);
            if (anyMethodToImplement == null) {
                return;
            }
            if (!anyMethodToImplement.hasModifierProperty("packageLocal") || JavaPsiFacade.getInstance((Project)error.project()).arePackagesTheSame((PsiElement)aClass, (PsiElement)containingClass)) {
                sink.accept(this.myFactory.createImplementMethodsFix((PsiElement)member));
            } else {
                sink.accept(this.addModifierFix((PsiModifierListOwner)anyMethodToImplement, "protected"));
                sink.accept(this.addModifierFix((PsiModifierListOwner)anyMethodToImplement, "public"));
            }
        });
        this.fix(JavaErrorKinds.CLASS_NO_ABSTRACT_METHOD, error -> {
            PsiClass aClass;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiClass && !((aClass = (PsiClass)patt0$temp) instanceof PsiAnonymousClass) && !aClass.isEnum()) {
                return this.maybeAddModifierFix((PsiModifierListOwner)aClass, "abstract");
            }
            return null;
        });
        this.fix(JavaErrorKinds.CLASS_REFERENCE_LIST_DUPLICATE, error -> this.myFactory.createRemoveDuplicateExtendsAction(HighlightNamesUtil.formatClass((PsiClass)error.context())));
        this.multi(JavaErrorKinds.CLASS_REFERENCE_LIST_INNER_PRIVATE, error -> List.of(this.addModifierFix((PsiModifierListOwner)error.context(), "public"), this.addModifierFix((PsiModifierListOwner)error.context(), "protected")));
        this.fix(JavaErrorKinds.CLASS_DUPLICATE, error -> this.myFactory.createRenameFix(Objects.requireNonNullElse(((PsiClass)error.psi()).getNameIdentifier(), error.psi())));
        this.fix(JavaErrorKinds.CLASS_CLASHES_WITH_PACKAGE, error -> this.myFactory.createRenameFix(Objects.requireNonNullElse(((PsiClass)error.psi()).getNameIdentifier(), error.psi())));
        this.fix(JavaErrorKinds.CLASS_DUPLICATE, error -> this.myFactory.createNavigateToDuplicateElementFix((NavigatablePsiElement)error.context()));
        this.fix(JavaErrorKinds.CLASS_DUPLICATE_IN_OTHER_FILE, error -> this.myFactory.createNavigateToDuplicateElementFix((NavigatablePsiElement)error.context()));
        this.fixes(JavaErrorKinds.INSTANTIATION_ABSTRACT, (error, sink) -> {
            PsiNewExpression newExpression;
            PsiElement patt0$temp;
            PsiClass aClass = (PsiClass)error.context();
            PsiMethod anyAbstractMethod = ClassUtil.getAnyAbstractMethod((PsiClass)aClass);
            if (!aClass.isInterface() && anyAbstractMethod == null) {
                sink.accept(this.removeModifierFix((PsiModifierListOwner)aClass, "abstract"));
            }
            if (anyAbstractMethod != null && (patt0$temp = error.psi()) instanceof PsiNewExpression && (newExpression = (PsiNewExpression)patt0$temp).getClassReference() != null) {
                sink.accept(this.myFactory.createImplementAbstractClassMethodsFix((PsiElement)newExpression));
            }
        });
        this.fixes(JavaErrorKinds.CLASS_WRONG_FILE_NAME, (error, sink) -> {
            PsiClass aClass = (PsiClass)error.psi();
            PsiJavaFile file = (PsiJavaFile)aClass.getContainingFile();
            Object[] classes = file.getClasses();
            boolean containsClassForFile = ContainerUtil.exists((Object[])classes, otherClass -> !otherClass.getManager().areElementsEquivalent((PsiElement)otherClass, (PsiElement)aClass) && otherClass.hasModifierProperty("public") && file.getVirtualFile().getNameWithoutExtension().equals(otherClass.getName()));
            if (!containsClassForFile) {
                sink.accept(this.myFactory.createRenameFileFix(aClass.getName() + ".java"));
            }
            if (classes.length > 1) {
                sink.accept(this.myFactory.createMoveClassToSeparateFileFix(aClass));
            }
            sink.accept(this.myFactory.createModifierListFix((PsiModifierListOwner)aClass, "public", false, false));
            if (!containsClassForFile) {
                sink.accept(this.myFactory.createRenameElementFix((PsiNamedElement)aClass));
            }
        });
        this.fix(JavaErrorKinds.CLASS_SEALED_NO_INHERITORS, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), "non-sealed"));
        this.fix(JavaErrorKinds.CLASS_SEALED_INCOMPLETE_PERMITS, error -> this.myFactory.createFillPermitsListFix(Objects.requireNonNull(((PsiClass)error.psi()).getNameIdentifier())));
        this.multi(JavaErrorKinds.CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS_CAN_BE_FINAL, error -> List.of(this.addModifierFix((PsiModifierListOwner)error.psi(), "final"), this.addModifierFix((PsiModifierListOwner)error.psi(), "sealed"), this.addModifierFix((PsiModifierListOwner)error.psi(), "non-sealed")));
        this.multi(JavaErrorKinds.CLASS_SEALED_INHERITOR_EXPECTED_MODIFIERS, error -> List.of(this.addModifierFix((PsiModifierListOwner)error.psi(), "sealed"), this.addModifierFix((PsiModifierListOwner)error.psi(), "non-sealed")));
        this.fix(JavaErrorKinds.CLASS_IMPLICIT_NO_MAIN_METHOD, error -> this.myFactory.createAddMainMethodFix((PsiImplicitClass)error.context()));
        this.fix(JavaErrorKinds.UNSUPPORTED_FEATURE, error -> {
            if (error.context() != JavaFeature.IMPLICIT_CLASSES) {
                return null;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getNonStrictParentOfType((PsiElement)error.psi(), (Class[])new Class[]{PsiMember.class});
            if (member == null || member instanceof PsiClass) {
                return null;
            }
            PsiClass patt0$temp = member.getContainingClass();
            if (!(patt0$temp instanceof PsiImplicitClass)) {
                return null;
            }
            PsiImplicitClass implicitClass = (PsiImplicitClass)patt0$temp;
            boolean hasClassToRelocate = PsiTreeUtil.findChildOfType((PsiElement)implicitClass, PsiClass.class) != null;
            return hasClassToRelocate ? new MoveMembersIntoClassFix(implicitClass) : null;
        });
        this.fixes(JavaErrorKinds.UNSUPPORTED_FEATURE, (error, sink) -> {
            PsiClass containingClass;
            if (error.context() != JavaFeature.INNER_STATICS) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)error.psi(), PsiMember.class);
            if (member == null) {
                return;
            }
            if (PsiUtil.isJavaToken((PsiElement)error.psi(), (IElementType)JavaTokenType.STATIC_KEYWORD)) {
                sink.accept(this.removeModifierFix((PsiModifierListOwner)member, "static"));
            }
            if ((containingClass = member.getContainingClass()) != null && containingClass.getContainingClass() != null) {
                sink.accept(this.addModifierFix((PsiModifierListOwner)containingClass, "static"));
            }
        });
        this.fix(JavaErrorKinds.INTERFACE_CONSTRUCTOR, error -> this.myFactory.createConvertInterfaceToClassFix(Objects.requireNonNull(((PsiMethod)error.psi()).getContainingClass())));
        this.fix(JavaErrorKinds.INTERFACE_CLASS_INITIALIZER, error -> this.myFactory.createConvertInterfaceToClassFix(Objects.requireNonNull(((PsiClassInitializer)error.psi()).getContainingClass())));
        this.fix(JavaErrorKinds.INTERFACE_IMPLEMENTS, error -> {
            PsiElement patt0$temp;
            PsiClassType[] referencedTypes = ((PsiReferenceList)error.psi()).getReferencedTypes();
            if (referencedTypes.length > 0 && (patt0$temp = ((PsiReferenceList)error.psi()).getParent()) instanceof PsiClass) {
                PsiClass aClass = (PsiClass)patt0$temp;
                return this.myFactory.createChangeExtendsToImplementsFix(aClass, referencedTypes[0]);
            }
            return null;
        });
        AbstractJavaErrorFixProvider.JavaFixProvider extendsToImplementsFix = error -> {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)error.psi();
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)error.project()).createType(ref);
            return this.myFactory.createChangeExtendsToImplementsFix((PsiClass)error.context(), type);
        };
        this.fix(JavaErrorKinds.CLASS_EXTENDS_INTERFACE, extendsToImplementsFix);
        this.fix(JavaErrorKinds.CLASS_IMPLEMENTS_CLASS, extendsToImplementsFix);
        this.fix(JavaErrorKinds.INTERFACE_EXTENDS_CLASS, extendsToImplementsFix);
        this.fix(JavaErrorKinds.CLASS_SEALED_PERMITS_ON_NON_SEALED, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), "sealed"));
        this.fix(JavaErrorKinds.CLASS_EXTENDS_FINAL, error -> this.removeModifierFix((PsiModifierListOwner)error.context(), "final"));
        this.fix(JavaErrorKinds.CLASS_ANONYMOUS_EXTENDS_SEALED, error -> this.myFactory.createConvertAnonymousToInnerAction((PsiAnonymousClass)error.psi()));
        AbstractJavaErrorFixProvider.JavaFixProvider makeInnerStatic = error -> {
            PsiClass innerClass = ((JavaErrorKinds.ClassStaticReferenceErrorContext)error.context()).innerClass();
            return innerClass == null || innerClass.getContainingClass() == null ? null : this.addModifierFix((PsiModifierListOwner)innerClass, "static");
        };
        this.fix(JavaErrorKinds.CLASS_NOT_ENCLOSING, makeInnerStatic);
        this.fix(JavaErrorKinds.CLASS_CANNOT_BE_REFERENCED_FROM_STATIC_CONTEXT, makeInnerStatic);
        this.fix(JavaErrorKinds.CLASS_CANNOT_BE_REFERENCED_FROM_STATIC_CONTEXT, error -> this.removeModifierFix(Objects.requireNonNull(((JavaErrorKinds.ClassStaticReferenceErrorContext)error.context()).enclosingStaticElement()), "static"));
        this.fix(JavaErrorKinds.INSTANTIATION_LOCAL_CLASS_WRONG_STATIC_CONTEXT, error -> this.removeModifierFix(Objects.requireNonNull(PsiUtil.getEnclosingStaticElement((PsiElement)error.psi(), null)), "static"));
        this.fix(JavaErrorKinds.CLASS_GENERIC_EXTENDS_EXCEPTION, error -> {
            PsiElement patt0$temp;
            PsiClass klass;
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)error.psi();
            PsiMember owner = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiMethod.class});
            if (owner instanceof PsiClass && !((klass = (PsiClass)owner) instanceof PsiAnonymousClass) && (patt0$temp = ref.resolve()) instanceof PsiClass) {
                PsiClass throwableClass = (PsiClass)patt0$temp;
                PsiClassType classType = JavaPsiFacade.getElementFactory((Project)error.project()).createType(throwableClass);
                return this.myFactory.createExtendsListFix(klass, classType, false);
            }
            return null;
        });
        this.multi(JavaErrorKinds.CLASS_NOT_ACCESSIBLE, error -> {
            PsiClass aClass = (PsiClass)error.context();
            String name = aClass.getQualifiedName();
            if (name != null) {
                PsiJavaCodeReferenceElement ref = JavaPsiFacade.getElementFactory((Project)error.project()).createReferenceFromText(name, error.psi());
                ArrayList fixes = new ArrayList();
                this.myFactory.registerOrderEntryFixes((PsiReference)ref, (PsiMember)aClass, fixes);
                return fixes;
            }
            return List.of();
        });
        this.fix(JavaErrorKinds.CLASS_EXTENDS_SEALED_LOCAL, error -> this.myFactory.createConvertLocalToInnerAction((PsiClass)error.context()));
        this.fix(JavaErrorKinds.CLASS_EXTENDS_SEALED_ANOTHER_PACKAGE, error -> {
            PsiFile patt0$temp = ((JavaErrorKinds.SuperclassSubclassContext)error.context()).superClass().getContainingFile();
            if (patt0$temp instanceof PsiClassOwner) {
                PsiClassOwner classOwner = (PsiClassOwner)patt0$temp;
                return this.myFactory.createMoveClassToPackageFix(((JavaErrorKinds.SuperclassSubclassContext)error.context()).subClass(), classOwner.getPackageName());
            }
            return null;
        });
        this.fix(JavaErrorKinds.CLASS_EXTENDS_SEALED_NOT_PERMITTED, error -> ((JavaErrorKinds.SuperclassSubclassContext)error.context()).superClass() instanceof PsiCompiledElement ? null : this.myFactory.createAddToPermitsListFix(((JavaErrorKinds.SuperclassSubclassContext)error.context()).subClass(), ((JavaErrorKinds.SuperclassSubclassContext)error.context()).superClass()));
        this.fixes(JavaErrorKinds.CLASS_PERMITTED_MUST_HAVE_MODIFIER, (error, sink) -> {
            boolean hasInheritors;
            PsiClass inheritorClass = (PsiClass)error.context();
            sink.accept(this.addModifierFix((PsiModifierListOwner)inheritorClass, "non-sealed"));
            boolean bl = hasInheritors = DirectClassInheritorsSearch.search((PsiClass)inheritorClass).findFirst() != null;
            if (!inheritorClass.isInterface() && !inheritorClass.hasModifierProperty("abstract") || hasInheritors) {
                IntentionAction action = hasInheritors ? this.myFactory.createSealClassFromPermitsListFix(inheritorClass) : this.addModifierFix((PsiModifierListOwner)inheritorClass, "final");
                sink.accept(action);
            }
        });
        this.multi(JavaErrorKinds.CLASS_PERMITTED_NOT_DIRECT_SUBCLASS, error -> this.myFactory.createExtendSealedClassFixes((PsiJavaCodeReferenceElement)error.psi(), ((JavaErrorKinds.SuperclassSubclassContext)error.context()).superClass(), ((JavaErrorKinds.SuperclassSubclassContext)error.context()).subClass()));
    }

    private void createAnnotationFixes() {
        this.fix(JavaErrorKinds.SAFE_VARARGS_ON_NON_FINAL_METHOD, error -> this.myFactory.createModifierListFix((PsiModifierListOwner)error.context(), "final", true, true));
        this.fixes(JavaErrorKinds.OVERRIDE_ON_NON_OVERRIDING_METHOD, (error, sink) -> {
            ArrayList registrar = new ArrayList();
            this.myFactory.registerPullAsAbstractUpFixes((PsiMethod)error.context(), registrar);
            registrar.forEach(sink);
        });
        AbstractJavaErrorFixProvider.JavaFixProvider annotationRemover = error -> {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiAnnotation) {
                PsiAnnotation annotation = (PsiAnnotation)patt0$temp;
                localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createDeleteFix((PsiElement)annotation, JavaAnalysisBundle.message((String)"remove.annotation", (Object[])new Object[0]));
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            return localQuickFixAndIntentionActionOnPsiElement;
        };
        for (JavaErrorKind kind : List.of(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_CLASS, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_HERE, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_REF, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_VAR, JavaErrorKinds.ANNOTATION_NOT_ALLOWED_VOID, JavaErrorKinds.LAMBDA_MULTIPLE_TARGET_METHODS, JavaErrorKinds.LAMBDA_NO_TARGET_METHOD, JavaErrorKinds.LAMBDA_NOT_FUNCTIONAL_INTERFACE, JavaErrorKinds.ANNOTATION_NOT_APPLICABLE, JavaErrorKinds.FUNCTIONAL_INTERFACE_SEALED, JavaErrorKinds.OVERRIDE_ON_STATIC_METHOD, JavaErrorKinds.OVERRIDE_ON_NON_OVERRIDING_METHOD, JavaErrorKinds.SAFE_VARARGS_ON_FIXED_ARITY, JavaErrorKinds.SAFE_VARARGS_ON_NON_FINAL_METHOD, JavaErrorKinds.SAFE_VARARGS_ON_RECORD_COMPONENT, JavaErrorKinds.ANNOTATION_CONTAINER_WRONG_PLACE, JavaErrorKinds.ANNOTATION_CONTAINER_NOT_APPLICABLE)) {
            this.fix(kind, annotationRemover);
        }
        this.fix(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_VAR, error -> {
            PsiTypeElement te;
            PsiElement patt0$temp;
            PsiTypeElement te2;
            PsiAnnotationOwner owner = ((PsiAnnotation)error.psi()).getOwner();
            PsiTypeElement type = owner instanceof PsiTypeElement ? (te2 = (PsiTypeElement)owner) : ((patt0$temp = PsiTreeUtil.skipSiblingsForward((PsiElement)((PsiModifierList)owner), (Class[])new Class[]{PsiComment.class, PsiWhiteSpace.class, PsiTypeParameterList.class})) instanceof PsiTypeElement ? (te = (PsiTypeElement)patt0$temp) : null);
            return type != null && type.isInferredType() ? new ReplaceVarWithExplicitTypeFix(type) : null;
        });
        this.fixes(JavaErrorKinds.ANNOTATION_NOT_APPLICABLE, (error, sink) -> {
            PsiClass annotationType = ((PsiAnnotation)error.psi()).resolveAnnotationType();
            if (annotationType == null || !BaseIntentionAction.canModify((PsiElement)annotationType) || annotationType.getLanguage() != JavaLanguage.INSTANCE) {
                return;
            }
            ((List)error.context()).forEach(targetType -> sink.accept(this.myFactory.createAddAnnotationTargetFix((PsiAnnotation)error.psi(), targetType)));
        });
        this.fix(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_STATIC, error -> new MoveAnnotationOnStaticMemberQualifyingTypeFix((PsiAnnotation)error.psi()));
        this.fix(JavaErrorKinds.ANNOTATION_MISSING_ATTRIBUTE, error -> this.myFactory.createAddMissingRequiredAnnotationParametersFix((PsiAnnotation)error.psi(), PsiMethod.EMPTY_ARRAY, (Collection)error.context()));
        this.multi(JavaErrorKinds.ANNOTATION_ATTRIBUTE_NAME_MISSING, error -> this.myFactory.createAddAnnotationAttributeNameFixes((PsiNameValuePair)error.psi()));
        this.multi(JavaErrorKinds.ANNOTATION_ATTRIBUTE_UNKNOWN_METHOD, error -> {
            PsiNameValuePair pair = (PsiNameValuePair)error.psi();
            if (pair.getName() != null) {
                return List.of();
            }
            return this.myFactory.createAddAnnotationAttributeNameFixes(pair);
        });
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_UNKNOWN_METHOD, error -> this.myFactory.createCreateAnnotationMethodFromUsageFix((PsiNameValuePair)error.psi()));
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_DUPLICATE, error -> this.myFactory.createMergeDuplicateAttributesFix((PsiNameValuePair)error.psi()));
        AbstractJavaErrorFixProvider.JavaFixProvider incompatibleTypeFix = error -> {
            PsiAnnotationMemberValue value = (PsiAnnotationMemberValue)error.psi();
            PsiAnnotationMethod method = ((JavaErrorKinds.AnnotationValueErrorContext)error.context()).method();
            PsiClassType type = null;
            if (value instanceof PsiAnnotation) {
                PsiAnnotation annotation = (PsiAnnotation)value;
                PsiClass annotationClass = annotation.resolveAnnotationType();
                if (annotationClass != null) {
                    type = TypeUtils.getType(annotationClass);
                }
            } else if (value instanceof PsiArrayInitializerMemberValue) {
                PsiType componentType;
                PsiArrayInitializerMemberValue arrayInitializer = (PsiArrayInitializerMemberValue)value;
                PsiAnnotationMemberValue[] initializers = arrayInitializer.getInitializers();
                if (initializers.length == 0) {
                    v0 = ((JavaErrorKinds.AnnotationValueErrorContext)error.context()).expectedType();
                } else {
                    PsiAnnotationMemberValue patt0$temp = initializers[0];
                    if (patt0$temp instanceof PsiExpression) {
                        PsiExpression firstInitializer = (PsiExpression)patt0$temp;
                        v0 = firstInitializer.getType();
                    } else {
                        v0 = componentType = null;
                    }
                }
                if (componentType != null) {
                    type = componentType.createArrayType();
                }
            } else if (value instanceof PsiExpression) {
                PsiExpression expression = (PsiExpression)value;
                type = expression.getType();
            }
            if (type == null) {
                return null;
            }
            return this.myFactory.createAnnotationMethodReturnFix((PsiMethod)method, (PsiType)type, ((JavaErrorKinds.AnnotationValueErrorContext)error.context()).fromDefaultValue());
        };
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE, incompatibleTypeFix);
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_INCOMPATIBLE_TYPE, error -> this.myFactory.createSurroundWithQuotesAnnotationParameterValueFix((PsiAnnotationMemberValue)error.psi(), ((JavaErrorKinds.AnnotationValueErrorContext)error.context()).expectedType()));
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_ILLEGAL_ARRAY_INITIALIZER, incompatibleTypeFix);
        this.fix(JavaErrorKinds.ANNOTATION_ATTRIBUTE_ILLEGAL_ARRAY_INITIALIZER, error -> {
            PsiAnnotationMemberValue patt0$temp;
            PsiAnnotationMemberValue[] initializers = ((PsiArrayInitializerMemberValue)error.psi()).getInitializers();
            if (initializers.length != 1 || !((patt0$temp = initializers[0]) instanceof PsiExpression)) {
                return null;
            }
            PsiExpression firstInitializer = (PsiExpression)patt0$temp;
            PsiType expectedType = ((JavaErrorKinds.AnnotationValueErrorContext)error.context()).expectedType();
            if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)expectedType, (PsiExpression)firstInitializer)) {
                return null;
            }
            return this.myFactory.createUnwrapArrayInitializerMemberValueAction((PsiArrayInitializerMemberValue)error.psi());
        });
        this.multi(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_ON_PACKAGE, error -> List.of(this.myFactory.createDeleteFix((PsiElement)Objects.requireNonNull(((PsiPackageStatement)error.psi()).getAnnotationList()), JavaAnalysisBundle.message((String)"intention.text.remove.annotation", (Object[])new Object[0])), new MoveAnnotationToPackageInfoFileFix((PsiPackageStatement)error.psi())));
        this.fix(JavaErrorKinds.ANNOTATION_NOT_ALLOWED_ON_PACKAGE, error -> this.myFactory.createDeleteFix(error.psi(), JavaAnalysisBundle.message((String)"intention.text.remove.annotation", (Object[])new Object[0])));
        this.fix(JavaErrorKinds.ANNOTATION_DUPLICATE_NON_REPEATABLE, error -> this.myFactory.createCollapseAnnotationsFix((PsiAnnotation)error.psi()));
        this.fix(JavaErrorKinds.ANNOTATION_MEMBER_MAY_NOT_HAVE_PARAMETERS, error -> this.myFactory.createRemoveParameterListFix((PsiMethod)((PsiParameterList)error.psi()).getParent()));
    }

    private void createGenericFixes() {
        this.fix(JavaErrorKinds.TYPE_PARAMETER_EXTENDS_INTERFACE_EXPECTED, error -> {
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)error.project()).createType((PsiJavaCodeReferenceElement)error.psi());
            return this.myFactory.createMoveBoundClassToFrontFix((PsiTypeParameter)error.context(), type);
        });
        this.fix(JavaErrorKinds.TYPE_PARAMETER_CANNOT_BE_FOLLOWED_BY_OTHER_BOUNDS, error -> {
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)error.project()).createType((PsiJavaCodeReferenceElement)error.psi());
            return this.myFactory.createExtendsListFix((PsiClass)error.context(), type, false);
        });
        this.fix(JavaErrorKinds.CALL_STATIC_INTERFACE_METHOD_QUALIFIER, error -> {
            LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement;
            PsiElement patt0$temp = error.psi();
            if (patt0$temp instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)patt0$temp;
                localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createAccessStaticViaInstanceFix(ref, ref.advancedResolve(true));
            } else {
                localQuickFixAndIntentionActionOnPsiElement = null;
            }
            return localQuickFixAndIntentionActionOnPsiElement;
        });
    }

    private void createRecordFixes() {
        this.fix(JavaErrorKinds.RECORD_NO_HEADER, error -> this.myFactory.createAddEmptyRecordHeaderFix((PsiClass)error.psi()));
        this.fix(JavaErrorKinds.RECORD_INSTANCE_FIELD, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), "static"));
        this.fix(JavaErrorKinds.RECORD_INSTANCE_INITIALIZER, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), "static"));
        this.fix(JavaErrorKinds.RECORD_COMPONENT_VARARG_NOT_LAST, error -> this.myFactory.createMakeVarargParameterLastFix((PsiVariable)error.psi()));
        this.fix(JavaErrorKinds.RECORD_COMPONENT_RESTRICTED_NAME, error -> this.myFactory.createRenameFix(error.psi()));
        this.fix(JavaErrorKinds.RECORD_COMPONENT_CSTYLE_DECLARATION, error -> new NormalizeBracketsFix((PsiVariable)error.psi()));
        this.fix(JavaErrorKinds.RECORD_CONSTRUCTOR_STRONGER_ACCESS, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), ((AccessModifier)error.context()).toPsiModifier()));
        this.fix(JavaErrorKinds.RECORD_ACCESSOR_NON_PUBLIC, error -> this.addModifierFix((PsiModifierListOwner)error.psi(), "public"));
        this.fix(JavaErrorKinds.RECORD_ACCESSOR_WRONG_RETURN_TYPE, error -> this.myFactory.createMethodReturnFix((PsiMethod)error.psi(), ((JavaIncompatibleTypeErrorContext)error.context()).lType(), false));
        this.fix(JavaErrorKinds.RECORD_NO_CONSTRUCTOR_CALL_IN_NON_CANONICAL, error -> this.myFactory.createRecordThisDelegateFix((PsiMethod)error.psi()));
        this.fix(JavaErrorKinds.RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_TYPE, error -> {
            PsiParameter parameter = (PsiParameter)error.psi();
            PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
            return this.myFactory.createMethodParameterTypeFix(method, method.getParameterList().getParameterIndex(parameter), ((PsiRecordComponent)error.context()).getType(), false);
        });
        this.fix(JavaErrorKinds.RECORD_CANONICAL_CONSTRUCTOR_WRONG_PARAMETER_NAME, error -> {
            String componentName;
            PsiParameter parameter = (PsiParameter)error.psi();
            Object[] parameters = ((PsiParameterList)parameter.getParent()).getParameters();
            return ContainerUtil.exists((Object[])parameters, arg_0 -> DefaultJavaErrorFixProvider.lambda$createRecordFixes$232(componentName = ((PsiRecordComponent)error.context()).getName(), arg_0)) ? null : this.myFactory.createRenameElementFix((PsiNamedElement)parameter, componentName);
        });
    }

    private void createReceiverParameterFixes() {
        this.fix(JavaErrorKinds.RECEIVER_TYPE_MISMATCH, error -> this.myFactory.createReceiverParameterTypeFix((PsiReceiverParameter)error.psi(), (PsiType)error.context()));
        this.fix(JavaErrorKinds.RECEIVER_NAME_MISMATCH, error -> error.context() == null ? null : this.myFactory.createReceiverParameterNameFix((PsiReceiverParameter)error.psi(), (String)error.context()));
        this.fix(JavaErrorKinds.RECEIVER_STATIC_CONTEXT, error -> {
            IntentionAction intentionAction;
            PsiElement patt0$temp = ((PsiReceiverParameter)error.psi()).getParent().getParent();
            if (patt0$temp instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)patt0$temp;
                intentionAction = this.removeModifierFix((PsiModifierListOwner)method, "static");
            } else {
                intentionAction = null;
            }
            return intentionAction;
        });
        this.fix(JavaErrorKinds.RECEIVER_WRONG_POSITION, error -> {
            PsiMethod method;
            PsiReceiverParameter firstReceiverParameter;
            PsiElement patt0$temp = ((PsiReceiverParameter)error.psi()).getParent().getParent();
            if (patt0$temp instanceof PsiMethod && !PsiUtil.isJavaToken((PsiElement)PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)(firstReceiverParameter = (PsiReceiverParameter)PsiTreeUtil.getChildOfType((PsiElement)(method = (PsiMethod)patt0$temp).getParameterList(), PsiReceiverParameter.class))), (IElementType)JavaTokenType.LPARENTH)) {
                return this.myFactory.createMakeReceiverParameterFirstFix((PsiReceiverParameter)error.psi());
            }
            return null;
        });
    }

    @NotNull
    private IntentionAction addModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant String modifier) {
        JvmModifiersOwner jvmModifiersOwner;
        IntentionAction action;
        JvmModifier jvmModifier;
        if (owner == null) {
            DefaultJavaErrorFixProvider.$$$reportNull$$$0(0);
        }
        if ((jvmModifier = JvmModifier.fromPsiModifier((String)modifier)) != null && owner instanceof JvmModifiersOwner && (action = (IntentionAction)ContainerUtil.getFirstItem((List)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)(jvmModifiersOwner = (JvmModifiersOwner)owner), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)jvmModifier, (boolean)true)))) != null) {
            IntentionAction intentionAction = action;
            if (intentionAction == null) {
                DefaultJavaErrorFixProvider.$$$reportNull$$$0(1);
            }
            return intentionAction;
        }
        LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createModifierListFix(owner, modifier, true, false);
        if (localQuickFixAndIntentionActionOnPsiElement == null) {
            DefaultJavaErrorFixProvider.$$$reportNull$$$0(2);
        }
        return localQuickFixAndIntentionActionOnPsiElement;
    }

    @Nullable
    private IntentionAction maybeAddModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant String modifier) {
        PsiModifierList modifierList;
        if (owner == null) {
            DefaultJavaErrorFixProvider.$$$reportNull$$$0(3);
        }
        if ((modifierList = owner.getModifierList()) != null && JavaPsiModifierUtil.getIncompatibleModifier((String)modifier, (PsiModifierList)modifierList) != null) {
            return null;
        }
        return this.addModifierFix(owner, modifier);
    }

    @NotNull
    private IntentionAction removeModifierFix(@NotNull PsiModifierListOwner owner, @PsiModifier.ModifierConstant String modifier) {
        JvmModifiersOwner jvmModifiersOwner;
        IntentionAction action;
        JvmModifier jvmModifier;
        if (owner == null) {
            DefaultJavaErrorFixProvider.$$$reportNull$$$0(4);
        }
        if ((jvmModifier = JvmModifier.fromPsiModifier((String)modifier)) != null && owner instanceof JvmModifiersOwner && (action = (IntentionAction)ContainerUtil.getFirstItem((List)JvmElementActionFactories.createModifierActions((JvmModifiersOwner)(jvmModifiersOwner = (JvmModifiersOwner)owner), (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)jvmModifier, (boolean)false)))) != null) {
            IntentionAction intentionAction = action;
            if (intentionAction == null) {
                DefaultJavaErrorFixProvider.$$$reportNull$$$0(5);
            }
            return intentionAction;
        }
        LocalQuickFixAndIntentionActionOnPsiElement localQuickFixAndIntentionActionOnPsiElement = this.myFactory.createModifierListFix(owner, modifier, false, false);
        if (localQuickFixAndIntentionActionOnPsiElement == null) {
            DefaultJavaErrorFixProvider.$$$reportNull$$$0(6);
        }
        return localQuickFixAndIntentionActionOnPsiElement;
    }

    private static /* synthetic */ boolean lambda$createRecordFixes$232(String componentName, PsiParameter p) {
        return p.getName().equals(componentName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/DefaultJavaErrorFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/DefaultJavaErrorFixProvider";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "addModifierFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "removeModifierFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addModifierFix";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "maybeAddModifierFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeModifierFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6 -> new IllegalStateException(string);
        };
    }
}

