/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.codeInsight.daemon.impl.analysis.JavaErrorFixProvider;
import com.intellij.codeInsight.daemon.impl.analysis.UnusedImportsVisitor;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.java.codeserver.highlighting.JavaErrorCollector;
import com.intellij.java.codeserver.highlighting.errors.JavaCompilationError;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorHighlightType;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKind;
import com.intellij.java.codeserver.highlighting.errors.JavaErrorKinds;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.NewUI;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class HighlightVisitorImpl
extends JavaElementVisitor
implements HighlightVisitor {
    private Map<String, String> myTooltipStyles;
    private JavaErrorCollector myCollector;

    protected HighlightVisitorImpl() {
    }

    @NotNull
    private static Map<String, String> initTooltipStyles() {
        Color parameterBgColor = EditorColorsUtil.getGlobalOrDefaultColorScheme().getAttributes(DefaultLanguageHighlighterColors.INLINE_PARAMETER_HINT).getBackgroundColor();
        String parameterBgStyle = parameterBgColor == null ? "" : "; background-color: " + ColorUtil.toHtmlColor((Color)parameterBgColor);
        Map<String, CallSite> map = Map.of("--java-display-information", "color: " + ColorUtil.toHtmlColor((Color)(NewUI.isEnabled() ? JBUI.CurrentTheme.Editor.Tooltip.FOREGROUND : UIUtil.getToolTipForeground())), "--java-display-grayed", "color: " + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()), "--java-display-parameter", "color: " + ColorUtil.toHtmlColor((Color)UIUtil.getContextHelpForeground()) + parameterBgStyle, "--java-display-error", "color: " + ColorUtil.toHtmlColor((Color)NamedColorUtil.getErrorForeground()));
        if (map == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Deprecated(forRemoval=true)
    protected HighlightVisitorImpl(@NotNull PsiResolveHelper psiResolveHelper) {
        if (psiResolveHelper == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(1);
        }
    }

    @NotNull
    public HighlightVisitorImpl clone() {
        return new HighlightVisitorImpl();
    }

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        HighlightingLevelManager highlightingLevelManager;
        if (psiFile == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(2);
        }
        if ((highlightingLevelManager = HighlightingLevelManager.getInstance((Project)psiFile.getProject())).runEssentialHighlightingOnly((PsiElement)psiFile)) {
            return false;
        }
        return psiFile instanceof PsiImportHolder && !InjectedLanguageManager.getInstance((Project)psiFile.getProject()).isInjectedFragment(psiFile);
    }

    public boolean supersedesDefaultHighlighter() {
        return true;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(3);
        }
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable highlight) {
        if (psiFile == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(5);
        }
        if (highlight == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(6);
        }
        try {
            this.prepare(holder, psiFile);
            if (updateWholeFile) {
                GlobalInspectionContextBase.assertUnderDaemonProgress();
                Project project = psiFile.getProject();
                Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                highlight.run();
                ProgressManager.checkCanceled();
                if (document != null) {
                    new UnusedImportsVisitor(psiFile, document).collectHighlights(holder);
                }
            } else {
                highlight.run();
            }
        }
        finally {
            this.myCollector = null;
        }
        return true;
    }

    private void prepare(@NotNull HighlightInfoHolder holder, @NotNull PsiFile psiFile) {
        if (holder == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(7);
        }
        if (psiFile == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(8);
        }
        this.myCollector = new JavaErrorCollector(psiFile, error -> this.reportError((JavaCompilationError<?, ?>)error, holder));
    }

    private void reportError(@NotNull JavaCompilationError<?, ?> error, @NotNull HighlightInfoHolder holder) {
        CharSequence sequence;
        int offset;
        if (error == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(9);
        }
        if (holder == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(10);
        }
        if (error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.SYNTAX_ERROR}).filter(e -> HighlightErrorFilter.EP_NAME.findFirstSafe((AreaInstance)e.getProject(), filter -> !filter.shouldHighlightErrorElement(e)) != null).isPresent()) {
            return;
        }
        JavaErrorHighlightType javaHighlightType = error.highlightType();
        HighlightInfoType type = switch (javaHighlightType) {
            default -> throw new MatchException(null, null);
            case JavaErrorHighlightType.ERROR, JavaErrorHighlightType.FILE_LEVEL_ERROR -> HighlightInfoType.ERROR;
            case JavaErrorHighlightType.UNHANDLED_EXCEPTION -> HighlightInfoType.UNHANDLED_EXCEPTION;
            case JavaErrorHighlightType.WRONG_REF -> HighlightInfoType.WRONG_REF;
            case JavaErrorHighlightType.PENDING_REF -> HighlightInfoType.PENDING_REFERENCE;
        };
        HtmlChunk tooltip = error.tooltip();
        HighlightInfo.Builder info = HighlightInfo.newHighlightInfo((HighlightInfoType)type);
        if (tooltip.isEmpty()) {
            info.descriptionAndTooltip(error.description());
        } else {
            if (this.myTooltipStyles == null) {
                this.myTooltipStyles = HighlightVisitorImpl.initTooltipStyles();
            }
            info.description(error.description()).escapedToolTip(tooltip.applyStyles(this.myTooltipStyles).toString());
        }
        if (javaHighlightType == JavaErrorHighlightType.FILE_LEVEL_ERROR) {
            info.fileLevelAnnotation();
        }
        TextRange range = error.range();
        info.range(range);
        info.navigationShift(error.navigationShift());
        if (range.getLength() == 0 && ((offset = range.getStartOffset()) >= (sequence = holder.getContextFile().getFileDocument().getCharsSequence()).length() || sequence.charAt(offset) == '\n')) {
            info.endOfLine();
        }
        Consumer<@NotNull CommonIntentionAction> consumer = fix -> info.registerFix(fix.asIntention(), null, null, null, null);
        JavaErrorFixProvider.EP_NAME.forEachExtensionSafe(provider -> provider.registerFixes(error, consumer));
        error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.EXPRESSION_EXPECTED, JavaErrorKinds.REFERENCE_UNRESOLVED, JavaErrorKinds.REFERENCE_AMBIGUOUS}).or(() -> error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.ACCESS_PRIVATE, JavaErrorKinds.ACCESS_PACKAGE_LOCAL, JavaErrorKinds.ACCESS_PROTECTED}).map(psi -> (PsiJavaCodeReferenceElement)ObjectUtils.tryCast((Object)psi, PsiJavaCodeReferenceElement.class))).or(() -> error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.TYPE_UNKNOWN_CLASS}).map(PsiTypeElement::getInnermostComponentReferenceElement)).or(() -> error.psiForKind(new JavaErrorKind[]{JavaErrorKinds.CALL_AMBIGUOUS_NO_MATCH, JavaErrorKinds.CALL_UNRESOLVED}).map(PsiMethodCallExpression::getMethodExpression)).ifPresent(ref -> UnresolvedReferenceQuickFixProvider.registerUnresolvedReferenceLazyQuickFixes((PsiReference)ref, (HighlightInfo.Builder)info));
        holder.add(info.create());
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(11);
        }
        this.myCollector.processElement(element);
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            HighlightVisitorImpl.$$$reportNull$$$0(12);
        }
        this.visitElement((PsiElement)expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiResolveHelper";
                break;
            }
            case 2: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initTooltipStyles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/HighlightVisitorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "suitableForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "analyze";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepare";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitReferenceExpression";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

