/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.java.codeserver.core.JavaPsiModuleUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.jvm.JvmLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaModuleGraphHelper;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiRequiresStatement;
import com.intellij.psi.impl.light.LightJavaModule;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaModuleGraphUtil {
    private static final Set<String> STATIC_REQUIRES_MODULE_NAMES = Set.of("lombok");

    private JavaModuleGraphUtil() {
    }

    @Contract(value="null->null")
    @Nullable
    public static PsiJavaModule findDescriptorByElement(@Nullable PsiElement element) {
        return JavaPsiModuleUtil.findDescriptorByElement((PsiElement)element);
    }

    @Contract(value="null,_->null")
    @Nullable
    public static PsiJavaModule findDescriptorByFile(@Nullable VirtualFile file, @NotNull Project project) {
        if (project == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(0);
        }
        return JavaPsiModuleUtil.findDescriptorByFile((VirtualFile)file, (Project)project);
    }

    @Contract(value="null,_->null")
    @Nullable
    public static PsiJavaModule findDescriptorByModule(@Nullable Module module, boolean inTests) {
        return JavaPsiModuleUtil.findDescriptorByModule((Module)module, (boolean)inTests);
    }

    @Nullable
    public static PsiJavaModule findDescriptorByLibrary(@Nullable Library library, @NotNull Project project) {
        if (project == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(1);
        }
        return JavaPsiModuleUtil.findDescriptorByLibrary((Library)library, (Project)project);
    }

    @Nullable
    public static PsiJavaModule findNonAutomaticDescriptorByModule(@Nullable Module module, boolean inTests) {
        PsiJavaModule javaModule = JavaModuleGraphUtil.findDescriptorByModule(module, inTests);
        return javaModule instanceof LightJavaModule ? null : javaModule;
    }

    public static boolean isModuleReadable(@NotNull PsiElement place, @NotNull VirtualFile targetModuleFile) {
        PsiJavaModule targetModule;
        if (place == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(2);
        }
        if (targetModuleFile == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(3);
        }
        if ((targetModule = JavaModuleGraphUtil.findDescriptorByFile(targetModuleFile, place.getProject())) == null) {
            return true;
        }
        return JavaModuleGraphUtil.isModuleReadable(place, targetModule);
    }

    public static boolean isModuleReadable(@NotNull PsiElement place, @NotNull PsiJavaModule targetModule) {
        if (place == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(4);
        }
        if (targetModule == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(5);
        }
        return JavaModuleGraphHelper.getInstance().isAccessible(targetModule, place);
    }

    public static boolean addDependency(@NotNull PsiJavaModule from, @NotNull String to, @Nullable DependencyScope scope, boolean isExported) {
        if (from == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(6);
        }
        if (to == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(7);
        }
        if (to.equals("java.base")) {
            return false;
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)from)) {
            return false;
        }
        if (from instanceof LightJavaModule) {
            return false;
        }
        if (to.equals(from.getName())) {
            return false;
        }
        if (!PsiNameHelper.isValidModuleName((String)to, (PsiElement)from)) {
            return false;
        }
        if (JavaModuleGraphUtil.alreadyContainsRequires(from, to)) {
            return false;
        }
        PsiJavaModule toModule = JavaPsiFacade.getInstance((Project)from.getProject()).findModule(to, from.getResolveScope());
        if (toModule != null && JavaPsiModuleUtil.reads((PsiJavaModule)toModule, (PsiJavaModule)from)) {
            return false;
        }
        PsiUtil.addModuleStatement((PsiJavaModule)from, (String)("requires " + (JavaModuleGraphUtil.isStaticModule(to, scope) ? "static " : "") + (isExported ? "transitive " : "") + to));
        return true;
    }

    public static boolean addDependency(@NotNull PsiElement from, @NotNull PsiClass to, @Nullable DependencyScope scope) {
        if (from == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(8);
        }
        if (to == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(9);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)from)) {
            return false;
        }
        PsiJavaModule fromDescriptor = JavaModuleGraphUtil.findDescriptorByElement(from);
        if (fromDescriptor == null) {
            return false;
        }
        PsiJavaModule toDescriptor = JavaModuleGraphUtil.findDescriptorByElement((PsiElement)to);
        if (toDescriptor == null) {
            return false;
        }
        if (!JavaModuleGraphHelper.getInstance().isAccessible(to, from)) {
            return false;
        }
        return JavaModuleGraphUtil.addDependency(fromDescriptor, toDescriptor, scope);
    }

    public static boolean addDependency(@NotNull PsiJavaModule from, @NotNull PsiJavaModule to, @Nullable DependencyScope scope) {
        if (from == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(10);
        }
        if (to == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(11);
        }
        if (to.getName().equals("java.base")) {
            return false;
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.MODULES, (PsiElement)from)) {
            return false;
        }
        if (from instanceof LightJavaModule) {
            return false;
        }
        if (from == to || from.getName().equals(to.getName())) {
            return false;
        }
        if (!PsiNameHelper.isValidModuleName((String)to.getName(), (PsiElement)to)) {
            return false;
        }
        if (JavaModuleGraphUtil.contains(from.getRequires(), to.getName())) {
            return false;
        }
        if (JavaPsiModuleUtil.reads((PsiJavaModule)from, (PsiJavaModule)to)) {
            return false;
        }
        if (JavaPsiModuleUtil.reads((PsiJavaModule)to, (PsiJavaModule)from)) {
            return false;
        }
        PsiUtil.addModuleStatement((PsiJavaModule)from, (String)("requires " + (JavaModuleGraphUtil.isStaticModule(to.getName(), scope) ? "static " : "") + (JavaModuleGraphUtil.isExported(from, to) ? "transitive " : "") + to.getName()));
        return true;
    }

    private static boolean contains(@NotNull Iterable<PsiRequiresStatement> requires, @NotNull String name) {
        if (requires == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(12);
        }
        if (name == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(13);
        }
        for (PsiRequiresStatement statement : requires) {
            if (!name.equals(statement.getModuleName())) continue;
            return true;
        }
        return false;
    }

    private static boolean isExported(@NotNull PsiJavaModule from, @NotNull PsiJavaModule to) {
        OrderEntry[] entries;
        VirtualFile toFile;
        if (from == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(14);
        }
        if (to == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(15);
        }
        if ((toFile = JavaModuleGraphUtil.getVirtualFile(to)) == null) {
            return false;
        }
        Module fromModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)from);
        if (fromModule == null) {
            return false;
        }
        HashSet toEntries = new HashSet(ProjectFileIndex.getInstance((Project)from.getProject()).getOrderEntriesForFile(toFile));
        if (toEntries.isEmpty()) {
            return false;
        }
        for (OrderEntry entry : entries = ModuleRootManager.getInstance((Module)fromModule).getOrderEntries()) {
            if (!toEntries.contains(entry) || !(entry instanceof ExportableOrderEntry)) continue;
            ExportableOrderEntry exportable = (ExportableOrderEntry)entry;
            return exportable.isExported();
        }
        return false;
    }

    @Nullable
    private static VirtualFile getVirtualFile(@NotNull PsiJavaModule module) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(16);
        }
        if (module instanceof LightJavaModule) {
            LightJavaModule light = (LightJavaModule)module;
            return light.getRootVirtualFile();
        }
        return PsiUtilCore.getVirtualFile((PsiElement)module);
    }

    private static boolean alreadyContainsRequires(@NotNull PsiJavaModule module, @NotNull String dependency) {
        if (module == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(17);
        }
        if (dependency == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(18);
        }
        for (PsiRequiresStatement requiresStatement : module.getRequires()) {
            if (!Objects.equals(requiresStatement.getModuleName(), dependency)) continue;
            return true;
        }
        return false;
    }

    private static boolean isStaticModule(@NotNull String moduleName, @Nullable DependencyScope scope) {
        if (moduleName == null) {
            JavaModuleGraphUtil.$$$reportNull$$$0(19);
        }
        if (STATIC_REQUIRES_MODULE_NAMES.contains(moduleName)) {
            return true;
        }
        return scope == DependencyScope.PROVIDED;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModuleFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetModule";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requires";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependency";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findDescriptorByFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findDescriptorByLibrary";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isModuleReadable";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependency";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isExported";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "getVirtualFile";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "alreadyContainsRequires";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isStaticModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class JavaModuleScope
    extends GlobalSearchScope {
        @NotNull
        private final MultiMap<String, PsiJavaModule> myModules;
        private final boolean myIncludeLibraries;
        private final boolean myIsInTests;

        private JavaModuleScope(@NotNull Project project, @NotNull Set<PsiJavaModule> modules) {
            if (project == null) {
                JavaModuleScope.$$$reportNull$$$0(0);
            }
            if (modules == null) {
                JavaModuleScope.$$$reportNull$$$0(1);
            }
            super(project);
            this.myModules = new MultiMap();
            for (PsiJavaModule module : modules) {
                this.myModules.putValue((Object)module.getName(), (Object)module);
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            this.myIncludeLibraries = ContainerUtil.or(modules, m -> {
                PsiFile containingFile = m.getContainingFile();
                if (containingFile == null) {
                    return true;
                }
                VirtualFile moduleFile = containingFile.getVirtualFile();
                if (moduleFile == null) {
                    return true;
                }
                return fileIndex.isInLibrary(moduleFile);
            });
            this.myIsInTests = !this.myIncludeLibraries && ContainerUtil.or(modules, m -> {
                PsiFile containingFile = m.getContainingFile();
                if (containingFile == null) {
                    return true;
                }
                VirtualFile moduleFile = containingFile.getVirtualFile();
                if (moduleFile == null) {
                    return true;
                }
                return fileIndex.isInTestSourceContent(moduleFile);
            });
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                JavaModuleScope.$$$reportNull$$$0(2);
            }
            return this.contains(JavaModuleGraphUtil.findDescriptorByModule(aModule, this.myIsInTests));
        }

        public boolean isSearchInLibraries() {
            return this.myIncludeLibraries;
        }

        public boolean contains(@NotNull VirtualFile file) {
            Project project;
            if (file == null) {
                JavaModuleScope.$$$reportNull$$$0(3);
            }
            if ((project = this.getProject()) == null) {
                return false;
            }
            if (!JavaModuleScope.isJvmLanguageFile(file)) {
                return false;
            }
            ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
            if (index.isInLibrary(file)) {
                return this.myIncludeLibraries && this.contains(JavaPsiModuleUtil.findDescriptorInLibrary((VirtualFile)file, (Project)project));
            }
            Module module = index.getModuleForFile(file);
            return this.contains(JavaModuleGraphUtil.findDescriptorByModule(module, this.myIsInTests));
        }

        private boolean contains(@Nullable PsiJavaModule module) {
            if (module == null || !module.isValid()) {
                return false;
            }
            Collection myCollectedModules = this.myModules.get((Object)module.getName());
            return myCollectedModules.contains(module);
        }

        private static boolean isJvmLanguageFile(@NotNull VirtualFile file) {
            FileTypeRegistry fileTypeRegistry;
            FileType fileType;
            if (file == null) {
                JavaModuleScope.$$$reportNull$$$0(4);
            }
            if ((fileType = (fileTypeRegistry = FileTypeRegistry.getInstance()).getFileTypeByFileName(file.getName())) == JavaClassFileType.INSTANCE || fileType == JavaFileType.INSTANCE) {
                return true;
            }
            LanguageFileType languageFileType = (LanguageFileType)ObjectUtils.tryCast((Object)fileType, LanguageFileType.class);
            if (languageFileType == null) {
                return false;
            }
            Language language = languageFileType.getLanguage();
            return language.isKindOf((Language)JavaLanguage.INSTANCE) || language instanceof JvmLanguage || language.getID().equals("kotlin");
        }

        @Nullable
        public static JavaModuleScope moduleScope(@NotNull PsiJavaModule module) {
            PsiFile moduleFile;
            if (module == null) {
                JavaModuleScope.$$$reportNull$$$0(5);
            }
            if ((moduleFile = module.getContainingFile()) == null) {
                return null;
            }
            VirtualFile virtualFile = moduleFile.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            return new JavaModuleScope(module.getProject(), Set.of(module));
        }

        @Nullable
        public static JavaModuleScope moduleWithTransitiveScope(@NotNull PsiJavaModule module) {
            Set allModules;
            if (module == null) {
                JavaModuleScope.$$$reportNull$$$0(6);
            }
            if ((allModules = JavaResolveUtil.getAllTransitiveModulesIncludeCurrent((PsiJavaModule)module)).isEmpty()) {
                return null;
            }
            return new JavaModuleScope(module.getProject(), allModules);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "modules";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaModuleGraphUtil$JavaModuleScope";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSearchInModuleContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contains";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isJvmLanguageFile";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleScope";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "moduleWithTransitiveScope";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

