/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightNamesUtil;
import com.intellij.codeInsight.daemon.impl.analysis.LocalRefUseInfo;
import com.intellij.codeInsight.javadoc.JavaDocFragmentAnchorCacheKt;
import com.intellij.openapi.editor.colors.TextAttributesScheme;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportHolder;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiJavaModuleReferenceElement;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.javadoc.PsiDocMethodOrFieldRef;
import com.intellij.psi.javadoc.PsiDocFragmentName;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import java.util.function.Supplier;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaNamesHighlightVisitor
extends JavaElementVisitor
implements HighlightVisitor,
DumbAware {
    private HighlightInfoHolder myHolder;
    private PsiFile myPsiFile;
    private LanguageLevel myLanguageLevel;
    private boolean shouldHighlightSoftKeywords;
    private boolean isClassFile;

    JavaNamesHighlightVisitor() {
    }

    @NotNull
    public JavaNamesHighlightVisitor clone() {
        return new JavaNamesHighlightVisitor();
    }

    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(0);
        }
        return psiFile instanceof PsiImportHolder;
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(1);
        }
        element.accept((PsiElementVisitor)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable highlight) {
        if (psiFile == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(3);
        }
        if (highlight == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(4);
        }
        try {
            this.prepare(holder, psiFile);
            highlight.run();
        }
        finally {
            this.myPsiFile = null;
            this.myHolder = null;
        }
        return true;
    }

    private void prepare(@NotNull HighlightInfoHolder holder, @NotNull PsiFile psiFile) {
        if (holder == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(5);
        }
        if (psiFile == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(6);
        }
        this.myHolder = holder;
        this.myPsiFile = psiFile;
        this.myLanguageLevel = PsiUtil.getLanguageLevel((PsiElement)psiFile);
        this.shouldHighlightSoftKeywords = "module-info.java".equals(psiFile.getName()) || this.myLanguageLevel.isAtLeast(LanguageLevel.JDK_10);
        this.isClassFile = psiFile.getOriginalFile() instanceof PsiCompiledFile;
    }

    public void visitDocTagValue(@NotNull PsiDocTagValue value) {
        PsiElement element;
        if (value == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(7);
        }
        if ((element = JavaNamesHighlightVisitor.computeIfSmartMode(value.getProject(), () -> {
            PsiElement patt0$temp;
            PsiReference reference = value.getReference();
            if (reference == null && (patt0$temp = value.getFirstChild()) instanceof PsiJavaModuleReferenceElement) {
                PsiJavaModuleReferenceElement moduleReference = (PsiJavaModuleReferenceElement)patt0$temp;
                reference = moduleReference.getReference();
            }
            return reference == null ? null : reference.resolve();
        })) instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            PsiElement nameElement = ((PsiDocMethodOrFieldRef)value).getNameElement();
            if (nameElement != null) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)psiMethod, nameElement, false, this.myHolder.getColorsScheme()));
            }
        } else if (element instanceof PsiParameter) {
            PsiParameter psiParam = (PsiParameter)element;
            this.myHolder.add(HighlightNamesUtil.highlightVariableName((PsiVariable)psiParam, value.getNavigationElement(), this.myHolder.getColorsScheme()));
        } else if (element instanceof PsiJavaModule) {
            PsiJavaModule javaModule = (PsiJavaModule)element;
            PsiReference reference = value.getFirstChild().getReference();
            if (reference != null) {
                this.myHolder.add(HighlightNamesUtil.highlightModule((PsiElement)javaModule, reference, this.myHolder.getColorsScheme()));
            }
        } else if (value instanceof PsiDocFragmentName) {
            PsiDocFragmentName docFragmentName = (PsiDocFragmentName)value;
            Pair fragmentData = JavaDocFragmentAnchorCacheKt.resolveJavaDocFragment((Project)value.getProject(), (PsiDocFragmentName)docFragmentName);
            if (fragmentData != null) {
                this.myHolder.add(HighlightNamesUtil.highlightFragmentReference(docFragmentName));
            }
        }
    }

    public void visitIdentifier(@NotNull PsiIdentifier identifier) {
        if (identifier == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(8);
        }
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        PsiElement parent = identifier.getParent();
        if (parent instanceof PsiVariable) {
            PsiElement child;
            PsiVariable variable = (PsiVariable)parent;
            if (variable.getInitializer() == null && (child = variable.getLastChild()) instanceof PsiErrorElement && child.getPrevSibling() == identifier) {
                return;
            }
            this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, (PsiElement)identifier, colorsScheme));
        } else if (parent instanceof PsiClass) {
            PsiClass aClass = (PsiClass)parent;
            if (!(parent instanceof PsiAnonymousClass) && aClass.getNameIdentifier() == identifier) {
                this.myHolder.add(HighlightNamesUtil.highlightClassName(aClass, (PsiElement)identifier, colorsScheme));
            }
        } else if (parent instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)parent;
            this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)method, (PsiElement)identifier, true, colorsScheme));
        }
        super.visitIdentifier(identifier);
    }

    public void visitImportStaticReferenceElement(@NotNull PsiImportStaticReferenceElement ref) {
        JavaResolveResult[] results;
        if (ref == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(9);
        }
        if ((results = JavaNamesHighlightVisitor.computeIfSmartMode(ref.getProject(), () -> ref.multiResolve(false))) == null) {
            results = JavaResolveResult.EMPTY_ARRAY;
        }
        PsiElement referenceNameElement = ref.getReferenceNameElement();
        if (!this.myHolder.hasErrorResults()) {
            PsiElement resolved;
            PsiElement psiElement = resolved = results.length >= 1 ? results[0].getElement() : null;
            if (results.length > 1) {
                for (int i = 1; i < results.length; ++i) {
                    PsiElement element = results[i].getElement();
                    if (!(resolved instanceof PsiMethod && !(element instanceof PsiMethod) || resolved instanceof PsiVariable && !(element instanceof PsiVariable)) && (!(resolved instanceof PsiClass) || element instanceof PsiClass)) continue;
                    resolved = null;
                    break;
                }
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (resolved instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)resolved;
                this.myHolder.add(HighlightNamesUtil.highlightClassName(psiClass, (PsiElement)ref, colorsScheme));
            } else if (referenceNameElement != null) {
                if (resolved instanceof PsiVariable) {
                    PsiVariable psiVariable = (PsiVariable)resolved;
                    this.myHolder.add(HighlightNamesUtil.highlightVariableName(psiVariable, referenceNameElement, colorsScheme));
                } else if (resolved instanceof PsiMethod) {
                    PsiMethod psiMethod = (PsiMethod)resolved;
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)psiMethod, referenceNameElement, false, colorsScheme));
                }
            }
        }
    }

    public void visitKeyword(@NotNull PsiKeyword keyword) {
        if (keyword == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(10);
        }
        if (this.shouldHighlightSoftKeywords && (PsiUtil.isSoftKeyword((CharSequence)keyword.getNode().getChars(), (LanguageLevel)this.myLanguageLevel) || JavaTokenType.NON_SEALED_KEYWORD == keyword.getTokenType())) {
            if (this.isClassFile) {
                this.myHolder.add(HighlightNamesUtil.highlightClassKeyword(keyword));
            } else {
                this.myHolder.add(HighlightNamesUtil.highlightKeyword(keyword));
            }
        }
    }

    public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        if (ref == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(11);
        }
        if (!(ref instanceof PsiReferenceExpression)) {
            this.doVisitReferenceElement(ref);
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        if (expression == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(12);
        }
        this.doVisitReferenceElement((PsiJavaCodeReferenceElement)expression);
    }

    private void doVisitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
        JavaResolveResult result;
        PsiElement resolved;
        if (ref == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(13);
        }
        PsiElement psiElement = resolved = (result = LocalRefUseInfo.resolveOptimised(ref, this.myPsiFile)) != null ? result.getElement() : null;
        if (resolved instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)resolved;
            if (!(variable instanceof PsiField)) {
                PsiElement containingClass = PsiTreeUtil.getNonStrictParentOfType((PsiElement)ref, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                while ((containingClass instanceof PsiAnonymousClass || containingClass instanceof PsiLambdaExpression) && !PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)variable, (boolean)false)) {
                    if (containingClass instanceof PsiLambdaExpression || !PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)containingClass).getArgumentList(), (PsiElement)ref, (boolean)false)) {
                        this.myHolder.add(HighlightNamesUtil.highlightImplicitAnonymousClassParameter(ref));
                        return;
                    }
                    containingClass = PsiTreeUtil.getParentOfType((PsiElement)containingClass, (Class[])new Class[]{PsiClass.class, PsiLambdaExpression.class});
                }
            }
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            PsiElement nameElement = ref.getReferenceNameElement();
            if (nameElement != null) {
                this.myHolder.add(HighlightNamesUtil.highlightVariableName(variable, nameElement, colorsScheme));
            }
        } else {
            this.highlightReferencedMethodOrClassName(ref, resolved);
        }
    }

    private void highlightReferencedMethodOrClassName(@NotNull PsiJavaCodeReferenceElement element, @Nullable PsiElement resolved) {
        if (element == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(14);
        }
        PsiElement parent = element.getParent();
        TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
        DumbService dumbService = DumbService.getInstance((Project)this.myPsiFile.getProject());
        if (parent instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)parent;
            PsiMethod method = (PsiMethod)dumbService.computeWithAlternativeResolveEnabled(() -> methodCall.resolveMethod());
            PsiElement methodNameElement = element.getReferenceNameElement();
            if (method != null && methodNameElement != null && !(methodNameElement instanceof PsiKeyword)) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)method, methodNameElement, false, colorsScheme));
            }
        } else if (parent instanceof PsiConstructorCall) {
            PsiElement referenceNameElement;
            PsiMethod methodOrClass;
            PsiConstructorCall constructorCall = (PsiConstructorCall)parent;
            PsiMethod method = (PsiMethod)dumbService.computeWithAlternativeResolveEnabled(() -> constructorCall.resolveConstructor());
            Object object = method != null ? method : (methodOrClass = resolved instanceof PsiClass ? (PsiClass)resolved : null);
            if (methodOrClass != null && (referenceNameElement = element.getReferenceNameElement()) != null) {
                this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)methodOrClass, referenceNameElement, false, colorsScheme));
            }
        } else if (resolved instanceof PsiPackage) {
            this.myHolder.add(HighlightNamesUtil.highlightPackage(resolved, element, colorsScheme));
        } else if (resolved instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)resolved;
            this.myHolder.add(HighlightNamesUtil.highlightClassName(psiClass, (PsiElement)element, colorsScheme));
        } else if (element.getParent() instanceof PsiAnnotation) {
            this.myHolder.add(HighlightNamesUtil.highlightClassName(null, (PsiElement)element, colorsScheme));
        } else if (PsiTreeUtil.skipParentsOfType((PsiElement)element, (Class[])new Class[]{PsiJavaCodeReferenceElement.class}) instanceof PsiAnnotation) {
            this.myHolder.add(HighlightNamesUtil.highlightPackage(null, element, colorsScheme));
        }
    }

    public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
        PsiIdentifier nameId;
        if (pair == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(15);
        }
        if ((nameId = pair.getNameIdentifier()) != null) {
            this.myHolder.add(HighlightNamesUtil.highlightAnnotationAttributeName(nameId));
        }
    }

    public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
        JavaResolveResult result;
        if (expression == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(16);
        }
        try {
            JavaResolveResult[] results = JavaNamesHighlightVisitor.computeIfSmartMode(this.myPsiFile.getProject(), () -> expression.multiResolve(true));
            result = results != null && results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
        }
        catch (IndexNotReadyException e) {
            return;
        }
        PsiElement method = result.getElement();
        if (!(method instanceof PsiJvmMember) || result.isAccessible()) {
            TextAttributesScheme colorsScheme = this.myHolder.getColorsScheme();
            if (method instanceof PsiMethod) {
                PsiElement methodNameElement;
                PsiMethod psiMethod = (PsiMethod)method;
                if (!expression.isConstructor() && (methodNameElement = expression.getReferenceNameElement()) != null) {
                    this.myHolder.add(HighlightNamesUtil.highlightMethodName((PsiMember)psiMethod, methodNameElement, false, colorsScheme));
                }
            }
        }
    }

    private static <T> T computeIfSmartMode(@NotNull Project project, @NotNull Supplier<T> operation) {
        if (project == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(17);
        }
        if (operation == null) {
            JavaNamesHighlightVisitor.$$$reportNull$$$0(18);
        }
        return DumbService.isDumb((Project)project) ? null : (T)operation.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlight";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/JavaNamesHighlightVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "prepare";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitDocTagValue";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitImportStaticReferenceElement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitKeyword";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "doVisitReferenceElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "highlightReferencedMethodOrClassName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNameValuePair";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMethodReferenceExpression";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "computeIfSmartMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

