/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.impl.GlobalUsageHelper;
import com.intellij.codeInsight.daemon.impl.analysis.InjectedLanguageJavaReferenceSupplier;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.reference.PsiMemberReference;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.impl.IncompleteModelUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.tree.java.PsiReferenceExpressionImpl;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiMatcherImpl;
import com.intellij.psi.util.PsiMatchers;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalRefUseInfo {
    private static final LocalRefUseInfo EMPTY_INFO = new LocalRefUseInfo((MultiMap<PsiElement, PsiReference>)MultiMap.empty(), Set.of(), Set.of());
    @NotNull
    private final MultiMap<PsiElement, PsiReference> myLocalRefsMap;
    @NotNull
    private final Set<PsiAnchor> myDclsUsedMap;
    @NotNull
    private final Set<PsiImportStatementBase> myUsedImports;

    @NotNull
    public static LocalRefUseInfo forFile(@NotNull PsiFile psiFileRoot) {
        if (psiFileRoot == null) {
            LocalRefUseInfo.$$$reportNull$$$0(0);
        }
        if (psiFileRoot instanceof PsiCompiledFile) {
            LocalRefUseInfo localRefUseInfo = EMPTY_INFO;
            if (localRefUseInfo == null) {
                LocalRefUseInfo.$$$reportNull$$$0(1);
            }
            return localRefUseInfo;
        }
        LocalRefUseInfo localRefUseInfo = (LocalRefUseInfo)CachedValuesManager.getCachedValue((PsiElement)psiFileRoot, () -> {
            Builder builder = new Builder(psiFileRoot);
            for (PsiFile psiFile : psiFileRoot.getViewProvider().getAllFiles()) {
                psiFile.accept((PsiElementVisitor)builder);
            }
            LocalRefUseInfo result = builder.build();
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (localRefUseInfo == null) {
            LocalRefUseInfo.$$$reportNull$$$0(2);
        }
        return localRefUseInfo;
    }

    private LocalRefUseInfo(@NotNull MultiMap<PsiElement, PsiReference> myLocalRefsMap, @NotNull Set<PsiAnchor> myDclsUsedMap, @NotNull Set<PsiImportStatementBase> myImportStatements) {
        if (myLocalRefsMap == null) {
            LocalRefUseInfo.$$$reportNull$$$0(3);
        }
        if (myDclsUsedMap == null) {
            LocalRefUseInfo.$$$reportNull$$$0(4);
        }
        if (myImportStatements == null) {
            LocalRefUseInfo.$$$reportNull$$$0(5);
        }
        this.myLocalRefsMap = myLocalRefsMap;
        this.myDclsUsedMap = myDclsUsedMap;
        this.myUsedImports = myImportStatements;
    }

    @NotNull
    public GlobalUsageHelper getGlobalUsageHelper(@NotNull PsiFile psiFile, final @Nullable UnusedDeclarationInspectionBase deadCodeInspection) {
        boolean isDeadCodeEnabled;
        if (psiFile == null) {
            LocalRefUseInfo.$$$reportNull$$$0(6);
        }
        FileViewProvider viewProvider = psiFile.getViewProvider();
        Project project = psiFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = viewProvider.getVirtualFile();
        boolean inLibrary = fileIndex.isInLibrary(virtualFile);
        boolean bl = isDeadCodeEnabled = deadCodeInspection != null && deadCodeInspection.isGlobalEnabledInEditor();
        if (isDeadCodeEnabled && !inLibrary) {
            return new GlobalUsageHelperBase(this){
                final Map<PsiMember, Boolean> myEntryPointCache;
                {
                    this.myEntryPointCache = FactoryMap.create(member -> {
                        if (Registry.is((String)"java.unused.symbol.strict.entry.points") ? deadCodeInspection.isStrictEntryPoint((PsiElement)member) : deadCodeInspection.isEntryPoint((PsiElement)member)) {
                            return true;
                        }
                        if (member instanceof PsiClass) {
                            return !((JBTreeTraverser)JBTreeTraverser.from(m -> m instanceof PsiClass ? JBIterable.from((Iterable)PsiTreeUtil.getStubChildrenOfTypeAsList((PsiElement)m, PsiMember.class)) : JBIterable.empty()).withRoot(member)).traverse().skip(1).processEach(this::shouldCheckUsages);
                        }
                        return false;
                    });
                }

                @Override
                public boolean shouldCheckUsages(@NotNull PsiMember member) {
                    if (member == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.myEntryPointCache.get(member) == false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo$1", "shouldCheckUsages"));
                }
            };
        }
        return new GlobalUsageHelperBase();
    }

    boolean isRedundant(@NotNull PsiImportStatementBase importStatement) {
        if (importStatement == null) {
            LocalRefUseInfo.$$$reportNull$$$0(7);
        }
        return !this.myUsedImports.contains(importStatement);
    }

    public boolean isVariableUsed(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        if (variable == null) {
            LocalRefUseInfo.$$$reportNull$$$0(8);
        }
        if (context == null) {
            LocalRefUseInfo.$$$reportNull$$$0(9);
        }
        for (PsiReference reference : this.myLocalRefsMap.get((Object)variable.getNavigationElement())) {
            if (!PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)reference.getElement(), (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public List<PsiReferenceExpression> getVariableReferences(@NotNull PsiVariable variable, @Nullable PsiElement context) {
        Collection references;
        if (variable == null) {
            LocalRefUseInfo.$$$reportNull$$$0(10);
        }
        if ((references = this.myLocalRefsMap.get((Object)variable.getNavigationElement())).isEmpty()) {
            return List.of();
        }
        ArrayList<PsiReferenceExpression> result = new ArrayList<PsiReferenceExpression>();
        for (PsiReference reference : references) {
            PsiElement psiElement = reference.getElement();
            if (!(psiElement instanceof PsiReferenceExpression)) continue;
            PsiReferenceExpression ref = (PsiReferenceExpression)psiElement;
            if (context != null && !PsiTreeUtil.isAncestor((PsiElement)context, (PsiElement)ref, (boolean)false)) continue;
            result.add(ref);
        }
        return result;
    }

    public boolean isReferenced(@NotNull PsiElement element) {
        Collection array;
        if (element == null) {
            LocalRefUseInfo.$$$reportNull$$$0(11);
        }
        if (!((array = this.myLocalRefsMap.get((Object)element)).isEmpty() || LocalRefUseInfo.isParameterUsedRecursively(element, array) || this.isClassUsedForInnerImports(element, array))) {
            for (PsiReference reference : array) {
                if (!reference.isReferenceTo(element)) continue;
                return true;
            }
        }
        return this.myDclsUsedMap.contains(PsiAnchor.create((PsiElement)element));
    }

    private boolean isClassUsedForInnerImports(@NotNull PsiElement element, @NotNull Collection<? extends PsiReference> array) {
        if (element == null) {
            LocalRefUseInfo.$$$reportNull$$$0(12);
        }
        if (array == null) {
            LocalRefUseInfo.$$$reportNull$$$0(13);
        }
        if (!(element instanceof PsiClass)) {
            return false;
        }
        HashSet<PsiImportStatementBase> imports = new HashSet<PsiImportStatementBase>();
        for (PsiReference psiReference : array) {
            PsiImportStatementBase importStmt2 = (PsiImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiImportStatementBase.class);
            if (importStmt2 == null) {
                return false;
            }
            imports.add(importStmt2);
        }
        return ContainerUtil.all(imports, importStmt -> {
            PsiElement importedMember = importStmt.resolve();
            if (importedMember != null && PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)importedMember, (boolean)false)) {
                for (PsiReference memberReference : this.myLocalRefsMap.get((Object)importedMember)) {
                    if (PsiTreeUtil.isAncestor((PsiElement)element, (PsiElement)memberReference.getElement(), (boolean)false)) continue;
                    return false;
                }
                return true;
            }
            return false;
        });
    }

    private static boolean isParameterUsedRecursively(@NotNull PsiElement element, @NotNull Collection<? extends PsiReference> array) {
        if (element == null) {
            LocalRefUseInfo.$$$reportNull$$$0(14);
        }
        if (array == null) {
            LocalRefUseInfo.$$$reportNull$$$0(15);
        }
        if (!(element instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter = (PsiParameter)element;
        PsiElement scope = parameter.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        int paramIndex = ArrayUtilRt.find((Object[])method.getParameterList().getParameters(), (Object)parameter);
        for (PsiReference psiReference : array) {
            if (!(psiReference instanceof PsiElement)) {
                return false;
            }
            PsiElement argument = (PsiElement)psiReference;
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)new PsiMatcherImpl(argument).dot(PsiMatchers.hasClass(PsiReferenceExpression.class)).parent(PsiMatchers.hasClass(PsiExpressionList.class)).parent(PsiMatchers.hasClass(PsiMethodCallExpression.class)).getElement();
            if (methodCallExpression == null) {
                return false;
            }
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            if (method != methodExpression.resolve()) {
                return false;
            }
            PsiExpressionList argumentList = methodCallExpression.getArgumentList();
            Object[] arguments = argumentList.getExpressions();
            int argumentIndex = ArrayUtilRt.find((Object[])arguments, (Object)argument);
            if (paramIndex == argumentIndex) continue;
            return false;
        }
        return true;
    }

    public boolean isReferencedForRead(@NotNull PsiVariable variable) {
        Collection array;
        if (variable == null) {
            LocalRefUseInfo.$$$reportNull$$$0(16);
        }
        if ((array = this.myLocalRefsMap.get((Object)variable)).isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement refElement = ref.getElement();
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = LocalRefUseInfo.getAccess(ref, resolved)) == null || !access.isReferencedForRead() || LocalRefUseInfo.isJustIncremented(access, refElement)) continue;
            return true;
        }
        return false;
    }

    private static ReadWriteAccessDetector.Access getAccess(@NotNull PsiReference ref, @NotNull PsiElement resolved) {
        PsiElement start;
        ReadWriteAccessDetector detector;
        if (ref == null) {
            LocalRefUseInfo.$$$reportNull$$$0(17);
        }
        if (resolved == null) {
            LocalRefUseInfo.$$$reportNull$$$0(18);
        }
        if ((detector = ReadWriteAccessDetector.findDetector((PsiElement)(start = resolved.getLanguage() == ref.getElement().getLanguage() ? resolved : ref.getElement()))) != null) {
            return detector.getReferenceAccess(resolved, ref);
        }
        return null;
    }

    private static boolean isJustIncremented(@NotNull ReadWriteAccessDetector.Access access, @NotNull PsiElement refElement) {
        if (access == null) {
            LocalRefUseInfo.$$$reportNull$$$0(19);
        }
        if (refElement == null) {
            LocalRefUseInfo.$$$reportNull$$$0(20);
        }
        return access == ReadWriteAccessDetector.Access.ReadWrite && refElement instanceof PsiExpression && refElement.getParent() instanceof PsiExpression && refElement.getParent().getParent() instanceof PsiExpressionStatement;
    }

    public boolean isReferencedForWrite(@NotNull PsiVariable variable) {
        Collection array;
        if (variable == null) {
            LocalRefUseInfo.$$$reportNull$$$0(21);
        }
        if ((array = this.myLocalRefsMap.get((Object)variable)).isEmpty()) {
            return false;
        }
        for (PsiReference ref : array) {
            ReadWriteAccessDetector.Access access;
            PsiElement resolved = ref.resolve();
            if (resolved == null || (access = LocalRefUseInfo.getAccess(ref, resolved)) == null || !access.isReferencedForWrite()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static JavaResolveResult resolveOptimised(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref == null) {
            LocalRefUseInfo.$$$reportNull$$$0(22);
        }
        if (containingFile == null) {
            LocalRefUseInfo.$$$reportNull$$$0(23);
        }
        try {
            if (ref instanceof PsiReferenceExpressionImpl) {
                PsiReferenceExpressionImpl.OurGenericsResolver resolver = PsiReferenceExpressionImpl.OurGenericsResolver.INSTANCE;
                JavaResolveResult[] results = JavaResolveUtil.resolveWithContainingFile((PsiPolyVariantReference)ref, (ResolveCache.PolyVariantContextResolver)resolver, (boolean)true, (boolean)true, (PsiFile)containingFile);
                return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
            }
            return ref.advancedResolve(true);
        }
        catch (IndexNotReadyException e) {
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFileRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myLocalRefsMap";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDclsUsedMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myImportStatements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 8: 
            case 10: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalUsageHelper";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isRedundant";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isVariableUsed";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getVariableReferences";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isClassUsedForInnerImports";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isParameterUsedRecursively";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedForRead";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAccess";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isJustIncremented";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedForWrite";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolveOptimised";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private class GlobalUsageHelperBase
    extends GlobalUsageHelper {
        private GlobalUsageHelperBase() {
        }

        @Override
        public boolean shouldCheckUsages(@NotNull PsiMember member) {
            if (member == null) {
                GlobalUsageHelperBase.$$$reportNull$$$0(0);
            }
            return false;
        }

        @Override
        public boolean isCurrentFileAlreadyChecked() {
            return true;
        }

        @Override
        public boolean isLocallyUsed(@NotNull PsiNamedElement member) {
            if (member == null) {
                GlobalUsageHelperBase.$$$reportNull$$$0(1);
            }
            return LocalRefUseInfo.this.isReferenced((PsiElement)member);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "member";
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo$GlobalUsageHelperBase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "shouldCheckUsages";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isLocallyUsed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class Builder
    extends JavaRecursiveElementWalkingVisitor {
        @NotNull
        private final PsiFile myPsiFile;
        @NotNull
        private final Set<PsiAnchor> myDclsUsedMap;
        @NotNull
        private final MultiMap<PsiElement, PsiReference> myLocalRefsMap;
        @NotNull
        private final Set<PsiImportStatementBase> myImportStatements;

        Builder(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myImportStatements = new HashSet<PsiImportStatementBase>();
            this.myDclsUsedMap = new HashSet<PsiAnchor>();
            this.myPsiFile = psiFile;
            this.myLocalRefsMap = MultiMap.createLinkedSet();
        }

        LocalRefUseInfo build() {
            return new LocalRefUseInfo(this.myLocalRefsMap, this.myDclsUsedMap, this.myImportStatements);
        }

        public void visitNameValuePair(@NotNull PsiNameValuePair pair) {
            if (pair == null) {
                Builder.$$$reportNull$$$0(1);
            }
            super.visitNameValuePair(pair);
            PsiReference ref = pair.getReference();
            if (ref == null) {
                return;
            }
            PsiMethod method = (PsiMethod)ref.resolve();
            this.registerReference(ref, (JavaResolveResult)(method != null ? new CandidateInfo((PsiElement)method, PsiSubstitutor.EMPTY) : JavaResolveResult.EMPTY));
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                Builder.$$$reportNull$$$0(2);
            }
            super.visitClass(aClass);
            if (aClass.getConstructors().length == 0) {
                this.registerSuperConstructor(aClass);
            }
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                Builder.$$$reportNull$$$0(3);
            }
            super.visitMethod(method);
            if (method.isConstructor() && JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)method) == null) {
                this.registerSuperConstructor(method.getContainingClass());
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                Builder.$$$reportNull$$$0(4);
            }
            super.visitElement(element);
            if (this.myPsiFile instanceof ServerPageFile) {
                try {
                    for (PsiReference reference : element.getReferences()) {
                        if (!(reference instanceof PsiJavaReference)) continue;
                        PsiJavaReference psiJavaReference = (PsiJavaReference)reference;
                        this.registerReference(reference, psiJavaReference.advancedResolve(false));
                    }
                }
                catch (IndexNotReadyException indexNotReadyException) {
                    // empty catch block
                }
            }
        }

        private void registerReferencesFromInjectedFragments(@NotNull PsiElement element) {
            if (element == null) {
                Builder.$$$reportNull$$$0(5);
            }
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.myPsiFile.getProject());
            manager.enumerateEx(element, this.myPsiFile, false, (injectedPsi, places) -> {
                if (InjectedLanguageJavaReferenceSupplier.containsPsiMemberReferences(injectedPsi.getLanguage().getID())) {
                    injectedPsi.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitElement(@NotNull PsiElement element) {
                            if (element == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitElement(element);
                            for (PsiReference reference : element.getReferences()) {
                                PsiElement resolved = reference.resolve();
                                if (!(resolved instanceof PsiNamedElement)) continue;
                                PsiNamedElement namedElement = (PsiNamedElement)resolved;
                                this.registerLocallyReferenced(namedElement);
                                if (!(resolved instanceof PsiMember)) continue;
                                this.registerReference(reference, (JavaResolveResult)new CandidateInfo(resolved, PsiSubstitutor.EMPTY));
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo$Builder$1", "visitElement"));
                        }
                    });
                }
            });
        }

        private void registerSuperConstructor(@Nullable PsiClass aClass) {
            if (aClass == null) {
                return;
            }
            PsiClass baseClass = aClass.getSuperClass();
            if (baseClass == null) {
                return;
            }
            PsiMethod[] constructors = baseClass.getConstructors();
            if (constructors.length == 0) {
                return;
            }
            PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace((PsiMember)aClass, (Project)aClass.getProject(), (PsiClass)baseClass);
            if (resolved instanceof PsiMethod) {
                PsiMethod constructor = (PsiMethod)resolved;
                this.registerLocallyReferenced((PsiNamedElement)constructor);
            }
        }

        private void registerLocallyReferenced(@NotNull PsiNamedElement result) {
            if (result == null) {
                Builder.$$$reportNull$$$0(6);
            }
            this.myDclsUsedMap.add(PsiAnchor.create((PsiElement)result));
        }

        void registerReference(@NotNull PsiReference ref, @NotNull JavaResolveResult resolveResult) {
            block10: {
                PsiElement refElement;
                block13: {
                    block14: {
                        block12: {
                            PsiJavaCodeReferenceElement javaRef;
                            block11: {
                                Object object;
                                PsiFile psiFile;
                                if (ref == null) {
                                    Builder.$$$reportNull$$$0(7);
                                }
                                if (resolveResult == null) {
                                    Builder.$$$reportNull$$$0(8);
                                }
                                PsiFile psiFile2 = psiFile = (refElement = resolveResult.getElement()) == null ? null : refElement.getContainingFile();
                                if (psiFile != null) {
                                    psiFile = (PsiFile)psiFile.getNavigationElement();
                                }
                                if (refElement != null && psiFile != null && this.myPsiFile.getViewProvider().equals((Object)psiFile.getViewProvider())) {
                                    this.registerLocalRef(ref, refElement.getNavigationElement());
                                }
                                if (!((object = resolveResult.getCurrentFileResolveScope()) instanceof PsiImportStatementBase)) break block11;
                                PsiImportStatementBase importStatement = (PsiImportStatementBase)object;
                                this.registerImportStatement(importStatement);
                                break block10;
                            }
                            if (!(ref instanceof PsiJavaCodeReferenceElement) || !Builder.isMethodCallResolvedToVariable(refElement, javaRef = (PsiJavaCodeReferenceElement)ref)) break block12;
                            for (PsiImportStatementBase potentialImport : IncompleteModelUtil.getPotentialImports((PsiJavaCodeReferenceElement)javaRef, (boolean)false)) {
                                this.registerImportStatement(potentialImport);
                            }
                            break block10;
                        }
                        if (refElement != null || !(ref instanceof PsiJavaReference)) break block13;
                        PsiJavaReference javaReference = (PsiJavaReference)ref;
                        JavaResolveResult[] results = javaReference.multiResolve(true);
                        if (results.length <= 0) break block14;
                        for (JavaResolveResult result : results) {
                            PsiElement psiElement = result.getCurrentFileResolveScope();
                            if (!(psiElement instanceof PsiImportStatementBase)) continue;
                            PsiImportStatementBase importStatement = (PsiImportStatementBase)psiElement;
                            this.registerImportStatement(importStatement);
                            break block10;
                        }
                        break block10;
                    }
                    if (!(ref instanceof PsiJavaCodeReferenceElement)) break block10;
                    PsiJavaCodeReferenceElement javaRef = (PsiJavaCodeReferenceElement)ref;
                    for (PsiImportStatementBase potentialImport : IncompleteModelUtil.getPotentialImports((PsiJavaCodeReferenceElement)javaRef)) {
                        this.registerImportStatement(potentialImport);
                    }
                    break block10;
                }
                if (ref instanceof PsiJavaCodeReferenceElement) {
                    PsiJavaCodeReferenceElement javaRef = (PsiJavaCodeReferenceElement)ref;
                    if (refElement instanceof PsiVariable && IncompleteModelUtil.canBeClassReference((PsiJavaCodeReferenceElement)javaRef)) {
                        for (PsiImportStatementBase potentialImport : IncompleteModelUtil.getPotentialImports((PsiJavaCodeReferenceElement)javaRef)) {
                            this.registerImportStatement(potentialImport);
                        }
                    }
                }
            }
        }

        public void visitLiteralExpression(@NotNull PsiLiteralExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(9);
            }
            super.visitLiteralExpression(expression);
            this.registerReferencesFromInjectedFragments((PsiElement)expression);
            for (PsiReference reference : expression.getReferences()) {
                PsiElement resolve;
                if (!(reference instanceof PsiMemberReference) || !((resolve = reference.resolve()) instanceof PsiMember)) continue;
                this.registerReference(reference, (JavaResolveResult)new CandidateInfo(resolve, PsiSubstitutor.EMPTY));
            }
        }

        public void visitNewExpression(@NotNull PsiNewExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(10);
            }
            super.visitNewExpression(expression);
            this.registerConstructorCall((PsiConstructorCall)expression);
        }

        public void visitReferenceElement(@NotNull PsiJavaCodeReferenceElement ref) {
            JavaResolveResult result;
            if (ref == null) {
                Builder.$$$reportNull$$$0(11);
            }
            super.visitReferenceElement(ref);
            if (!(ref instanceof PsiImportStaticReferenceElement) && (result = LocalRefUseInfo.resolveOptimised(ref, this.myPsiFile)) != null) {
                this.registerReference((PsiReference)ref, result);
            }
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression ref) {
            if (ref == null) {
                Builder.$$$reportNull$$$0(12);
            }
            super.visitReferenceExpression(ref);
            JavaResolveResult result = LocalRefUseInfo.resolveOptimised((PsiJavaCodeReferenceElement)ref, this.myPsiFile);
            if (result != null) {
                this.registerReference((PsiReference)ref, result);
            }
        }

        public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
            if (expression == null) {
                Builder.$$$reportNull$$$0(13);
            }
            super.visitMethodReferenceExpression(expression);
            JavaResolveResult result = expression.advancedResolve(true);
            this.registerReference((PsiReference)expression, result);
            PsiParameter[] psiParameterArray = result.getElement();
            if (psiParameterArray instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)psiParameterArray;
                for (PsiParameter parameter : method.getParameterList().getParameters()) {
                    this.registerLocallyReferenced((PsiNamedElement)parameter);
                }
            }
        }

        public void visitComment(@NotNull PsiComment comment) {
            if (comment == null) {
                Builder.$$$reportNull$$$0(14);
            }
            super.visitComment(comment);
            this.registerReferencesFromInjectedFragments((PsiElement)comment);
        }

        public void visitEnumConstant(@NotNull PsiEnumConstant enumConstant) {
            if (enumConstant == null) {
                Builder.$$$reportNull$$$0(15);
            }
            super.visitEnumConstant(enumConstant);
            this.registerConstructorCall((PsiConstructorCall)enumConstant);
        }

        private static boolean isMethodCallResolvedToVariable(@Nullable PsiElement refElement, @NotNull PsiJavaCodeReferenceElement javaRef) {
            if (javaRef == null) {
                Builder.$$$reportNull$$$0(16);
            }
            return javaRef.getParent() instanceof PsiMethodCallExpression && (refElement instanceof PsiLocalVariable || refElement instanceof PsiField || refElement instanceof PsiParameter);
        }

        private void registerConstructorCall(@NotNull PsiConstructorCall constructorCall) {
            PsiElement psiElement;
            if (constructorCall == null) {
                Builder.$$$reportNull$$$0(17);
            }
            if ((psiElement = constructorCall.resolveMethodGenerics().getElement()) instanceof PsiNamedElement) {
                PsiNamedElement namedElement = (PsiNamedElement)psiElement;
                this.registerLocallyReferenced(namedElement);
            }
        }

        private void registerImportStatement(@NotNull PsiImportStatementBase importStatement) {
            if (importStatement == null) {
                Builder.$$$reportNull$$$0(18);
            }
            this.myImportStatements.add(importStatement);
        }

        private void registerLocalRef(@NotNull PsiReference ref, PsiElement refElement) {
            if (ref == null) {
                Builder.$$$reportNull$$$0(19);
            }
            PsiElement element = ref.getElement();
            if (refElement instanceof PsiMethod && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
                return;
            }
            if (refElement instanceof PsiClass && PsiTreeUtil.isAncestor((PsiElement)refElement, (PsiElement)element, (boolean)true)) {
                return;
            }
            this.myLocalRefsMap.putValue((Object)refElement, (Object)ref);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 7: 
                case 11: 
                case 12: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ref";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveResult";
                    break;
                }
                case 9: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enumConstant";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "javaRef";
                    break;
                }
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constructorCall";
                    break;
                }
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/LocalRefUseInfo$Builder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNameValuePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerReferencesFromInjectedFragments";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerLocallyReferenced";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerReference";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitLiteralExpression";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitNewExpression";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceElement";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethodReferenceExpression";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitComment";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitEnumConstant";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isMethodCallResolvedToVariable";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerConstructorCall";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerImportStatement";
                    break;
                }
                case 19: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerLocalRef";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

