/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAllUnusedImportsFix
implements ModCommandAction {
    private final List<SmartPsiElementPointer<PsiImportStatementBase>> myUnusedImportPointerList;

    public RemoveAllUnusedImportsFix(@NotNull List<PsiImportStatementBase> unusedImportList) {
        if (unusedImportList == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(0);
        }
        this.myUnusedImportPointerList = ContainerUtil.map(unusedImportList, SmartPointerManager::createPointer);
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaErrorBundle.message("remove.unused.imports.quickfix.text", new Object[0]);
        if (string == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public Presentation getPresentation(@NotNull ActionContext context) {
        if (context == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(2);
        }
        return context.file() instanceof PsiJavaFile ? Presentation.of((String)this.getFamilyName()) : null;
    }

    @NotNull
    public ModCommand perform(@NotNull ActionContext context) {
        if (context == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(3);
        }
        if (!(context.file() instanceof PsiJavaFile)) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                RemoveAllUnusedImportsFix.$$$reportNull$$$0(4);
            }
            return modCommand;
        }
        List importStatements = ContainerUtil.mapNotNull(this.myUnusedImportPointerList, SmartPsiElementPointer::getElement);
        return RemoveAllUnusedImportsFix.removeImports(context, importStatements);
    }

    @NotNull
    protected static ModCommand removeImports(@NotNull ActionContext context, List<PsiImportStatementBase> importStatements) {
        if (context == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(5);
        }
        if (importStatements.isEmpty()) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                RemoveAllUnusedImportsFix.$$$reportNull$$$0(6);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)context, updater -> {
            for (PsiImportStatementBase statement : ContainerUtil.map((Collection)importStatements, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0))) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)statement);
            }
        });
        if (modCommand == null) {
            RemoveAllUnusedImportsFix.$$$reportNull$$$0(7);
        }
        return modCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unusedImportList";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAllUnusedImportsFix";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAllUnusedImportsFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "removeImports";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeImports";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 7 -> new IllegalStateException(string);
        };
    }
}

