/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDirectiveFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiPackageAccessibilityStatement;
import com.intellij.psi.util.PsiUtil;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/codeInsight/daemon/impl/quickfix/AddPackageAccessibilityFix;", "Lcom/intellij/codeInsight/daemon/impl/quickfix/AddModuleDirectiveFix;", "directive", "", "module", "Lcom/intellij/psi/PsiJavaModule;", "packageName", "targetName", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiJavaModule;Ljava/lang/String;Ljava/lang/String;)V", "addPackageAccessibility", "", "project", "Lcom/intellij/openapi/project/Project;", "accessibilityStatements", "", "Lcom/intellij/psi/PsiPackageAccessibilityStatement;", "intellij.java.analysis.impl"})
@SourceDebugExtension(value={"SMAP\nAddModuleDirectiveFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddModuleDirectiveFix.kt\ncom/intellij/codeInsight/daemon/impl/quickfix/AddPackageAccessibilityFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public abstract class AddPackageAccessibilityFix
extends AddModuleDirectiveFix {
    @NotNull
    private final String directive;
    @NotNull
    private final String packageName;
    @NotNull
    private final String targetName;

    public AddPackageAccessibilityFix(@NotNull String directive, @NotNull PsiJavaModule module, @NotNull String packageName, @NotNull String targetName) {
        Intrinsics.checkNotNullParameter((Object)directive, (String)"directive");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)targetName, (String)"targetName");
        super(module);
        this.directive = directive;
        this.packageName = packageName;
        this.targetName = targetName;
    }

    protected final void addPackageAccessibility(@NotNull Project project, @NotNull PsiJavaModule module, @NotNull Iterable<? extends PsiPackageAccessibilityStatement> accessibilityStatements) {
        PsiPackageAccessibilityStatement psiPackageAccessibilityStatement;
        block5: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter(accessibilityStatements, (String)"accessibilityStatements");
            Iterable<? extends PsiPackageAccessibilityStatement> iterable = accessibilityStatements;
            Iterator<? extends PsiPackageAccessibilityStatement> iterator = iterable.iterator();
            while (iterator.hasNext()) {
                PsiPackageAccessibilityStatement psiPackageAccessibilityStatement2;
                PsiPackageAccessibilityStatement it = psiPackageAccessibilityStatement2 = iterator.next();
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)this.packageName, (Object)it.getPackageName())) continue;
                psiPackageAccessibilityStatement = psiPackageAccessibilityStatement2;
                break block5;
            }
            psiPackageAccessibilityStatement = null;
        }
        PsiPackageAccessibilityStatement existing = psiPackageAccessibilityStatement;
        if (existing == null) {
            PsiUtil.addModuleStatement((PsiJavaModule)module, (String)(this.directive + " " + this.packageName));
        } else if (!(((CharSequence)this.targetName).length() == 0)) {
            List list = existing.getModuleNames();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getModuleNames(...)");
            List targets = list;
            if (!targets.isEmpty() && !targets.contains(this.targetName)) {
                existing.add((PsiElement)PsiElementFactory.getInstance((Project)project).createModuleReferenceFromText(this.targetName, null));
            }
        }
    }
}

