/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.RemoveRedundantTypeArgumentsUtil;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.util.PsiExpressionTrimRenderer;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChangeNewOperatorTypeFix
extends PsiUpdateModCommandAction<PsiNewExpression> {
    private final PsiType myType;

    private ChangeNewOperatorTypeFix(PsiType type, PsiNewExpression expression) {
        super((PsiElement)expression);
        this.myType = type;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.new.operator.type.family", new Object[0]);
        if (string == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiNewExpression expression) {
        if (context == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(2);
        }
        if (!this.myType.isValid() || TypeConversionUtil.isPrimitiveAndNotNull((PsiType)this.myType)) {
            return null;
        }
        String message = QuickFixBundle.message("change.new.operator.type.text", PsiExpressionTrimRenderer.render((PsiExpression)expression), this.myType.getPresentableText(), this.myType instanceof PsiArrayType ? "" : "()");
        return Presentation.of((String)message);
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiNewExpression element, @NotNull ModPsiUpdater updater) {
        UnfairTextRange selection;
        PsiNewExpression newExpression;
        int caretOffset;
        if (context == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(4);
        }
        if (updater == null) {
            ChangeNewOperatorTypeFix.$$$reportNull$$$0(5);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)element.getProject());
        CommentTracker commentTracker = new CommentTracker();
        if (this.myType instanceof PsiArrayType) {
            PsiExpression[] originalExpressionArrayDimensions = element.getArrayDimensions();
            caretOffset = 0;
            @NonNls StringBuilder text = new StringBuilder("new " + this.myType.getDeepComponentType().getCanonicalText() + "[");
            if (originalExpressionArrayDimensions.length > 0) {
                text.append(commentTracker.text((PsiElement)originalExpressionArrayDimensions[0]));
            } else {
                text.append("0");
                caretOffset = -2;
            }
            text.append("]");
            for (int i = 1; i < this.myType.getArrayDimensions(); ++i) {
                text.append("[");
                if (originalExpressionArrayDimensions.length > i) {
                    text.append(commentTracker.text((PsiElement)originalExpressionArrayDimensions[i]));
                }
                text.append("]");
                if (caretOffset >= 0) continue;
                caretOffset -= 2;
            }
            newExpression = (PsiNewExpression)factory.createExpressionFromText(text.toString(), (PsiElement)element);
            selection = caretOffset < 0 ? new UnfairTextRange(caretOffset, caretOffset + 1) : null;
        } else {
            PsiAnonymousClass anonymousClass = element.getAnonymousClass();
            newExpression = (PsiNewExpression)factory.createExpressionFromText("new " + this.myType.getCanonicalText() + "()" + (anonymousClass != null ? "{}" : ""), (PsiElement)element);
            PsiExpressionList argumentList = element.getArgumentList();
            if (argumentList != null) {
                PsiExpressionList newArgumentList = newExpression.getArgumentList();
                assert (newArgumentList != null);
                newArgumentList.replace((PsiElement)commentTracker.markUnchanged(argumentList));
            }
            if (anonymousClass != null) {
                PsiAnonymousClass newAnonymousClass = newExpression.getAnonymousClass();
                assert (newAnonymousClass != null);
                PsiElement lBrace = anonymousClass.getLBrace();
                assert (lBrace != null);
                PsiElement childInside = lBrace.getNextSibling();
                if (childInside != null) {
                    PsiElement element1 = childInside;
                    do {
                        commentTracker.markUnchanged(element1);
                    } while ((element1 = element1.getNextSibling()) != null);
                    PsiElement rBrace = anonymousClass.getRBrace();
                    assert (rBrace != null);
                    newAnonymousClass.addRange(childInside, rBrace.getPrevSibling());
                }
            }
            selection = null;
            caretOffset = -1;
        }
        newExpression = (PsiNewExpression)commentTracker.replaceAndRestoreComments((PsiElement)element, (PsiElement)newExpression);
        if (PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newExpression, (PsiNewExpression)newExpression, (PsiType)this.myType)) {
            PsiJavaCodeReferenceElement reference = newExpression.getClassOrAnonymousClassReference();
            assert (reference != null);
            RemoveRedundantTypeArgumentsUtil.replaceExplicitWithDiamond((PsiElement)reference.getParameterList());
        }
        if (selection != null) {
            selection = selection.shiftRight(newExpression.getTextRange().getEndOffset());
            updater.select((TextRange)selection);
        }
        updater.moveCaretTo(newExpression.getTextRange().getEndOffset() + caretOffset);
    }

    public static ModCommandAction createFix(PsiExpression expression, PsiType lType) {
        if (PsiUtil.resolveClassInClassTypeOnly((PsiType)lType) instanceof PsiAnonymousClass) {
            return null;
        }
        if (!((expression = PsiUtil.deparenthesizeExpression((PsiExpression)expression)) instanceof PsiNewExpression)) {
            return null;
        }
        PsiNewExpression newExpression = (PsiNewExpression)expression;
        PsiType rType = expression.getType();
        PsiType newType = lType;
        if (rType instanceof PsiClassType) {
            PsiClassType rClassType = (PsiClassType)rType;
            if (newType instanceof PsiClassType) {
                PsiSubstitutor substitutor;
                PsiClassType.ClassResolveResult lResolveResult;
                PsiClass lClass;
                PsiClassType newClassType = (PsiClassType)newType;
                PsiClassType.ClassResolveResult rResolveResult = rClassType.resolveGenerics();
                PsiClass rClass = rResolveResult.getElement();
                if (rClass instanceof PsiAnonymousClass) {
                    rClass = ((PsiAnonymousClass)rClass).getBaseClassType().resolve();
                }
                if (rClass != null && (lClass = (lResolveResult = newClassType.resolveGenerics()).getElement()) != null && (substitutor = ChangeNewOperatorTypeFix.getInheritorSubstitutorForNewExpression(lClass, rClass, lResolveResult.getSubstitutor(), (PsiElement)expression)) != null) {
                    newType = JavaPsiFacade.getElementFactory((Project)lClass.getProject()).createType(rClass, substitutor);
                }
            }
        }
        if (rType == null || newType.getCanonicalText().equals(rType.getCanonicalText())) {
            return null;
        }
        PsiClass aClass = PsiTypesUtil.getPsiClass((PsiType)newType);
        if (aClass != null && (aClass.isEnum() || aClass.isAnnotationType())) {
            return null;
        }
        return new ChangeNewOperatorTypeFix(newType, newExpression);
    }

    @Nullable
    private static PsiSubstitutor getInheritorSubstitutorForNewExpression(PsiClass baseClass, PsiClass inheritor, PsiSubstitutor baseSubstitutor, PsiElement context) {
        Project project = baseClass.getProject();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiSubstitutor superSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)baseClass, (PsiClass)inheritor, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        if (superSubstitutor == null) {
            return null;
        }
        PsiSubstitutor inheritorSubstitutor = PsiSubstitutor.EMPTY;
        block0: for (PsiTypeParameter inheritorParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)inheritor)) {
            for (PsiTypeParameter baseParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)baseClass)) {
                PsiType substituted = superSubstitutor.substitute(baseParameter);
                PsiType arg = baseSubstitutor.substitute(baseParameter);
                if (arg instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType = (PsiWildcardType)arg;
                    arg = wildcardType.getBound();
                }
                PsiType substitution = resolveHelper.getSubstitutionForTypeParameter(inheritorParameter, substituted, arg, true, PsiUtil.getLanguageLevel((PsiElement)context));
                if (PsiTypes.nullType().equals(substitution)) continue;
                if (substitution == null) {
                    return facade.getElementFactory().createRawSubstitutor((PsiTypeParameterListOwner)inheritor);
                }
                inheritorSubstitutor = inheritorSubstitutor.put(inheritorParameter, substitution);
                continue block0;
            }
        }
        return inheritorSubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeNewOperatorTypeFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

