/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiConstructorCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class ChangeStringLiteralToCharInMethodCallFix
extends PsiUpdateModCommandAction<PsiLiteralExpression> {
    private ChangeStringLiteralToCharInMethodCallFix(@NotNull PsiLiteralExpression literal) {
        if (literal == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)literal);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.single.character.string.to.char.literal.family", new Object[0]);
        if (string == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiLiteralExpression literal) {
        if (context == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(2);
        }
        if (literal == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(3);
        }
        String convertedValue = ChangeStringLiteralToCharInMethodCallFix.convertedValue(literal);
        boolean isString = ChangeStringLiteralToCharInMethodCallFix.isString(literal.getType());
        String message = QuickFixBundle.message("fix.single.character.string.to.char.literal.text", literal.getText(), ChangeStringLiteralToCharInMethodCallFix.quote(convertedValue, !isString), isString ? PsiTypes.charType().getCanonicalText() : "String");
        Presentation presentation = Presentation.of((String)message).withPriority(PriorityAction.Priority.HIGH);
        if (presentation == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(4);
        }
        return presentation;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiLiteralExpression literal, @NotNull ModPsiUpdater updater) {
        Object value;
        if (context == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(5);
        }
        if (literal == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(7);
        }
        if ((value = literal.getValue()) != null && value.toString().length() == 1) {
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)context.project());
            PsiExpression newExpression = factory.createExpressionFromText(ChangeStringLiteralToCharInMethodCallFix.quote(ChangeStringLiteralToCharInMethodCallFix.convertedValue(literal), !ChangeStringLiteralToCharInMethodCallFix.isString(literal.getType())), literal.getParent());
            literal.replace((PsiElement)newExpression);
        }
    }

    private static String quote(String value, boolean doubleQuotes) {
        char quote = doubleQuotes ? (char)'\"' : '\'';
        return quote + value + quote;
    }

    private static String convertedValue(@NotNull PsiLiteralExpression literal) {
        if (literal == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(8);
        }
        String value = String.valueOf(literal.getValue());
        StringBuilder builder = new StringBuilder();
        StringUtil.escapeStringCharacters((int)value.length(), (String)value, (String)"\"'", (StringBuilder)builder);
        return builder.toString();
    }

    public static void registerFixes(PsiMethod @NotNull [] candidates, @NotNull PsiConstructorCall call, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (call == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(9);
        }
        if (info == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(10);
        }
        if (candidates == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(11);
        }
        HashSet literals = new HashSet();
        if (call.getArgumentList() == null) {
            return;
        }
        boolean exactMatch = false;
        for (PsiMethod method : candidates) {
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(call.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, info);
        }
    }

    public static void registerFixes(CandidateInfo @NotNull [] candidates, @NotNull PsiMethodCallExpression methodCall, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (methodCall == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(12);
        }
        if (info == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(13);
        }
        if (candidates == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(14);
        }
        HashSet literals = new HashSet();
        boolean exactMatch = false;
        for (CandidateInfo candidate : candidates) {
            if (!(candidate instanceof MethodCandidateInfo)) continue;
            PsiMethod method = ((MethodCandidateInfo)candidate).getElement();
            exactMatch |= ChangeStringLiteralToCharInMethodCallFix.findMatchingExpressions(methodCall.getArgumentList().getExpressions(), method, literals);
        }
        if (!exactMatch) {
            ChangeStringLiteralToCharInMethodCallFix.processLiterals(literals, info);
        }
    }

    private static void processLiterals(@NotNull Set<? extends PsiLiteralExpression> literals, @NotNull Consumer<? super CommonIntentionAction> info) {
        if (literals == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(15);
        }
        if (info == null) {
            ChangeStringLiteralToCharInMethodCallFix.$$$reportNull$$$0(16);
        }
        for (PsiLiteralExpression psiLiteralExpression : literals) {
            ChangeStringLiteralToCharInMethodCallFix fix = new ChangeStringLiteralToCharInMethodCallFix(psiLiteralExpression);
            info.accept((CommonIntentionAction)fix);
        }
    }

    private static boolean findMatchingExpressions(PsiExpression[] arguments, PsiMethod existingMethod, Set<? super PsiLiteralExpression> result) {
        PsiParameterList parameterList = existingMethod.getParameterList();
        PsiParameter[] parameters = parameterList.getParameters();
        if (arguments.length != parameters.length) {
            return false;
        }
        boolean typeMatch = true;
        for (int i = 0; i < parameters.length; ++i) {
            String value;
            PsiParameter parameter = parameters[i];
            PsiType parameterType = parameter.getType();
            PsiType argumentType = arguments[i].getType();
            typeMatch &= Comparing.equal((Object)parameterType, (Object)argumentType);
            PsiLiteralExpression argument = (PsiLiteralExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[i]), PsiLiteralExpression.class);
            if (argument == null || result.contains(argument) || !ChangeStringLiteralToCharInMethodCallFix.charToString(parameterType, argumentType) && !ChangeStringLiteralToCharInMethodCallFix.charToString(argumentType, parameterType) || (value = String.valueOf(argument.getValue())) == null || value.length() != 1) continue;
            result.add((PsiLiteralExpression)argument);
        }
        return typeMatch;
    }

    private static boolean charToString(PsiType firstType, PsiType secondType) {
        return Comparing.equal((Object)PsiTypes.charType(), (Object)firstType) && ChangeStringLiteralToCharInMethodCallFix.isString(secondType);
    }

    private static boolean isString(PsiType type) {
        return type != null && type.equalsToText("java.lang.String");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literal";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literals";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ChangeStringLiteralToCharInMethodCallFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertedValue";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processLiterals";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4 -> new IllegalStateException(string);
        };
    }
}

