/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ExtendsListModCommandFix
extends PsiUpdateModCommandAction<PsiClass> {
    @Nullable
    protected final SmartPsiElementPointer<PsiClass> myClassToExtendFromPointer;
    private final boolean myToAdd;
    private final PsiClassType myTypeToExtendFrom;
    @IntentionName
    private final String myName;

    public ExtendsListModCommandFix(@NotNull PsiClass aClass, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(0);
        }
        if (typeToExtendFrom == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(1);
        }
        this(aClass, typeToExtendFrom.resolve(), typeToExtendFrom, toAdd);
    }

    public ExtendsListModCommandFix(@NotNull PsiClass aClass, @NotNull PsiClass classToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(2);
        }
        if (classToExtendFrom == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(3);
        }
        this(aClass, classToExtendFrom, JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(classToExtendFrom), toAdd);
    }

    @ApiStatus.Internal
    public ExtendsListModCommandFix(@NotNull PsiClass aClass, @Nullable PsiClass classToExtendFrom, @NotNull PsiClassType typeToExtendFrom, boolean toAdd) {
        if (aClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(4);
        }
        if (typeToExtendFrom == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(5);
        }
        super((PsiElement)aClass);
        this.myClassToExtendFromPointer = classToExtendFrom == null ? null : SmartPointerManager.createPointer((PsiElement)classToExtendFrom);
        this.myToAdd = toAdd;
        PsiClassType psiClassType = this.myTypeToExtendFrom = aClass instanceof PsiTypeParameter ? typeToExtendFrom : (PsiClassType)GenericsUtil.eliminateWildcards((PsiType)typeToExtendFrom);
        @PropertyKey(resourceBundle="messages.QuickFixBundle") String messageKey = classToExtendFrom != null && aClass.isInterface() == classToExtendFrom.isInterface() || aClass instanceof PsiTypeParameter ? (toAdd ? "add.class.to.extends.list" : "remove.class.from.extends.list") : (toAdd ? "add.interface.to.implements.list" : "remove.interface.from.implements.list");
        this.myName = QuickFixBundle.message(messageKey, aClass.getName(), classToExtendFrom == null ? "" : (classToExtendFrom instanceof PsiTypeParameter ? classToExtendFrom.getName() : classToExtendFrom.getQualifiedName()));
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiClass myClass) {
        boolean available;
        PsiClass classToExtendFrom;
        if (context == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(6);
        }
        if (myClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(7);
        }
        if (!this.myTypeToExtendFrom.isValid()) {
            return null;
        }
        PsiClass psiClass = classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        boolean bl = classToExtendFrom != null && !classToExtendFrom.hasModifierProperty("final") && (classToExtendFrom.isInterface() || !myClass.isInterface() && myClass.getExtendsList() != null && myClass.getExtendsList().getReferencedTypes().length == 0 == this.myToAdd) ? true : (available = false);
        if (!available) {
            return null;
        }
        return Presentation.of((String)this.myName);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("change.extends.list.family", new Object[0]);
        if (string == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiClass myClass, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(9);
        }
        if (myClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(10);
        }
        if (updater == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(11);
        }
        this.invokeImpl(myClass);
    }

    @ApiStatus.Internal
    public void invokeImpl(@NotNull PsiClass myClass) {
        PsiReferenceList otherList;
        if (myClass == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(12);
        }
        PsiClass classToExtendFrom = this.myClassToExtendFromPointer != null ? (PsiClass)this.myClassToExtendFromPointer.getElement() : null;
        PsiReferenceList extendsList = !(myClass instanceof PsiTypeParameter) && classToExtendFrom != null && myClass.isInterface() != classToExtendFrom.isInterface() ? myClass.getImplementsList() : myClass.getExtendsList();
        PsiReferenceList psiReferenceList = otherList = extendsList == myClass.getImplementsList() ? myClass.getExtendsList() : myClass.getImplementsList();
        if (extendsList != null) {
            ExtendsListModCommandFix.modifyList(extendsList, this.myToAdd, -1, this.myTypeToExtendFrom);
        }
        if (otherList != null) {
            ExtendsListModCommandFix.modifyList(otherList, false, -1, this.myTypeToExtendFrom);
        }
    }

    @ApiStatus.Internal
    public static void modifyList(@NotNull PsiReferenceList extendsList, boolean add, int position, @NotNull PsiClassType myTypeToExtendFrom) {
        PsiClass classToExtendFrom;
        if (extendsList == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(13);
        }
        if (myTypeToExtendFrom == null) {
            ExtendsListModCommandFix.$$$reportNull$$$0(14);
        }
        if ((classToExtendFrom = myTypeToExtendFrom.resolve()) == null) {
            return;
        }
        PsiJavaCodeReferenceElement[] referenceElements = extendsList.getReferenceElements();
        boolean alreadyExtends = false;
        for (PsiJavaCodeReferenceElement referenceElement : referenceElements) {
            if (!referenceElement.getManager().areElementsEquivalent((PsiElement)classToExtendFrom, referenceElement.resolve())) continue;
            alreadyExtends = true;
            if (add) continue;
            referenceElement.delete();
        }
        PsiReferenceList list = extendsList;
        Project project = extendsList.getProject();
        if (add && !alreadyExtends) {
            PsiJavaCodeReferenceElement anchor = position == -1 ? (referenceElements.length == 0 ? null : referenceElements[referenceElements.length - 1]) : (position == 0 ? null : referenceElements[position - 1]);
            PsiJavaCodeReferenceElement classReferenceElement = JavaPsiFacade.getElementFactory((Project)project).createReferenceElementByType(myTypeToExtendFrom.annotate(TypeAnnotationProvider.EMPTY));
            PsiElement element = anchor == null ? (referenceElements.length == 0 ? extendsList.add((PsiElement)classReferenceElement) : extendsList.addBefore((PsiElement)classReferenceElement, (PsiElement)referenceElements[0])) : extendsList.addAfter((PsiElement)classReferenceElement, (PsiElement)anchor);
            list = (PsiReferenceList)element.getParent();
        }
        if (!add && !alreadyExtends) {
            return;
        }
        CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)list));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeToExtendFrom";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToExtendFrom";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListModCommandFix";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendsList";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myTypeToExtendFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/ExtendsListModCommandFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invokeImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "modifyList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

