/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.javadoc.JavaDocUtil;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.find.findUsages.JavaMethodFindUsagesOptions;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModShowConflicts;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiBasedModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public abstract class MethodThrowsFix
extends PsiBasedModCommandAction<PsiMethod> {
    protected final String myThrowsCanonicalText;
    private final String myMethodName;
    @PropertyKey(resourceBundle="messages.QuickFixBundle")
    private final @PropertyKey(resourceBundle="messages.QuickFixBundle") String myMessageKey;

    protected MethodThrowsFix(@PropertyKey(resourceBundle="messages.QuickFixBundle") @PropertyKey(resourceBundle="messages.QuickFixBundle") String key, @NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
        if (method == null) {
            MethodThrowsFix.$$$reportNull$$$0(0);
        }
        if (exceptionType == null) {
            MethodThrowsFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)method);
        this.myMessageKey = key;
        this.myThrowsCanonicalText = exceptionType.getCanonicalText();
        this.myMethodName = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)(1 | (showClassName ? 4096 : 0)), (int)0);
    }

    @NotNull
    public final String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            MethodThrowsFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethod element) {
        if (context == null) {
            MethodThrowsFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            MethodThrowsFix.$$$reportNull$$$0(4);
        }
        if (element.getThrowsList() instanceof PsiCompiledElement) {
            return null;
        }
        return Presentation.of((String)QuickFixBundle.message(this.myMessageKey, StringUtil.getShortName((String)this.myThrowsCanonicalText), this.myMethodName));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static class Remove
    extends MethodThrowsFix {
        public Remove(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                Remove.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                Remove.$$$reportNull$$$0(1);
            }
            super("fix.throws.list.remove.exception", method, exceptionType, showClassName);
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiMethod method) {
            if (context == null) {
                Remove.$$$reportNull$$$0(2);
            }
            if (method == null) {
                Remove.$$$reportNull$$$0(3);
            }
            Project project = context.project();
            PsiClassType exception = JavaPsiFacade.getElementFactory((Project)project).createTypeByFQClassName(this.myThrowsCanonicalText, method.getResolveScope());
            ModCommand action = ModCommand.psiUpdate((PsiElement)method, m -> this.processMethod(project, (PsiMethod)m));
            if (!IntentionPreviewUtils.isIntentionPreviewActive() && !ExceptionUtil.isUncheckedException((PsiClassType)exception)) {
                JavaMethodFindUsagesOptions ops = new JavaMethodFindUsagesOptions(project);
                ops.isSearchForTextOccurrences = false;
                ops.isImplicitToString = false;
                ops.isSkipImportStatements = true;
                HashMap conflicts = new HashMap();
                JavaFindUsagesHelper.processElementUsages((PsiElement)method, (FindUsagesOptions)ops, (Processor<? super UsageInfo>)((Processor)usage -> {
                    ExceptionUtil.HandlePlace place;
                    PsiElement element = usage.getElement();
                    if (!(element instanceof PsiReferenceExpression)) {
                        return true;
                    }
                    PsiElement parent = element.getParent();
                    if (parent instanceof PsiCallExpression && (place = ExceptionUtil.getHandlePlace((PsiElement)parent, (PsiClassType)exception, null)) instanceof ExceptionUtil.HandlePlace.TryCatch) {
                        ExceptionUtil.HandlePlace.TryCatch tryCatch = (ExceptionUtil.HandlePlace.TryCatch)place;
                        PsiParameter parameter = tryCatch.getParameter();
                        PsiCodeBlock block = tryCatch.getTryStatement().getTryBlock();
                        if (block != null) {
                            PsiCallExpression call = (PsiCallExpression)parent;
                            Collection types = ExceptionUtil.collectUnhandledExceptions((PsiElement)block, null, (PsiCallExpression)call);
                            if (types.contains(exception)) {
                                return true;
                            }
                            ArrayList thrownCheckedExceptions = new ArrayList(ExceptionUtil.getThrownCheckedExceptions((PsiElement[])new PsiElement[]{call}));
                            thrownCheckedExceptions.remove(exception);
                            PsiType caughtExceptionType = parameter.getType();
                            if (Stream.concat(types.stream(), thrownCheckedExceptions.stream()).noneMatch(ex -> caughtExceptionType.isAssignableFrom((PsiType)ex))) {
                                conflicts.put(parameter, new ModShowConflicts.Conflict(List.of(JavaAnalysisBundle.message((String)"exception.handler.will.become.unreachable", (Object[])new Object[0]))));
                            }
                        }
                    }
                    return true;
                }));
                ModCommand modCommand = ModCommand.showConflicts(conflicts).andThen(action);
                if (modCommand == null) {
                    Remove.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            ModCommand modCommand = action;
            if (modCommand == null) {
                Remove.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        void processMethod(@NotNull Project project, @NotNull PsiMethod method) {
            if (project == null) {
                Remove.$$$reportNull$$$0(6);
            }
            if (method == null) {
                Remove.$$$reportNull$$$0(7);
            }
            PsiType exceptionType = JavaPsiFacade.getElementFactory((Project)project).createTypeFromText(this.myThrowsCanonicalText, null);
            for (PsiElement element : Remove.extractRefsToRemove(method, exceptionType)) {
                element.delete();
            }
        }

        public static PsiElement[] extractRefsToRemove(PsiMethod method, PsiType exceptionType) {
            SmartList refs = new SmartList();
            PsiJavaCodeReferenceElement[] referenceElements = method.getThrowsList().getReferenceElements();
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)method.getProject());
            Arrays.stream(referenceElements).filter(ref -> {
                PsiClassType refType = elementFactory.createType(ref);
                return exceptionType.isAssignableFrom((PsiType)refType);
            }).forEach(((List)refs)::add);
            PsiDocComment comment = method.getDocComment();
            if (comment != null) {
                Arrays.stream(comment.getTags()).filter(tag -> "throws".equals(tag.getName())).filter(tag -> {
                    PsiClass tagValueClass = JavaDocUtil.resolveClassInTagValue((PsiDocTagValue)tag.getValueElement());
                    if (tagValueClass == null) {
                        return false;
                    }
                    PsiClassType tagValueType = elementFactory.createType(tagValueClass);
                    return exceptionType.isAssignableFrom((PsiType)tagValueType);
                }).forEach(((List)refs)::add);
            }
            return refs.toArray(PsiElement.EMPTY_ARRAY);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Remove";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Remove";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "processMethod";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class RemoveFirst
    extends MethodThrowsFix {
        public RemoveFirst(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                RemoveFirst.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                RemoveFirst.$$$reportNull$$$0(1);
            }
            super("fix.throws.list.remove.exception", method, exceptionType, showClassName);
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiMethod method) {
            if (context == null) {
                RemoveFirst.$$$reportNull$$$0(2);
            }
            if (method == null) {
                RemoveFirst.$$$reportNull$$$0(3);
            }
            PsiJavaCodeReferenceElement[] referenceElements = method.getThrowsList().getReferenceElements();
            ModCommand modCommand = Arrays.stream(referenceElements).filter(referenceElement -> referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText)).findFirst().map(ref -> ModCommand.psiUpdate((PsiElement)ref, PsiElement::delete)).orElse(ModCommand.nop());
            if (modCommand == null) {
                RemoveFirst.$$$reportNull$$$0(4);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$RemoveFirst";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$RemoveFirst";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    public static class Add
    extends MethodThrowsFix {
        public Add(@NotNull PsiMethod method, @NotNull PsiClassType exceptionType, boolean showClassName) {
            if (method == null) {
                Add.$$$reportNull$$$0(0);
            }
            if (exceptionType == null) {
                Add.$$$reportNull$$$0(1);
            }
            super("fix.throws.list.add.exception", method, exceptionType, showClassName);
        }

        @NotNull
        protected ModCommand perform(@NotNull ActionContext context, @NotNull PsiMethod myMethod) {
            Object[] referenceElements;
            boolean alreadyThrows;
            if (context == null) {
                Add.$$$reportNull$$$0(2);
            }
            if (myMethod == null) {
                Add.$$$reportNull$$$0(3);
            }
            if (alreadyThrows = ContainerUtil.exists((Object[])(referenceElements = myMethod.getThrowsList().getReferenceElements()), referenceElement -> referenceElement.getCanonicalText().equals(this.myThrowsCanonicalText))) {
                ModCommand modCommand = ModCommand.nop();
                if (modCommand == null) {
                    Add.$$$reportNull$$$0(4);
                }
                return modCommand;
            }
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)myMethod.getProject());
            PsiClassType type = (PsiClassType)factory.createTypeFromText(this.myThrowsCanonicalText, (PsiElement)myMethod);
            JavaCodeStyleManager manager = JavaCodeStyleManager.getInstance((Project)context.project());
            PsiElement ref = manager.shortenClassReferences((PsiElement)factory.createReferenceElementByType(type));
            ModCommand modCommand = ModCommand.psiUpdate((PsiElement)myMethod, method -> method.getThrowsList().add(ref));
            if (modCommand == null) {
                Add.$$$reportNull$$$0(5);
            }
            return modCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptionType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "myMethod";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Add";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/MethodThrowsFix$Add";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "perform";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "perform";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

