/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifyMethodCallFix
extends PsiUpdateModCommandAction<PsiMethodCallExpression> {
    private final String myQualifierText;

    public QualifyMethodCallFix(@NotNull PsiMethodCallExpression call, @NotNull String qualifierText) {
        if (call == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(0);
        }
        if (qualifierText == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(1);
        }
        super((PsiElement)call);
        this.myQualifierText = qualifierText;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiMethodCallExpression element) {
        if (context == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(2);
        }
        if (element == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(3);
        }
        return Presentation.of((String)QuickFixBundle.message("qualify.method.call.fix", this.myQualifierText)).withFixAllOption((ModCommandAction)this);
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("qualify.method.call.family", new Object[0]);
        if (string == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiMethodCallExpression call, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(5);
        }
        if (call == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(6);
        }
        if (updater == null) {
            QualifyMethodCallFix.$$$reportNull$$$0(7);
        }
        PsiReferenceExpression expression = call.getMethodExpression();
        expression.setQualifierExpression(JavaPsiFacade.getElementFactory((Project)context.project()).createExpressionFromText(this.myQualifierText, null));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierText";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyMethodCallFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/QualifyMethodCallFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

