/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.guess.impl;

import com.intellij.codeInsight.JavaPsiEquivalenceUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.util.containers.HashingStrategy;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExpressionVariableDescriptor
implements VariableDescriptor {
    public static final HashingStrategy<PsiExpression> EXPRESSION_HASHING_STRATEGY = new PsiExpressionStrategy();
    @NotNull
    private final PsiExpression myExpression;

    public ExpressionVariableDescriptor(@NotNull PsiExpression expression) {
        if (expression == null) {
            ExpressionVariableDescriptor.$$$reportNull$$$0(0);
        }
        this.myExpression = expression;
    }

    public boolean isStable() {
        return true;
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression = this.myExpression;
        if (psiExpression == null) {
            ExpressionVariableDescriptor.$$$reportNull$$$0(1);
        }
        return psiExpression;
    }

    @NotNull
    public DfType getDfType(@Nullable DfaVariableValue qualifier) {
        DfType dfType = DfTypes.typedObject(this.myExpression.getType(), Nullability.UNKNOWN);
        if (dfType == null) {
            ExpressionVariableDescriptor.$$$reportNull$$$0(2);
        }
        return dfType;
    }

    public int hashCode() {
        return EXPRESSION_HASHING_STRATEGY.hashCode((Object)this.myExpression);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExpressionVariableDescriptor && EXPRESSION_HASHING_STRATEGY.equals((Object)this.myExpression, (Object)((ExpressionVariableDescriptor)obj).myExpression);
    }

    public String toString() {
        return this.myExpression.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/guess/impl/ExpressionVariableDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/guess/impl/ExpressionVariableDescriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }

    private static class PsiExpressionStrategy
    implements HashingStrategy<PsiExpression> {
        private static final Logger LOG = Logger.getInstance(PsiExpressionStrategy.class);

        private PsiExpressionStrategy() {
        }

        public int hashCode(PsiExpression object) {
            if (object == null) {
                return 0;
            }
            if (object instanceof PsiReferenceExpression) {
                return Objects.hashCode(((PsiReferenceExpression)object).getReferenceName()) * 31 + 1;
            }
            if (object instanceof PsiMethodCallExpression) {
                return Objects.hashCode(((PsiMethodCallExpression)object).getMethodExpression().getReferenceName()) * 31 + 2;
            }
            return object.getNode().getElementType().hashCode();
        }

        public boolean equals(PsiExpression o1, PsiExpression o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (JavaPsiEquivalenceUtil.areExpressionsEquivalent((PsiExpression)o1, (PsiExpression)o2)) {
                if (this.hashCode(o1) != this.hashCode(o2)) {
                    LOG.error("different hashCodes: " + String.valueOf(o1) + "; " + String.valueOf(o2) + "; " + this.hashCode(o1) + "!=" + this.hashCode(o2));
                }
                return true;
            }
            return false;
        }
    }
}

