/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddTypeAnnotationFix
extends PsiUpdateModCommandAction<PsiTypeElement> {
    @NotNull
    private final String myAnnotationToAdd;
    @NotNull
    private final Collection<String> myAnnotationsToRemove;

    public AddTypeAnnotationFix(@NotNull PsiTypeElement element, @NotNull String annotationToAdd, @NotNull Collection<String> annotationsToRemove) {
        if (element == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(0);
        }
        if (annotationToAdd == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(1);
        }
        if (annotationsToRemove == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)element);
        this.myAnnotationToAdd = annotationToAdd;
        this.myAnnotationsToRemove = annotationsToRemove;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context, @NotNull PsiTypeElement element) {
        if (context == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(3);
        }
        if (element == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(4);
        }
        if (!element.acceptsAnnotations()) {
            return null;
        }
        return Presentation.of((String)JavaAnalysisBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{StringUtil.getShortName((String)this.myAnnotationToAdd)}));
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"intention.add.type.annotation.family", (Object[])new Object[0]);
        if (string == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected void invoke(@NotNull ActionContext context, @NotNull PsiTypeElement typeElement, @NotNull ModPsiUpdater updater) {
        if (context == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(6);
        }
        if (typeElement == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(7);
        }
        if (updater == null) {
            AddTypeAnnotationFix.$$$reportNull$$$0(8);
        }
        for (PsiAnnotation annotation : typeElement.getAnnotations()) {
            if (!this.myAnnotationsToRemove.contains(annotation.getQualifiedName())) continue;
            annotation.delete();
        }
        JavaCodeStyleManager.getInstance((Project)context.project()).shortenClassReferences((PsiElement)typeElement.addAnnotation(this.myAnnotationToAdd));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationToAdd";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsToRemove";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/AddTypeAnnotationFix";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/AddTypeAnnotationFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPresentation";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

