/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ipp.psiutils.ErrorUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SplitConditionUtil {
    public static PsiPolyadicExpression findCondition(PsiElement element) {
        return SplitConditionUtil.findCondition(element, true, true);
    }

    public static PsiPolyadicExpression findCondition(PsiElement element, boolean acceptAnd, boolean acceptOr) {
        boolean isOrExpression;
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiElement psiElement = token.getParent();
        if (!(psiElement instanceof PsiPolyadicExpression)) {
            return null;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)psiElement;
        boolean isAndExpression = acceptAnd && expression.getOperationTokenType() == JavaTokenType.ANDAND;
        boolean bl = isOrExpression = acceptOr && expression.getOperationTokenType() == JavaTokenType.OROR;
        if (!isAndExpression && !isOrExpression) {
            return null;
        }
        if (ErrorUtil.containsError((PsiElement)expression)) {
            return null;
        }
        while (expression.getParent() instanceof PsiPolyadicExpression) {
            expression = (PsiPolyadicExpression)expression.getParent();
            if (isAndExpression && expression.getOperationTokenType() != JavaTokenType.ANDAND) {
                return null;
            }
            if (!isOrExpression || expression.getOperationTokenType() == JavaTokenType.OROR) continue;
            return null;
        }
        return expression;
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression, PsiJavaToken separator) {
        return SplitConditionUtil.getROperands(expression, separator, new CommentTracker());
    }

    public static PsiExpression getROperands(PsiPolyadicExpression expression, PsiJavaToken separator, CommentTracker ct) {
        int offsetInParent;
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)separator);
        if (next == null) {
            offsetInParent = separator.getStartOffsetInParent() + separator.getTextLength();
        } else {
            ct.markRangeUnchanged(next, expression.getLastChild());
            offsetInParent = next.getStartOffsetInParent();
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        String rOperands = expression.getText().substring(offsetInParent);
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }

    public static PsiExpression getLOperands(@NotNull PsiPolyadicExpression expression, @NotNull PsiJavaToken separator) {
        if (expression == null) {
            SplitConditionUtil.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            SplitConditionUtil.$$$reportNull$$$0(1);
        }
        return SplitConditionUtil.getLOperands(expression, separator, new CommentTracker());
    }

    public static PsiExpression getLOperands(@NotNull PsiPolyadicExpression expression, @NotNull PsiJavaToken separator, @NotNull CommentTracker ct) {
        PsiJavaToken prev;
        if (expression == null) {
            SplitConditionUtil.$$$reportNull$$$0(2);
        }
        if (separator == null) {
            SplitConditionUtil.$$$reportNull$$$0(3);
        }
        if (ct == null) {
            SplitConditionUtil.$$$reportNull$$$0(4);
        }
        if ((prev = separator).getPrevSibling() instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        ct.markRangeUnchanged(expression.getFirstChild(), prev.getPrevSibling());
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expression.getProject());
        String rOperands = expression.getText().substring(0, prev.getStartOffsetInParent());
        return factory.createExpressionFromText(rOperands, expression.getParent());
    }

    @ApiStatus.Internal
    @Nullable
    public static PsiIfStatement create(@NotNull PsiElementFactory factory, @NotNull PsiIfStatement ifStatement, @NotNull PsiExpression extract, @NotNull PsiExpression leave, @NotNull IElementType operation, CommentTracker tracker) {
        PsiStatement thenBranch;
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(5);
        }
        if (ifStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(6);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(7);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(8);
        }
        if (operation == null) {
            SplitConditionUtil.$$$reportNull$$$0(9);
        }
        if ((thenBranch = ifStatement.getThenBranch()) == null) {
            return null;
        }
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (operation == JavaTokenType.OROR) {
            return SplitConditionUtil.createOrOr(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        if (operation == JavaTokenType.ANDAND) {
            return SplitConditionUtil.createAndAnd(factory, thenBranch, elseBranch, extract, leave, tracker);
        }
        return null;
    }

    @NotNull
    private static PsiIfStatement createAndAnd(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        Object thenString;
        PsiExpression nextCondition;
        PsiIfStatement nextIf;
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(10);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(11);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(12);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(13);
        }
        ArrayList<String> elseChain = new ArrayList<String>();
        boolean chainFinished = false;
        block0: while (!chainFinished && (nextIf = (PsiIfStatement)ObjectUtils.tryCast((Object)ControlFlowUtils.stripBraces(elseBranch), PsiIfStatement.class)) != null && (nextCondition = PsiUtil.skipParenthesizedExprDown((PsiExpression)nextIf.getCondition())) != null) {
            EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
            if (nextIf.getThenBranch() == null) break;
            if (equivalence.expressionsAreEquivalent(extract, nextCondition)) {
                elseChain.add(tracker.text((PsiElement)nextIf.getThenBranch()));
                chainFinished = true;
            } else {
                PsiExpression[] operands;
                PsiPolyadicExpression nextPolyadic;
                if (nextIf.getElseBranch() == null && equivalence.expressionsAreEquivalent(extract, factory.createExpressionFromText(BoolUtils.getNegatedExpressionText(nextCondition), (PsiElement)nextCondition))) {
                    elseBranch = nextIf.getThenBranch();
                    chainFinished = true;
                    break;
                }
                if (!(nextCondition instanceof PsiPolyadicExpression) || !(nextPolyadic = (PsiPolyadicExpression)nextCondition).getOperationTokenType().equals(JavaTokenType.ANDAND)) break;
                PsiExpression[] nextOperands = nextPolyadic.getOperands();
                if (nextOperands.length <= (operands = extract instanceof PsiPolyadicExpression && ((PsiPolyadicExpression)extract).getOperationTokenType().equals(JavaTokenType.ANDAND) ? ((PsiPolyadicExpression)extract).getOperands() : new PsiExpression[]{extract}).length) break;
                for (int i = 0; i < operands.length; ++i) {
                    if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)nextOperands[i], (PsiElement)operands[i])) break block0;
                }
                PsiExpression nextExtracted = SplitConditionUtil.getROperands(nextPolyadic, nextPolyadic.getTokenBeforeOperand(nextOperands[operands.length]), tracker);
                elseChain.add(SplitConditionUtil.createIfString(nextExtracted, nextIf.getThenBranch(), (PsiStatement)null, tracker));
            }
            elseBranch = nextIf.getElseBranch();
        }
        if (!chainFinished && elseBranch != null) {
            elseChain.add(elseBranch.getText());
        }
        if (elseChain.isEmpty()) {
            thenString = SplitConditionUtil.createIfString(leave, thenBranch, (String)null, tracker);
            if (elseBranch != null) {
                thenString = "{" + (String)thenString + "}";
            }
        } else {
            thenString = "{" + SplitConditionUtil.createIfString(leave, thenBranch, String.join((CharSequence)"\nelse ", elseChain), tracker) + "\n}";
        }
        String ifString = SplitConditionUtil.createIfString(extract, (String)thenString, elseBranch, tracker);
        PsiIfStatement psiIfStatement = (PsiIfStatement)factory.createStatementFromText(ifString, (PsiElement)thenBranch);
        if (psiIfStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(14);
        }
        return psiIfStatement;
    }

    @NotNull
    private static PsiIfStatement createOrOr(@NotNull PsiElementFactory factory, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, @NotNull PsiExpression extract, @NotNull PsiExpression leave, CommentTracker tracker) {
        if (factory == null) {
            SplitConditionUtil.$$$reportNull$$$0(15);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(16);
        }
        if (extract == null) {
            SplitConditionUtil.$$$reportNull$$$0(17);
        }
        if (leave == null) {
            SplitConditionUtil.$$$reportNull$$$0(18);
        }
        PsiIfStatement psiIfStatement = (PsiIfStatement)factory.createStatementFromText(SplitConditionUtil.createIfString(extract, thenBranch, SplitConditionUtil.createIfString(leave, thenBranch, elseBranch, tracker), tracker), (PsiElement)thenBranch);
        if (psiIfStatement == null) {
            SplitConditionUtil.$$$reportNull$$$0(19);
        }
        return psiIfStatement;
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull PsiStatement thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition == null) {
            SplitConditionUtil.$$$reportNull$$$0(20);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(21);
        }
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null ? condition : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), SplitConditionUtil.toElseBranchString(tracker.markUnchanged(elseBranch), false));
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull PsiStatement thenBranch, @Nullable String elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition == null) {
            SplitConditionUtil.$$$reportNull$$$0(22);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(23);
        }
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null ? condition : stripped)), SplitConditionUtil.toThenBranchString(tracker.markUnchanged(thenBranch)), elseBranch);
    }

    @NotNull
    private static String createIfString(@NotNull PsiExpression condition, @NotNull String thenBranch, @Nullable PsiStatement elseBranch, CommentTracker tracker) {
        PsiExpression stripped;
        if (condition == null) {
            SplitConditionUtil.$$$reportNull$$$0(24);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(25);
        }
        return SplitConditionUtil.createIfString(tracker.text((PsiElement)((stripped = PsiUtil.skipParenthesizedExprDown((PsiExpression)condition)) == null ? condition : stripped)), thenBranch, SplitConditionUtil.toElseBranchString(tracker.markUnchanged(elseBranch), true));
    }

    @NotNull
    private static String createIfString(@NotNull String condition, @NotNull String thenBranch, @Nullable String elseBranch) {
        if (condition == null) {
            SplitConditionUtil.$$$reportNull$$$0(26);
        }
        if (thenBranch == null) {
            SplitConditionUtil.$$$reportNull$$$0(27);
        }
        Object elsePart = elseBranch != null ? "\n else " + elseBranch : "";
        String string = "if (" + condition + ")\n" + thenBranch + (String)elsePart;
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private static String toThenBranchString(@NotNull PsiStatement statement) {
        if (statement == null) {
            SplitConditionUtil.$$$reportNull$$$0(29);
        }
        if (!(statement instanceof PsiBlockStatement)) {
            String string = "{ " + statement.getText() + "\n }";
            if (string == null) {
                SplitConditionUtil.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = statement.getText();
        if (string == null) {
            SplitConditionUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @Nullable
    private static String toElseBranchString(@Nullable PsiStatement statement, boolean skipElse) {
        if (statement == null) {
            return null;
        }
        if (statement instanceof PsiBlockStatement || skipElse && statement instanceof PsiIfStatement) {
            return statement.getText();
        }
        return "{ " + statement.getText() + "\n }";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 19, 28, 30, 31 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ct";
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extract";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leave";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 11: 
            case 16: 
            case 21: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thenBranch";
                break;
            }
            case 14: 
            case 19: 
            case 28: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/SplitConditionUtil";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/SplitConditionUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndAnd";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrOr";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIfString";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "toThenBranchString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLOperands";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAndAnd";
                break;
            }
            case 14: 
            case 19: 
            case 28: 
            case 30: 
            case 31: {
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createOrOr";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createIfString";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "toThenBranchString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 19, 28, 30, 31 -> new IllegalStateException(string);
        };
    }
}

