/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.options;

import com.intellij.codeInspection.ui.StringValidatorWithSwingSelector;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFolderValidator
implements StringValidatorWithSwingSelector {
    @NlsContexts.DialogTitle
    private final String myTitle;

    public LocalFolderValidator(@NlsContexts.DialogTitle String title) {
        this.myTitle = title;
    }

    @Nullable
    public String select(@NotNull Project project) {
        if (project == null) {
            LocalFolderValidator.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.singleDir();
        descriptor.setTitle(this.myTitle);
        descriptor.setForcedToUseIdeaFileChooser(true);
        VirtualFile newRoot = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        return newRoot == null ? null : newRoot.getPath();
    }

    @NotNull
    public String validatorId() {
        return "fs.folder";
    }

    @Nullable
    public String getErrorMessage(@Nullable Project project, @NotNull String filePath) {
        Path file;
        if (filePath == null) {
            LocalFolderValidator.$$$reportNull$$$0(1);
        }
        try {
            file = Path.of(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return e.getMessage();
        }
        VirtualFile virtualFile = VfsUtil.findFile((Path)file, (boolean)true);
        if (virtualFile == null) {
            return JavaBundle.message((String)"validator.text.directory.not.found", (Object[])new Object[0]);
        }
        if (!virtualFile.isDirectory()) {
            return JavaBundle.message((String)"validator.text.not.directory", (Object[])new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/options/LocalFolderValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getErrorMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

