/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InvalidComparatorMethodReferenceInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            InvalidComparatorMethodReferenceInspection.$$$reportNull$$$0(0);
        }
        return new JavaElementVisitor(this){

            public void visitMethodReferenceExpression(@NotNull PsiMethodReferenceExpression expression) {
                PsiElement referenceNameElement;
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((referenceNameElement = expression.getReferenceNameElement()) == null) {
                    return;
                }
                String name = referenceNameElement.getText();
                if (!name.equals("min") && !name.equals("max")) {
                    return;
                }
                String className = InvalidComparatorMethodReferenceInspection.getMethodReferenceClassName(expression);
                if (!"java.lang.Integer".equals(className) && !"java.lang.Math".equals(className)) {
                    return;
                }
                String functionalInterface = InvalidComparatorMethodReferenceInspection.getFunctionalInterfaceClassName(expression);
                if (!"java.util.Comparator".equals(functionalInterface)) {
                    return;
                }
                holder.registerProblem((PsiElement)expression, JavaAnalysisBundle.message((String)"method.reference.mapped.to.comparator", (Object[])new Object[0]), new LocalQuickFix[]{new ReplaceWithComparatorQuickFix(name.equals("min"))});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$1", "visitMethodReferenceExpression"));
            }
        };
    }

    @Nullable
    static String getFunctionalInterfaceClassName(PsiMethodReferenceExpression expression) {
        PsiType functionalInterfaceType = expression.getFunctionalInterfaceType();
        if (!(functionalInterfaceType instanceof PsiClassType)) {
            return null;
        }
        PsiClass targetType = ((PsiClassType)functionalInterfaceType).resolve();
        if (targetType == null) {
            return null;
        }
        return targetType.getQualifiedName();
    }

    @Nullable
    static String getMethodReferenceClassName(PsiMethodReferenceExpression expression) {
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (!(qualifierExpression instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiElement refType = ((PsiReference)qualifierExpression).resolve();
        if (!(refType instanceof PsiClass)) {
            return null;
        }
        return ((PsiClass)refType).getQualifiedName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection", "buildVisitor"));
    }

    private static class ReplaceWithComparatorQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean reverse;

        ReplaceWithComparatorQuickFix(boolean reverse) {
            this.reverse = reverse;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.reverse ? "Comparator.reverseOrder()" : "Comparator.naturalOrder()"});
            if (string == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"replace.with.comparator", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            PsiElement parent;
            if (project == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithComparatorQuickFix.$$$reportNull$$$0(4);
            }
            if ((parent = element.getParent()) != null) {
                PsiExpression newMethodExpression = JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText("java.util.Comparator." + (this.reverse ? "reverseOrder()" : "naturalOrder()"), parent);
                element.replace((PsiElement)newMethodExpression);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/InvalidComparatorMethodReferenceInspection$ReplaceWithComparatorQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

