/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationOwner;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiJavaDocumentedElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceListElement;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiVariableEx;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class JavaSuppressionUtil {
    private static final String GENERATED_ANNOTATION_NAME = "javax.annotation.Generated";
    private static final String JDK9_GENERATED_ANNOTATION_NAME = "javax.annotation.processing.Generated";
    public static final String SUPPRESS_INSPECTIONS_ANNOTATION_NAME = "java.lang.SuppressWarnings";
    private static final Set<String> GENERATED_RELATED_ANNOTATIONS = Set.of("javax.annotation.Generated", "javax.annotation.processing.Generated");

    public static boolean alreadyHas14Suppressions(@NotNull PsiJavaDocumentedElement commentOwner) {
        PsiDocComment docComment;
        if (commentOwner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(0);
        }
        return (docComment = commentOwner.getDocComment()) != null && docComment.findTagByName("noinspection") != null;
    }

    @Nullable
    private static String getInspectionIdSuppressedInAnnotationAttribute(@NotNull PsiElement element) {
        PsiVariableEx var;
        PsiReferenceExpression ref;
        Object object;
        if (element == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiLiteralExpression) {
            PsiLiteralExpression literal = (PsiLiteralExpression)element;
            Object object2 = literal.getValue();
            if (object2 instanceof String) {
                String s = (String)object2;
                return s;
            }
        } else if (element instanceof PsiReferenceExpression && (object = (ref = (PsiReferenceExpression)element).resolve()) instanceof PsiVariableEx && (object = (var = (PsiVariableEx)object).computeConstantValue(new HashSet())) instanceof String) {
            String s = (String)object;
            return s;
        }
        return null;
    }

    @NotNull
    public static Collection<String> getInspectionIdsSuppressedInAnnotation(@Nullable PsiModifierList modifierList) {
        if (modifierList == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(2);
            }
            return list;
        }
        PsiElement parent = modifierList.getParent();
        if (!(parent instanceof PsiModifierListOwner)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiModifierListOwner owner = (PsiModifierListOwner)parent;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME});
        if (annotation == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getCachedValue((PsiElement)annotation, () -> CachedValueProvider.Result.create(JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(annotation), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (collection == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static @Unmodifiable Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiAnnotation annotation) {
        PsiNameValuePair[] attributes;
        if (annotation == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(6);
        }
        if ((attributes = annotation.getParameterList().getAttributes()).length == 0) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Collection)AnnotationUtil.arrayAttributeValues((PsiAnnotationMemberValue)attributes[0].getValue()), JavaSuppressionUtil::getInspectionIdSuppressedInAnnotationAttribute);
        if (list == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    static <T extends PsiElement> PsiElement getElementMemberSuppressedIn(@NotNull T owner, @NotNull String inspectionToolID) {
        PsiPackage aPackage;
        PsiDirectory directory;
        PsiModifierListOwner o;
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(9);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(10);
        }
        PsiElement element = null;
        if (owner instanceof PsiJavaDocumentedElement) {
            PsiJavaDocumentedElement documented = (PsiJavaDocumentedElement)owner;
            element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(documented, inspectionToolID);
        }
        if (element != null) {
            return element;
        }
        if (owner instanceof PsiModifierListOwner && (element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn(o = (PsiModifierListOwner)owner, inspectionToolID)) != null) {
            return element;
        }
        PsiJavaDocumentedElement container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType(owner, PsiJavaDocumentedElement.class);
        while (container != null) {
            PsiModifierListOwner o2;
            element = JavaSuppressionUtil.getDocCommentToolSuppressedIn(container, inspectionToolID);
            if (element != null) {
                return element;
            }
            if (container instanceof PsiModifierListOwner && (element = JavaSuppressionUtil.getAnnotationMemberSuppressedIn(o2 = (PsiModifierListOwner)container, inspectionToolID)) != null) {
                return element;
            }
            container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class);
        }
        PsiJavaFile file = (PsiJavaFile)PsiTreeUtil.getParentOfType(owner, PsiJavaFile.class);
        if (file != null && (directory = file.getContainingDirectory()) != null && (aPackage = JavaDirectoryService.getInstance().getPackage(directory)) != null) {
            return AnnotationUtil.findAnnotation((PsiModifierListOwner)aPackage, (String[])new String[]{GENERATED_ANNOTATION_NAME, JDK9_GENERATED_ANNOTATION_NAME});
        }
        return null;
    }

    private static PsiElement getAnnotationMemberSuppressedIn(@NotNull PsiModifierListOwner owner, @NotNull String inspectionToolID) {
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(11);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(12);
        }
        PsiModifierList modifierList = owner.getModifierList();
        Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
        for (String ids : suppressedIds) {
            if (!SuppressionUtil.isInspectionToolIdMentioned((String)ids, (String)inspectionToolID)) continue;
            return modifierList != null ? AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME}) : null;
        }
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, GENERATED_RELATED_ANNOTATIONS, (boolean)false);
    }

    private static PsiElement getDocCommentToolSuppressedIn(@NotNull PsiJavaDocumentedElement owner, @NotNull String inspectionToolID) {
        PsiDocTag inspectionTag;
        PsiElement el;
        PsiDocComment docComment;
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(13);
        }
        if (inspectionToolID == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(14);
        }
        if ((docComment = owner.getDocComment()) == null && owner.getParent() instanceof PsiDeclarationStatement && (el = PsiTreeUtil.skipWhitespacesBackward((PsiElement)owner.getParent())) instanceof PsiDocComment) {
            PsiDocComment c;
            docComment = c = (PsiDocComment)el;
        }
        if (docComment != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            for (PsiElement dataElement : inspectionTag.getDataElements()) {
                String valueText = dataElement.getText();
                if (!SuppressionUtil.isInspectionToolIdMentioned((String)valueText, (String)inspectionToolID)) continue;
                return docComment;
            }
        }
        return null;
    }

    @NotNull
    private static Collection<String> getInspectionIdsSuppressedInAnnotation(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(15);
        }
        if (!PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)owner)) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                JavaSuppressionUtil.$$$reportNull$$$0(16);
            }
            return list;
        }
        PsiModifierList modifierList = owner.getModifierList();
        return JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(modifierList);
    }

    public static String getSuppressedInspectionIdsIn(@NotNull PsiElement element) {
        PsiDocTag inspectionTag;
        PsiJavaDocumentedElement documented;
        PsiDocComment docComment;
        String text;
        Matcher matcher;
        if (element == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(17);
        }
        if (element instanceof PsiComment && (matcher = SuppressionUtil.SUPPRESS_IN_LINE_COMMENT_PATTERN.matcher(text = element.getText())).matches()) {
            return matcher.group(1).trim();
        }
        if (element instanceof PsiJavaDocumentedElement && (docComment = (documented = (PsiJavaDocumentedElement)element).getDocComment()) != null && (inspectionTag = docComment.findTagByName("noinspection")) != null) {
            StringBuilder valueText = new StringBuilder();
            for (PsiElement dataElement : inspectionTag.getDataElements()) {
                valueText.append(dataElement.getText());
            }
            return valueText.toString();
        }
        if (element instanceof PsiModifierListOwner) {
            PsiModifierListOwner owner = (PsiModifierListOwner)element;
            Collection<String> suppressedIds = JavaSuppressionUtil.getInspectionIdsSuppressedInAnnotation(owner);
            return suppressedIds.isEmpty() ? null : StringUtil.join(suppressedIds, (String)",");
        }
        return null;
    }

    static PsiElement getElementToolSuppressedIn(@NotNull PsiElement place, @NotNull String toolId) {
        if (place == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(18);
        }
        if (toolId == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(19);
        }
        if (place instanceof PsiFile) {
            return null;
        }
        return (PsiElement)ReadAction.compute(() -> {
            PsiElement element;
            PsiJavaDocumentedElement container;
            PsiVariable var;
            PsiElement annotation;
            PsiModifierListOwner o;
            PsiElement statement = SuppressionUtil.getStatementToolSuppressedIn((PsiElement)place, (String)toolId, PsiStatement.class);
            if (statement != null) {
                return statement;
            }
            PsiElement up = PsiTreeUtil.getNonStrictParentOfType((PsiElement)place, (Class[])new Class[]{PsiVariable.class, PsiJavaDocumentedElement.class});
            if (up instanceof PsiModifierListOwner && (o = (PsiModifierListOwner)up).getModifierList() == null) {
                up = PsiTreeUtil.getParentOfType((PsiElement)up, (Class[])new Class[]{PsiVariable.class, PsiJavaDocumentedElement.class});
            }
            if (up instanceof PsiVariable && (annotation = JavaSuppressionUtil.getAnnotationMemberSuppressedIn((PsiModifierListOwner)(var = (PsiVariable)up), toolId)) != null) {
                return annotation;
            }
            PsiJavaDocumentedElement psiJavaDocumentedElement = container = up == null || up instanceof PsiJavaDocumentedElement ? (PsiJavaDocumentedElement)up : (PsiJavaDocumentedElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)up, (Class[])new Class[]{PsiJavaDocumentedElement.class});
            while (container instanceof PsiTypeParameter) {
                container = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class);
            }
            if (container != null && (element = JavaSuppressionUtil.getElementMemberSuppressedIn(container, toolId)) != null) {
                return element;
            }
            PsiJavaDocumentedElement classContainer = (PsiJavaDocumentedElement)PsiTreeUtil.getParentOfType((PsiElement)container, PsiJavaDocumentedElement.class, (boolean)true);
            if (classContainer != null) {
                return JavaSuppressionUtil.getElementMemberSuppressedIn(classContainer, toolId);
            }
            return null;
        });
    }

    public static void addSuppressAnnotation(@NotNull Project project, PsiElement container, @NotNull PsiModifierListOwner modifierOwner, @NotNull String id) throws IncorrectOperationException {
        PsiAnnotation annotation;
        PsiAnnotation newAnnotation;
        if (project == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(20);
        }
        if (modifierOwner == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(21);
        }
        if (id == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(22);
        }
        if ((newAnnotation = JavaSuppressionUtil.createNewAnnotation(project, container, annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierOwner, (String[])new String[]{SUPPRESS_INSPECTIONS_ANNOTATION_NAME}), id)) != null) {
            if (annotation != null) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                AddAnnotationPsiFix.addPhysicalAnnotationIfAbsent(SUPPRESS_INSPECTIONS_ANNOTATION_NAME, attributes, (PsiAnnotationOwner)Objects.requireNonNull(modifierOwner.getModifierList()));
            }
        }
    }

    private static PsiAnnotation createNewAnnotation(@NotNull Project project, PsiElement container, PsiAnnotation annotation, @NotNull String id) {
        if (project == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(23);
        }
        if (id == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(24);
        }
        String escaped = "\"" + StringUtil.escapeStringCharacters((String)id) + "\"";
        if (annotation == null) {
            return JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText("@java.lang.SuppressWarnings(" + escaped + ")", container);
        }
        StringBuilder newAnnotationText = new StringBuilder("@").append(SUPPRESS_INSPECTIONS_ANNOTATION_NAME).append("(");
        PsiAnnotationMemberValue value = annotation.findAttributeValue("value");
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiArrayInitializerMemberValue array = (PsiArrayInitializerMemberValue)value;
            PsiAnnotationMemberValue[] initializers = array.getInitializers();
            if (initializers.length > 0) {
                newAnnotationText.append('{');
                for (PsiAnnotationMemberValue initializer : initializers) {
                    PsiExpression expression;
                    newAnnotationText.append(initializer.getText()).append(',');
                    if (!(initializer instanceof PsiExpression) || !id.equals(ExpressionUtils.computeConstantExpression(expression = (PsiExpression)initializer))) continue;
                    return null;
                }
                newAnnotationText.append(escaped).append('}');
            } else {
                newAnnotationText.append(escaped);
            }
        } else if (value instanceof PsiExpression) {
            PsiExpression expression = (PsiExpression)value;
            if (id.equals(ExpressionUtils.computeConstantExpression(expression))) {
                return null;
            }
            newAnnotationText.append("{").append(expression.getText()).append(", ").append(escaped).append("}");
        } else {
            newAnnotationText.append(escaped);
        }
        return JavaPsiFacade.getElementFactory((Project)project).createAnnotationFromText(newAnnotationText.append(")").toString(), container);
    }

    public static boolean canHave15Suppressions(@NotNull PsiElement element) {
        if (element == null) {
            JavaSuppressionUtil.$$$reportNull$$$0(25);
        }
        return DaemonCodeAnalyzerSettings.getInstance().isSuppressWarnings() && PsiUtil.isAvailable((JavaFeature)JavaFeature.ANNOTATIONS, (PsiElement)element);
    }

    @Nullable
    public static PsiElement getElementToAnnotate(@NotNull PsiElement element, @NotNull PsiElement container) {
        block10: {
            PsiTryStatement statement;
            PsiResourceList resourceList;
            block9: {
                if (element == null) {
                    JavaSuppressionUtil.$$$reportNull$$$0(26);
                }
                if (container == null) {
                    JavaSuppressionUtil.$$$reportNull$$$0(27);
                }
                if (!(container instanceof PsiDeclarationStatement)) break block9;
                PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)container;
                if (!JavaSuppressionUtil.canHave15Suppressions(element)) break block10;
                for (PsiElement declaredElement : declarationStatement.getDeclaredElements()) {
                    PsiLocalVariable var;
                    if (!(declaredElement instanceof PsiLocalVariable) || (var = (PsiLocalVariable)declaredElement).getModifierList() == null) continue;
                    return declaredElement;
                }
                break block10;
            }
            if (container instanceof PsiForeachStatement) {
                PsiForeachStatement foreach = (PsiForeachStatement)container;
                if (JavaSuppressionUtil.canHave15Suppressions(element)) {
                    PsiModifierList modifierList;
                    PsiParameter parameter = foreach.getIterationParameter();
                    PsiModifierList psiModifierList = modifierList = element.getParent() == parameter ? parameter.getModifierList() : null;
                    if (modifierList != null) {
                        return parameter;
                    }
                }
            } else if (container instanceof PsiTryStatement && (resourceList = (statement = (PsiTryStatement)container).getResourceList()) != null) {
                for (PsiResourceListElement listElement : resourceList) {
                    PsiResourceVariable var;
                    if (listElement != element.getParent() || !(listElement instanceof PsiResourceVariable) || (var = (PsiResourceVariable)listElement).getModifierList() == null) continue;
                    return listElement;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 7, 8, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commentOwner";
                break;
            }
            case 1: 
            case 17: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/JavaSuppressionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionToolID";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolId";
                break;
            }
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierOwner";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/JavaSuppressionUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionIdsSuppressedInAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "alreadyHas14Suppressions";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionIdSuppressedInAnnotationAttribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: {
                break;
            }
            case 6: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getInspectionIdsSuppressedInAnnotation";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getElementMemberSuppressedIn";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMemberSuppressedIn";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentToolSuppressedIn";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSuppressedInspectionIdsIn";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getElementToolSuppressedIn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressAnnotation";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createNewAnnotation";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "canHave15Suppressions";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getElementToAnnotate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 7, 8, 16 -> new IllegalStateException(string);
        };
    }
}

