/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.JavaErrorBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class NumericOverflowInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final Key<String> HAS_OVERFLOW_IN_CHILD = Key.create((String)"HAS_OVERFLOW_IN_CHILD");
    public boolean ignoreLeftShiftWithNegativeResult = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"ignoreLeftShiftWithNegativeResult", (String)JavaAnalysisBundle.message((String)"ignore.operation.which.results.in.negative.value", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            NumericOverflowInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.numeric.issues", (Object[])new Object[0]);
        if (string == null) {
            NumericOverflowInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        return "NumericOverflow";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            NumericOverflowInspection.$$$reportNull$$$0(2);
        }
        return new JavaElementVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(expression.getParent() instanceof PsiMethodCallExpression)) {
                    this.visitExpression((PsiExpression)expression);
                }
            }

            public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
                if (expression == null) {
                    1.$$$reportNull$$$0(1);
                }
            }

            public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
                if (callExpression == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            public void visitExpression(@NotNull PsiExpression expression) {
                boolean hasOverflow;
                if (expression == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (!(!(hasOverflow = NumericOverflowInspection.hasOverflow(expression, holder.getProject())) || NumericOverflowInspection.this.ignoreLeftShiftWithNegativeResult && NumericOverflowInspection.isLeftShiftWithNegativeResult(expression, holder.getProject()))) {
                    holder.registerProblem((PsiElement)expression, JavaErrorBundle.message("numeric.overflow.in.expression", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "callExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/NumericOverflowInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitArrayAccessExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitCallExpression";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static boolean isLeftShiftWithNegativeResult(PsiExpression expression, Project project) {
        PsiBinaryExpression binOp = (PsiBinaryExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)expression), PsiBinaryExpression.class);
        if (binOp == null || !binOp.getOperationTokenType().equals(JavaTokenType.LTLT)) {
            return false;
        }
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
        Object lOperandValue = helper.computeConstantExpression((PsiElement)binOp.getLOperand());
        Object rOperandValue = helper.computeConstantExpression((PsiElement)binOp.getROperand());
        if (lOperandValue instanceof Character) {
            lOperandValue = (int)((Character)lOperandValue).charValue();
        }
        if (rOperandValue instanceof Character) {
            rOperandValue = (int)((Character)rOperandValue).charValue();
        }
        if (!(lOperandValue instanceof Number) || !(rOperandValue instanceof Number)) {
            return false;
        }
        if (lOperandValue instanceof Long) {
            long l = ((Number)lOperandValue).longValue();
            long r = ((Number)rOperandValue).longValue();
            return (long)Long.numberOfLeadingZeros(l) - (r & 0x3FL) == 0L;
        }
        int l = ((Number)lOperandValue).intValue();
        int r = ((Number)rOperandValue).intValue();
        return Integer.numberOfLeadingZeros(l) - (r & 0x1F) == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasOverflow(PsiExpression expr, @NotNull Project project) {
        if (project == null) {
            NumericOverflowInspection.$$$reportNull$$$0(3);
        }
        if (!TypeConversionUtil.isNumericType((PsiType)expr.getType())) {
            return false;
        }
        boolean result = false;
        boolean toStoreInParent = false;
        try {
            if (expr.getUserData(HAS_OVERFLOW_IN_CHILD) == null) {
                JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper().computeConstantExpression((PsiElement)expr, true);
            } else {
                toStoreInParent = true;
                expr.putUserData(HAS_OVERFLOW_IN_CHILD, null);
            }
        }
        catch (ConstantEvaluationOverflowException e) {
            toStoreInParent = true;
            result = true;
        }
        finally {
            PsiElement parent = expr.getParent();
            if (toStoreInParent && parent instanceof PsiExpression) {
                parent.putUserData(HAS_OVERFLOW_IN_CHILD, (Object)"");
            }
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/NumericOverflowInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasOverflow";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

