/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class PossibleHeapPollutionVarargsInspection
extends AbstractBaseJavaLocalInspectionTool {
    public static final Logger LOG = Logger.getInstance(PossibleHeapPollutionVarargsInspection.class);

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message((String)"group.names.language.level.specific.issues.and.migration.aids", (Object[])new Object[0]);
        if (string == null) {
            PossibleHeapPollutionVarargsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        return "SafeVarargsDetector";
    }

    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "unchecked";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PossibleHeapPollutionVarargsInspection.$$$reportNull$$$0(1);
        }
        return new HeapPollutionVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }

    public static class HeapPollutionVisitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public HeapPollutionVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitMethod(@NotNull PsiMethod method) {
            if (method == null) {
                HeapPollutionVisitor.$$$reportNull$$$0(0);
            }
            super.visitMethod(method);
            if (!PsiUtil.getLanguageLevel((PsiElement)method).isAtLeast(LanguageLevel.JDK_1_7)) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            if (!method.isVarArgs()) {
                return;
            }
            PsiParameter[] parameters = method.getParameterList().getParameters();
            PsiParameter psiParameter = parameters[parameters.length - 1];
            if (!psiParameter.isVarArgs()) {
                return;
            }
            this.checkForHeapPollution(method, (PsiVariable)psiParameter);
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (aClass == null) {
                HeapPollutionVisitor.$$$reportNull$$$0(1);
            }
            super.visitClass(aClass);
            if (!aClass.isRecord()) {
                return;
            }
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, (String)"java.lang.SafeVarargs", (int)0)) {
                return;
            }
            PsiRecordHeader header = aClass.getRecordHeader();
            if (header == null) {
                return;
            }
            PsiRecordComponent lastComponent = (PsiRecordComponent)ArrayUtil.getLastElement((Object[])header.getRecordComponents());
            if (lastComponent == null || !lastComponent.isVarArgs()) {
                return;
            }
            PsiMethod constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)aClass);
            if (constructor != null && constructor.isPhysical()) {
                return;
            }
            PsiType type = lastComponent.getType();
            LOG.assertTrue(type instanceof PsiEllipsisType, (Object)("type: " + type.getCanonicalText() + "; param: " + String.valueOf(lastComponent)));
            PsiType componentType = ((PsiEllipsisType)type).getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                return;
            }
            PsiElement nameIdentifier = aClass.getNameIdentifier();
            if (nameIdentifier != null) {
                AnnotateAsSafeVarargsQuickFix quickFix = new AnnotateAsSafeVarargsQuickFix(false);
                this.myHolder.registerProblem(nameIdentifier, JavaAnalysisBundle.message((String)"possible.heap.pollution.from.parameterized.vararg.type.loc", (Object[])new Object[0]), new LocalQuickFix[]{quickFix});
            }
        }

        private void checkForHeapPollution(PsiMethod method, PsiVariable psiParameter) {
            PsiType type = psiParameter.getType();
            LOG.assertTrue(type instanceof PsiEllipsisType, (Object)("type: " + type.getCanonicalText() + "; param: " + String.valueOf(psiParameter)));
            PsiType componentType = ((PsiEllipsisType)type).getComponentType();
            if (JavaGenericsUtil.isReifiableType((PsiType)componentType)) {
                return;
            }
            for (PsiReferenceExpression element : VariableAccessUtils.getVariableReferences(psiParameter)) {
                if (PsiUtil.isAccessedForReading((PsiExpression)element)) continue;
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier != null) {
                this.registerProblem(method, nameIdentifier);
            }
        }

        protected void registerProblem(PsiMethod method, PsiIdentifier nameIdentifier) {
            AnnotateAsSafeVarargsQuickFix quickFix;
            if (GenericsUtil.isSafeVarargsNoOverridingCondition((PsiMethod)method)) {
                quickFix = new AnnotateAsSafeVarargsQuickFix(false);
            } else {
                PsiClass containingClass = method.getContainingClass();
                LOG.assertTrue(containingClass != null);
                boolean canBeFinal = !method.hasModifierProperty("abstract") && !containingClass.isInterface() && OverridingMethodsSearch.search((PsiMethod)method).findFirst() == null;
                quickFix = canBeFinal ? new AnnotateAsSafeVarargsQuickFix(true) : null;
            }
            this.myHolder.registerProblem((PsiElement)nameIdentifier, JavaAnalysisBundle.message((String)"possible.heap.pollution.from.parameterized.vararg.type.loc", (Object[])new Object[0]), LocalQuickFix.notNullElements((LocalQuickFix)quickFix));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$HeapPollutionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitMethod";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitClass";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class AnnotateAsSafeVarargsQuickFix
    extends PsiUpdateModCommandQuickFix {
        private final boolean myFinal;

        AnnotateAsSafeVarargsQuickFix(boolean makeFinal) {
            this.myFinal = makeFinal;
        }

        @NotNull
        public String getName() {
            String string = this.myFinal ? JavaAnalysisBundle.message((String)"make.final.and.annotate.as.safevarargs", (Object[])new Object[0]) : super.getName();
            if (string == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"annotate.as.safevarargs", (Object[])new Object[0]);
            if (string == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement psiElement, @NotNull ModPsiUpdater updater) {
            if (project == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(2);
            }
            if (psiElement == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                AnnotateAsSafeVarargsQuickFix.$$$reportNull$$$0(4);
            }
            if (!(psiElement instanceof PsiIdentifier)) {
                return;
            }
            PsiModifierListOwner owner = (PsiModifierListOwner)psiElement.getParent();
            if (owner instanceof PsiClass) {
                PsiClass rec = (PsiClass)owner;
                if (!rec.isRecord()) {
                    return;
                }
                String compactCtorText = "public " + rec.getName() + " {}";
                PsiMethod ctor = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText(compactCtorText, (PsiElement)owner);
                PsiMethod firstMethod = (PsiMethod)ArrayUtil.getFirstElement((Object[])rec.getMethods());
                owner = (PsiMethod)rec.addBefore((PsiElement)ctor, (PsiElement)firstMethod);
            }
            if (owner instanceof PsiMethod) {
                PsiModifierList list = owner.getModifierList();
                if (this.myFinal) {
                    list.setModifierProperty("final", true);
                }
                list.addAnnotation("java.lang.SafeVarargs");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/PossibleHeapPollutionVarargsInspection$AnnotateAsSafeVarargsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

