/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.java.JavaBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class ReassignedVariableInspection
extends AbstractBaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ReassignedVariableInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ReassignedVariableInspection.$$$reportNull$$$0(1);
        }
        return new ReassignedVariableVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/ReassignedVariableInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReassignedVariableVisitor
    extends JavaElementVisitor {
        private final Map<PsiElement, Collection<ControlFlowUtil.VariableInfo>> myLocalVariableProblems;
        private final Map<PsiParameter, Boolean> myParameterIsReassigned;
        @NotNull
        private final ProblemsHolder myHolder;

        private ReassignedVariableVisitor(ProblemsHolder holder) {
            if (holder == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(0);
            }
            this.myLocalVariableProblems = new ConcurrentHashMap<PsiElement, Collection<ControlFlowUtil.VariableInfo>>();
            this.myParameterIsReassigned = new ConcurrentHashMap<PsiParameter, Boolean>();
            this.myHolder = holder;
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            if (variable == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(1);
            }
            this.checkReassigned((PsiVariable)variable);
        }

        public void visitParameter(@NotNull PsiParameter parameter) {
            if (parameter == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(2);
            }
            this.myParameterIsReassigned.put(parameter, this.checkReassigned((PsiVariable)parameter));
        }

        private boolean checkReassigned(@NotNull PsiVariable variable) {
            PsiIdentifier nameIdentifier;
            if (variable == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(3);
            }
            if ((nameIdentifier = variable.getNameIdentifier()) != null && !variable.hasModifierProperty("final") && ControlFlowUtil.isReassigned((PsiVariable)variable, this.myLocalVariableProblems)) {
                this.myHolder.registerProblem((PsiElement)nameIdentifier, ReassignedVariableVisitor.getReassignedMessage(variable), new LocalQuickFix[0]);
                return true;
            }
            return false;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            PsiElement resolved;
            if (expression == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(4);
            }
            if (!this.myHolder.isOnTheFly()) {
                return;
            }
            PsiElement referenceNameElement = expression.getReferenceNameElement();
            if (referenceNameElement != null && ((resolved = expression.resolve()) instanceof PsiLocalVariable || resolved instanceof PsiParameter) && !((PsiVariable)resolved).hasModifierProperty("final") && !SuppressionUtil.inspectionResultSuppressed((PsiElement)resolved, (LocalInspectionTool)ReassignedVariableInspection.this)) {
                if (resolved instanceof PsiLocalVariable) {
                    if (ControlFlowUtil.isReassigned((PsiVariable)((PsiVariable)resolved), this.myLocalVariableProblems)) {
                        this.myHolder.registerProblem(referenceNameElement, ReassignedVariableVisitor.getReassignedMessage((PsiVariable)resolved), new LocalQuickFix[0]);
                    }
                } else {
                    Boolean isReassigned = this.myParameterIsReassigned.computeIfAbsent((PsiParameter)resolved, VariableAccessUtils::variableIsAssigned);
                    if (isReassigned.booleanValue()) {
                        this.myHolder.registerProblem(referenceNameElement, ReassignedVariableVisitor.getReassignedMessage((PsiVariable)resolved), new LocalQuickFix[0]);
                    }
                }
            }
        }

        @NotNull
        private static String getReassignedMessage(PsiVariable variable) {
            String string = JavaBundle.message((String)(variable instanceof PsiLocalVariable ? "tooltip.reassigned.local.variable" : "tooltip.reassigned.parameter"), (Object[])new Object[0]);
            if (string == null) {
                ReassignedVariableVisitor.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameter";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ReassignedVariableInspection$ReassignedVariableVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ReassignedVariableInspection$ReassignedVariableVisitor";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReassignedMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitLocalVariable";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visitParameter";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "checkReassigned";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "visitReferenceExpression";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }
}

