/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ModCommandAwareExternalAnnotationsManager;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAnnotationQuickFix
extends ModCommandQuickFix {
    private final SmartPsiElementPointer<PsiAnnotation> myAnnotation;
    private final SmartPsiElementPointer<PsiModifierListOwner> myListOwner;
    private final boolean myRemoveInheritors;

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner) {
        if (annotation == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(0);
        }
        this(annotation, listOwner, false);
    }

    public RemoveAnnotationQuickFix(@NotNull PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner, boolean removeInheritors) {
        if (annotation == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(1);
        }
        Project project = annotation.getProject();
        SmartPointerManager pm = SmartPointerManager.getInstance((Project)project);
        this.myAnnotation = pm.createSmartPsiElementPointer((PsiElement)annotation);
        this.myListOwner = listOwner == null ? null : pm.createSmartPsiElementPointer((PsiElement)listOwner);
        this.myRemoveInheritors = removeInheritors;
    }

    @NotNull
    public String getFamilyName() {
        String string = JavaAnalysisBundle.message((String)"remove.annotation", (Object[])new Object[0]);
        if (string == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiAnnotation annotation;
        if (project == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(3);
        }
        if (descriptor == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(4);
        }
        if ((annotation = (PsiAnnotation)this.myAnnotation.getElement()) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                RemoveAnnotationQuickFix.$$$reportNull$$$0(5);
            }
            return modCommand;
        }
        PsiModifierListOwner listOwner = this.myListOwner == null ? null : (PsiModifierListOwner)this.myListOwner.getElement();
        String qualifiedName = annotation.getQualifiedName();
        ArrayList<PsiAnnotation> physical = new ArrayList<PsiAnnotation>();
        ArrayList<PsiModifierListOwner> externalOwners = new ArrayList<PsiModifierListOwner>();
        RemoveAnnotationQuickFix.registerAnnotation(annotation, listOwner, physical, externalOwners);
        if (this.myRemoveInheritors && qualifiedName != null && !IntentionPreviewUtils.isIntentionPreviewActive()) {
            if (listOwner instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)listOwner;
                for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method).asIterable()) {
                    if (!psiMethod.isPhysical() || NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod)) continue;
                    RemoveAnnotationQuickFix.registerAnnotation(AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMethod, (String[])new String[]{qualifiedName}), (PsiModifierListOwner)psiMethod, physical, externalOwners);
                }
            } else if (listOwner instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)listOwner;
                PsiMethod method = (PsiMethod)ObjectUtils.tryCast((Object)parameter.getDeclarationScope(), PsiMethod.class);
                if (method == null) {
                    ModCommand modCommand = ModCommand.nop();
                    if (modCommand == null) {
                        RemoveAnnotationQuickFix.$$$reportNull$$$0(6);
                    }
                    return modCommand;
                }
                int index = method.getParameterList().getParameterIndex(parameter);
                if (index < 0) {
                    ModCommand modCommand = ModCommand.nop();
                    if (modCommand == null) {
                        RemoveAnnotationQuickFix.$$$reportNull$$$0(7);
                    }
                    return modCommand;
                }
                for (PsiMethod psiMethod : OverridingMethodsSearch.search((PsiMethod)method).asIterable()) {
                    PsiParameter subParameter;
                    if (!psiMethod.isPhysical() || NullableStuffInspectionBase.shouldSkipOverriderAsGenerated(psiMethod) || (subParameter = psiMethod.getParameterList().getParameter(index)) == null) continue;
                    RemoveAnnotationQuickFix.registerAnnotation(AnnotationUtil.findAnnotation((PsiModifierListOwner)subParameter, (String[])new String[]{qualifiedName}), (PsiModifierListOwner)subParameter, physical, externalOwners);
                }
            }
        }
        ModCommand modCommand = ModCommand.psiUpdate((ActionContext)ActionContext.from((ProblemDescriptor)descriptor), updater -> {
            List annotations = ContainerUtil.map((Collection)physical, arg_0 -> ((ModPsiUpdater)updater).getWritable(arg_0));
            Set containingFiles = StreamEx.of((Collection)annotations).map(PsiElement::getContainingFile).select(PsiJavaFile.class).toSet();
            annotations.forEach(PsiElement::delete);
            containingFiles.forEach(arg_0 -> ((JavaCodeStyleManager)JavaCodeStyleManager.getInstance((Project)project)).removeRedundantImports(arg_0));
        }).andThen(RemoveAnnotationQuickFix.deannotateExternal(project, qualifiedName, externalOwners));
        if (modCommand == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(8);
        }
        return modCommand;
    }

    @NotNull
    private static ModCommand deannotateExternal(@NotNull Project project, String qualifiedName, List<PsiModifierListOwner> externalOwners) {
        if (project == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(9);
        }
        if (qualifiedName != null) {
            ModCommand modCommand = ModCommandAwareExternalAnnotationsManager.getInstance(project).deannotateModCommand(externalOwners, List.of(qualifiedName));
            if (modCommand == null) {
                RemoveAnnotationQuickFix.$$$reportNull$$$0(10);
            }
            return modCommand;
        }
        ModCommand modCommand = ModCommand.nop();
        if (modCommand == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(11);
        }
        return modCommand;
    }

    private static void registerAnnotation(@Nullable PsiAnnotation annotation, @Nullable PsiModifierListOwner listOwner, @NotNull List<PsiAnnotation> physical, @NotNull List<PsiModifierListOwner> externalOwners) {
        if (physical == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(12);
        }
        if (externalOwners == null) {
            RemoveAnnotationQuickFix.$$$reportNull$$$0(13);
        }
        if (annotation == null) {
            return;
        }
        if (AnnotationUtil.isExternalAnnotation((PsiAnnotation)annotation)) {
            ContainerUtil.addIfNotNull(externalOwners, (Object)listOwner);
        } else {
            physical.add(annotation);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 7, 8, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "physical";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalOwners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveAnnotationQuickFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "deannotateExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deannotateExternal";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "registerAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 7, 8, 10, 11 -> new IllegalStateException(string);
        };
    }
}

