/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.ModCommandAwareExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class RemoveSuppressWarningAction
extends ModCommandQuickFix {
    private static final Logger LOG = Logger.getInstance(RemoveSuppressWarningAction.class);
    @NotNull
    private final String myID;

    RemoveSuppressWarningAction(@NotNull String id) {
        if (id == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(0);
        }
        int idx = id.indexOf(59);
        this.myID = idx > -1 ? id.substring(0, idx) : id;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("remove.suppression.action.family", new Object[0]);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public final ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(3);
        }
        PsiElement element = descriptor.getStartElement();
        ModCommand modCommand = ModCommand.psiUpdate((PsiElement)element, (e, updater) -> this.removeFromCode((PsiElement)e)).andThen(this.removeExternal(element));
        if (modCommand == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(4);
        }
        return modCommand;
    }

    private void removeFromCode(@NotNull PsiElement element) {
        if (element == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(5);
        }
        if (element instanceof PsiComment) {
            PsiComment comment = (PsiComment)element;
            this.removeFromComment(comment);
        } else {
            PsiModifierListOwner commentOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
            if (commentOwner != null) {
                PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(commentOwner, this.myID);
                if (psiElement instanceof PsiAnnotation) {
                    PsiAnnotation annotation = (PsiAnnotation)psiElement;
                    if (!ExternalAnnotationsManager.getInstance((Project)annotation.getProject()).isExternalAnnotation(annotation)) {
                        this.removeFromAnnotation(annotation);
                    }
                } else if (psiElement instanceof PsiDocComment) {
                    PsiDocComment docComment = (PsiDocComment)psiElement;
                    this.removeFromJavaDoc(docComment);
                } else {
                    final HashSet comments = new HashSet();
                    commentOwner.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                        public void visitComment(@NotNull PsiComment comment) {
                            if (comment == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            super.visitComment(comment);
                            if (comment.getText().contains(RemoveSuppressWarningAction.this.myID)) {
                                comments.add(comment);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comment", "com/intellij/codeInspection/RemoveSuppressWarningAction$1", "visitComment"));
                        }
                    });
                    for (PsiComment comment : comments) {
                        try {
                            this.removeFromComment(comment);
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                }
            }
        }
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("remove.suppression.action.name", this.myID);
        if (string == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(6);
        }
        return string;
    }

    private void removeFromComment(@NotNull PsiComment comment) throws IncorrectOperationException {
        String newText;
        if (comment == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(7);
        }
        String commentText = comment.getText();
        int secondCommentIdx = commentText.indexOf("//", 2);
        String suffix = "";
        if (secondCommentIdx > 0) {
            suffix = commentText.substring(secondCommentIdx);
        }
        if ((newText = this.removeFromElementText(new PsiElement[]{comment})) != null) {
            if (newText.isEmpty()) {
                if (suffix.isEmpty()) {
                    comment.delete();
                } else {
                    comment.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText(suffix, (PsiElement)comment));
                }
            } else {
                PsiComment newComment = JavaPsiFacade.getElementFactory((Project)comment.getProject()).createCommentFromText("// noinspection " + newText + suffix, (PsiElement)comment);
                comment.replace((PsiElement)newComment);
            }
        }
    }

    private void removeFromJavaDoc(@NotNull PsiDocComment docComment) throws IncorrectOperationException {
        PsiDocTag tag;
        if (docComment == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(8);
        }
        if ((tag = docComment.findTagByName("noinspection")) == null) {
            return;
        }
        String text = tag.getText();
        int i = text.indexOf(this.myID);
        if (i < 0) {
            return;
        }
        String noInspectionText = StringUtil.trimEnd((String)text.substring(0, i), (String)" ");
        String nextText = StringUtil.trimStart((String)text.substring(i + this.myID.length()), (String)" ");
        String nextTagText = noInspectionText.endsWith(",") ? noInspectionText.substring(0, noInspectionText.length() - 1) + nextText : (nextText.startsWith(",") ? noInspectionText + nextText.substring(1) : null);
        if (nextTagText != null) {
            tag.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)tag.getProject()).createDocTagFromText(nextTagText));
        } else {
            PsiElement[] descriptionElements = JavaPsiFacade.getElementFactory((Project)tag.getProject()).createDocCommentFromText("/**" + nextText + "*/", (PsiElement)tag).getDescriptionElements();
            if (descriptionElements.length > 0) {
                docComment.addRangeAfter(descriptionElements[0], descriptionElements[descriptionElements.length - 1], (PsiElement)tag);
            }
            tag.delete();
        }
    }

    @Nullable
    private String removeFromElementText(PsiElement ... elements) {
        ArrayList ids;
        int i;
        if (elements == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(9);
        }
        StringBuilder textBuilder = new StringBuilder();
        for (PsiElement element : elements) {
            textBuilder.append(StringUtil.trimStart((String)element.getText(), (String)"//").trim());
        }
        String text = textBuilder.toString();
        int secondCommentIdx = (text = StringUtil.trimStart((String)text, (String)"@").trim()).indexOf("//");
        if (secondCommentIdx > 0) {
            text = text.substring(0, secondCommentIdx);
        }
        if ((i = ArrayUtil.find((Object[])(ids = new ArrayList(StringUtil.split((String)(text = StringUtil.trimStart((String)text, (String)"noinspection").trim()), (String)","))).toArray(), (Object)this.myID)) == -1) {
            return null;
        }
        ids.remove(i);
        return StringUtil.join(ids, (String)",");
    }

    private void removeFromAnnotation(@NotNull PsiAnnotation annotation) throws IncorrectOperationException {
        Object[] attributes;
        PsiNameValuePair attribute;
        if (annotation == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(10);
        }
        if ((attribute = (PsiNameValuePair)ContainerUtil.find((Object[])(attributes = annotation.getParameterList().getAttributes()), attr -> "value".equals(attr.getAttributeName()))) == null) {
            return;
        }
        PsiAnnotationMemberValue value = attribute.getValue();
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                if (!this.removeFromValue(annotation, initializer, initializers.length == 1)) continue;
                return;
            }
        }
        assert (value != null);
        this.removeFromValue(annotation, value, attributes.length == 1);
    }

    private boolean removeFromValue(@NotNull PsiAnnotation annotation, @NotNull PsiAnnotationMemberValue value, boolean removeParent) throws IncorrectOperationException {
        String text;
        if (annotation == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(11);
        }
        if (value == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(12);
        }
        if (!this.myID.equals(text = StringUtil.unquoteString((String)value.getText()))) {
            return false;
        }
        new CommentTracker().deleteAndRestoreComments((PsiElement)(removeParent ? annotation : value));
        return true;
    }

    private ModCommand removeExternal(@NotNull PsiElement element) {
        PsiAnnotation annotation;
        PsiModifierListOwner owner;
        if (element == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(13);
        }
        if ((owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false)) == null) {
            return ModCommand.nop();
        }
        PsiElement psiElement = JavaSuppressionUtil.getElementMemberSuppressedIn(owner, this.myID);
        if (psiElement instanceof PsiAnnotation && ExternalAnnotationsManager.getInstance((Project)(annotation = (PsiAnnotation)psiElement).getProject()).isExternalAnnotation(annotation)) {
            return this.removeFromAnnotationExternal(annotation, owner);
        }
        return ModCommand.nop();
    }

    @NotNull
    private ModCommand removeFromAnnotationExternal(@NotNull PsiAnnotation annotation, @NotNull PsiModifierListOwner owner) throws IncorrectOperationException {
        Object[] attributes;
        PsiNameValuePair attribute;
        if (annotation == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(14);
        }
        if (owner == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(15);
        }
        if ((attribute = (PsiNameValuePair)ContainerUtil.find((Object[])(attributes = annotation.getParameterList().getAttributes()), attr -> "value".equals(attr.getAttributeName()))) == null) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                RemoveSuppressWarningAction.$$$reportNull$$$0(16);
            }
            return modCommand;
        }
        PsiAnnotationMemberValue value = attribute.getValue();
        if (value instanceof PsiArrayInitializerMemberValue) {
            PsiAnnotationMemberValue[] initializers;
            for (PsiAnnotationMemberValue initializer : initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()) {
                ModCommand command = this.removeFromValueExternal(annotation, initializer, initializers.length == 1, owner);
                if (command.isEmpty()) continue;
                ModCommand modCommand = command;
                if (modCommand == null) {
                    RemoveSuppressWarningAction.$$$reportNull$$$0(17);
                }
                return modCommand;
            }
        }
        assert (value != null);
        return this.removeFromValueExternal(annotation, value, attributes.length == 1, owner);
    }

    @NotNull
    private ModCommand removeFromValueExternal(@NotNull PsiAnnotation annotation, @NotNull PsiAnnotationMemberValue value, boolean removeParent, @NotNull PsiModifierListOwner owner) throws IncorrectOperationException {
        String text;
        if (annotation == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(18);
        }
        if (value == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(19);
        }
        if (owner == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(20);
        }
        if (!this.myID.equals(text = StringUtil.unquoteString((String)value.getText()))) {
            ModCommand modCommand = ModCommand.nop();
            if (modCommand == null) {
                RemoveSuppressWarningAction.$$$reportNull$$$0(21);
            }
            return modCommand;
        }
        ModCommandAwareExternalAnnotationsManager manager = ModCommandAwareExternalAnnotationsManager.getInstance(annotation.getProject());
        if (removeParent) {
            String qualifiedName = annotation.getQualifiedName();
            assert (qualifiedName != null);
            ModCommand modCommand = manager.deannotateModCommand(List.of(owner), List.of(qualifiedName));
            if (modCommand == null) {
                RemoveSuppressWarningAction.$$$reportNull$$$0(22);
            }
            return modCommand;
        }
        PsiAnnotation annotationCopy = (PsiAnnotation)annotation.copy();
        PsiTreeUtil.processElements((PsiElement)annotationCopy, e -> {
            if (e instanceof PsiAnnotationMemberValue && e.getText().equals(value.getText())) {
                e.delete();
                return false;
            }
            return true;
        });
        PsiNameValuePair[] nameValuePairs = annotationCopy.getParameterList().getAttributes();
        String qualifiedName = annotation.getQualifiedName();
        assert (qualifiedName != null);
        ModCommand modCommand = manager.editExternalAnnotationModCommand(owner, qualifiedName, nameValuePairs);
        if (modCommand == null) {
            RemoveSuppressWarningAction.$$$reportNull$$$0(23);
        }
        return modCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 16, 17, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/RemoveSuppressWarningAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 5: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 10: 
            case 11: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/RemoveSuppressWarningAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "perform";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromAnnotationExternal";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "removeFromValueExternal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFromCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFromComment";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "removeFromJavaDoc";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeFromElementText";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeFromAnnotation";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFromValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "removeExternal";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeFromAnnotationExternal";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "removeFromValueExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 16, 17, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

