/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.UpdateInspectionOptionFix;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.style.SimplifiableIfStatementInspection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UseCompareMethodInspection
extends AbstractBaseJavaLocalInspectionTool {
    public boolean suggestFloatingCompare = true;

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"suggestFloatingCompare", (String)JavaAnalysisBundle.message((String)"inspection.use.compare.method.option.double", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(0);
        }
        return optPane;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.getLanguageLevel((PsiElement)holder.getFile()).isAtLeast(LanguageLevel.JDK_1_4)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                UseCompareMethodInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JavaElementVisitor(){

            public void visitMethodCallExpression(@NotNull PsiMethodCallExpression call) {
                if (call == null) {
                    1.$$$reportNull$$$0(0);
                }
                CompareInfo info = UseCompareMethodInspection.fromCall(call);
                PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
                if (info != null && nameElement != null) {
                    this.register(info, nameElement);
                }
            }

            public void visitIfStatement(@NotNull PsiIfStatement statement) {
                if (statement == null) {
                    1.$$$reportNull$$$0(1);
                }
                CompareInfo info = UseCompareMethodInspection.fromIf(statement);
                PsiElement keyword = statement.getFirstChild();
                if (info != null && keyword != null) {
                    this.register(info, keyword);
                }
            }

            public void visitConditionalExpression(@NotNull PsiConditionalExpression expression) {
                CompareInfo info;
                if (expression == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((info = UseCompareMethodInspection.fromTernary(expression)) != null) {
                    this.register(info, (PsiElement)expression);
                }
            }

            private void register(CompareInfo info, PsiElement nameElement) {
                if (!UseCompareMethodInspection.this.suggestFloatingCompare && info.myMayChangeSemantics) {
                    return;
                }
                LocalQuickFix turnOffFloating = info.myMayChangeSemantics ? LocalQuickFix.from((ModCommandAction)new UpdateInspectionOptionFix((InspectionProfileEntry)UseCompareMethodInspection.this, "suggestFloatingCompare", JavaAnalysisBundle.message((String)"inspection.use.compare.method.turn.off.double", (Object[])new Object[0]), false)) : null;
                holder.registerProblem(nameElement, JavaAnalysisBundle.message((String)"inspection.expression.can.be.replaced.with.message", (Object[])new Object[]{info.myClass.getClassName() + ".compare"}), LocalQuickFix.notNullElements((LocalQuickFix[])new LocalQuickFix[]{new ReplaceWithPrimitiveCompareFix(info.getReplacementText()), turnOffFloating}));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "call";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "statement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitMethodCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIfStatement";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitConditionalExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static CompareInfo fromIf(PsiIfStatement ifStatement) {
        PsiExpression firstCondition = ifStatement.getCondition();
        if (firstCondition == null) {
            return null;
        }
        PsiIfStatement elseIfStatement = (PsiIfStatement)ObjectUtils.tryCast((Object)UseCompareMethodInspection.getElse(ifStatement), PsiIfStatement.class);
        if (elseIfStatement == null) {
            return null;
        }
        PsiExpression secondCondition = elseIfStatement.getCondition();
        if (secondCondition == null) {
            return null;
        }
        PsiStatement firstStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (firstStatement == null) {
            return null;
        }
        PsiStatement secondStatement = ControlFlowUtils.stripBraces(elseIfStatement.getThenBranch());
        if (secondStatement == null) {
            return null;
        }
        PsiStatement thirdStatement = UseCompareMethodInspection.getElse(elseIfStatement);
        if (thirdStatement == null) {
            return null;
        }
        HashMap<Integer, PsiExpression> result = new HashMap<Integer, PsiExpression>(3);
        if (firstStatement instanceof PsiReturnStatement) {
            if (!(secondStatement instanceof PsiReturnStatement) || !(thirdStatement instanceof PsiReturnStatement)) {
                return null;
            }
            PsiExpression firstValue = ((PsiReturnStatement)firstStatement).getReturnValue();
            if (!UseCompareMethodInspection.storeCondition(result, firstCondition, firstValue)) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result, secondCondition, ((PsiReturnStatement)secondStatement).getReturnValue())) {
                return null;
            }
            if (!UseCompareMethodInspection.storeCondition(result, null, ((PsiReturnStatement)thirdStatement).getReturnValue())) {
                return null;
            }
            return UseCompareMethodInspection.fromMap(result, firstValue, (PsiElement)firstStatement);
        }
        PsiAssignmentExpression assignment = ExpressionUtils.getAssignment((PsiElement)firstStatement);
        if (assignment == null) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)ObjectUtils.tryCast((Object)assignment.getLExpression(), PsiReferenceExpression.class);
        if (ref == null) {
            return null;
        }
        PsiVariable variable = (PsiVariable)ObjectUtils.tryCast((Object)ref.resolve(), PsiVariable.class);
        if (variable == null) {
            return null;
        }
        PsiExpression firstExpression = assignment.getRExpression();
        if (!UseCompareMethodInspection.storeCondition(result, firstCondition, firstExpression)) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result, secondCondition, ExpressionUtils.getAssignmentTo((PsiElement)secondStatement, variable))) {
            return null;
        }
        if (!UseCompareMethodInspection.storeCondition(result, null, ExpressionUtils.getAssignmentTo((PsiElement)thirdStatement, variable))) {
            return null;
        }
        return UseCompareMethodInspection.fromMap(result, firstExpression, (PsiElement)firstStatement);
    }

    private static PsiStatement getElse(PsiIfStatement ifStatement) {
        PsiStatement branch = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
        if (branch != null) {
            return branch;
        }
        PsiStatement thenBranch = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
        if (!(thenBranch instanceof PsiReturnStatement)) {
            return null;
        }
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)ifStatement);
        return (PsiStatement)ObjectUtils.tryCast((Object)next, PsiStatement.class);
    }

    @Nullable
    private static Map<Integer, PsiExpression> extractConditions(PsiConditionalExpression ternary) {
        HashMap<Integer, PsiExpression> result = new HashMap<Integer, PsiExpression>(3);
        if (!UseCompareMethodInspection.storeCondition(result, ternary.getCondition(), ternary.getThenExpression())) {
            return null;
        }
        PsiExpression elseExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)ternary.getElseExpression());
        if (elseExpression instanceof PsiConditionalExpression) {
            Map<Integer, PsiExpression> m = UseCompareMethodInspection.extractConditions((PsiConditionalExpression)elseExpression);
            if (m == null) {
                return null;
            }
            for (Map.Entry<Integer, PsiExpression> entry : m.entrySet()) {
                if (result.put(entry.getKey(), entry.getValue()) == null) continue;
                return null;
            }
            return result;
        }
        return UseCompareMethodInspection.storeCondition(result, null, elseExpression) ? result : null;
    }

    @Contract(value="_, _, null -> false")
    private static boolean storeCondition(@NotNull Map<Integer, PsiExpression> result, @Nullable PsiExpression condition, @Nullable PsiExpression expression) {
        if (result == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            return false;
        }
        Object thenValue = ExpressionUtils.computeConstantExpression(expression);
        if (!(thenValue instanceof Integer) || Math.abs((Integer)thenValue) > 1) {
            return false;
        }
        result.put((Integer)thenValue, condition);
        return true;
    }

    private static CompareInfo fromTernary(PsiConditionalExpression ternary) {
        if (!PsiTypes.intType().equals((Object)ternary.getType())) {
            return null;
        }
        Map<Integer, PsiExpression> map = UseCompareMethodInspection.extractConditions(ternary);
        return UseCompareMethodInspection.fromMap(map, (PsiExpression)ternary, (PsiElement)ternary);
    }

    private static CompareInfo fromMap(@Nullable Map<Integer, PsiExpression> map, @NotNull PsiExpression expression, @NotNull PsiElement template) {
        PsiClassType boxedType;
        if (expression == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(4);
        }
        if (template == null) {
            UseCompareMethodInspection.$$$reportNull$$$0(5);
        }
        if (map == null || map.size() != 3) {
            return null;
        }
        PsiExpression lt = map.get(-1);
        Pair<PsiExpression, PsiExpression> ltPair = UseCompareMethodInspection.getOperands(lt, JavaTokenType.LT);
        if (lt != null && ltPair == null) {
            return null;
        }
        PsiExpression gt = map.get(1);
        Pair<PsiExpression, PsiExpression> gtPair = UseCompareMethodInspection.getOperands(gt, JavaTokenType.GT);
        if ((gt != null || ltPair == null) && gtPair == null) {
            return null;
        }
        if (ltPair != null && gtPair != null) {
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)ltPair.getFirst()), (PsiElement)((PsiElement)gtPair.getFirst()))) {
                return null;
            }
            if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)ltPair.getSecond()), (PsiElement)((PsiElement)gtPair.getSecond()))) {
                return null;
            }
        }
        Pair<PsiExpression, PsiExpression> canonicalPair = ltPair == null ? gtPair : ltPair;
        PsiType leftType = ((PsiExpression)canonicalPair.getFirst()).getType();
        PsiType rightType = ((PsiExpression)canonicalPair.getSecond()).getType();
        if (!UseCompareMethodInspection.isTypeConvertible(leftType, (PsiElement)expression) || !leftType.equals(rightType)) {
            return null;
        }
        PsiExpression eq = map.get(0);
        Pair<PsiExpression, PsiExpression> eqPair = UseCompareMethodInspection.getOperands(eq, JavaTokenType.EQEQ);
        if (eq != null && eqPair == null) {
            return null;
        }
        if (!(eqPair == null || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getFirst()), (PsiElement)((PsiElement)eqPair.getFirst())) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getSecond()), (PsiElement)((PsiElement)eqPair.getSecond())) || PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getFirst()), (PsiElement)((PsiElement)eqPair.getSecond())) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)((PsiElement)canonicalPair.getSecond()), (PsiElement)((PsiElement)eqPair.getFirst())))) {
            return null;
        }
        PsiClassType psiClassType = boxedType = leftType instanceof PsiPrimitiveType ? ((PsiPrimitiveType)leftType).getBoxedType((PsiElement)expression) : (PsiClassType)ObjectUtils.tryCast((Object)leftType, PsiClassType.class);
        if (boxedType == null) {
            return null;
        }
        return new CompareInfo(template, expression, (PsiExpression)canonicalPair.getFirst(), (PsiExpression)canonicalPair.getSecond(), boxedType, TypeConversionUtil.isFloatOrDoubleType((PsiType)boxedType));
    }

    private static Pair<PsiExpression, PsiExpression> getOperands(PsiExpression expression, IElementType expectedToken) {
        if (!((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) instanceof PsiBinaryExpression)) {
            return null;
        }
        PsiBinaryExpression binOp = (PsiBinaryExpression)expression;
        PsiExpression left = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getLOperand());
        PsiExpression right = PsiUtil.skipParenthesizedExprDown((PsiExpression)binOp.getROperand());
        if (left == null || right == null) {
            return null;
        }
        if (binOp.getOperationTokenType().equals(expectedToken)) {
            return Pair.create((Object)left, (Object)right);
        }
        if (expectedToken.equals(JavaTokenType.GT) && binOp.getOperationTokenType().equals(JavaTokenType.LT) || expectedToken.equals(JavaTokenType.LT) && binOp.getOperationTokenType().equals(JavaTokenType.GT)) {
            return Pair.create((Object)right, (Object)left);
        }
        return null;
    }

    @Contract(value="null -> null")
    private static CompareInfo fromCall(PsiMethodCallExpression call) {
        if (call == null) {
            return null;
        }
        PsiElement nameElement = call.getMethodExpression().getReferenceNameElement();
        if (nameElement == null) {
            return null;
        }
        String name = nameElement.getText();
        if (!"compareTo".equals(name)) {
            return null;
        }
        PsiExpression[] args = call.getArgumentList().getExpressions();
        if (args.length != 1) {
            return null;
        }
        PsiExpression arg = args[0];
        PsiExpression qualifier = call.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return null;
        }
        PsiClassType boxedType = UseCompareMethodInspection.getBoxedType(call);
        if (boxedType == null) {
            return null;
        }
        PsiPrimitiveType primitiveType = PsiPrimitiveType.getUnboxedType((PsiType)boxedType);
        if (!UseCompareMethodInspection.isTypeConvertible((PsiType)primitiveType, (PsiElement)call)) {
            return null;
        }
        PsiExpression left = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, qualifier);
        if (left == null) {
            return null;
        }
        PsiExpression right = UseCompareMethodInspection.extractPrimitive(boxedType, primitiveType, arg);
        if (right == null) {
            return null;
        }
        return new CompareInfo((PsiElement)call, (PsiExpression)call, left, right, boxedType, false);
    }

    @Nullable
    static PsiClassType getBoxedType(PsiMethodCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return null;
        }
        PsiClass aClass = method.getContainingClass();
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getElementFactory((Project)call.getProject()).createType(aClass);
    }

    @Nullable
    static PsiExpression extractPrimitive(PsiClassType type, PsiPrimitiveType primitiveType, PsiExpression expression) {
        if ((expression = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression)) == null) {
            return null;
        }
        if (primitiveType.equals((Object)expression.getType())) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression;
            if (!"valueOf".equals(call.getMethodExpression().getReferenceName())) {
                return null;
            }
            PsiExpression[] args = call.getArgumentList().getExpressions();
            if (args.length != 1) {
                return null;
            }
            PsiMethod method = call.resolveMethod();
            if (method == null || type.resolve() != method.getContainingClass()) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        if (expression instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression cast = (PsiTypeCastExpression)expression;
            if (!type.equals((Object)cast.getType())) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(cast.getOperand());
        }
        if (expression instanceof PsiNewExpression) {
            PsiNewExpression newExpression = (PsiNewExpression)expression;
            if (!type.equals((Object)newExpression.getType())) {
                return null;
            }
            PsiExpressionList argumentList = newExpression.getArgumentList();
            if (argumentList == null) {
                return null;
            }
            PsiExpression[] args = argumentList.getExpressions();
            if (args.length != 1) {
                return null;
            }
            if (!(args[0].getType() instanceof PsiPrimitiveType)) {
                return null;
            }
            return UseCompareMethodInspection.checkPrimitive(args[0]);
        }
        return null;
    }

    private static PsiExpression checkPrimitive(PsiExpression expression) {
        return expression != null && expression.getType() instanceof PsiPrimitiveType ? expression : null;
    }

    @Contract(value="null, _ -> false")
    private static boolean isTypeConvertible(PsiType type, PsiElement context) {
        return (type = PsiPrimitiveType.getOptionallyUnboxedType((PsiType)type)) != null && (PsiTypes.doubleType().equals((Object)type) || PsiTypes.floatType().equals((Object)type) || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/UseCompareMethodInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "storeCondition";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }

    static class CompareInfo {
        @NotNull
        final PsiElement myTemplate;
        @NotNull
        final PsiExpression myToReplace;
        @NotNull
        final PsiExpression myLeft;
        @NotNull
        final PsiExpression myRight;
        @NotNull
        final PsiClassType myClass;
        final boolean myMayChangeSemantics;

        CompareInfo(@NotNull PsiElement template, @NotNull PsiExpression toReplace, @NotNull PsiExpression left, @NotNull PsiExpression right, @NotNull PsiClassType aClass, boolean mayChangeSemantics) {
            if (template == null) {
                CompareInfo.$$$reportNull$$$0(0);
            }
            if (toReplace == null) {
                CompareInfo.$$$reportNull$$$0(1);
            }
            if (left == null) {
                CompareInfo.$$$reportNull$$$0(2);
            }
            if (right == null) {
                CompareInfo.$$$reportNull$$$0(3);
            }
            if (aClass == null) {
                CompareInfo.$$$reportNull$$$0(4);
            }
            this.myTemplate = template;
            this.myToReplace = toReplace;
            this.myLeft = left;
            this.myRight = right;
            this.myClass = aClass;
            this.myMayChangeSemantics = mayChangeSemantics;
        }

        @NotNull
        private PsiElement replace(PsiElement toReplace, CommentTracker ct) {
            String replacement = this.myLeft.getType() instanceof PsiClassType ? ct.text(this.myLeft, 1) + ".compareTo(" + ct.text((PsiElement)this.myRight) + ")" : this.myClass.getCanonicalText() + ".compare(" + ct.text((PsiElement)this.myLeft) + "," + ct.text((PsiElement)this.myRight) + ")";
            if (toReplace == this.myTemplate) {
                PsiElement psiElement = ct.replaceAndRestoreComments((PsiElement)this.myToReplace, replacement);
                if (psiElement == null) {
                    CompareInfo.$$$reportNull$$$0(5);
                }
                return psiElement;
            }
            ct.replace((PsiElement)this.myToReplace, replacement);
            PsiElement psiElement = ct.replaceAndRestoreComments(toReplace, this.myTemplate);
            if (psiElement == null) {
                CompareInfo.$$$reportNull$$$0(6);
            }
            return psiElement;
        }

        public String getReplacementText() {
            String methodName = this.myLeft.getType() instanceof PsiClassType ? "compareTo" : "compare";
            return this.myClass.getName() + "." + methodName + "()";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toReplace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "left";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "right";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection$CompareInfo";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class ReplaceWithPrimitiveCompareFix
    extends PsiUpdateModCommandQuickFix {
        private final String myReplacementText;

        ReplaceWithPrimitiveCompareFix(String replacementText) {
            this.myReplacementText = replacementText;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myReplacementText});
            if (string == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            String string = JavaAnalysisBundle.message((String)"inspection.use.compare.method.fix.family.name", (Object[])new Object[0]);
            if (string == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            CompareInfo info;
            PsiElement toReplace;
            if (project == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(2);
            }
            if (element == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(3);
            }
            if (updater == null) {
                ReplaceWithPrimitiveCompareFix.$$$reportNull$$$0(4);
            }
            ArrayList<PsiStatement> toDelete = new ArrayList<PsiStatement>();
            if (element instanceof PsiConditionalExpression) {
                toReplace = element;
                info = UseCompareMethodInspection.fromTernary((PsiConditionalExpression)element);
            } else {
                PsiElement parent = element.getParent();
                if (parent instanceof PsiIfStatement) {
                    toReplace = parent;
                    info = UseCompareMethodInspection.fromIf((PsiIfStatement)parent);
                    PsiStatement elseIf = UseCompareMethodInspection.getElse((PsiIfStatement)parent);
                    toDelete.add(elseIf);
                    if (elseIf instanceof PsiIfStatement) {
                        toDelete.add(UseCompareMethodInspection.getElse((PsiIfStatement)elseIf));
                    }
                } else {
                    PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
                    info = UseCompareMethodInspection.fromCall(call);
                    toReplace = call;
                }
            }
            if (info == null) {
                return;
            }
            CommentTracker ct = new CommentTracker();
            PsiElement result = info.replace(toReplace, ct);
            ((StreamEx)StreamEx.of(toDelete).nonNull().filter(PsiElement::isValid)).forEach(e -> new CommentTracker().deleteAndRestoreComments((PsiElement)e));
            SimplifiableIfStatementInspection.tryJoinDeclaration(result);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updater";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/UseCompareMethodInspection$ReplaceWithPrimitiveCompareFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }
}

