/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.Conf;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

final class AbstractValues {
    static final BasicValue InstanceOfCheckValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue TrueValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue FalseValue = new BasicValue(Type.INT_TYPE){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue NullValue = new BasicValue(Type.getObjectType((String)"null")){

        public boolean equals(Object value) {
            return this == value;
        }
    };
    static final BasicValue CLASS_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/Class"));
    static final BasicValue METHOD_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/invoke/MethodType"));
    static final BasicValue STRING_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/String"));
    static final BasicValue METHOD_HANDLE_VALUE = new NotNullValue(Type.getObjectType((String)"java/lang/invoke/MethodHandle"));

    AbstractValues() {
    }

    static boolean isInstance(Conf curr, Conf prev) {
        int i;
        if (curr.insnIndex != prev.insnIndex) {
            return false;
        }
        Frame<BasicValue> currFr = curr.frame;
        Frame<BasicValue> prevFr = prev.frame;
        for (i = 0; i < currFr.getLocals(); ++i) {
            if (AbstractValues.isInstance((BasicValue)currFr.getLocal(i), (BasicValue)prevFr.getLocal(i))) continue;
            return false;
        }
        for (i = 0; i < currFr.getStackSize(); ++i) {
            if (AbstractValues.isInstance((BasicValue)currFr.getStack(i), (BasicValue)prevFr.getStack(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean isInstance(BasicValue curr, BasicValue prev) {
        if (prev instanceof ParamValue) {
            return curr instanceof ParamValue;
        }
        if (InstanceOfCheckValue == prev) {
            if (InstanceOfCheckValue != curr) return false;
            return true;
        }
        if (TrueValue == prev) {
            if (TrueValue != curr) return false;
            return true;
        }
        if (FalseValue == prev) {
            if (FalseValue != curr) return false;
            return true;
        }
        if (NullValue == prev) {
            if (NullValue != curr) return false;
            return true;
        }
        if (prev instanceof NotNullValue) {
            return curr instanceof NotNullValue;
        }
        if (!(prev instanceof CallResultValue)) return true;
        CallResultValue prevCall = (CallResultValue)prev;
        if (!(curr instanceof CallResultValue)) return false;
        CallResultValue currCall = (CallResultValue)curr;
        if (prevCall.inters.size() != currCall.inters.size()) return false;
        if (!prevCall.inters.containsAll(currCall.inters)) return false;
        return true;
    }

    static boolean equiv(BasicValue curr, BasicValue prev) {
        if (curr == prev) {
            return true;
        }
        if (curr.getClass() == prev.getClass()) {
            if (curr instanceof CallResultValue) {
                CallResultValue currRes = (CallResultValue)curr;
                if (prev instanceof CallResultValue) {
                    CallResultValue prevRes = (CallResultValue)prev;
                    List<EKey> keys1 = prevRes.inters;
                    List<EKey> keys2 = currRes.inters;
                    return keys1.size() == keys2.size() && keys1.containsAll(keys2);
                }
            }
            return true;
        }
        return false;
    }

    static final class ParamValue
    extends BasicValue {
        ParamValue(Type tp) {
            super(tp);
        }
    }

    static final class NotNullValue
    extends BasicValue {
        NotNullValue(Type tp) {
            super(tp);
        }
    }

    static final class CallResultValue
    extends BasicValue {
        final List<EKey> inters;

        CallResultValue(Type tp, List<EKey> inters) {
            super(tp);
            this.inters = inters;
        }
    }

    static final class NthParamValue
    extends BasicValue {
        final int n;

        NthParamValue(Type type, int n) {
            super(type);
            this.n = n;
        }
    }
}

