/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisGist;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisIndex;
import com.intellij.codeInspection.bytecodeAnalysis.BytecodeAnalysisSuppressor;
import com.intellij.codeInspection.bytecodeAnalysis.CombinedAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.DataValue;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.DirectionResultPair;
import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.EffectQuantum;
import com.intellij.codeInspection.bytecodeAnalysis.Effects;
import com.intellij.codeInspection.bytecodeAnalysis.Equation;
import com.intellij.codeInspection.bytecodeAnalysis.Equations;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.FieldAccess;
import com.intellij.codeInspection.bytecodeAnalysis.HMember;
import com.intellij.codeInspection.bytecodeAnalysis.HardCodedPurity;
import com.intellij.codeInspection.bytecodeAnalysis.InOutAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.InThrowAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.KeyedMethodVisitor;
import com.intellij.codeInspection.bytecodeAnalysis.Member;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NegationAnalysisFailedException;
import com.intellij.codeInspection.bytecodeAnalysis.NonNullInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableInAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.NullableMethodAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PResults;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.PendingAction;
import com.intellij.codeInspection.bytecodeAnalysis.ProjectBytecodeAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PurityAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.PuritySolver;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.TooComplexException;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ControlFlowGraph;
import com.intellij.codeInspection.bytecodeAnalysis.asm.DFSTree;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParameters;
import com.intellij.codeInspection.bytecodeAnalysis.asm.OriginsAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringHash;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.util.CachedValueImpl;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.gist.VirtualFileGist;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;

public final class ClassDataIndexer
implements VirtualFileGist.GistCalculator<Map<HMember, Equations>> {
    static final String STRING_CONCAT_FACTORY = "java/lang/invoke/StringConcatFactory";
    public static final Consumer<Map<HMember, Equations>> ourIndexSizeStatistics = ApplicationManager.getApplication().isUnitTestMode() ? new ClassDataIndexerStatistics() : map -> {};
    static final BinaryOperator<Equations> MERGER = (eq1, eq2) -> eq1.equals(eq2) ? eq1 : new Equations(Collections.emptyList(), false);
    private static final int VERSION = 19;
    private static final int VERSION_MODIFIER = HardCodedPurity.AGGRESSIVE_HARDCODED_PURITY ? 1 : 0;
    static final int FINAL_VERSION = 38 + VERSION_MODIFIER + StringHash.murmur((CharSequence)BytecodeAnalysisSuppressor.EP_NAME.getExtensionList().stream().map(ep -> String.valueOf(ep.getVersion())).collect(Collectors.joining("-")), (int)31);
    private static final Pattern ANDROID_JAR_PATH = Pattern.compile("(platforms/android-.+/android.jar!/|com/google/android/android/[\\d.]+/android-[\\d.]+.jar!/android)");
    private static final Key<CachedValue<Map<HMember, Equations>>> EQUATIONS = Key.create((String)"com.intellij.codeInspection.bytecodeAnalysis.ClassDataIndexer.Equations");

    @Nullable
    public Map<HMember, Equations> calcData(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            ClassDataIndexer.$$$reportNull$$$0(0);
        }
        HashMap<HMember, Equations> map = new HashMap<HMember, Equations>();
        if (ClassDataIndexer.isFileExcluded(file)) {
            return map;
        }
        try {
            ClassReader reader = new ClassReader(file.contentsToByteArray(false));
            Map<EKey, Equations> allEquations = ClassDataIndexer.processClass(reader, file.getPresentableUrl());
            ClassDataIndexer.solvePartially(reader.getClassName(), allEquations);
            allEquations.forEach((methodKey, equations) -> map.merge(methodKey.member.hashed(), ClassDataIndexer.hash(equations), MERGER));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during indexing of bytecode", e);
        }
        ourIndexSizeStatistics.accept(map);
        return map;
    }

    static boolean isFileExcluded(VirtualFile file) {
        String path = file.getPath();
        return ClassDataIndexer.isInsideDummyAndroidJar(path) || path.endsWith("!/play/db/jpa/GenericModel.class") || ContainerUtil.exists((Iterable)BytecodeAnalysisSuppressor.EP_NAME.getExtensionList(), ep -> ep.shouldSuppress(file));
    }

    private static boolean isInsideDummyAndroidJar(String path) {
        return path.contains("android") && ANDROID_JAR_PATH.matcher(path).find();
    }

    @Contract(mutates="param2")
    private static void solvePartially(String className, Map<EKey, Equations> map) {
        PuritySolver solver = new PuritySolver();
        for (Map.Entry<EKey, Equations> entry : map.entrySet()) {
            EKey key2 = entry.getKey();
            Equations equations = entry.getValue();
            for (DirectionResultPair drp : equations.results) {
                Result result = drp.result;
                if (!(result instanceof Effects)) continue;
                Effects effects = (Effects)result;
                key2 = new EKey(key2.member, Direction.fromInt(drp.directionKey), equations.stable, false);
                solver.addEquation(key2, effects);
            }
        }
        solver.addPlainFieldEquations(md -> {
            if (!(md instanceof Member)) return false;
            Member member = (Member)md;
            if (!member.internalClassName.equals(className)) return false;
            return true;
        });
        solver.solve();
        map.replaceAll((key, eqs) -> ClassDataIndexer.updatePurity(key, eqs, solver));
    }

    @NotNull
    private static Equations updatePurity(EKey key, Equations eqs, PuritySolver solver) {
        for (int i = 0; i < eqs.results.size(); ++i) {
            ArrayList<DirectionResultPair> newPairs;
            DirectionResultPair drp = eqs.results.get(i);
            if (drp.directionKey != Direction.Pure.asInt() && drp.directionKey != Direction.Volatile.asInt()) continue;
            EKey newKey = new EKey(key.member, Direction.fromInt(drp.directionKey), eqs.stable, false);
            Effects effects = solver.pending.get(newKey);
            if (effects == null || effects.isTop()) {
                effects = solver.solved.get(newKey);
            }
            if (effects == drp.result) {
                Equations equations = eqs;
                if (equations == null) {
                    ClassDataIndexer.$$$reportNull$$$0(1);
                }
                return equations;
            }
            if (effects == null || effects.isTop()) {
                newPairs = new ArrayList(eqs.results.size() - 1);
                newPairs.addAll(eqs.results.subList(0, i));
                newPairs.addAll(eqs.results.subList(i + 1, eqs.results.size()));
            } else {
                newPairs = new ArrayList<DirectionResultPair>(eqs.results);
                newPairs.set(i, new DirectionResultPair(Direction.Pure.asInt(), effects));
            }
            return new Equations(newPairs, eqs.stable);
        }
        Equations equations = eqs;
        if (equations == null) {
            ClassDataIndexer.$$$reportNull$$$0(2);
        }
        return equations;
    }

    private static Equations hash(Equations equations) {
        return new Equations(ContainerUtil.map(equations.results, ClassDataIndexer::hash), equations.stable);
    }

    private static DirectionResultPair hash(DirectionResultPair drp) {
        return new DirectionResultPair(drp.directionKey, ClassDataIndexer.hash(drp.result));
    }

    private static Result hash(Result result) {
        if (result instanceof Effects) {
            Effects effects = (Effects)result;
            return new Effects(effects.returnValue, StreamEx.of(effects.effects).map(ClassDataIndexer::hash).toSet());
        }
        if (result instanceof Pending) {
            return new Pending(ContainerUtil.map((Object[])((Pending)result).delta, ClassDataIndexer::hash));
        }
        return result;
    }

    private static Component hash(Component component) {
        EKey[] ids = component.ids;
        EKey[] hashedKeys = new EKey[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            hashedKeys[i] = ids[i].hashed();
        }
        return new Component(component.value, hashedKeys);
    }

    private static EffectQuantum hash(EffectQuantum effect) {
        if (effect instanceof EffectQuantum.CallQuantum) {
            EffectQuantum.CallQuantum call = (EffectQuantum.CallQuantum)effect;
            return new EffectQuantum.CallQuantum(call.key.hashed(), call.data, call.isStatic);
        }
        return effect;
    }

    @NotNull
    private static Equations convertEquations(EKey methodKey, List<Equation> rawMethodEquations) {
        List compressedMethodEquations = ContainerUtil.map(rawMethodEquations, equation -> new DirectionResultPair(equation.key.dirKey, equation.result));
        return new Equations(compressedMethodEquations, methodKey.stable);
    }

    static Map<EKey, Equations> processClass(ClassReader classReader, String presentableUrl) {
        ExpandableArray<State> sharedPendingStates = new ExpandableArray<State>();
        ExpandableArray<PendingAction> sharedPendingActions = new ExpandableArray<PendingAction>();
        ExpandableArray<PResults.PResult> sharedResults = new ExpandableArray<PResults.PResult>();
        HashMap<EKey, Equations> equations = new HashMap<EKey, Equations>();
        FieldData data = FieldData.read(classReader);
        data.registerVolatileFields(equations);
        Set<Member> staticFinalFields = data.staticFinalFields();
        if ((classReader.getAccess() & 0x4000) != 0) {
            EKey ordinalKey = new EKey(new Member(classReader.getClassName(), "ordinal", "()I"), Direction.Out, true);
            equations.put(ordinalKey, new Equations(Collections.singletonList(new DirectionResultPair(Direction.Pure.asInt(), new Effects(DataValue.LocalDataValue, Collections.emptySet()))), true));
        }
        classReader.accept((ClassVisitor)new MethodAnalysisVisitor(equations, presentableUrl, sharedPendingStates, sharedPendingActions, sharedResults, staticFinalFields), 6);
        return equations;
    }

    @NotNull
    static @Unmodifiable List<Equations> getEquations(GlobalSearchScope scope, HMember key) {
        List list = ContainerUtil.mapNotNull((Collection)FileBasedIndex.getInstance().getContainingFiles(BytecodeAnalysisIndex.NAME, (Object)key, scope), file -> {
            CachedValue equations = (CachedValue)ConcurrencyUtil.computeIfAbsent((UserDataHolder)file, EQUATIONS, () -> new CachedValueImpl(() -> CachedValueProvider.Result.create((Object)((Map)BytecodeAnalysisGist.getInstance().getGist().getFileData(null, file)), (Object[])new Object[]{file})));
            return (Equations)((Map)equations.getValue()).get(key);
        });
        if (list == null) {
            ClassDataIndexer.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePurity";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEquations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcData";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }

    private record FieldData(Set<Member> staticFinalFields, Set<Member> volatileFields) {
        @NotNull
        static FieldData read(final @NotNull ClassReader classReader) {
            if (classReader == null) {
                FieldData.$$$reportNull$$$0(0);
            }
            final HashSet<Member> staticFields = new HashSet<Member>();
            final HashSet<Member> volatileFields = new HashSet<Member>();
            classReader.accept(new ClassVisitor(589824){

                public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                    int modifiers = 24;
                    if ((access & modifiers) == modifiers && (access & 0x5000) == 0 && (desc.startsWith("L") || desc.startsWith("["))) {
                        staticFields.add(new Member(classReader.getClassName(), name, desc));
                    }
                    if ((access & 0x40) != 0) {
                        volatileFields.add(new Member(classReader.getClassName(), name, desc));
                    }
                    return null;
                }
            }, 7);
            return new FieldData(staticFields, volatileFields);
        }

        void registerVolatileFields(Map<EKey, Equations> equations) {
            for (Member field : this.volatileFields) {
                EKey fieldKey = new EKey(field, Direction.Out, true);
                equations.put(fieldKey, new Equations(Collections.singletonList(new DirectionResultPair(Direction.Volatile.asInt(), Effects.VOLATILE_EFFECTS)), true));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReader", "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$FieldData", "read"));
        }
    }

    private static final class MethodAnalysisVisitor
    extends KeyedMethodVisitor {
        private final Map<EKey, Equations> myEquations;
        private final String myPresentableUrl;
        private final ExpandableArray<State> mySharedPendingStates;
        private final ExpandableArray<PendingAction> mySharedPendingActions;
        private final ExpandableArray<PResults.PResult> mySharedResults;
        private final Set<Member> myStaticFinalFields;

        private MethodAnalysisVisitor(Map<EKey, Equations> equations, String presentableUrl, ExpandableArray<State> sharedPendingStates, ExpandableArray<PendingAction> sharedPendingActions, ExpandableArray<PResults.PResult> sharedResults, Set<Member> staticFinalFields) {
            this.myEquations = equations;
            this.myPresentableUrl = presentableUrl;
            this.mySharedPendingStates = sharedPendingStates;
            this.mySharedPendingActions = sharedPendingActions;
            this.mySharedResults = sharedResults;
            this.myStaticFinalFields = staticFinalFields;
        }

        @Override
        protected MethodVisitor visitMethod(final MethodNode node, final Member method, final EKey key) {
            return new MethodVisitor(589824, (MethodVisitor)node){
                private boolean jsr;
                private boolean skip;

                public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
                    if (descriptor.equals("Lio/quarkus/panache/common/impl/GenerateBridge;")) {
                        this.skip = true;
                    }
                    return super.visitAnnotation(descriptor, visible);
                }

                public void visitJumpInsn(int opcode, Label label) {
                    if (opcode == 168) {
                        this.jsr = true;
                    }
                    super.visitJumpInsn(opcode, label);
                }

                public void visitEnd() {
                    super.visitEnd();
                    if (!this.skip) {
                        myEquations.put(key, ClassDataIndexer.convertEquations(key, this.processMethod(node, this.jsr, method, key.stable)));
                    }
                }
            };
        }

        private List<Equation> processMethod(MethodNode methodNode, boolean jsr, Member method, boolean stable) {
            ProgressManager.checkCanceled();
            Type[] argumentTypes = Type.getArgumentTypes((String)methodNode.desc);
            Type resultType = Type.getReturnType((String)methodNode.desc);
            boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
            boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
            boolean isInterestingResult = isReferenceResult || isBooleanResult;
            ArrayList<Equation> equations = new ArrayList<Equation>();
            ContainerUtil.addIfNotNull(equations, (Object)PurityAnalysis.analyze(method, methodNode, stable, jsr));
            try {
                ControlFlowGraph graph = ControlFlowGraph.build(this.className, methodNode, jsr);
                if (graph.transitions.length > 0) {
                    boolean branching;
                    DFSTree dfs = DFSTree.build(graph.transitions, graph.edgeCount);
                    boolean bl = branching = !dfs.isBackEmpty();
                    if (!branching) {
                        for (int[] transition : graph.transitions) {
                            if (transition == null || transition.length <= 1) continue;
                            branching = true;
                            break;
                        }
                    }
                    if (branching) {
                        RichControlFlow richControlFlow = new RichControlFlow(graph, dfs);
                        if (richControlFlow.reducible()) {
                            NegationAnalysis negated = MethodAnalysisVisitor.tryNegation(method, argumentTypes, graph, isBooleanResult, dfs, jsr);
                            this.processBranchingMethod(method, methodNode, richControlFlow, argumentTypes, resultType, stable, jsr, equations, negated);
                            return equations;
                        }
                        ProjectBytecodeAnalysis.LOG.debug(String.valueOf(method) + ": CFG is not reducible");
                    } else {
                        this.processNonBranchingMethod(method, argumentTypes, graph, resultType, stable, equations);
                        return equations;
                    }
                }
                equations.addAll(MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable));
                return equations;
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (TooComplexException e) {
                ProjectBytecodeAnalysis.LOG.debug(String.valueOf(method) + " in " + this.myPresentableUrl + " is too complex for bytecode analysis");
                return MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable);
            }
            catch (Throwable e) {
                ProjectBytecodeAnalysis.LOG.debug("Unexpected Error during processing of " + String.valueOf(method) + " in " + this.myPresentableUrl, e);
                return MethodAnalysisVisitor.topEquations(method, argumentTypes, isReferenceResult, isInterestingResult, stable);
            }
        }

        private static NegationAnalysis tryNegation(final Member method, final Type[] argumentTypes, final ControlFlowGraph graph, boolean isBooleanResult, DFSTree dfs, final boolean jsr) throws AnalyzerException {
            Util util;
            class Util {
                Util() {
                }

                boolean isMethodCall(int opCode) {
                    return opCode == 184 || opCode == 183 || opCode == 182 || opCode == 185;
                }

                boolean singleIfBranch() {
                    int branch = 0;
                    for (int i = 0; i < graph.transitions.length; ++i) {
                        int[] transition = graph.transitions[i];
                        if (transition.length == 2) {
                            boolean isIfInsn;
                            ++branch;
                            int opCode = graph.methodNode.instructions.get(i).getOpcode();
                            boolean bl = isIfInsn = opCode == 153 || opCode == 154;
                            if (!isIfInsn) {
                                return false;
                            }
                        }
                        if (branch <= 1) continue;
                        return false;
                    }
                    return branch == 1;
                }

                boolean singleMethodCall() {
                    int callCount = 0;
                    for (int i = 0; i < graph.transitions.length; ++i) {
                        if (!this.isMethodCall(graph.methodNode.instructions.get(i).getOpcode()) || ++callCount <= 1) continue;
                        return false;
                    }
                    return callCount == 1;
                }

                public boolean booleanConstResult() {
                    try {
                        boolean[] origins = OriginsAnalysis.resultOrigins(MethodAnalysisVisitor.leakingParametersAndFrames((Member)method, (MethodNode)graph.methodNode, (Type[])argumentTypes, (boolean)jsr).frames, graph.methodNode.instructions, graph);
                        for (int i = 0; i < origins.length; ++i) {
                            boolean isBooleanConst;
                            if (!origins[i]) continue;
                            int opCode = graph.methodNode.instructions.get(i).getOpcode();
                            boolean bl = isBooleanConst = opCode == 3 || opCode == 4;
                            if (isBooleanConst) continue;
                            return false;
                        }
                        return true;
                    }
                    catch (AnalyzerException analyzerException) {
                        return false;
                    }
                }
            }
            if (graph.methodNode.instructions.size() < 20 && isBooleanResult && dfs.isBackEmpty() && !jsr && (util = new Util()).singleIfBranch() && util.singleMethodCall() && util.booleanConstResult()) {
                NegationAnalysis analyzer = new NegationAnalysis(method, graph);
                try {
                    analyzer.analyze();
                    return analyzer;
                }
                catch (NegationAnalysisFailedException ignore) {
                    return null;
                }
            }
            return null;
        }

        private void processBranchingMethod(Member method, MethodNode methodNode, RichControlFlow richControlFlow, Type[] argumentTypes, Type resultType, boolean stable, boolean jsr, List<? super Equation> result, NegationAnalysis negatedAnalysis) throws AnalyzerException {
            boolean withCycle;
            Equation throwEquation;
            boolean shouldInferNonTrivialFailingContracts;
            Equation outEquation;
            boolean isReferenceResult = ASMUtils.isReferenceType(resultType);
            boolean isBooleanResult = ASMUtils.isBooleanType(resultType);
            boolean isInterestingResult = isBooleanResult || isReferenceResult;
            LeakingParameters leakingParametersAndFrames = MethodAnalysisVisitor.leakingParametersAndFrames(method, methodNode, argumentTypes, jsr);
            boolean[] leakingParameters = leakingParametersAndFrames.parameters;
            boolean[] leakingNullableParameters = leakingParametersAndFrames.nullableParameters;
            boolean[] origins = OriginsAnalysis.resultOrigins(leakingParametersAndFrames.frames, methodNode.instructions, richControlFlow.controlFlow);
            Equation equation = outEquation = isInterestingResult ? new InOutAnalysis(richControlFlow, Direction.Out, origins, stable, this.mySharedPendingStates).analyze() : null;
            if (isReferenceResult) {
                result.add(outEquation);
                result.add(new Equation(new EKey(method, Direction.NullableOut, stable), NullableMethodAnalysis.analyze(methodNode, origins, jsr)));
            }
            if (methodNode.name.equals("<init>") || methodNode.instructions.size() > 64) {
                shouldInferNonTrivialFailingContracts = false;
                throwEquation = new Equation(new EKey(method, Direction.Throw, stable), Value.Top);
            } else {
                InThrowAnalysis inThrowAnalysis = new InThrowAnalysis(richControlFlow, Direction.Throw, origins, stable, this.mySharedPendingStates);
                throwEquation = inThrowAnalysis.analyze();
                if (!throwEquation.result.equals(Value.Top)) {
                    result.add(throwEquation);
                }
                shouldInferNonTrivialFailingContracts = !inThrowAnalysis.myHasNonTrivialReturn && richControlFlow.controlFlow.errorTransitions.isEmpty();
            }
            boolean bl = withCycle = !richControlFlow.dfsTree.isBackEmpty();
            if (argumentTypes.length > 50 && withCycle) {
                return;
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                boolean notNullParam = false;
                if (ASMUtils.isReferenceType(argumentTypes[i])) {
                    boolean possibleNPE = false;
                    if (leakingParameters[i]) {
                        NonNullInAnalysis notNullInAnalysis = new NonNullInAnalysis(richControlFlow, new Direction.In(i, false), stable, this.mySharedPendingActions, this.mySharedResults);
                        Equation notNullParamEquation = notNullInAnalysis.analyze();
                        possibleNPE = notNullInAnalysis.possibleNPE;
                        notNullParam = notNullParamEquation.result.equals(Value.NotNull);
                        result.add(notNullParamEquation);
                    } else {
                        result.add(new Equation(new EKey(method, new Direction.In(i, false), stable), Value.Top));
                    }
                    if (leakingNullableParameters[i]) {
                        if (notNullParam || possibleNPE) {
                            result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Top));
                        } else {
                            result.add(new NullableInAnalysis(richControlFlow, new Direction.In(i, true), stable, this.mySharedPendingStates).analyze());
                        }
                    } else {
                        result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Null));
                    }
                    if (isInterestingResult) {
                        if (!leakingParameters[i]) {
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), outEquation.result));
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.result));
                            continue;
                        }
                        if (notNullParam) {
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), Value.Bot));
                            result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), outEquation.result));
                            continue;
                        }
                    }
                }
                for (Value val : Value.typeValues(argumentTypes[i])) {
                    if (isBooleanResult && negatedAnalysis != null) {
                        result.add(negatedAnalysis.contractEquation(i, val, stable));
                        continue;
                    }
                    try {
                        if (isInterestingResult) {
                            result.add(new InOutAnalysis(richControlFlow, new Direction.InOut(i, val), origins, stable, this.mySharedPendingStates).analyze());
                        }
                        if (!shouldInferNonTrivialFailingContracts) continue;
                        Direction.InThrow direction = new Direction.InThrow(i, val);
                        Equation failEquation = throwEquation.result.equals(Value.Fail) ? new Equation(new EKey(method, direction, stable), Value.Fail) : new InThrowAnalysis(richControlFlow, direction, origins, stable, this.mySharedPendingStates).analyze();
                        result.add(failEquation);
                    }
                    catch (AnalyzerException e) {
                        throw new RuntimeException("Analyzer error", e);
                    }
                }
            }
        }

        private void processNonBranchingMethod(Member method, Type[] argumentTypes, ControlFlowGraph graph, Type returnType, boolean stable, List<? super Equation> result) throws AnalyzerException {
            Set<Member> fieldsToTrack;
            Set<Member> set = fieldsToTrack = method.methodName.equals("<clinit>") ? this.myStaticFinalFields : Collections.emptySet();
            if (argumentTypes.length == 0 && !Type.VOID_TYPE.equals((Object)returnType)) {
                ContainerUtil.addIfNotNull(result, (Object)this.getterEquation(method, graph, stable));
            }
            if (argumentTypes.length == 1 && Type.VOID_TYPE.equals((Object)returnType)) {
                ContainerUtil.addIfNotNull(result, (Object)this.setterEquation(method, graph, stable));
            }
            CombinedAnalysis analyzer = new CombinedAnalysis(method, graph, fieldsToTrack);
            analyzer.analyze();
            ContainerUtil.addIfNotNull(result, (Object)analyzer.outContractEquation(stable));
            ContainerUtil.addIfNotNull(result, (Object)analyzer.failEquation(stable));
            this.storeStaticFieldEquations(analyzer);
            if (ASMUtils.isReferenceType(returnType)) {
                result.add(analyzer.nullableResultEquation(stable));
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                Type argType = argumentTypes[i];
                if (ASMUtils.isReferenceType(argType)) {
                    result.add(analyzer.notNullParamEquation(i, stable));
                    result.add(analyzer.nullableParamEquation(i, stable));
                    for (Value val : Value.OBJECT) {
                        ContainerUtil.addIfNotNull(result, (Object)analyzer.contractEquation(i, val, stable));
                        ContainerUtil.addIfNotNull(result, (Object)analyzer.failEquation(i, val, stable));
                    }
                    continue;
                }
                if (!ASMUtils.isBooleanType(argType)) continue;
                for (Value val : Value.BOOLEAN) {
                    ContainerUtil.addIfNotNull(result, (Object)analyzer.contractEquation(i, val, stable));
                    ContainerUtil.addIfNotNull(result, (Object)analyzer.failEquation(i, val, stable));
                }
            }
        }

        @Nullable
        private Equation setterEquation(@NotNull Member method, @NotNull ControlFlowGraph controlFlow, boolean stable) {
            FieldInsnNode fieldAccess;
            VarInsnNode varAccess;
            AbstractInsnNode abstractInsnNode;
            int shift;
            if (method == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(0);
            }
            if (controlFlow == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(1);
            }
            MethodNode node = controlFlow.methodNode;
            boolean isStatic = (node.access & 8) != 0;
            InsnList instructions = node.instructions;
            int size = instructions.size();
            int n = shift = isStatic ? 0 : 1;
            if (size != 3 + shift) {
                return null;
            }
            if (instructions.get(2 + shift).getOpcode() != 177) {
                return null;
            }
            if (!(isStatic || (abstractInsnNode = instructions.get(0)) instanceof VarInsnNode && (varAccess = (VarInsnNode)abstractInsnNode).getOpcode() == 25 && varAccess.var == 0)) {
                return null;
            }
            abstractInsnNode = instructions.get(shift);
            if (!(abstractInsnNode instanceof VarInsnNode)) {
                return null;
            }
            VarInsnNode argLoad = (VarInsnNode)abstractInsnNode;
            if (argLoad.var != shift) {
                return null;
            }
            int loadOpcode = argLoad.getOpcode();
            if (loadOpcode < 21 || loadOpcode > 25) {
                return null;
            }
            AbstractInsnNode abstractInsnNode2 = instructions.get(1 + shift);
            if (!(abstractInsnNode2 instanceof FieldInsnNode) || (fieldAccess = (FieldInsnNode)abstractInsnNode2).getOpcode() != (isStatic ? 179 : 181) || !fieldAccess.owner.equals(this.className)) {
                return null;
            }
            String name = fieldAccess.name;
            return new Equation(new EKey(method, new Direction.In(0, true), stable), new FieldAccess(name));
        }

        @Nullable
        private Equation getterEquation(@NotNull Member method, @NotNull ControlFlowGraph controlFlow, boolean stable) {
            FieldInsnNode fieldAccess;
            VarInsnNode varAccess;
            AbstractInsnNode abstractInsnNode;
            int shift;
            if (method == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(2);
            }
            if (controlFlow == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(3);
            }
            MethodNode node = controlFlow.methodNode;
            boolean isStatic = (node.access & 8) != 0;
            InsnList instructions = node.instructions;
            int size = instructions.size();
            int n = shift = isStatic ? 0 : 1;
            if (size != 2 + shift) {
                return null;
            }
            int returnOpcode = instructions.get(1 + shift).getOpcode();
            if (returnOpcode < 172 || returnOpcode > 176) {
                return null;
            }
            if (!(isStatic || (abstractInsnNode = instructions.get(0)) instanceof VarInsnNode && (varAccess = (VarInsnNode)abstractInsnNode).getOpcode() == 25 && varAccess.var == 0)) {
                return null;
            }
            abstractInsnNode = instructions.get(shift);
            if (!(abstractInsnNode instanceof FieldInsnNode) || (fieldAccess = (FieldInsnNode)abstractInsnNode).getOpcode() != (isStatic ? 178 : 180) || !fieldAccess.owner.equals(this.className)) {
                return null;
            }
            String name = fieldAccess.name;
            return new Equation(new EKey(method, Direction.Out, stable), new FieldAccess(name));
        }

        private void storeStaticFieldEquations(CombinedAnalysis analyzer) {
            for (Equation equation : analyzer.staticFieldEquations()) {
                this.myEquations.put(equation.key, new Equations(Collections.singletonList(new DirectionResultPair(equation.key.dirKey, equation.result)), true));
            }
        }

        private static List<Equation> topEquations(Member method, Type[] argumentTypes, boolean isReferenceResult, boolean isInterestingResult, boolean stable) {
            ArrayList<Equation> result = new ArrayList<Equation>(argumentTypes.length * 4 + 2);
            if (isReferenceResult) {
                result.add(new Equation(new EKey(method, Direction.Out, stable), Value.Top));
                result.add(new Equation(new EKey(method, Direction.NullableOut, stable), Value.Bot));
            }
            for (int i = 0; i < argumentTypes.length; ++i) {
                if (!ASMUtils.isReferenceType(argumentTypes[i])) continue;
                result.add(new Equation(new EKey(method, new Direction.In(i, false), stable), Value.Top));
                result.add(new Equation(new EKey(method, new Direction.In(i, true), stable), Value.Top));
                if (!isInterestingResult) continue;
                result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.Null), stable), Value.Top));
                result.add(new Equation(new EKey(method, new Direction.InOut(i, Value.NotNull), stable), Value.Top));
            }
            return result;
        }

        @NotNull
        private static LeakingParameters leakingParametersAndFrames(Member method, MethodNode methodNode, Type[] argumentTypes, boolean jsr) throws AnalyzerException {
            LeakingParameters leakingParameters = argumentTypes.length < 32 ? LeakingParameters.buildFast(method.internalClassName, methodNode, jsr) : LeakingParameters.build(method.internalClassName, methodNode, jsr);
            if (leakingParameters == null) {
                MethodAnalysisVisitor.$$$reportNull$$$0(4);
            }
            return leakingParameters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "controlFlow";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$MethodAnalysisVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/ClassDataIndexer$MethodAnalysisVisitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "leakingParametersAndFrames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setterEquation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getterEquation";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static class ClassDataIndexerStatistics
    implements Consumer<Map<HMember, Equations>> {
        private static final AtomicLong ourTotalSize = new AtomicLong(0L);
        private static final AtomicLong ourTotalCount = new AtomicLong(0L);

        private ClassDataIndexerStatistics() {
        }

        @Override
        public void accept(Map<HMember, Equations> map) {
            try {
                UnsyncByteArrayOutputStream stream = new UnsyncByteArrayOutputStream();
                BytecodeAnalysisIndex.EquationsExternalizer.INSTANCE.save((DataOutput)new DataOutputStream((OutputStream)stream), map);
                ourTotalSize.addAndGet(stream.size());
                ourTotalCount.incrementAndGet();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public String toString() {
            if (ourTotalCount.get() == 0L) {
                return "";
            }
            return String.format(Locale.ENGLISH, "Classes: %d\nBytes: %d\nBytes per class: %.2f%n", ourTotalCount.get(), ourTotalSize.get(), (double)ourTotalSize.get() / (double)ourTotalCount.get());
        }
    }
}

