/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.EKey;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

final class Component {
    static final Component[] EMPTY_ARRAY = new Component[0];
    @NotNull
    Value value;
    final EKey @NotNull [] ids;

    Component(@NotNull Value value, @NotNull Collection<EKey> ids) {
        if (value == null) {
            Component.$$$reportNull$$$0(0);
        }
        if (ids == null) {
            Component.$$$reportNull$$$0(1);
        }
        this(value, ids.toArray(EKey.EMPTY_ARRAY));
    }

    Component(@NotNull Value value, EKey ... ids) {
        if (value == null) {
            Component.$$$reportNull$$$0(2);
        }
        if (ids == null) {
            Component.$$$reportNull$$$0(3);
        }
        this.value = value;
        this.ids = ids.length == 0 ? EKey.EMPTY_ARRAY : ids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Component that = (Component)o;
        return this.value == that.value && Arrays.equals(this.ids, that.ids);
    }

    public int hashCode() {
        return 31 * this.value.hashCode() + Arrays.hashCode(this.ids);
    }

    public boolean remove(@NotNull EKey id) {
        if (id == null) {
            Component.$$$reportNull$$$0(4);
        }
        boolean removed = false;
        for (int i = 0; i < this.ids.length; ++i) {
            if (!id.equals(this.ids[i])) continue;
            this.ids[i] = null;
            removed = true;
        }
        return removed;
    }

    public boolean isEmpty() {
        for (EKey id : this.ids) {
            if (id == null) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public Component copy() {
        return new Component(this.value, (EKey[])this.ids.clone());
    }

    public boolean isSuperStateOf(Component other) {
        return other.value == this.value && Arrays.asList(other.ids).containsAll(Arrays.asList(this.ids));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/bytecodeAnalysis/Component";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "remove";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

