/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.AbstractValues;
import com.intellij.codeInspection.bytecodeAnalysis.Component;
import com.intellij.codeInspection.bytecodeAnalysis.ContractAnalysis;
import com.intellij.codeInspection.bytecodeAnalysis.Direction;
import com.intellij.codeInspection.bytecodeAnalysis.ExpandableArray;
import com.intellij.codeInspection.bytecodeAnalysis.Pending;
import com.intellij.codeInspection.bytecodeAnalysis.Result;
import com.intellij.codeInspection.bytecodeAnalysis.State;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.codeInspection.bytecodeAnalysis.asm.RichControlFlow;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;

class InOutAnalysis
extends ContractAnalysis {
    protected InOutAnalysis(RichControlFlow richControlFlow, Direction direction, boolean[] resultOrigins, boolean stable, ExpandableArray<State> pending) {
        super(richControlFlow, direction, resultOrigins, stable, pending);
    }

    @Override
    boolean handleReturn(Frame<BasicValue> frame, int opcode, boolean unsure) throws AnalyzerException {
        if (this.interpreter.deReferenced) {
            return true;
        }
        return switch (opcode) {
            case 172, 173, 174, 175, 176, 177 -> {
                Result subResult;
                BasicValue stackTop = InOutAnalysis.popValue(frame);
                if (AbstractValues.FalseValue == stackTop) {
                    subResult = Value.False;
                } else if (AbstractValues.TrueValue == stackTop) {
                    subResult = Value.True;
                } else if (AbstractValues.NullValue == stackTop) {
                    subResult = Value.Null;
                } else if (stackTop instanceof AbstractValues.NotNullValue) {
                    subResult = Value.NotNull;
                } else if (stackTop instanceof AbstractValues.ParamValue) {
                    subResult = this.inValue;
                } else if (stackTop instanceof AbstractValues.CallResultValue) {
                    AbstractValues.CallResultValue callResultValue = (AbstractValues.CallResultValue)stackTop;
                    subResult = new Pending(new Component[]{new Component(Value.Top, callResultValue.inters)});
                } else {
                    this.earlyResult = Value.Top;
                    yield true;
                }
                this.internalResult = InOutAnalysis.checkLimit(resultUtil.join(this.internalResult, subResult));
                this.unsureOnly &= unsure;
                if (!unsure && this.internalResult == Value.Top) {
                    this.earlyResult = this.internalResult;
                }
                yield true;
            }
            case 191 -> true;
            default -> false;
        };
    }
}

